<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfflineQuery StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OfflineQuery
 * @subpackage Structs
 */
class OfflineQuery extends AbstractStructBase
{
    /**
     * The DataColumns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfOutputColumnSpecification
     */
    public $DataColumns;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\DateTimeOffset
     */
    public $FromDate;
    /**
     * The GroupByInstanceNameParts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $GroupByInstanceNameParts;
    /**
     * The GroupByTimePeriod
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $GroupByTimePeriod;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\DateTimeOffset
     */
    public $ToDate;
    /**
     * Constructor method for OfflineQuery
     * @uses OfflineQuery::setDataColumns()
     * @uses OfflineQuery::setFromDate()
     * @uses OfflineQuery::setGroupByInstanceNameParts()
     * @uses OfflineQuery::setGroupByTimePeriod()
     * @uses OfflineQuery::setToDate()
     * @param \patest\ArrayType\ArrayOfOutputColumnSpecification $dataColumns
     * @param \patest\StructType\DateTimeOffset $fromDate
     * @param string[] $groupByInstanceNameParts
     * @param string $groupByTimePeriod
     * @param \patest\StructType\DateTimeOffset $toDate
     */
    public function __construct(\patest\ArrayType\ArrayOfOutputColumnSpecification $dataColumns = null, \patest\StructType\DateTimeOffset $fromDate = null, array $groupByInstanceNameParts = array(), $groupByTimePeriod = null, \patest\StructType\DateTimeOffset $toDate = null)
    {
        $this
            ->setDataColumns($dataColumns)
            ->setFromDate($fromDate)
            ->setGroupByInstanceNameParts($groupByInstanceNameParts)
            ->setGroupByTimePeriod($groupByTimePeriod)
            ->setToDate($toDate);
    }
    /**
     * Get DataColumns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfOutputColumnSpecification|null
     */
    public function getDataColumns()
    {
        return isset($this->DataColumns) ? $this->DataColumns : null;
    }
    /**
     * Set DataColumns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfOutputColumnSpecification $dataColumns
     * @return \patest\StructType\OfflineQuery
     */
    public function setDataColumns(\patest\ArrayType\ArrayOfOutputColumnSpecification $dataColumns = null)
    {
        if (is_null($dataColumns) || (is_array($dataColumns) && empty($dataColumns))) {
            unset($this->DataColumns);
        } else {
            $this->DataColumns = $dataColumns;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * @return \patest\StructType\DateTimeOffset|null
     */
    public function getFromDate()
    {
        return $this->FromDate;
    }
    /**
     * Set FromDate value
     * @param \patest\StructType\DateTimeOffset $fromDate
     * @return \patest\StructType\OfflineQuery
     */
    public function setFromDate(\patest\StructType\DateTimeOffset $fromDate = null)
    {
        $this->FromDate = $fromDate;
        return $this;
    }
    /**
     * Get GroupByInstanceNameParts value
     * @return string[]|null
     */
    public function getGroupByInstanceNameParts()
    {
        return $this->GroupByInstanceNameParts;
    }
    /**
     * This method is responsible for validating the values passed to the setGroupByInstanceNameParts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGroupByInstanceNameParts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGroupByInstanceNamePartsForArrayConstraintsFromSetGroupByInstanceNameParts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offlineQueryGroupByInstanceNamePartsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\InstanceNamePart::valueIsValid($offlineQueryGroupByInstanceNamePartsItem)) {
                $invalidValues[] = is_object($offlineQueryGroupByInstanceNamePartsItem) ? get_class($offlineQueryGroupByInstanceNamePartsItem) : sprintf('%s(%s)', gettype($offlineQueryGroupByInstanceNamePartsItem), var_export($offlineQueryGroupByInstanceNamePartsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstanceNamePart', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\InstanceNamePart::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GroupByInstanceNameParts value
     * @uses \patest\EnumType\InstanceNamePart::valueIsValid()
     * @uses \patest\EnumType\InstanceNamePart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $groupByInstanceNameParts
     * @return \patest\StructType\OfflineQuery
     */
    public function setGroupByInstanceNameParts(array $groupByInstanceNameParts = array())
    {
        // validation for constraint: list
        if ('' !== ($groupByInstanceNamePartsArrayErrorMessage = self::validateGroupByInstanceNamePartsForArrayConstraintsFromSetGroupByInstanceNameParts($groupByInstanceNameParts))) {
            throw new \InvalidArgumentException($groupByInstanceNamePartsArrayErrorMessage, __LINE__);
        }
        $this->GroupByInstanceNameParts = is_array($groupByInstanceNameParts) ? implode(' ', $groupByInstanceNameParts) : null;
        return $this;
    }
    /**
     * Get GroupByTimePeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupByTimePeriod()
    {
        return isset($this->GroupByTimePeriod) ? $this->GroupByTimePeriod : null;
    }
    /**
     * Set GroupByTimePeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupByTimePeriod
     * @return \patest\StructType\OfflineQuery
     */
    public function setGroupByTimePeriod($groupByTimePeriod = null)
    {
        // validation for constraint: string
        if (!is_null($groupByTimePeriod) && !is_string($groupByTimePeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupByTimePeriod, true), gettype($groupByTimePeriod)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($groupByTimePeriod) && false === mb_strpos($groupByTimePeriod, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $groupByTimePeriod)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($groupByTimePeriod, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($groupByTimePeriod) && false !== mb_strpos($groupByTimePeriod, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $groupByTimePeriod)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($groupByTimePeriod, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($groupByTimePeriod) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $groupByTimePeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($groupByTimePeriod, true)), __LINE__);
        }
        if (is_null($groupByTimePeriod) || (is_array($groupByTimePeriod) && empty($groupByTimePeriod))) {
            unset($this->GroupByTimePeriod);
        } else {
            $this->GroupByTimePeriod = $groupByTimePeriod;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * @return \patest\StructType\DateTimeOffset|null
     */
    public function getToDate()
    {
        return $this->ToDate;
    }
    /**
     * Set ToDate value
     * @param \patest\StructType\DateTimeOffset $toDate
     * @return \patest\StructType\OfflineQuery
     */
    public function setToDate(\patest\StructType\DateTimeOffset $toDate = null)
    {
        $this->ToDate = $toDate;
        return $this;
    }
}
