<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotifyClientByEmail-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NotifyClientByEmail-Request
 * @subpackage Structs
 */
class NotifyClientByEmail_Request extends AbstractStructBase
{
    /**
     * The ClientEntity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var mixed
     */
    public $ClientEntity;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The EmailBody
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailBody;
    /**
     * The EmailTemplateName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailTemplateName;
    /**
     * The IsThrowExceptionOnError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsThrowExceptionOnError;
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Subject;
    /**
     * The TemplatePlaceHolders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $TemplatePlaceHolders;
    /**
     * Constructor method for NotifyClientByEmail-Request
     * @uses NotifyClientByEmail_Request::setClientEntity()
     * @uses NotifyClientByEmail_Request::setClientId()
     * @uses NotifyClientByEmail_Request::setEmailBody()
     * @uses NotifyClientByEmail_Request::setEmailTemplateName()
     * @uses NotifyClientByEmail_Request::setIsThrowExceptionOnError()
     * @uses NotifyClientByEmail_Request::setSubject()
     * @uses NotifyClientByEmail_Request::setTemplatePlaceHolders()
     * @param mixed $clientEntity
     * @param string $clientId
     * @param string $emailBody
     * @param string $emailTemplateName
     * @param bool $isThrowExceptionOnError
     * @param string $subject
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $templatePlaceHolders
     */
    public function __construct($clientEntity = null, $clientId = null, $emailBody = null, $emailTemplateName = null, $isThrowExceptionOnError = null, $subject = null, \patest\ArrayType\ArrayOfKeyValueOfstringstring $templatePlaceHolders = null)
    {
        $this
            ->setClientEntity($clientEntity)
            ->setClientId($clientId)
            ->setEmailBody($emailBody)
            ->setEmailTemplateName($emailTemplateName)
            ->setIsThrowExceptionOnError($isThrowExceptionOnError)
            ->setSubject($subject)
            ->setTemplatePlaceHolders($templatePlaceHolders);
    }
    /**
     * Get ClientEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return mixed|null
     */
    public function getClientEntity()
    {
        return isset($this->ClientEntity) ? $this->ClientEntity : null;
    }
    /**
     * Set ClientEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param mixed $clientEntity
     * @return \patest\StructType\NotifyClientByEmail_Request
     */
    public function setClientEntity($clientEntity = null)
    {
        if (is_null($clientEntity) || (is_array($clientEntity) && empty($clientEntity))) {
            unset($this->ClientEntity);
        } else {
            $this->ClientEntity = $clientEntity;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\NotifyClientByEmail_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get EmailBody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailBody()
    {
        return isset($this->EmailBody) ? $this->EmailBody : null;
    }
    /**
     * Set EmailBody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailBody
     * @return \patest\StructType\NotifyClientByEmail_Request
     */
    public function setEmailBody($emailBody = null)
    {
        // validation for constraint: string
        if (!is_null($emailBody) && !is_string($emailBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailBody, true), gettype($emailBody)), __LINE__);
        }
        if (is_null($emailBody) || (is_array($emailBody) && empty($emailBody))) {
            unset($this->EmailBody);
        } else {
            $this->EmailBody = $emailBody;
        }
        return $this;
    }
    /**
     * Get EmailTemplateName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailTemplateName()
    {
        return isset($this->EmailTemplateName) ? $this->EmailTemplateName : null;
    }
    /**
     * Set EmailTemplateName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailTemplateName
     * @return \patest\StructType\NotifyClientByEmail_Request
     */
    public function setEmailTemplateName($emailTemplateName = null)
    {
        // validation for constraint: string
        if (!is_null($emailTemplateName) && !is_string($emailTemplateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailTemplateName, true), gettype($emailTemplateName)), __LINE__);
        }
        if (is_null($emailTemplateName) || (is_array($emailTemplateName) && empty($emailTemplateName))) {
            unset($this->EmailTemplateName);
        } else {
            $this->EmailTemplateName = $emailTemplateName;
        }
        return $this;
    }
    /**
     * Get IsThrowExceptionOnError value
     * @return bool|null
     */
    public function getIsThrowExceptionOnError()
    {
        return $this->IsThrowExceptionOnError;
    }
    /**
     * Set IsThrowExceptionOnError value
     * @param bool $isThrowExceptionOnError
     * @return \patest\StructType\NotifyClientByEmail_Request
     */
    public function setIsThrowExceptionOnError($isThrowExceptionOnError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isThrowExceptionOnError) && !is_bool($isThrowExceptionOnError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isThrowExceptionOnError, true), gettype($isThrowExceptionOnError)), __LINE__);
        }
        $this->IsThrowExceptionOnError = $isThrowExceptionOnError;
        return $this;
    }
    /**
     * Get Subject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubject()
    {
        return isset($this->Subject) ? $this->Subject : null;
    }
    /**
     * Set Subject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subject
     * @return \patest\StructType\NotifyClientByEmail_Request
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        if (is_null($subject) || (is_array($subject) && empty($subject))) {
            unset($this->Subject);
        } else {
            $this->Subject = $subject;
        }
        return $this;
    }
    /**
     * Get TemplatePlaceHolders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getTemplatePlaceHolders()
    {
        return isset($this->TemplatePlaceHolders) ? $this->TemplatePlaceHolders : null;
    }
    /**
     * Set TemplatePlaceHolders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $templatePlaceHolders
     * @return \patest\StructType\NotifyClientByEmail_Request
     */
    public function setTemplatePlaceHolders(\patest\ArrayType\ArrayOfKeyValueOfstringstring $templatePlaceHolders = null)
    {
        if (is_null($templatePlaceHolders) || (is_array($templatePlaceHolders) && empty($templatePlaceHolders))) {
            unset($this->TemplatePlaceHolders);
        } else {
            $this->TemplatePlaceHolders = $templatePlaceHolders;
        }
        return $this;
    }
}
