<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MyTicketsCardRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MyTicketsCardRequest
 * @subpackage Structs
 */
class MyTicketsCardRequest extends AbstractStructBase
{
    /**
     * The AccessibilityText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessibilityText;
    /**
     * The BackgroundColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BackgroundColor;
    /**
     * The BackgroundImageGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BackgroundImageGuid;
    /**
     * The BarcodeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeType;
    /**
     * The CardHeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardHeader;
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardType;
    /**
     * The ExternalLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalLink;
    /**
     * The LabelColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LabelColor;
    /**
     * The LogoImageGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LogoImageGuid;
    /**
     * The TextColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TextColor;
    /**
     * The TintColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TintColor;
    /**
     * The UserHeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserHeader;
    /**
     * The YearsApplicable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $YearsApplicable;
    /**
     * Constructor method for MyTicketsCardRequest
     * @uses MyTicketsCardRequest::setAccessibilityText()
     * @uses MyTicketsCardRequest::setBackgroundColor()
     * @uses MyTicketsCardRequest::setBackgroundImageGuid()
     * @uses MyTicketsCardRequest::setBarcodeType()
     * @uses MyTicketsCardRequest::setCardHeader()
     * @uses MyTicketsCardRequest::setCardType()
     * @uses MyTicketsCardRequest::setExternalLink()
     * @uses MyTicketsCardRequest::setLabelColor()
     * @uses MyTicketsCardRequest::setLogoImageGuid()
     * @uses MyTicketsCardRequest::setTextColor()
     * @uses MyTicketsCardRequest::setTintColor()
     * @uses MyTicketsCardRequest::setUserHeader()
     * @uses MyTicketsCardRequest::setYearsApplicable()
     * @param string $accessibilityText
     * @param string $backgroundColor
     * @param string $backgroundImageGuid
     * @param string $barcodeType
     * @param string $cardHeader
     * @param string $cardType
     * @param string $externalLink
     * @param string $labelColor
     * @param string $logoImageGuid
     * @param string $textColor
     * @param string $tintColor
     * @param string $userHeader
     * @param string $yearsApplicable
     */
    public function __construct($accessibilityText = null, $backgroundColor = null, $backgroundImageGuid = null, $barcodeType = null, $cardHeader = null, $cardType = null, $externalLink = null, $labelColor = null, $logoImageGuid = null, $textColor = null, $tintColor = null, $userHeader = null, $yearsApplicable = null)
    {
        $this
            ->setAccessibilityText($accessibilityText)
            ->setBackgroundColor($backgroundColor)
            ->setBackgroundImageGuid($backgroundImageGuid)
            ->setBarcodeType($barcodeType)
            ->setCardHeader($cardHeader)
            ->setCardType($cardType)
            ->setExternalLink($externalLink)
            ->setLabelColor($labelColor)
            ->setLogoImageGuid($logoImageGuid)
            ->setTextColor($textColor)
            ->setTintColor($tintColor)
            ->setUserHeader($userHeader)
            ->setYearsApplicable($yearsApplicable);
    }
    /**
     * Get AccessibilityText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessibilityText()
    {
        return isset($this->AccessibilityText) ? $this->AccessibilityText : null;
    }
    /**
     * Set AccessibilityText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessibilityText
     * @return \patest\StructType\MyTicketsCardRequest
     */
    public function setAccessibilityText($accessibilityText = null)
    {
        // validation for constraint: string
        if (!is_null($accessibilityText) && !is_string($accessibilityText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessibilityText, true), gettype($accessibilityText)), __LINE__);
        }
        if (is_null($accessibilityText) || (is_array($accessibilityText) && empty($accessibilityText))) {
            unset($this->AccessibilityText);
        } else {
            $this->AccessibilityText = $accessibilityText;
        }
        return $this;
    }
    /**
     * Get BackgroundColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackgroundColor()
    {
        return isset($this->BackgroundColor) ? $this->BackgroundColor : null;
    }
    /**
     * Set BackgroundColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backgroundColor
     * @return \patest\StructType\MyTicketsCardRequest
     */
    public function setBackgroundColor($backgroundColor = null)
    {
        // validation for constraint: string
        if (!is_null($backgroundColor) && !is_string($backgroundColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backgroundColor, true), gettype($backgroundColor)), __LINE__);
        }
        if (is_null($backgroundColor) || (is_array($backgroundColor) && empty($backgroundColor))) {
            unset($this->BackgroundColor);
        } else {
            $this->BackgroundColor = $backgroundColor;
        }
        return $this;
    }
    /**
     * Get BackgroundImageGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackgroundImageGuid()
    {
        return isset($this->BackgroundImageGuid) ? $this->BackgroundImageGuid : null;
    }
    /**
     * Set BackgroundImageGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backgroundImageGuid
     * @return \patest\StructType\MyTicketsCardRequest
     */
    public function setBackgroundImageGuid($backgroundImageGuid = null)
    {
        // validation for constraint: string
        if (!is_null($backgroundImageGuid) && !is_string($backgroundImageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backgroundImageGuid, true), gettype($backgroundImageGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($backgroundImageGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $backgroundImageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($backgroundImageGuid, true)), __LINE__);
        }
        if (is_null($backgroundImageGuid) || (is_array($backgroundImageGuid) && empty($backgroundImageGuid))) {
            unset($this->BackgroundImageGuid);
        } else {
            $this->BackgroundImageGuid = $backgroundImageGuid;
        }
        return $this;
    }
    /**
     * Get BarcodeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeType()
    {
        return isset($this->BarcodeType) ? $this->BarcodeType : null;
    }
    /**
     * Set BarcodeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MyTicketsCardBarcodeTypes::valueIsValid()
     * @uses \patest\EnumType\MyTicketsCardBarcodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $barcodeType
     * @return \patest\StructType\MyTicketsCardRequest
     */
    public function setBarcodeType($barcodeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MyTicketsCardBarcodeTypes::valueIsValid($barcodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MyTicketsCardBarcodeTypes', is_array($barcodeType) ? implode(', ', $barcodeType) : var_export($barcodeType, true), implode(', ', \patest\EnumType\MyTicketsCardBarcodeTypes::getValidValues())), __LINE__);
        }
        if (is_null($barcodeType) || (is_array($barcodeType) && empty($barcodeType))) {
            unset($this->BarcodeType);
        } else {
            $this->BarcodeType = $barcodeType;
        }
        return $this;
    }
    /**
     * Get CardHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardHeader()
    {
        return isset($this->CardHeader) ? $this->CardHeader : null;
    }
    /**
     * Set CardHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardHeader
     * @return \patest\StructType\MyTicketsCardRequest
     */
    public function setCardHeader($cardHeader = null)
    {
        // validation for constraint: string
        if (!is_null($cardHeader) && !is_string($cardHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHeader, true), gettype($cardHeader)), __LINE__);
        }
        if (is_null($cardHeader) || (is_array($cardHeader) && empty($cardHeader))) {
            unset($this->CardHeader);
        } else {
            $this->CardHeader = $cardHeader;
        }
        return $this;
    }
    /**
     * Get CardType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardType()
    {
        return isset($this->CardType) ? $this->CardType : null;
    }
    /**
     * Set CardType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MyTicketsCardType::valueIsValid()
     * @uses \patest\EnumType\MyTicketsCardType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardType
     * @return \patest\StructType\MyTicketsCardRequest
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MyTicketsCardType::valueIsValid($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MyTicketsCardType', is_array($cardType) ? implode(', ', $cardType) : var_export($cardType, true), implode(', ', \patest\EnumType\MyTicketsCardType::getValidValues())), __LINE__);
        }
        if (is_null($cardType) || (is_array($cardType) && empty($cardType))) {
            unset($this->CardType);
        } else {
            $this->CardType = $cardType;
        }
        return $this;
    }
    /**
     * Get ExternalLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalLink()
    {
        return isset($this->ExternalLink) ? $this->ExternalLink : null;
    }
    /**
     * Set ExternalLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalLink
     * @return \patest\StructType\MyTicketsCardRequest
     */
    public function setExternalLink($externalLink = null)
    {
        // validation for constraint: string
        if (!is_null($externalLink) && !is_string($externalLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalLink, true), gettype($externalLink)), __LINE__);
        }
        if (is_null($externalLink) || (is_array($externalLink) && empty($externalLink))) {
            unset($this->ExternalLink);
        } else {
            $this->ExternalLink = $externalLink;
        }
        return $this;
    }
    /**
     * Get LabelColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabelColor()
    {
        return isset($this->LabelColor) ? $this->LabelColor : null;
    }
    /**
     * Set LabelColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $labelColor
     * @return \patest\StructType\MyTicketsCardRequest
     */
    public function setLabelColor($labelColor = null)
    {
        // validation for constraint: string
        if (!is_null($labelColor) && !is_string($labelColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelColor, true), gettype($labelColor)), __LINE__);
        }
        if (is_null($labelColor) || (is_array($labelColor) && empty($labelColor))) {
            unset($this->LabelColor);
        } else {
            $this->LabelColor = $labelColor;
        }
        return $this;
    }
    /**
     * Get LogoImageGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogoImageGuid()
    {
        return isset($this->LogoImageGuid) ? $this->LogoImageGuid : null;
    }
    /**
     * Set LogoImageGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logoImageGuid
     * @return \patest\StructType\MyTicketsCardRequest
     */
    public function setLogoImageGuid($logoImageGuid = null)
    {
        // validation for constraint: string
        if (!is_null($logoImageGuid) && !is_string($logoImageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logoImageGuid, true), gettype($logoImageGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($logoImageGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $logoImageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($logoImageGuid, true)), __LINE__);
        }
        if (is_null($logoImageGuid) || (is_array($logoImageGuid) && empty($logoImageGuid))) {
            unset($this->LogoImageGuid);
        } else {
            $this->LogoImageGuid = $logoImageGuid;
        }
        return $this;
    }
    /**
     * Get TextColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTextColor()
    {
        return isset($this->TextColor) ? $this->TextColor : null;
    }
    /**
     * Set TextColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $textColor
     * @return \patest\StructType\MyTicketsCardRequest
     */
    public function setTextColor($textColor = null)
    {
        // validation for constraint: string
        if (!is_null($textColor) && !is_string($textColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($textColor, true), gettype($textColor)), __LINE__);
        }
        if (is_null($textColor) || (is_array($textColor) && empty($textColor))) {
            unset($this->TextColor);
        } else {
            $this->TextColor = $textColor;
        }
        return $this;
    }
    /**
     * Get TintColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTintColor()
    {
        return isset($this->TintColor) ? $this->TintColor : null;
    }
    /**
     * Set TintColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tintColor
     * @return \patest\StructType\MyTicketsCardRequest
     */
    public function setTintColor($tintColor = null)
    {
        // validation for constraint: string
        if (!is_null($tintColor) && !is_string($tintColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tintColor, true), gettype($tintColor)), __LINE__);
        }
        if (is_null($tintColor) || (is_array($tintColor) && empty($tintColor))) {
            unset($this->TintColor);
        } else {
            $this->TintColor = $tintColor;
        }
        return $this;
    }
    /**
     * Get UserHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHeader()
    {
        return isset($this->UserHeader) ? $this->UserHeader : null;
    }
    /**
     * Set UserHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userHeader
     * @return \patest\StructType\MyTicketsCardRequest
     */
    public function setUserHeader($userHeader = null)
    {
        // validation for constraint: string
        if (!is_null($userHeader) && !is_string($userHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userHeader, true), gettype($userHeader)), __LINE__);
        }
        if (is_null($userHeader) || (is_array($userHeader) && empty($userHeader))) {
            unset($this->UserHeader);
        } else {
            $this->UserHeader = $userHeader;
        }
        return $this;
    }
    /**
     * Get YearsApplicable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getYearsApplicable()
    {
        return isset($this->YearsApplicable) ? $this->YearsApplicable : null;
    }
    /**
     * Set YearsApplicable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $yearsApplicable
     * @return \patest\StructType\MyTicketsCardRequest
     */
    public function setYearsApplicable($yearsApplicable = null)
    {
        // validation for constraint: string
        if (!is_null($yearsApplicable) && !is_string($yearsApplicable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yearsApplicable, true), gettype($yearsApplicable)), __LINE__);
        }
        if (is_null($yearsApplicable) || (is_array($yearsApplicable) && empty($yearsApplicable))) {
            unset($this->YearsApplicable);
        } else {
            $this->YearsApplicable = $yearsApplicable;
        }
        return $this;
    }
}
