<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * MoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem
 * @subpackage Structs
 */
class MoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem extends AbstractStructBase
{
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemId;
    /**
     * The SeatId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatId;
    /**
     * The TargetAreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetAreaId;
    /**
     * Constructor method for
     * MoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem
     * @uses MoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem::setItemId()
     * @uses MoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem::setSeatId()
     * @uses MoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem::setTargetAreaId()
     * @param int $itemId
     * @param int $seatId
     * @param string $targetAreaId
     */
    public function __construct($itemId = null, $seatId = null, $targetAreaId = null)
    {
        $this
            ->setItemId($itemId)
            ->setSeatId($seatId)
            ->setTargetAreaId($targetAreaId);
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \patest\StructType\MoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get SeatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatId()
    {
        return isset($this->SeatId) ? $this->SeatId : null;
    }
    /**
     * Set SeatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatId
     * @return \patest\StructType\MoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem
     */
    public function setSeatId($seatId = null)
    {
        // validation for constraint: int
        if (!is_null($seatId) && !(is_int($seatId) || ctype_digit($seatId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatId, true), gettype($seatId)), __LINE__);
        }
        if (is_null($seatId) || (is_array($seatId) && empty($seatId))) {
            unset($this->SeatId);
        } else {
            $this->SeatId = $seatId;
        }
        return $this;
    }
    /**
     * Get TargetAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetAreaId()
    {
        return isset($this->TargetAreaId) ? $this->TargetAreaId : null;
    }
    /**
     * Set TargetAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetAreaId
     * @return \patest\StructType\MoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem
     */
    public function setTargetAreaId($targetAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($targetAreaId) && !is_string($targetAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetAreaId, true), gettype($targetAreaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetAreaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetAreaId, true)), __LINE__);
        }
        if (is_null($targetAreaId) || (is_array($targetAreaId) && empty($targetAreaId))) {
            unset($this->TargetAreaId);
        } else {
            $this->TargetAreaId = $targetAreaId;
        }
        return $this;
    }
}
