<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MoveAudienceTargetInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MoveAudienceTargetInfo
 * @subpackage Structs
 */
class MoveAudienceTargetInfo extends AbstractStructBase
{
    /**
     * The AllowNoFullBlockCatch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowNoFullBlockCatch;
    /**
     * The AllowNonContiguousSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowNonContiguousSeats;
    /**
     * The AllowSnakePath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowSnakePath;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The SeatIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $SeatIds;
    /**
     * The ShouldRetainSourceSeatsAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShouldRetainSourceSeatsAttributes;
    /**
     * Constructor method for MoveAudienceTargetInfo
     * @uses MoveAudienceTargetInfo::setAllowNoFullBlockCatch()
     * @uses MoveAudienceTargetInfo::setAllowNonContiguousSeats()
     * @uses MoveAudienceTargetInfo::setAllowSnakePath()
     * @uses MoveAudienceTargetInfo::setAreaId()
     * @uses MoveAudienceTargetInfo::setEventId()
     * @uses MoveAudienceTargetInfo::setSeatIds()
     * @uses MoveAudienceTargetInfo::setShouldRetainSourceSeatsAttributes()
     * @param bool $allowNoFullBlockCatch
     * @param bool $allowNonContiguousSeats
     * @param bool $allowSnakePath
     * @param string $areaId
     * @param string $eventId
     * @param \patest\ArrayType\ArrayOfint $seatIds
     * @param bool $shouldRetainSourceSeatsAttributes
     */
    public function __construct($allowNoFullBlockCatch = null, $allowNonContiguousSeats = null, $allowSnakePath = null, $areaId = null, $eventId = null, \patest\ArrayType\ArrayOfint $seatIds = null, $shouldRetainSourceSeatsAttributes = null)
    {
        $this
            ->setAllowNoFullBlockCatch($allowNoFullBlockCatch)
            ->setAllowNonContiguousSeats($allowNonContiguousSeats)
            ->setAllowSnakePath($allowSnakePath)
            ->setAreaId($areaId)
            ->setEventId($eventId)
            ->setSeatIds($seatIds)
            ->setShouldRetainSourceSeatsAttributes($shouldRetainSourceSeatsAttributes);
    }
    /**
     * Get AllowNoFullBlockCatch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowNoFullBlockCatch()
    {
        return isset($this->AllowNoFullBlockCatch) ? $this->AllowNoFullBlockCatch : null;
    }
    /**
     * Set AllowNoFullBlockCatch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowNoFullBlockCatch
     * @return \patest\StructType\MoveAudienceTargetInfo
     */
    public function setAllowNoFullBlockCatch($allowNoFullBlockCatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowNoFullBlockCatch) && !is_bool($allowNoFullBlockCatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowNoFullBlockCatch, true), gettype($allowNoFullBlockCatch)), __LINE__);
        }
        if (is_null($allowNoFullBlockCatch) || (is_array($allowNoFullBlockCatch) && empty($allowNoFullBlockCatch))) {
            unset($this->AllowNoFullBlockCatch);
        } else {
            $this->AllowNoFullBlockCatch = $allowNoFullBlockCatch;
        }
        return $this;
    }
    /**
     * Get AllowNonContiguousSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowNonContiguousSeats()
    {
        return isset($this->AllowNonContiguousSeats) ? $this->AllowNonContiguousSeats : null;
    }
    /**
     * Set AllowNonContiguousSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowNonContiguousSeats
     * @return \patest\StructType\MoveAudienceTargetInfo
     */
    public function setAllowNonContiguousSeats($allowNonContiguousSeats = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowNonContiguousSeats) && !is_bool($allowNonContiguousSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowNonContiguousSeats, true), gettype($allowNonContiguousSeats)), __LINE__);
        }
        if (is_null($allowNonContiguousSeats) || (is_array($allowNonContiguousSeats) && empty($allowNonContiguousSeats))) {
            unset($this->AllowNonContiguousSeats);
        } else {
            $this->AllowNonContiguousSeats = $allowNonContiguousSeats;
        }
        return $this;
    }
    /**
     * Get AllowSnakePath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowSnakePath()
    {
        return isset($this->AllowSnakePath) ? $this->AllowSnakePath : null;
    }
    /**
     * Set AllowSnakePath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowSnakePath
     * @return \patest\StructType\MoveAudienceTargetInfo
     */
    public function setAllowSnakePath($allowSnakePath = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowSnakePath) && !is_bool($allowSnakePath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowSnakePath, true), gettype($allowSnakePath)), __LINE__);
        }
        if (is_null($allowSnakePath) || (is_array($allowSnakePath) && empty($allowSnakePath))) {
            unset($this->AllowSnakePath);
        } else {
            $this->AllowSnakePath = $allowSnakePath;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\MoveAudienceTargetInfo
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\MoveAudienceTargetInfo
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get SeatIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getSeatIds()
    {
        return isset($this->SeatIds) ? $this->SeatIds : null;
    }
    /**
     * Set SeatIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $seatIds
     * @return \patest\StructType\MoveAudienceTargetInfo
     */
    public function setSeatIds(\patest\ArrayType\ArrayOfint $seatIds = null)
    {
        if (is_null($seatIds) || (is_array($seatIds) && empty($seatIds))) {
            unset($this->SeatIds);
        } else {
            $this->SeatIds = $seatIds;
        }
        return $this;
    }
    /**
     * Get ShouldRetainSourceSeatsAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShouldRetainSourceSeatsAttributes()
    {
        return isset($this->ShouldRetainSourceSeatsAttributes) ? $this->ShouldRetainSourceSeatsAttributes : null;
    }
    /**
     * Set ShouldRetainSourceSeatsAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shouldRetainSourceSeatsAttributes
     * @return \patest\StructType\MoveAudienceTargetInfo
     */
    public function setShouldRetainSourceSeatsAttributes($shouldRetainSourceSeatsAttributes = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldRetainSourceSeatsAttributes) && !is_bool($shouldRetainSourceSeatsAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldRetainSourceSeatsAttributes, true), gettype($shouldRetainSourceSeatsAttributes)), __LINE__);
        }
        if (is_null($shouldRetainSourceSeatsAttributes) || (is_array($shouldRetainSourceSeatsAttributes) && empty($shouldRetainSourceSeatsAttributes))) {
            unset($this->ShouldRetainSourceSeatsAttributes);
        } else {
            $this->ShouldRetainSourceSeatsAttributes = $shouldRetainSourceSeatsAttributes;
        }
        return $this;
    }
}
