<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.StockTakeLine StructType
 * @subpackage Structs
 */
class Merchandise_StockTakeLine extends Merchandise_MerchandiseBase
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The CheckedByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CheckedByUserId;
    /**
     * The CheckedOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CheckedOn;
    /**
     * The CheckedQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CheckedQuantity;
    /**
     * The CrossOrgUnitsAclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CrossOrgUnitsAclSchemeId;
    /**
     * The LineCheckStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LineCheckStatus;
    /**
     * The LineNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LineNo;
    /**
     * The LocationName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $LocationName;
    /**
     * The MerchandiseItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseItemId;
    /**
     * The MerchandiseItemName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MerchandiseItemName;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ProductName;
    /**
     * The QuantityDifference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantityDifference;
    /**
     * The QuantityDifferencePercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantityDifferencePercent;
    /**
     * The StockQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $StockQuantity;
    /**
     * The StockTakeBypassReasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StockTakeBypassReasonId;
    /**
     * The StockTakeHeaderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StockTakeHeaderId;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Merchandise.StockTakeLine
     * @uses Merchandise_StockTakeLine::setAclSchemeId()
     * @uses Merchandise_StockTakeLine::setCheckedByUserId()
     * @uses Merchandise_StockTakeLine::setCheckedOn()
     * @uses Merchandise_StockTakeLine::setCheckedQuantity()
     * @uses Merchandise_StockTakeLine::setCrossOrgUnitsAclSchemeId()
     * @uses Merchandise_StockTakeLine::setLineCheckStatus()
     * @uses Merchandise_StockTakeLine::setLineNo()
     * @uses Merchandise_StockTakeLine::setLocationName()
     * @uses Merchandise_StockTakeLine::setMerchandiseItemId()
     * @uses Merchandise_StockTakeLine::setMerchandiseItemName()
     * @uses Merchandise_StockTakeLine::setOrganizationUnitId()
     * @uses Merchandise_StockTakeLine::setProductName()
     * @uses Merchandise_StockTakeLine::setQuantityDifference()
     * @uses Merchandise_StockTakeLine::setQuantityDifferencePercent()
     * @uses Merchandise_StockTakeLine::setStockQuantity()
     * @uses Merchandise_StockTakeLine::setStockTakeBypassReasonId()
     * @uses Merchandise_StockTakeLine::setStockTakeHeaderId()
     * @uses Merchandise_StockTakeLine::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param string $checkedByUserId
     * @param string $checkedOn
     * @param float $checkedQuantity
     * @param int $crossOrgUnitsAclSchemeId
     * @param string $lineCheckStatus
     * @param int $lineNo
     * @param \patest\StructType\GlobalString $locationName
     * @param string $merchandiseItemId
     * @param \patest\StructType\GlobalString $merchandiseItemName
     * @param string $organizationUnitId
     * @param \patest\StructType\GlobalString $productName
     * @param float $quantityDifference
     * @param float $quantityDifferencePercent
     * @param float $stockQuantity
     * @param string $stockTakeBypassReasonId
     * @param string $stockTakeHeaderId
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, $checkedByUserId = null, $checkedOn = null, $checkedQuantity = null, $crossOrgUnitsAclSchemeId = null, $lineCheckStatus = null, $lineNo = null, \patest\StructType\GlobalString $locationName = null, $merchandiseItemId = null, \patest\StructType\GlobalString $merchandiseItemName = null, $organizationUnitId = null, \patest\StructType\GlobalString $productName = null, $quantityDifference = null, $quantityDifferencePercent = null, $stockQuantity = null, $stockTakeBypassReasonId = null, $stockTakeHeaderId = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setCheckedByUserId($checkedByUserId)
            ->setCheckedOn($checkedOn)
            ->setCheckedQuantity($checkedQuantity)
            ->setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId)
            ->setLineCheckStatus($lineCheckStatus)
            ->setLineNo($lineNo)
            ->setLocationName($locationName)
            ->setMerchandiseItemId($merchandiseItemId)
            ->setMerchandiseItemName($merchandiseItemName)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProductName($productName)
            ->setQuantityDifference($quantityDifference)
            ->setQuantityDifferencePercent($quantityDifferencePercent)
            ->setStockQuantity($stockQuantity)
            ->setStockTakeBypassReasonId($stockTakeBypassReasonId)
            ->setStockTakeHeaderId($stockTakeHeaderId)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get CheckedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckedByUserId()
    {
        return isset($this->CheckedByUserId) ? $this->CheckedByUserId : null;
    }
    /**
     * Set CheckedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkedByUserId
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setCheckedByUserId($checkedByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($checkedByUserId) && !is_string($checkedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkedByUserId, true), gettype($checkedByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($checkedByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $checkedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($checkedByUserId, true)), __LINE__);
        }
        if (is_null($checkedByUserId) || (is_array($checkedByUserId) && empty($checkedByUserId))) {
            unset($this->CheckedByUserId);
        } else {
            $this->CheckedByUserId = $checkedByUserId;
        }
        return $this;
    }
    /**
     * Get CheckedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckedOn()
    {
        return isset($this->CheckedOn) ? $this->CheckedOn : null;
    }
    /**
     * Set CheckedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkedOn
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setCheckedOn($checkedOn = null)
    {
        // validation for constraint: string
        if (!is_null($checkedOn) && !is_string($checkedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkedOn, true), gettype($checkedOn)), __LINE__);
        }
        if (is_null($checkedOn) || (is_array($checkedOn) && empty($checkedOn))) {
            unset($this->CheckedOn);
        } else {
            $this->CheckedOn = $checkedOn;
        }
        return $this;
    }
    /**
     * Get CheckedQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCheckedQuantity()
    {
        return isset($this->CheckedQuantity) ? $this->CheckedQuantity : null;
    }
    /**
     * Set CheckedQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $checkedQuantity
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setCheckedQuantity($checkedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($checkedQuantity) && !(is_float($checkedQuantity) || is_numeric($checkedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($checkedQuantity, true), gettype($checkedQuantity)), __LINE__);
        }
        if (is_null($checkedQuantity) || (is_array($checkedQuantity) && empty($checkedQuantity))) {
            unset($this->CheckedQuantity);
        } else {
            $this->CheckedQuantity = $checkedQuantity;
        }
        return $this;
    }
    /**
     * Get CrossOrgUnitsAclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCrossOrgUnitsAclSchemeId()
    {
        return isset($this->CrossOrgUnitsAclSchemeId) ? $this->CrossOrgUnitsAclSchemeId : null;
    }
    /**
     * Set CrossOrgUnitsAclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $crossOrgUnitsAclSchemeId
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($crossOrgUnitsAclSchemeId) && !(is_int($crossOrgUnitsAclSchemeId) || ctype_digit($crossOrgUnitsAclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($crossOrgUnitsAclSchemeId, true), gettype($crossOrgUnitsAclSchemeId)), __LINE__);
        }
        if (is_null($crossOrgUnitsAclSchemeId) || (is_array($crossOrgUnitsAclSchemeId) && empty($crossOrgUnitsAclSchemeId))) {
            unset($this->CrossOrgUnitsAclSchemeId);
        } else {
            $this->CrossOrgUnitsAclSchemeId = $crossOrgUnitsAclSchemeId;
        }
        return $this;
    }
    /**
     * Get LineCheckStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLineCheckStatus()
    {
        return isset($this->LineCheckStatus) ? $this->LineCheckStatus : null;
    }
    /**
     * Set LineCheckStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\StockTakeLineCheckStatus::valueIsValid()
     * @uses \patest\EnumType\StockTakeLineCheckStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lineCheckStatus
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setLineCheckStatus($lineCheckStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\StockTakeLineCheckStatus::valueIsValid($lineCheckStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\StockTakeLineCheckStatus', is_array($lineCheckStatus) ? implode(', ', $lineCheckStatus) : var_export($lineCheckStatus, true), implode(', ', \patest\EnumType\StockTakeLineCheckStatus::getValidValues())), __LINE__);
        }
        if (is_null($lineCheckStatus) || (is_array($lineCheckStatus) && empty($lineCheckStatus))) {
            unset($this->LineCheckStatus);
        } else {
            $this->LineCheckStatus = $lineCheckStatus;
        }
        return $this;
    }
    /**
     * Get LineNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLineNo()
    {
        return isset($this->LineNo) ? $this->LineNo : null;
    }
    /**
     * Set LineNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lineNo
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setLineNo($lineNo = null)
    {
        // validation for constraint: int
        if (!is_null($lineNo) && !(is_int($lineNo) || ctype_digit($lineNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineNo, true), gettype($lineNo)), __LINE__);
        }
        if (is_null($lineNo) || (is_array($lineNo) && empty($lineNo))) {
            unset($this->LineNo);
        } else {
            $this->LineNo = $lineNo;
        }
        return $this;
    }
    /**
     * Get LocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getLocationName()
    {
        return isset($this->LocationName) ? $this->LocationName : null;
    }
    /**
     * Set LocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $locationName
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setLocationName(\patest\StructType\GlobalString $locationName = null)
    {
        if (is_null($locationName) || (is_array($locationName) && empty($locationName))) {
            unset($this->LocationName);
        } else {
            $this->LocationName = $locationName;
        }
        return $this;
    }
    /**
     * Get MerchandiseItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseItemId()
    {
        return isset($this->MerchandiseItemId) ? $this->MerchandiseItemId : null;
    }
    /**
     * Set MerchandiseItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseItemId
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setMerchandiseItemId($merchandiseItemId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseItemId) && !is_string($merchandiseItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseItemId, true), gettype($merchandiseItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseItemId, true)), __LINE__);
        }
        if (is_null($merchandiseItemId) || (is_array($merchandiseItemId) && empty($merchandiseItemId))) {
            unset($this->MerchandiseItemId);
        } else {
            $this->MerchandiseItemId = $merchandiseItemId;
        }
        return $this;
    }
    /**
     * Get MerchandiseItemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMerchandiseItemName()
    {
        return isset($this->MerchandiseItemName) ? $this->MerchandiseItemName : null;
    }
    /**
     * Set MerchandiseItemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $merchandiseItemName
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setMerchandiseItemName(\patest\StructType\GlobalString $merchandiseItemName = null)
    {
        if (is_null($merchandiseItemName) || (is_array($merchandiseItemName) && empty($merchandiseItemName))) {
            unset($this->MerchandiseItemName);
        } else {
            $this->MerchandiseItemName = $merchandiseItemName;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProductName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getProductName()
    {
        return isset($this->ProductName) ? $this->ProductName : null;
    }
    /**
     * Set ProductName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $productName
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setProductName(\patest\StructType\GlobalString $productName = null)
    {
        if (is_null($productName) || (is_array($productName) && empty($productName))) {
            unset($this->ProductName);
        } else {
            $this->ProductName = $productName;
        }
        return $this;
    }
    /**
     * Get QuantityDifference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantityDifference()
    {
        return isset($this->QuantityDifference) ? $this->QuantityDifference : null;
    }
    /**
     * Set QuantityDifference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantityDifference
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setQuantityDifference($quantityDifference = null)
    {
        // validation for constraint: float
        if (!is_null($quantityDifference) && !(is_float($quantityDifference) || is_numeric($quantityDifference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityDifference, true), gettype($quantityDifference)), __LINE__);
        }
        if (is_null($quantityDifference) || (is_array($quantityDifference) && empty($quantityDifference))) {
            unset($this->QuantityDifference);
        } else {
            $this->QuantityDifference = $quantityDifference;
        }
        return $this;
    }
    /**
     * Get QuantityDifferencePercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantityDifferencePercent()
    {
        return isset($this->QuantityDifferencePercent) ? $this->QuantityDifferencePercent : null;
    }
    /**
     * Set QuantityDifferencePercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantityDifferencePercent
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setQuantityDifferencePercent($quantityDifferencePercent = null)
    {
        // validation for constraint: float
        if (!is_null($quantityDifferencePercent) && !(is_float($quantityDifferencePercent) || is_numeric($quantityDifferencePercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityDifferencePercent, true), gettype($quantityDifferencePercent)), __LINE__);
        }
        if (is_null($quantityDifferencePercent) || (is_array($quantityDifferencePercent) && empty($quantityDifferencePercent))) {
            unset($this->QuantityDifferencePercent);
        } else {
            $this->QuantityDifferencePercent = $quantityDifferencePercent;
        }
        return $this;
    }
    /**
     * Get StockQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getStockQuantity()
    {
        return isset($this->StockQuantity) ? $this->StockQuantity : null;
    }
    /**
     * Set StockQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $stockQuantity
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setStockQuantity($stockQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($stockQuantity) && !(is_float($stockQuantity) || is_numeric($stockQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($stockQuantity, true), gettype($stockQuantity)), __LINE__);
        }
        if (is_null($stockQuantity) || (is_array($stockQuantity) && empty($stockQuantity))) {
            unset($this->StockQuantity);
        } else {
            $this->StockQuantity = $stockQuantity;
        }
        return $this;
    }
    /**
     * Get StockTakeBypassReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStockTakeBypassReasonId()
    {
        return isset($this->StockTakeBypassReasonId) ? $this->StockTakeBypassReasonId : null;
    }
    /**
     * Set StockTakeBypassReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stockTakeBypassReasonId
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setStockTakeBypassReasonId($stockTakeBypassReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($stockTakeBypassReasonId) && !is_string($stockTakeBypassReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockTakeBypassReasonId, true), gettype($stockTakeBypassReasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($stockTakeBypassReasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $stockTakeBypassReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($stockTakeBypassReasonId, true)), __LINE__);
        }
        if (is_null($stockTakeBypassReasonId) || (is_array($stockTakeBypassReasonId) && empty($stockTakeBypassReasonId))) {
            unset($this->StockTakeBypassReasonId);
        } else {
            $this->StockTakeBypassReasonId = $stockTakeBypassReasonId;
        }
        return $this;
    }
    /**
     * Get StockTakeHeaderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStockTakeHeaderId()
    {
        return isset($this->StockTakeHeaderId) ? $this->StockTakeHeaderId : null;
    }
    /**
     * Set StockTakeHeaderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stockTakeHeaderId
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setStockTakeHeaderId($stockTakeHeaderId = null)
    {
        // validation for constraint: string
        if (!is_null($stockTakeHeaderId) && !is_string($stockTakeHeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockTakeHeaderId, true), gettype($stockTakeHeaderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($stockTakeHeaderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $stockTakeHeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($stockTakeHeaderId, true)), __LINE__);
        }
        if (is_null($stockTakeHeaderId) || (is_array($stockTakeHeaderId) && empty($stockTakeHeaderId))) {
            unset($this->StockTakeHeaderId);
        } else {
            $this->StockTakeHeaderId = $stockTakeHeaderId;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Merchandise_StockTakeLine
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
