<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.StockAdjustment StructType
 * @subpackage Structs
 */
class Merchandise_StockAdjustment extends Merchandise_FormHeader
{
    /**
     * The IsSaleReturn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSaleReturn;
    /**
     * Constructor method for Merchandise.StockAdjustment
     * @uses Merchandise_StockAdjustment::setIsSaleReturn()
     * @param bool $isSaleReturn
     */
    public function __construct($isSaleReturn = null)
    {
        $this
            ->setIsSaleReturn($isSaleReturn);
    }
    /**
     * Get IsSaleReturn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSaleReturn()
    {
        return isset($this->IsSaleReturn) ? $this->IsSaleReturn : null;
    }
    /**
     * Set IsSaleReturn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSaleReturn
     * @return \patest\StructType\Merchandise_StockAdjustment
     */
    public function setIsSaleReturn($isSaleReturn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSaleReturn) && !is_bool($isSaleReturn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSaleReturn, true), gettype($isSaleReturn)), __LINE__);
        }
        if (is_null($isSaleReturn) || (is_array($isSaleReturn) && empty($isSaleReturn))) {
            unset($this->IsSaleReturn);
        } else {
            $this->IsSaleReturn = $isSaleReturn;
        }
        return $this;
    }
}
