<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.SaleFilter StructType
 * @subpackage Structs
 */
class Merchandise_SaleFilter extends FilterEntity
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountId;
    /**
     * The FormNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormNo;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The IsEditMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEditMode;
    /**
     * The SalesTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SalesTransactionNumber;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * Constructor method for Merchandise.SaleFilter
     * @uses Merchandise_SaleFilter::setAccountId()
     * @uses Merchandise_SaleFilter::setFormNo()
     * @uses Merchandise_SaleFilter::setFromDate()
     * @uses Merchandise_SaleFilter::setIsEditMode()
     * @uses Merchandise_SaleFilter::setSalesTransactionNumber()
     * @uses Merchandise_SaleFilter::setToDate()
     * @param string $accountId
     * @param string $formNo
     * @param string $fromDate
     * @param bool $isEditMode
     * @param int $salesTransactionNumber
     * @param string $toDate
     */
    public function __construct($accountId = null, $formNo = null, $fromDate = null, $isEditMode = null, $salesTransactionNumber = null, $toDate = null)
    {
        $this
            ->setAccountId($accountId)
            ->setFormNo($formNo)
            ->setFromDate($fromDate)
            ->setIsEditMode($isEditMode)
            ->setSalesTransactionNumber($salesTransactionNumber)
            ->setToDate($toDate);
    }
    /**
     * Get AccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountId()
    {
        return isset($this->AccountId) ? $this->AccountId : null;
    }
    /**
     * Set AccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountId
     * @return \patest\StructType\Merchandise_SaleFilter
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountId, true)), __LINE__);
        }
        if (is_null($accountId) || (is_array($accountId) && empty($accountId))) {
            unset($this->AccountId);
        } else {
            $this->AccountId = $accountId;
        }
        return $this;
    }
    /**
     * Get FormNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormNo()
    {
        return isset($this->FormNo) ? $this->FormNo : null;
    }
    /**
     * Set FormNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formNo
     * @return \patest\StructType\Merchandise_SaleFilter
     */
    public function setFormNo($formNo = null)
    {
        // validation for constraint: string
        if (!is_null($formNo) && !is_string($formNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formNo, true), gettype($formNo)), __LINE__);
        }
        if (is_null($formNo) || (is_array($formNo) && empty($formNo))) {
            unset($this->FormNo);
        } else {
            $this->FormNo = $formNo;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Merchandise_SaleFilter
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get IsEditMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEditMode()
    {
        return isset($this->IsEditMode) ? $this->IsEditMode : null;
    }
    /**
     * Set IsEditMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEditMode
     * @return \patest\StructType\Merchandise_SaleFilter
     */
    public function setIsEditMode($isEditMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEditMode) && !is_bool($isEditMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEditMode, true), gettype($isEditMode)), __LINE__);
        }
        if (is_null($isEditMode) || (is_array($isEditMode) && empty($isEditMode))) {
            unset($this->IsEditMode);
        } else {
            $this->IsEditMode = $isEditMode;
        }
        return $this;
    }
    /**
     * Get SalesTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSalesTransactionNumber()
    {
        return isset($this->SalesTransactionNumber) ? $this->SalesTransactionNumber : null;
    }
    /**
     * Set SalesTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $salesTransactionNumber
     * @return \patest\StructType\Merchandise_SaleFilter
     */
    public function setSalesTransactionNumber($salesTransactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($salesTransactionNumber) && !(is_int($salesTransactionNumber) || ctype_digit($salesTransactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($salesTransactionNumber, true), gettype($salesTransactionNumber)), __LINE__);
        }
        if (is_null($salesTransactionNumber) || (is_array($salesTransactionNumber) && empty($salesTransactionNumber))) {
            unset($this->SalesTransactionNumber);
        } else {
            $this->SalesTransactionNumber = $salesTransactionNumber;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\Merchandise_SaleFilter
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
}
