<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.Product StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Merchandise.Product
 * @subpackage Structs
 */
class Merchandise_Product extends Merchandise_MerchandiseBase
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The AddOns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMerchandise_ProductAddOn
     */
    public $AddOns;
    /**
     * The AlertInventoryAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AlertInventoryAmount;
    /**
     * The AttrType1Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AttrType1Id;
    /**
     * The AttrType2Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AttrType2Id;
    /**
     * The AttrType3Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AttrType3Id;
    /**
     * The AttrType4Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AttrType4Id;
    /**
     * The AvailableForDisplayFrom
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForDisplayFrom;
    /**
     * The AvailableForDisplayUntil
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForDisplayUntil;
    /**
     * The AvailableForSaleFrom
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForSaleFrom;
    /**
     * The AvailableForSaleUntil
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForSaleUntil;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The CategoryName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CategoryName;
    /**
     * The CrossOrgUnitsAclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CrossOrgUnitsAclSchemeId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsAllowNegativeQty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAllowNegativeQty;
    /**
     * The IsAttributeMandatory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAttributeMandatory;
    /**
     * The IsAvailableForDisplay
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForDisplay;
    /**
     * The IsAvailableForSale
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForSale;
    /**
     * The IsBarcodeToBePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBarcodeToBePrinted;
    /**
     * The IsBuildNameAndSkuAutomatically
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBuildNameAndSkuAutomatically;
    /**
     * The IsCountable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCountable;
    /**
     * The IsCustomizable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCustomizable;
    /**
     * The IsProductUsedInItems
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsProductUsedInItems;
    /**
     * The IsPurchaseable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPurchaseable;
    /**
     * The IsSellable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSellable;
    /**
     * The ItemTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemTypeId;
    /**
     * The KeyDescLine1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $KeyDescLine1;
    /**
     * The KeyDescLine2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $KeyDescLine2;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The MainUOMId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MainUOMId;
    /**
     * The Manufacturer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Manufacturer;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Merchandise_Media
     */
    public $Media;
    /**
     * The Merchandises
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMerchandise_Merchandise
     */
    public $Merchandises;
    /**
     * The Model
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Model;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NotificationToUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NotificationToUserId;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProductEsv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ProductEsv;
    /**
     * The ProductFaceValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ProductFaceValue;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The ShortName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ShortName;
    /**
     * The StockType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StockType;
    /**
     * The TinyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TinyName;
    /**
     * The UIInstructions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UIInstructions;
    /**
     * The UOMs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMerchandise_ProductUOM
     */
    public $UOMs;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Merchandise.Product
     * @uses Merchandise_Product::setAclSchemeId()
     * @uses Merchandise_Product::setAddOns()
     * @uses Merchandise_Product::setAlertInventoryAmount()
     * @uses Merchandise_Product::setAttrType1Id()
     * @uses Merchandise_Product::setAttrType2Id()
     * @uses Merchandise_Product::setAttrType3Id()
     * @uses Merchandise_Product::setAttrType4Id()
     * @uses Merchandise_Product::setAvailableForDisplayFrom()
     * @uses Merchandise_Product::setAvailableForDisplayUntil()
     * @uses Merchandise_Product::setAvailableForSaleFrom()
     * @uses Merchandise_Product::setAvailableForSaleUntil()
     * @uses Merchandise_Product::setCategoryId()
     * @uses Merchandise_Product::setCategoryName()
     * @uses Merchandise_Product::setCrossOrgUnitsAclSchemeId()
     * @uses Merchandise_Product::setDescription()
     * @uses Merchandise_Product::setIsActive()
     * @uses Merchandise_Product::setIsAllowNegativeQty()
     * @uses Merchandise_Product::setIsAttributeMandatory()
     * @uses Merchandise_Product::setIsAvailableForDisplay()
     * @uses Merchandise_Product::setIsAvailableForSale()
     * @uses Merchandise_Product::setIsBarcodeToBePrinted()
     * @uses Merchandise_Product::setIsBuildNameAndSkuAutomatically()
     * @uses Merchandise_Product::setIsCountable()
     * @uses Merchandise_Product::setIsCustomizable()
     * @uses Merchandise_Product::setIsProductUsedInItems()
     * @uses Merchandise_Product::setIsPurchaseable()
     * @uses Merchandise_Product::setIsSellable()
     * @uses Merchandise_Product::setItemTypeId()
     * @uses Merchandise_Product::setKeyDescLine1()
     * @uses Merchandise_Product::setKeyDescLine2()
     * @uses Merchandise_Product::setLedgerId()
     * @uses Merchandise_Product::setMainUOMId()
     * @uses Merchandise_Product::setManufacturer()
     * @uses Merchandise_Product::setMedia()
     * @uses Merchandise_Product::setMerchandises()
     * @uses Merchandise_Product::setModel()
     * @uses Merchandise_Product::setName()
     * @uses Merchandise_Product::setNotificationToUserId()
     * @uses Merchandise_Product::setOrdinal()
     * @uses Merchandise_Product::setOrganizationUnitId()
     * @uses Merchandise_Product::setProductEsv()
     * @uses Merchandise_Product::setProductFaceValue()
     * @uses Merchandise_Product::setProjectIdentifierId()
     * @uses Merchandise_Product::setShortName()
     * @uses Merchandise_Product::setStockType()
     * @uses Merchandise_Product::setTinyName()
     * @uses Merchandise_Product::setUIInstructions()
     * @uses Merchandise_Product::setUOMs()
     * @uses Merchandise_Product::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param \patest\StructType\RecordSetOfMerchandise_ProductAddOn $addOns
     * @param int $alertInventoryAmount
     * @param string $attrType1Id
     * @param string $attrType2Id
     * @param string $attrType3Id
     * @param string $attrType4Id
     * @param string $availableForDisplayFrom
     * @param string $availableForDisplayUntil
     * @param string $availableForSaleFrom
     * @param string $availableForSaleUntil
     * @param string $categoryId
     * @param \patest\StructType\GlobalString $categoryName
     * @param int $crossOrgUnitsAclSchemeId
     * @param \patest\StructType\GlobalString $description
     * @param bool $isActive
     * @param bool $isAllowNegativeQty
     * @param bool $isAttributeMandatory
     * @param bool $isAvailableForDisplay
     * @param bool $isAvailableForSale
     * @param bool $isBarcodeToBePrinted
     * @param bool $isBuildNameAndSkuAutomatically
     * @param bool $isCountable
     * @param bool $isCustomizable
     * @param bool $isProductUsedInItems
     * @param bool $isPurchaseable
     * @param bool $isSellable
     * @param string $itemTypeId
     * @param \patest\StructType\GlobalString $keyDescLine1
     * @param \patest\StructType\GlobalString $keyDescLine2
     * @param string $ledgerId
     * @param string $mainUOMId
     * @param \patest\StructType\GlobalString $manufacturer
     * @param \patest\StructType\Merchandise_Media $media
     * @param \patest\StructType\RecordSetOfMerchandise_Merchandise $merchandises
     * @param string $model
     * @param \patest\StructType\GlobalString $name
     * @param string $notificationToUserId
     * @param int $ordinal
     * @param string $organizationUnitId
     * @param \patest\StructType\Money $productEsv
     * @param \patest\StructType\Money $productFaceValue
     * @param string $projectIdentifierId
     * @param \patest\StructType\GlobalString $shortName
     * @param string $stockType
     * @param \patest\StructType\GlobalString $tinyName
     * @param string $uIInstructions
     * @param \patest\StructType\RecordSetOfMerchandise_ProductUOM $uOMs
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, \patest\StructType\RecordSetOfMerchandise_ProductAddOn $addOns = null, $alertInventoryAmount = null, $attrType1Id = null, $attrType2Id = null, $attrType3Id = null, $attrType4Id = null, $availableForDisplayFrom = null, $availableForDisplayUntil = null, $availableForSaleFrom = null, $availableForSaleUntil = null, $categoryId = null, \patest\StructType\GlobalString $categoryName = null, $crossOrgUnitsAclSchemeId = null, \patest\StructType\GlobalString $description = null, $isActive = null, $isAllowNegativeQty = null, $isAttributeMandatory = null, $isAvailableForDisplay = null, $isAvailableForSale = null, $isBarcodeToBePrinted = null, $isBuildNameAndSkuAutomatically = null, $isCountable = null, $isCustomizable = null, $isProductUsedInItems = null, $isPurchaseable = null, $isSellable = null, $itemTypeId = null, \patest\StructType\GlobalString $keyDescLine1 = null, \patest\StructType\GlobalString $keyDescLine2 = null, $ledgerId = null, $mainUOMId = null, \patest\StructType\GlobalString $manufacturer = null, \patest\StructType\Merchandise_Media $media = null, \patest\StructType\RecordSetOfMerchandise_Merchandise $merchandises = null, $model = null, \patest\StructType\GlobalString $name = null, $notificationToUserId = null, $ordinal = null, $organizationUnitId = null, \patest\StructType\Money $productEsv = null, \patest\StructType\Money $productFaceValue = null, $projectIdentifierId = null, \patest\StructType\GlobalString $shortName = null, $stockType = null, \patest\StructType\GlobalString $tinyName = null, $uIInstructions = null, \patest\StructType\RecordSetOfMerchandise_ProductUOM $uOMs = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setAddOns($addOns)
            ->setAlertInventoryAmount($alertInventoryAmount)
            ->setAttrType1Id($attrType1Id)
            ->setAttrType2Id($attrType2Id)
            ->setAttrType3Id($attrType3Id)
            ->setAttrType4Id($attrType4Id)
            ->setAvailableForDisplayFrom($availableForDisplayFrom)
            ->setAvailableForDisplayUntil($availableForDisplayUntil)
            ->setAvailableForSaleFrom($availableForSaleFrom)
            ->setAvailableForSaleUntil($availableForSaleUntil)
            ->setCategoryId($categoryId)
            ->setCategoryName($categoryName)
            ->setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId)
            ->setDescription($description)
            ->setIsActive($isActive)
            ->setIsAllowNegativeQty($isAllowNegativeQty)
            ->setIsAttributeMandatory($isAttributeMandatory)
            ->setIsAvailableForDisplay($isAvailableForDisplay)
            ->setIsAvailableForSale($isAvailableForSale)
            ->setIsBarcodeToBePrinted($isBarcodeToBePrinted)
            ->setIsBuildNameAndSkuAutomatically($isBuildNameAndSkuAutomatically)
            ->setIsCountable($isCountable)
            ->setIsCustomizable($isCustomizable)
            ->setIsProductUsedInItems($isProductUsedInItems)
            ->setIsPurchaseable($isPurchaseable)
            ->setIsSellable($isSellable)
            ->setItemTypeId($itemTypeId)
            ->setKeyDescLine1($keyDescLine1)
            ->setKeyDescLine2($keyDescLine2)
            ->setLedgerId($ledgerId)
            ->setMainUOMId($mainUOMId)
            ->setManufacturer($manufacturer)
            ->setMedia($media)
            ->setMerchandises($merchandises)
            ->setModel($model)
            ->setName($name)
            ->setNotificationToUserId($notificationToUserId)
            ->setOrdinal($ordinal)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProductEsv($productEsv)
            ->setProductFaceValue($productFaceValue)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setShortName($shortName)
            ->setStockType($stockType)
            ->setTinyName($tinyName)
            ->setUIInstructions($uIInstructions)
            ->setUOMs($uOMs)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Merchandise_Product
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get AddOns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMerchandise_ProductAddOn|null
     */
    public function getAddOns()
    {
        return isset($this->AddOns) ? $this->AddOns : null;
    }
    /**
     * Set AddOns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMerchandise_ProductAddOn $addOns
     * @return \patest\StructType\Merchandise_Product
     */
    public function setAddOns(\patest\StructType\RecordSetOfMerchandise_ProductAddOn $addOns = null)
    {
        if (is_null($addOns) || (is_array($addOns) && empty($addOns))) {
            unset($this->AddOns);
        } else {
            $this->AddOns = $addOns;
        }
        return $this;
    }
    /**
     * Get AlertInventoryAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAlertInventoryAmount()
    {
        return isset($this->AlertInventoryAmount) ? $this->AlertInventoryAmount : null;
    }
    /**
     * Set AlertInventoryAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $alertInventoryAmount
     * @return \patest\StructType\Merchandise_Product
     */
    public function setAlertInventoryAmount($alertInventoryAmount = null)
    {
        // validation for constraint: int
        if (!is_null($alertInventoryAmount) && !(is_int($alertInventoryAmount) || ctype_digit($alertInventoryAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alertInventoryAmount, true), gettype($alertInventoryAmount)), __LINE__);
        }
        if (is_null($alertInventoryAmount) || (is_array($alertInventoryAmount) && empty($alertInventoryAmount))) {
            unset($this->AlertInventoryAmount);
        } else {
            $this->AlertInventoryAmount = $alertInventoryAmount;
        }
        return $this;
    }
    /**
     * Get AttrType1Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttrType1Id()
    {
        return isset($this->AttrType1Id) ? $this->AttrType1Id : null;
    }
    /**
     * Set AttrType1Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attrType1Id
     * @return \patest\StructType\Merchandise_Product
     */
    public function setAttrType1Id($attrType1Id = null)
    {
        // validation for constraint: string
        if (!is_null($attrType1Id) && !is_string($attrType1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attrType1Id, true), gettype($attrType1Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attrType1Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attrType1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attrType1Id, true)), __LINE__);
        }
        if (is_null($attrType1Id) || (is_array($attrType1Id) && empty($attrType1Id))) {
            unset($this->AttrType1Id);
        } else {
            $this->AttrType1Id = $attrType1Id;
        }
        return $this;
    }
    /**
     * Get AttrType2Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttrType2Id()
    {
        return isset($this->AttrType2Id) ? $this->AttrType2Id : null;
    }
    /**
     * Set AttrType2Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attrType2Id
     * @return \patest\StructType\Merchandise_Product
     */
    public function setAttrType2Id($attrType2Id = null)
    {
        // validation for constraint: string
        if (!is_null($attrType2Id) && !is_string($attrType2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attrType2Id, true), gettype($attrType2Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attrType2Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attrType2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attrType2Id, true)), __LINE__);
        }
        if (is_null($attrType2Id) || (is_array($attrType2Id) && empty($attrType2Id))) {
            unset($this->AttrType2Id);
        } else {
            $this->AttrType2Id = $attrType2Id;
        }
        return $this;
    }
    /**
     * Get AttrType3Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttrType3Id()
    {
        return isset($this->AttrType3Id) ? $this->AttrType3Id : null;
    }
    /**
     * Set AttrType3Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attrType3Id
     * @return \patest\StructType\Merchandise_Product
     */
    public function setAttrType3Id($attrType3Id = null)
    {
        // validation for constraint: string
        if (!is_null($attrType3Id) && !is_string($attrType3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attrType3Id, true), gettype($attrType3Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attrType3Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attrType3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attrType3Id, true)), __LINE__);
        }
        if (is_null($attrType3Id) || (is_array($attrType3Id) && empty($attrType3Id))) {
            unset($this->AttrType3Id);
        } else {
            $this->AttrType3Id = $attrType3Id;
        }
        return $this;
    }
    /**
     * Get AttrType4Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttrType4Id()
    {
        return isset($this->AttrType4Id) ? $this->AttrType4Id : null;
    }
    /**
     * Set AttrType4Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attrType4Id
     * @return \patest\StructType\Merchandise_Product
     */
    public function setAttrType4Id($attrType4Id = null)
    {
        // validation for constraint: string
        if (!is_null($attrType4Id) && !is_string($attrType4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attrType4Id, true), gettype($attrType4Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attrType4Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attrType4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attrType4Id, true)), __LINE__);
        }
        if (is_null($attrType4Id) || (is_array($attrType4Id) && empty($attrType4Id))) {
            unset($this->AttrType4Id);
        } else {
            $this->AttrType4Id = $attrType4Id;
        }
        return $this;
    }
    /**
     * Get AvailableForDisplayFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForDisplayFrom()
    {
        return isset($this->AvailableForDisplayFrom) ? $this->AvailableForDisplayFrom : null;
    }
    /**
     * Set AvailableForDisplayFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForDisplayFrom
     * @return \patest\StructType\Merchandise_Product
     */
    public function setAvailableForDisplayFrom($availableForDisplayFrom = null)
    {
        // validation for constraint: string
        if (!is_null($availableForDisplayFrom) && !is_string($availableForDisplayFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForDisplayFrom, true), gettype($availableForDisplayFrom)), __LINE__);
        }
        if (is_null($availableForDisplayFrom) || (is_array($availableForDisplayFrom) && empty($availableForDisplayFrom))) {
            unset($this->AvailableForDisplayFrom);
        } else {
            $this->AvailableForDisplayFrom = $availableForDisplayFrom;
        }
        return $this;
    }
    /**
     * Get AvailableForDisplayUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForDisplayUntil()
    {
        return isset($this->AvailableForDisplayUntil) ? $this->AvailableForDisplayUntil : null;
    }
    /**
     * Set AvailableForDisplayUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForDisplayUntil
     * @return \patest\StructType\Merchandise_Product
     */
    public function setAvailableForDisplayUntil($availableForDisplayUntil = null)
    {
        // validation for constraint: string
        if (!is_null($availableForDisplayUntil) && !is_string($availableForDisplayUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForDisplayUntil, true), gettype($availableForDisplayUntil)), __LINE__);
        }
        if (is_null($availableForDisplayUntil) || (is_array($availableForDisplayUntil) && empty($availableForDisplayUntil))) {
            unset($this->AvailableForDisplayUntil);
        } else {
            $this->AvailableForDisplayUntil = $availableForDisplayUntil;
        }
        return $this;
    }
    /**
     * Get AvailableForSaleFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForSaleFrom()
    {
        return isset($this->AvailableForSaleFrom) ? $this->AvailableForSaleFrom : null;
    }
    /**
     * Set AvailableForSaleFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForSaleFrom
     * @return \patest\StructType\Merchandise_Product
     */
    public function setAvailableForSaleFrom($availableForSaleFrom = null)
    {
        // validation for constraint: string
        if (!is_null($availableForSaleFrom) && !is_string($availableForSaleFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForSaleFrom, true), gettype($availableForSaleFrom)), __LINE__);
        }
        if (is_null($availableForSaleFrom) || (is_array($availableForSaleFrom) && empty($availableForSaleFrom))) {
            unset($this->AvailableForSaleFrom);
        } else {
            $this->AvailableForSaleFrom = $availableForSaleFrom;
        }
        return $this;
    }
    /**
     * Get AvailableForSaleUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForSaleUntil()
    {
        return isset($this->AvailableForSaleUntil) ? $this->AvailableForSaleUntil : null;
    }
    /**
     * Set AvailableForSaleUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForSaleUntil
     * @return \patest\StructType\Merchandise_Product
     */
    public function setAvailableForSaleUntil($availableForSaleUntil = null)
    {
        // validation for constraint: string
        if (!is_null($availableForSaleUntil) && !is_string($availableForSaleUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForSaleUntil, true), gettype($availableForSaleUntil)), __LINE__);
        }
        if (is_null($availableForSaleUntil) || (is_array($availableForSaleUntil) && empty($availableForSaleUntil))) {
            unset($this->AvailableForSaleUntil);
        } else {
            $this->AvailableForSaleUntil = $availableForSaleUntil;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Merchandise_Product
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get CategoryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCategoryName()
    {
        return isset($this->CategoryName) ? $this->CategoryName : null;
    }
    /**
     * Set CategoryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $categoryName
     * @return \patest\StructType\Merchandise_Product
     */
    public function setCategoryName(\patest\StructType\GlobalString $categoryName = null)
    {
        if (is_null($categoryName) || (is_array($categoryName) && empty($categoryName))) {
            unset($this->CategoryName);
        } else {
            $this->CategoryName = $categoryName;
        }
        return $this;
    }
    /**
     * Get CrossOrgUnitsAclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCrossOrgUnitsAclSchemeId()
    {
        return isset($this->CrossOrgUnitsAclSchemeId) ? $this->CrossOrgUnitsAclSchemeId : null;
    }
    /**
     * Set CrossOrgUnitsAclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $crossOrgUnitsAclSchemeId
     * @return \patest\StructType\Merchandise_Product
     */
    public function setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($crossOrgUnitsAclSchemeId) && !(is_int($crossOrgUnitsAclSchemeId) || ctype_digit($crossOrgUnitsAclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($crossOrgUnitsAclSchemeId, true), gettype($crossOrgUnitsAclSchemeId)), __LINE__);
        }
        if (is_null($crossOrgUnitsAclSchemeId) || (is_array($crossOrgUnitsAclSchemeId) && empty($crossOrgUnitsAclSchemeId))) {
            unset($this->CrossOrgUnitsAclSchemeId);
        } else {
            $this->CrossOrgUnitsAclSchemeId = $crossOrgUnitsAclSchemeId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Merchandise_Product
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Merchandise_Product
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsAllowNegativeQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAllowNegativeQty()
    {
        return isset($this->IsAllowNegativeQty) ? $this->IsAllowNegativeQty : null;
    }
    /**
     * Set IsAllowNegativeQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAllowNegativeQty
     * @return \patest\StructType\Merchandise_Product
     */
    public function setIsAllowNegativeQty($isAllowNegativeQty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllowNegativeQty) && !is_bool($isAllowNegativeQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAllowNegativeQty, true), gettype($isAllowNegativeQty)), __LINE__);
        }
        if (is_null($isAllowNegativeQty) || (is_array($isAllowNegativeQty) && empty($isAllowNegativeQty))) {
            unset($this->IsAllowNegativeQty);
        } else {
            $this->IsAllowNegativeQty = $isAllowNegativeQty;
        }
        return $this;
    }
    /**
     * Get IsAttributeMandatory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAttributeMandatory()
    {
        return isset($this->IsAttributeMandatory) ? $this->IsAttributeMandatory : null;
    }
    /**
     * Set IsAttributeMandatory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAttributeMandatory
     * @return \patest\StructType\Merchandise_Product
     */
    public function setIsAttributeMandatory($isAttributeMandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAttributeMandatory) && !is_bool($isAttributeMandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAttributeMandatory, true), gettype($isAttributeMandatory)), __LINE__);
        }
        if (is_null($isAttributeMandatory) || (is_array($isAttributeMandatory) && empty($isAttributeMandatory))) {
            unset($this->IsAttributeMandatory);
        } else {
            $this->IsAttributeMandatory = $isAttributeMandatory;
        }
        return $this;
    }
    /**
     * Get IsAvailableForDisplay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForDisplay()
    {
        return isset($this->IsAvailableForDisplay) ? $this->IsAvailableForDisplay : null;
    }
    /**
     * Set IsAvailableForDisplay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForDisplay
     * @return \patest\StructType\Merchandise_Product
     */
    public function setIsAvailableForDisplay($isAvailableForDisplay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForDisplay) && !is_bool($isAvailableForDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForDisplay, true), gettype($isAvailableForDisplay)), __LINE__);
        }
        if (is_null($isAvailableForDisplay) || (is_array($isAvailableForDisplay) && empty($isAvailableForDisplay))) {
            unset($this->IsAvailableForDisplay);
        } else {
            $this->IsAvailableForDisplay = $isAvailableForDisplay;
        }
        return $this;
    }
    /**
     * Get IsAvailableForSale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForSale()
    {
        return isset($this->IsAvailableForSale) ? $this->IsAvailableForSale : null;
    }
    /**
     * Set IsAvailableForSale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForSale
     * @return \patest\StructType\Merchandise_Product
     */
    public function setIsAvailableForSale($isAvailableForSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForSale) && !is_bool($isAvailableForSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForSale, true), gettype($isAvailableForSale)), __LINE__);
        }
        if (is_null($isAvailableForSale) || (is_array($isAvailableForSale) && empty($isAvailableForSale))) {
            unset($this->IsAvailableForSale);
        } else {
            $this->IsAvailableForSale = $isAvailableForSale;
        }
        return $this;
    }
    /**
     * Get IsBarcodeToBePrinted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBarcodeToBePrinted()
    {
        return isset($this->IsBarcodeToBePrinted) ? $this->IsBarcodeToBePrinted : null;
    }
    /**
     * Set IsBarcodeToBePrinted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBarcodeToBePrinted
     * @return \patest\StructType\Merchandise_Product
     */
    public function setIsBarcodeToBePrinted($isBarcodeToBePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBarcodeToBePrinted) && !is_bool($isBarcodeToBePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBarcodeToBePrinted, true), gettype($isBarcodeToBePrinted)), __LINE__);
        }
        if (is_null($isBarcodeToBePrinted) || (is_array($isBarcodeToBePrinted) && empty($isBarcodeToBePrinted))) {
            unset($this->IsBarcodeToBePrinted);
        } else {
            $this->IsBarcodeToBePrinted = $isBarcodeToBePrinted;
        }
        return $this;
    }
    /**
     * Get IsBuildNameAndSkuAutomatically value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBuildNameAndSkuAutomatically()
    {
        return isset($this->IsBuildNameAndSkuAutomatically) ? $this->IsBuildNameAndSkuAutomatically : null;
    }
    /**
     * Set IsBuildNameAndSkuAutomatically value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBuildNameAndSkuAutomatically
     * @return \patest\StructType\Merchandise_Product
     */
    public function setIsBuildNameAndSkuAutomatically($isBuildNameAndSkuAutomatically = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBuildNameAndSkuAutomatically) && !is_bool($isBuildNameAndSkuAutomatically)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBuildNameAndSkuAutomatically, true), gettype($isBuildNameAndSkuAutomatically)), __LINE__);
        }
        if (is_null($isBuildNameAndSkuAutomatically) || (is_array($isBuildNameAndSkuAutomatically) && empty($isBuildNameAndSkuAutomatically))) {
            unset($this->IsBuildNameAndSkuAutomatically);
        } else {
            $this->IsBuildNameAndSkuAutomatically = $isBuildNameAndSkuAutomatically;
        }
        return $this;
    }
    /**
     * Get IsCountable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCountable()
    {
        return isset($this->IsCountable) ? $this->IsCountable : null;
    }
    /**
     * Set IsCountable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCountable
     * @return \patest\StructType\Merchandise_Product
     */
    public function setIsCountable($isCountable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCountable) && !is_bool($isCountable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCountable, true), gettype($isCountable)), __LINE__);
        }
        if (is_null($isCountable) || (is_array($isCountable) && empty($isCountable))) {
            unset($this->IsCountable);
        } else {
            $this->IsCountable = $isCountable;
        }
        return $this;
    }
    /**
     * Get IsCustomizable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCustomizable()
    {
        return isset($this->IsCustomizable) ? $this->IsCustomizable : null;
    }
    /**
     * Set IsCustomizable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCustomizable
     * @return \patest\StructType\Merchandise_Product
     */
    public function setIsCustomizable($isCustomizable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCustomizable) && !is_bool($isCustomizable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCustomizable, true), gettype($isCustomizable)), __LINE__);
        }
        if (is_null($isCustomizable) || (is_array($isCustomizable) && empty($isCustomizable))) {
            unset($this->IsCustomizable);
        } else {
            $this->IsCustomizable = $isCustomizable;
        }
        return $this;
    }
    /**
     * Get IsProductUsedInItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsProductUsedInItems()
    {
        return isset($this->IsProductUsedInItems) ? $this->IsProductUsedInItems : null;
    }
    /**
     * Set IsProductUsedInItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isProductUsedInItems
     * @return \patest\StructType\Merchandise_Product
     */
    public function setIsProductUsedInItems($isProductUsedInItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($isProductUsedInItems) && !is_bool($isProductUsedInItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isProductUsedInItems, true), gettype($isProductUsedInItems)), __LINE__);
        }
        if (is_null($isProductUsedInItems) || (is_array($isProductUsedInItems) && empty($isProductUsedInItems))) {
            unset($this->IsProductUsedInItems);
        } else {
            $this->IsProductUsedInItems = $isProductUsedInItems;
        }
        return $this;
    }
    /**
     * Get IsPurchaseable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPurchaseable()
    {
        return isset($this->IsPurchaseable) ? $this->IsPurchaseable : null;
    }
    /**
     * Set IsPurchaseable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPurchaseable
     * @return \patest\StructType\Merchandise_Product
     */
    public function setIsPurchaseable($isPurchaseable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPurchaseable) && !is_bool($isPurchaseable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPurchaseable, true), gettype($isPurchaseable)), __LINE__);
        }
        if (is_null($isPurchaseable) || (is_array($isPurchaseable) && empty($isPurchaseable))) {
            unset($this->IsPurchaseable);
        } else {
            $this->IsPurchaseable = $isPurchaseable;
        }
        return $this;
    }
    /**
     * Get IsSellable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSellable()
    {
        return isset($this->IsSellable) ? $this->IsSellable : null;
    }
    /**
     * Set IsSellable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSellable
     * @return \patest\StructType\Merchandise_Product
     */
    public function setIsSellable($isSellable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSellable) && !is_bool($isSellable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSellable, true), gettype($isSellable)), __LINE__);
        }
        if (is_null($isSellable) || (is_array($isSellable) && empty($isSellable))) {
            unset($this->IsSellable);
        } else {
            $this->IsSellable = $isSellable;
        }
        return $this;
    }
    /**
     * Get ItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemTypeId()
    {
        return isset($this->ItemTypeId) ? $this->ItemTypeId : null;
    }
    /**
     * Set ItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemTypeId
     * @return \patest\StructType\Merchandise_Product
     */
    public function setItemTypeId($itemTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($itemTypeId) && !is_string($itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemTypeId, true), gettype($itemTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemTypeId, true)), __LINE__);
        }
        if (is_null($itemTypeId) || (is_array($itemTypeId) && empty($itemTypeId))) {
            unset($this->ItemTypeId);
        } else {
            $this->ItemTypeId = $itemTypeId;
        }
        return $this;
    }
    /**
     * Get KeyDescLine1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getKeyDescLine1()
    {
        return isset($this->KeyDescLine1) ? $this->KeyDescLine1 : null;
    }
    /**
     * Set KeyDescLine1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $keyDescLine1
     * @return \patest\StructType\Merchandise_Product
     */
    public function setKeyDescLine1(\patest\StructType\GlobalString $keyDescLine1 = null)
    {
        if (is_null($keyDescLine1) || (is_array($keyDescLine1) && empty($keyDescLine1))) {
            unset($this->KeyDescLine1);
        } else {
            $this->KeyDescLine1 = $keyDescLine1;
        }
        return $this;
    }
    /**
     * Get KeyDescLine2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getKeyDescLine2()
    {
        return isset($this->KeyDescLine2) ? $this->KeyDescLine2 : null;
    }
    /**
     * Set KeyDescLine2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $keyDescLine2
     * @return \patest\StructType\Merchandise_Product
     */
    public function setKeyDescLine2(\patest\StructType\GlobalString $keyDescLine2 = null)
    {
        if (is_null($keyDescLine2) || (is_array($keyDescLine2) && empty($keyDescLine2))) {
            unset($this->KeyDescLine2);
        } else {
            $this->KeyDescLine2 = $keyDescLine2;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\Merchandise_Product
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get MainUOMId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMainUOMId()
    {
        return isset($this->MainUOMId) ? $this->MainUOMId : null;
    }
    /**
     * Set MainUOMId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mainUOMId
     * @return \patest\StructType\Merchandise_Product
     */
    public function setMainUOMId($mainUOMId = null)
    {
        // validation for constraint: string
        if (!is_null($mainUOMId) && !is_string($mainUOMId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mainUOMId, true), gettype($mainUOMId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mainUOMId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mainUOMId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mainUOMId, true)), __LINE__);
        }
        if (is_null($mainUOMId) || (is_array($mainUOMId) && empty($mainUOMId))) {
            unset($this->MainUOMId);
        } else {
            $this->MainUOMId = $mainUOMId;
        }
        return $this;
    }
    /**
     * Get Manufacturer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getManufacturer()
    {
        return isset($this->Manufacturer) ? $this->Manufacturer : null;
    }
    /**
     * Set Manufacturer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $manufacturer
     * @return \patest\StructType\Merchandise_Product
     */
    public function setManufacturer(\patest\StructType\GlobalString $manufacturer = null)
    {
        if (is_null($manufacturer) || (is_array($manufacturer) && empty($manufacturer))) {
            unset($this->Manufacturer);
        } else {
            $this->Manufacturer = $manufacturer;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Merchandise_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Merchandise_Media $media
     * @return \patest\StructType\Merchandise_Product
     */
    public function setMedia(\patest\StructType\Merchandise_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get Merchandises value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMerchandise_Merchandise|null
     */
    public function getMerchandises()
    {
        return isset($this->Merchandises) ? $this->Merchandises : null;
    }
    /**
     * Set Merchandises value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMerchandise_Merchandise $merchandises
     * @return \patest\StructType\Merchandise_Product
     */
    public function setMerchandises(\patest\StructType\RecordSetOfMerchandise_Merchandise $merchandises = null)
    {
        if (is_null($merchandises) || (is_array($merchandises) && empty($merchandises))) {
            unset($this->Merchandises);
        } else {
            $this->Merchandises = $merchandises;
        }
        return $this;
    }
    /**
     * Get Model value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModel()
    {
        return isset($this->Model) ? $this->Model : null;
    }
    /**
     * Set Model value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $model
     * @return \patest\StructType\Merchandise_Product
     */
    public function setModel($model = null)
    {
        // validation for constraint: string
        if (!is_null($model) && !is_string($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($model, true), gettype($model)), __LINE__);
        }
        if (is_null($model) || (is_array($model) && empty($model))) {
            unset($this->Model);
        } else {
            $this->Model = $model;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Merchandise_Product
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NotificationToUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotificationToUserId()
    {
        return isset($this->NotificationToUserId) ? $this->NotificationToUserId : null;
    }
    /**
     * Set NotificationToUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notificationToUserId
     * @return \patest\StructType\Merchandise_Product
     */
    public function setNotificationToUserId($notificationToUserId = null)
    {
        // validation for constraint: string
        if (!is_null($notificationToUserId) && !is_string($notificationToUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationToUserId, true), gettype($notificationToUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($notificationToUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $notificationToUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($notificationToUserId, true)), __LINE__);
        }
        if (is_null($notificationToUserId) || (is_array($notificationToUserId) && empty($notificationToUserId))) {
            unset($this->NotificationToUserId);
        } else {
            $this->NotificationToUserId = $notificationToUserId;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Merchandise_Product
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Merchandise_Product
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProductEsv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getProductEsv()
    {
        return isset($this->ProductEsv) ? $this->ProductEsv : null;
    }
    /**
     * Set ProductEsv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $productEsv
     * @return \patest\StructType\Merchandise_Product
     */
    public function setProductEsv(\patest\StructType\Money $productEsv = null)
    {
        if (is_null($productEsv) || (is_array($productEsv) && empty($productEsv))) {
            unset($this->ProductEsv);
        } else {
            $this->ProductEsv = $productEsv;
        }
        return $this;
    }
    /**
     * Get ProductFaceValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getProductFaceValue()
    {
        return isset($this->ProductFaceValue) ? $this->ProductFaceValue : null;
    }
    /**
     * Set ProductFaceValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $productFaceValue
     * @return \patest\StructType\Merchandise_Product
     */
    public function setProductFaceValue(\patest\StructType\Money $productFaceValue = null)
    {
        if (is_null($productFaceValue) || (is_array($productFaceValue) && empty($productFaceValue))) {
            unset($this->ProductFaceValue);
        } else {
            $this->ProductFaceValue = $productFaceValue;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\Merchandise_Product
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get ShortName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getShortName()
    {
        return isset($this->ShortName) ? $this->ShortName : null;
    }
    /**
     * Set ShortName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $shortName
     * @return \patest\StructType\Merchandise_Product
     */
    public function setShortName(\patest\StructType\GlobalString $shortName = null)
    {
        if (is_null($shortName) || (is_array($shortName) && empty($shortName))) {
            unset($this->ShortName);
        } else {
            $this->ShortName = $shortName;
        }
        return $this;
    }
    /**
     * Get StockType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStockType()
    {
        return isset($this->StockType) ? $this->StockType : null;
    }
    /**
     * Set StockType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\StockType::valueIsValid()
     * @uses \patest\EnumType\StockType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stockType
     * @return \patest\StructType\Merchandise_Product
     */
    public function setStockType($stockType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\StockType::valueIsValid($stockType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\StockType', is_array($stockType) ? implode(', ', $stockType) : var_export($stockType, true), implode(', ', \patest\EnumType\StockType::getValidValues())), __LINE__);
        }
        if (is_null($stockType) || (is_array($stockType) && empty($stockType))) {
            unset($this->StockType);
        } else {
            $this->StockType = $stockType;
        }
        return $this;
    }
    /**
     * Get TinyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTinyName()
    {
        return isset($this->TinyName) ? $this->TinyName : null;
    }
    /**
     * Set TinyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $tinyName
     * @return \patest\StructType\Merchandise_Product
     */
    public function setTinyName(\patest\StructType\GlobalString $tinyName = null)
    {
        if (is_null($tinyName) || (is_array($tinyName) && empty($tinyName))) {
            unset($this->TinyName);
        } else {
            $this->TinyName = $tinyName;
        }
        return $this;
    }
    /**
     * Get UIInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUIInstructions()
    {
        return isset($this->UIInstructions) ? $this->UIInstructions : null;
    }
    /**
     * Set UIInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uIInstructions
     * @return \patest\StructType\Merchandise_Product
     */
    public function setUIInstructions($uIInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($uIInstructions) && !is_string($uIInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uIInstructions, true), gettype($uIInstructions)), __LINE__);
        }
        if (is_null($uIInstructions) || (is_array($uIInstructions) && empty($uIInstructions))) {
            unset($this->UIInstructions);
        } else {
            $this->UIInstructions = $uIInstructions;
        }
        return $this;
    }
    /**
     * Get UOMs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMerchandise_ProductUOM|null
     */
    public function getUOMs()
    {
        return isset($this->UOMs) ? $this->UOMs : null;
    }
    /**
     * Set UOMs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMerchandise_ProductUOM $uOMs
     * @return \patest\StructType\Merchandise_Product
     */
    public function setUOMs(\patest\StructType\RecordSetOfMerchandise_ProductUOM $uOMs = null)
    {
        if (is_null($uOMs) || (is_array($uOMs) && empty($uOMs))) {
            unset($this->UOMs);
        } else {
            $this->UOMs = $uOMs;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Merchandise_Product
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
