<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.MerchandiseSupplier StructType
 * @subpackage Structs
 */
class Merchandise_MerchandiseSupplier extends Merchandise_MerchandiseBase
{
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The IsMain
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMain;
    /**
     * The ItemTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemTypeId;
    /**
     * The MerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseId;
    /**
     * The MinQuantityToOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MinQuantityToOrder;
    /**
     * The SupplierCostPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SupplierCostPrice;
    /**
     * The SupplierESVPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SupplierESVPrice;
    /**
     * The SupplierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SupplierId;
    /**
     * The SupplierItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SupplierItemId;
    /**
     * Constructor method for Merchandise.MerchandiseSupplier
     * @uses Merchandise_MerchandiseSupplier::setCategoryId()
     * @uses Merchandise_MerchandiseSupplier::setExternalId()
     * @uses Merchandise_MerchandiseSupplier::setIsMain()
     * @uses Merchandise_MerchandiseSupplier::setItemTypeId()
     * @uses Merchandise_MerchandiseSupplier::setMerchandiseId()
     * @uses Merchandise_MerchandiseSupplier::setMinQuantityToOrder()
     * @uses Merchandise_MerchandiseSupplier::setSupplierCostPrice()
     * @uses Merchandise_MerchandiseSupplier::setSupplierESVPrice()
     * @uses Merchandise_MerchandiseSupplier::setSupplierId()
     * @uses Merchandise_MerchandiseSupplier::setSupplierItemId()
     * @param string $categoryId
     * @param string $externalId
     * @param bool $isMain
     * @param string $itemTypeId
     * @param string $merchandiseId
     * @param float $minQuantityToOrder
     * @param \patest\StructType\Money $supplierCostPrice
     * @param \patest\StructType\Money $supplierESVPrice
     * @param string $supplierId
     * @param string $supplierItemId
     */
    public function __construct($categoryId = null, $externalId = null, $isMain = null, $itemTypeId = null, $merchandiseId = null, $minQuantityToOrder = null, \patest\StructType\Money $supplierCostPrice = null, \patest\StructType\Money $supplierESVPrice = null, $supplierId = null, $supplierItemId = null)
    {
        $this
            ->setCategoryId($categoryId)
            ->setExternalId($externalId)
            ->setIsMain($isMain)
            ->setItemTypeId($itemTypeId)
            ->setMerchandiseId($merchandiseId)
            ->setMinQuantityToOrder($minQuantityToOrder)
            ->setSupplierCostPrice($supplierCostPrice)
            ->setSupplierESVPrice($supplierESVPrice)
            ->setSupplierId($supplierId)
            ->setSupplierItemId($supplierItemId);
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Merchandise_MerchandiseSupplier
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \patest\StructType\Merchandise_MerchandiseSupplier
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get IsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMain()
    {
        return isset($this->IsMain) ? $this->IsMain : null;
    }
    /**
     * Set IsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMain
     * @return \patest\StructType\Merchandise_MerchandiseSupplier
     */
    public function setIsMain($isMain = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMain) && !is_bool($isMain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMain, true), gettype($isMain)), __LINE__);
        }
        if (is_null($isMain) || (is_array($isMain) && empty($isMain))) {
            unset($this->IsMain);
        } else {
            $this->IsMain = $isMain;
        }
        return $this;
    }
    /**
     * Get ItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemTypeId()
    {
        return isset($this->ItemTypeId) ? $this->ItemTypeId : null;
    }
    /**
     * Set ItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemTypeId
     * @return \patest\StructType\Merchandise_MerchandiseSupplier
     */
    public function setItemTypeId($itemTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($itemTypeId) && !is_string($itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemTypeId, true), gettype($itemTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemTypeId, true)), __LINE__);
        }
        if (is_null($itemTypeId) || (is_array($itemTypeId) && empty($itemTypeId))) {
            unset($this->ItemTypeId);
        } else {
            $this->ItemTypeId = $itemTypeId;
        }
        return $this;
    }
    /**
     * Get MerchandiseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseId()
    {
        return isset($this->MerchandiseId) ? $this->MerchandiseId : null;
    }
    /**
     * Set MerchandiseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseId
     * @return \patest\StructType\Merchandise_MerchandiseSupplier
     */
    public function setMerchandiseId($merchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseId) && !is_string($merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseId, true), gettype($merchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseId, true)), __LINE__);
        }
        if (is_null($merchandiseId) || (is_array($merchandiseId) && empty($merchandiseId))) {
            unset($this->MerchandiseId);
        } else {
            $this->MerchandiseId = $merchandiseId;
        }
        return $this;
    }
    /**
     * Get MinQuantityToOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMinQuantityToOrder()
    {
        return isset($this->MinQuantityToOrder) ? $this->MinQuantityToOrder : null;
    }
    /**
     * Set MinQuantityToOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $minQuantityToOrder
     * @return \patest\StructType\Merchandise_MerchandiseSupplier
     */
    public function setMinQuantityToOrder($minQuantityToOrder = null)
    {
        // validation for constraint: float
        if (!is_null($minQuantityToOrder) && !(is_float($minQuantityToOrder) || is_numeric($minQuantityToOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minQuantityToOrder, true), gettype($minQuantityToOrder)), __LINE__);
        }
        if (is_null($minQuantityToOrder) || (is_array($minQuantityToOrder) && empty($minQuantityToOrder))) {
            unset($this->MinQuantityToOrder);
        } else {
            $this->MinQuantityToOrder = $minQuantityToOrder;
        }
        return $this;
    }
    /**
     * Get SupplierCostPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSupplierCostPrice()
    {
        return isset($this->SupplierCostPrice) ? $this->SupplierCostPrice : null;
    }
    /**
     * Set SupplierCostPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $supplierCostPrice
     * @return \patest\StructType\Merchandise_MerchandiseSupplier
     */
    public function setSupplierCostPrice(\patest\StructType\Money $supplierCostPrice = null)
    {
        if (is_null($supplierCostPrice) || (is_array($supplierCostPrice) && empty($supplierCostPrice))) {
            unset($this->SupplierCostPrice);
        } else {
            $this->SupplierCostPrice = $supplierCostPrice;
        }
        return $this;
    }
    /**
     * Get SupplierESVPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSupplierESVPrice()
    {
        return isset($this->SupplierESVPrice) ? $this->SupplierESVPrice : null;
    }
    /**
     * Set SupplierESVPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $supplierESVPrice
     * @return \patest\StructType\Merchandise_MerchandiseSupplier
     */
    public function setSupplierESVPrice(\patest\StructType\Money $supplierESVPrice = null)
    {
        if (is_null($supplierESVPrice) || (is_array($supplierESVPrice) && empty($supplierESVPrice))) {
            unset($this->SupplierESVPrice);
        } else {
            $this->SupplierESVPrice = $supplierESVPrice;
        }
        return $this;
    }
    /**
     * Get SupplierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierId()
    {
        return isset($this->SupplierId) ? $this->SupplierId : null;
    }
    /**
     * Set SupplierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierId
     * @return \patest\StructType\Merchandise_MerchandiseSupplier
     */
    public function setSupplierId($supplierId = null)
    {
        // validation for constraint: string
        if (!is_null($supplierId) && !is_string($supplierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierId, true), gettype($supplierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($supplierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $supplierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($supplierId, true)), __LINE__);
        }
        if (is_null($supplierId) || (is_array($supplierId) && empty($supplierId))) {
            unset($this->SupplierId);
        } else {
            $this->SupplierId = $supplierId;
        }
        return $this;
    }
    /**
     * Get SupplierItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierItemId()
    {
        return isset($this->SupplierItemId) ? $this->SupplierItemId : null;
    }
    /**
     * Set SupplierItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierItemId
     * @return \patest\StructType\Merchandise_MerchandiseSupplier
     */
    public function setSupplierItemId($supplierItemId = null)
    {
        // validation for constraint: string
        if (!is_null($supplierItemId) && !is_string($supplierItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierItemId, true), gettype($supplierItemId)), __LINE__);
        }
        if (is_null($supplierItemId) || (is_array($supplierItemId) && empty($supplierItemId))) {
            unset($this->SupplierItemId);
        } else {
            $this->SupplierItemId = $supplierItemId;
        }
        return $this;
    }
}
