<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.MerchandiseExtended StructType
 * @subpackage Structs
 */
class Merchandise_MerchandiseExtended extends Sales_Item
{
    /**
     * The AgencyAccountId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgencyAccountId;
    /**
     * The AgencyName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgencyName;
    /**
     * The AttachedToBenefitInstanceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AttachedToBenefitInstanceId;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The CategoryName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CategoryName;
    /**
     * The CommitDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDate;
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraInfo;
    /**
     * The HasHistory
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasHistory;
    /**
     * The ItemTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemTypeId;
    /**
     * The MerchandiseId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseId;
    /**
     * The MerchandiseName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MerchandiseName;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerName;
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaidAmount;
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentStatus;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ProductName;
    /**
     * The PurchaserClientId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurchaserClientId;
    /**
     * The PurchaserName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PurchaserName;
    /**
     * The SalesRepCustomerId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepCustomerId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNotes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionNotes;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TransactionReferenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionReferenceNumber;
    /**
     * The UnpaidAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $UnpaidAmount;
    /**
     * The UnpaidInstallmentsAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $UnpaidInstallmentsAmount;
    /**
     * Constructor method for Merchandise.MerchandiseExtended
     * @uses Merchandise_MerchandiseExtended::setAgencyAccountId()
     * @uses Merchandise_MerchandiseExtended::setAgencyName()
     * @uses Merchandise_MerchandiseExtended::setAttachedToBenefitInstanceId()
     * @uses Merchandise_MerchandiseExtended::setBarcode()
     * @uses Merchandise_MerchandiseExtended::setCategoryId()
     * @uses Merchandise_MerchandiseExtended::setCategoryName()
     * @uses Merchandise_MerchandiseExtended::setCommitDate()
     * @uses Merchandise_MerchandiseExtended::setExtraInfo()
     * @uses Merchandise_MerchandiseExtended::setHasHistory()
     * @uses Merchandise_MerchandiseExtended::setItemTypeId()
     * @uses Merchandise_MerchandiseExtended::setMerchandiseId()
     * @uses Merchandise_MerchandiseExtended::setMerchandiseName()
     * @uses Merchandise_MerchandiseExtended::setOwnerName()
     * @uses Merchandise_MerchandiseExtended::setPaidAmount()
     * @uses Merchandise_MerchandiseExtended::setPaymentStatus()
     * @uses Merchandise_MerchandiseExtended::setPrintCount()
     * @uses Merchandise_MerchandiseExtended::setProductId()
     * @uses Merchandise_MerchandiseExtended::setProductName()
     * @uses Merchandise_MerchandiseExtended::setPurchaserClientId()
     * @uses Merchandise_MerchandiseExtended::setPurchaserName()
     * @uses Merchandise_MerchandiseExtended::setSalesRepCustomerId()
     * @uses Merchandise_MerchandiseExtended::setTransactionGuid()
     * @uses Merchandise_MerchandiseExtended::setTransactionNotes()
     * @uses Merchandise_MerchandiseExtended::setTransactionNumber()
     * @uses Merchandise_MerchandiseExtended::setTransactionReferenceNumber()
     * @uses Merchandise_MerchandiseExtended::setUnpaidAmount()
     * @uses Merchandise_MerchandiseExtended::setUnpaidInstallmentsAmount()
     * @param string $agencyAccountId
     * @param string $agencyName
     * @param string $attachedToBenefitInstanceId
     * @param string $barcode
     * @param string $categoryId
     * @param \patest\StructType\GlobalString $categoryName
     * @param string $commitDate
     * @param string $extraInfo
     * @param bool $hasHistory
     * @param string $itemTypeId
     * @param string $merchandiseId
     * @param \patest\StructType\GlobalString $merchandiseName
     * @param string $ownerName
     * @param \patest\StructType\Money $paidAmount
     * @param string $paymentStatus
     * @param int $printCount
     * @param string $productId
     * @param \patest\StructType\GlobalString $productName
     * @param string $purchaserClientId
     * @param string $purchaserName
     * @param string $salesRepCustomerId
     * @param string $transactionGuid
     * @param string $transactionNotes
     * @param int $transactionNumber
     * @param int $transactionReferenceNumber
     * @param \patest\StructType\Money $unpaidAmount
     * @param \patest\StructType\Money $unpaidInstallmentsAmount
     */
    public function __construct($agencyAccountId = null, $agencyName = null, $attachedToBenefitInstanceId = null, $barcode = null, $categoryId = null, \patest\StructType\GlobalString $categoryName = null, $commitDate = null, $extraInfo = null, $hasHistory = null, $itemTypeId = null, $merchandiseId = null, \patest\StructType\GlobalString $merchandiseName = null, $ownerName = null, \patest\StructType\Money $paidAmount = null, $paymentStatus = null, $printCount = null, $productId = null, \patest\StructType\GlobalString $productName = null, $purchaserClientId = null, $purchaserName = null, $salesRepCustomerId = null, $transactionGuid = null, $transactionNotes = null, $transactionNumber = null, $transactionReferenceNumber = null, \patest\StructType\Money $unpaidAmount = null, \patest\StructType\Money $unpaidInstallmentsAmount = null)
    {
        $this
            ->setAgencyAccountId($agencyAccountId)
            ->setAgencyName($agencyName)
            ->setAttachedToBenefitInstanceId($attachedToBenefitInstanceId)
            ->setBarcode($barcode)
            ->setCategoryId($categoryId)
            ->setCategoryName($categoryName)
            ->setCommitDate($commitDate)
            ->setExtraInfo($extraInfo)
            ->setHasHistory($hasHistory)
            ->setItemTypeId($itemTypeId)
            ->setMerchandiseId($merchandiseId)
            ->setMerchandiseName($merchandiseName)
            ->setOwnerName($ownerName)
            ->setPaidAmount($paidAmount)
            ->setPaymentStatus($paymentStatus)
            ->setPrintCount($printCount)
            ->setProductId($productId)
            ->setProductName($productName)
            ->setPurchaserClientId($purchaserClientId)
            ->setPurchaserName($purchaserName)
            ->setSalesRepCustomerId($salesRepCustomerId)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNotes($transactionNotes)
            ->setTransactionNumber($transactionNumber)
            ->setTransactionReferenceNumber($transactionReferenceNumber)
            ->setUnpaidAmount($unpaidAmount)
            ->setUnpaidInstallmentsAmount($unpaidInstallmentsAmount);
    }
    /**
     * Get AgencyAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyAccountId()
    {
        return isset($this->AgencyAccountId) ? $this->AgencyAccountId : null;
    }
    /**
     * Set AgencyAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyAccountId
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setAgencyAccountId($agencyAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($agencyAccountId) && !is_string($agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyAccountId, true), gettype($agencyAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agencyAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agencyAccountId, true)), __LINE__);
        }
        if (is_null($agencyAccountId) || (is_array($agencyAccountId) && empty($agencyAccountId))) {
            unset($this->AgencyAccountId);
        } else {
            $this->AgencyAccountId = $agencyAccountId;
        }
        return $this;
    }
    /**
     * Get AgencyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyName()
    {
        return isset($this->AgencyName) ? $this->AgencyName : null;
    }
    /**
     * Set AgencyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyName
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setAgencyName($agencyName = null)
    {
        // validation for constraint: string
        if (!is_null($agencyName) && !is_string($agencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyName, true), gettype($agencyName)), __LINE__);
        }
        if (is_null($agencyName) || (is_array($agencyName) && empty($agencyName))) {
            unset($this->AgencyName);
        } else {
            $this->AgencyName = $agencyName;
        }
        return $this;
    }
    /**
     * Get AttachedToBenefitInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttachedToBenefitInstanceId()
    {
        return isset($this->AttachedToBenefitInstanceId) ? $this->AttachedToBenefitInstanceId : null;
    }
    /**
     * Set AttachedToBenefitInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attachedToBenefitInstanceId
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setAttachedToBenefitInstanceId($attachedToBenefitInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($attachedToBenefitInstanceId) && !is_string($attachedToBenefitInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachedToBenefitInstanceId, true), gettype($attachedToBenefitInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attachedToBenefitInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attachedToBenefitInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attachedToBenefitInstanceId, true)), __LINE__);
        }
        if (is_null($attachedToBenefitInstanceId) || (is_array($attachedToBenefitInstanceId) && empty($attachedToBenefitInstanceId))) {
            unset($this->AttachedToBenefitInstanceId);
        } else {
            $this->AttachedToBenefitInstanceId = $attachedToBenefitInstanceId;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get CategoryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCategoryName()
    {
        return isset($this->CategoryName) ? $this->CategoryName : null;
    }
    /**
     * Set CategoryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $categoryName
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setCategoryName(\patest\StructType\GlobalString $categoryName = null)
    {
        if (is_null($categoryName) || (is_array($categoryName) && empty($categoryName))) {
            unset($this->CategoryName);
        } else {
            $this->CategoryName = $categoryName;
        }
        return $this;
    }
    /**
     * Get CommitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDate()
    {
        return isset($this->CommitDate) ? $this->CommitDate : null;
    }
    /**
     * Set CommitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDate
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setCommitDate($commitDate = null)
    {
        // validation for constraint: string
        if (!is_null($commitDate) && !is_string($commitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDate, true), gettype($commitDate)), __LINE__);
        }
        if (is_null($commitDate) || (is_array($commitDate) && empty($commitDate))) {
            unset($this->CommitDate);
        } else {
            $this->CommitDate = $commitDate;
        }
        return $this;
    }
    /**
     * Get ExtraInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraInfo()
    {
        return isset($this->ExtraInfo) ? $this->ExtraInfo : null;
    }
    /**
     * Set ExtraInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraInfo
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setExtraInfo($extraInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extraInfo) && !is_string($extraInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInfo, true), gettype($extraInfo)), __LINE__);
        }
        if (is_null($extraInfo) || (is_array($extraInfo) && empty($extraInfo))) {
            unset($this->ExtraInfo);
        } else {
            $this->ExtraInfo = $extraInfo;
        }
        return $this;
    }
    /**
     * Get HasHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasHistory()
    {
        return isset($this->HasHistory) ? $this->HasHistory : null;
    }
    /**
     * Set HasHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasHistory
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setHasHistory($hasHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasHistory) && !is_bool($hasHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasHistory, true), gettype($hasHistory)), __LINE__);
        }
        if (is_null($hasHistory) || (is_array($hasHistory) && empty($hasHistory))) {
            unset($this->HasHistory);
        } else {
            $this->HasHistory = $hasHistory;
        }
        return $this;
    }
    /**
     * Get ItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemTypeId()
    {
        return isset($this->ItemTypeId) ? $this->ItemTypeId : null;
    }
    /**
     * Set ItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemTypeId
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setItemTypeId($itemTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($itemTypeId) && !is_string($itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemTypeId, true), gettype($itemTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemTypeId, true)), __LINE__);
        }
        if (is_null($itemTypeId) || (is_array($itemTypeId) && empty($itemTypeId))) {
            unset($this->ItemTypeId);
        } else {
            $this->ItemTypeId = $itemTypeId;
        }
        return $this;
    }
    /**
     * Get MerchandiseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseId()
    {
        return isset($this->MerchandiseId) ? $this->MerchandiseId : null;
    }
    /**
     * Set MerchandiseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseId
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setMerchandiseId($merchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseId) && !is_string($merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseId, true), gettype($merchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseId, true)), __LINE__);
        }
        if (is_null($merchandiseId) || (is_array($merchandiseId) && empty($merchandiseId))) {
            unset($this->MerchandiseId);
        } else {
            $this->MerchandiseId = $merchandiseId;
        }
        return $this;
    }
    /**
     * Get MerchandiseName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMerchandiseName()
    {
        return isset($this->MerchandiseName) ? $this->MerchandiseName : null;
    }
    /**
     * Set MerchandiseName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $merchandiseName
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setMerchandiseName(\patest\StructType\GlobalString $merchandiseName = null)
    {
        if (is_null($merchandiseName) || (is_array($merchandiseName) && empty($merchandiseName))) {
            unset($this->MerchandiseName);
        } else {
            $this->MerchandiseName = $merchandiseName;
        }
        return $this;
    }
    /**
     * Get OwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerName()
    {
        return isset($this->OwnerName) ? $this->OwnerName : null;
    }
    /**
     * Set OwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerName
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        if (is_null($ownerName) || (is_array($ownerName) && empty($ownerName))) {
            unset($this->OwnerName);
        } else {
            $this->OwnerName = $ownerName;
        }
        return $this;
    }
    /**
     * Get PaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaidAmount()
    {
        return isset($this->PaidAmount) ? $this->PaidAmount : null;
    }
    /**
     * Set PaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paidAmount
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setPaidAmount(\patest\StructType\Money $paidAmount = null)
    {
        if (is_null($paidAmount) || (is_array($paidAmount) && empty($paidAmount))) {
            unset($this->PaidAmount);
        } else {
            $this->PaidAmount = $paidAmount;
        }
        return $this;
    }
    /**
     * Get PaymentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return isset($this->PaymentStatus) ? $this->PaymentStatus : null;
    }
    /**
     * Set PaymentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentPaidStatusType::valueIsValid()
     * @uses \patest\EnumType\PaymentPaidStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentStatus
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentPaidStatusType::valueIsValid($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentPaidStatusType', is_array($paymentStatus) ? implode(', ', $paymentStatus) : var_export($paymentStatus, true), implode(', ', \patest\EnumType\PaymentPaidStatusType::getValidValues())), __LINE__);
        }
        if (is_null($paymentStatus) || (is_array($paymentStatus) && empty($paymentStatus))) {
            unset($this->PaymentStatus);
        } else {
            $this->PaymentStatus = $paymentStatus;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductId()
    {
        return isset($this->ProductId) ? $this->ProductId : null;
    }
    /**
     * Set ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productId
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        if (is_null($productId) || (is_array($productId) && empty($productId))) {
            unset($this->ProductId);
        } else {
            $this->ProductId = $productId;
        }
        return $this;
    }
    /**
     * Get ProductName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getProductName()
    {
        return isset($this->ProductName) ? $this->ProductName : null;
    }
    /**
     * Set ProductName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $productName
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setProductName(\patest\StructType\GlobalString $productName = null)
    {
        if (is_null($productName) || (is_array($productName) && empty($productName))) {
            unset($this->ProductName);
        } else {
            $this->ProductName = $productName;
        }
        return $this;
    }
    /**
     * Get PurchaserClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserClientId()
    {
        return isset($this->PurchaserClientId) ? $this->PurchaserClientId : null;
    }
    /**
     * Set PurchaserClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserClientId
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setPurchaserClientId($purchaserClientId = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserClientId) && !is_string($purchaserClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserClientId, true), gettype($purchaserClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purchaserClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purchaserClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purchaserClientId, true)), __LINE__);
        }
        if (is_null($purchaserClientId) || (is_array($purchaserClientId) && empty($purchaserClientId))) {
            unset($this->PurchaserClientId);
        } else {
            $this->PurchaserClientId = $purchaserClientId;
        }
        return $this;
    }
    /**
     * Get PurchaserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserName()
    {
        return isset($this->PurchaserName) ? $this->PurchaserName : null;
    }
    /**
     * Set PurchaserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserName
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setPurchaserName($purchaserName = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserName) && !is_string($purchaserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserName, true), gettype($purchaserName)), __LINE__);
        }
        if (is_null($purchaserName) || (is_array($purchaserName) && empty($purchaserName))) {
            unset($this->PurchaserName);
        } else {
            $this->PurchaserName = $purchaserName;
        }
        return $this;
    }
    /**
     * Get SalesRepCustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepCustomerId()
    {
        return isset($this->SalesRepCustomerId) ? $this->SalesRepCustomerId : null;
    }
    /**
     * Set SalesRepCustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepCustomerId
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setSalesRepCustomerId($salesRepCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepCustomerId) && !is_string($salesRepCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepCustomerId, true), gettype($salesRepCustomerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepCustomerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepCustomerId, true)), __LINE__);
        }
        if (is_null($salesRepCustomerId) || (is_array($salesRepCustomerId) && empty($salesRepCustomerId))) {
            unset($this->SalesRepCustomerId);
        } else {
            $this->SalesRepCustomerId = $salesRepCustomerId;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionNotes()
    {
        return isset($this->TransactionNotes) ? $this->TransactionNotes : null;
    }
    /**
     * Set TransactionNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionNotes
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setTransactionNotes($transactionNotes = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNotes) && !is_string($transactionNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNotes, true), gettype($transactionNotes)), __LINE__);
        }
        if (is_null($transactionNotes) || (is_array($transactionNotes) && empty($transactionNotes))) {
            unset($this->TransactionNotes);
        } else {
            $this->TransactionNotes = $transactionNotes;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionReferenceNumber()
    {
        return isset($this->TransactionReferenceNumber) ? $this->TransactionReferenceNumber : null;
    }
    /**
     * Set TransactionReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionReferenceNumber
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setTransactionReferenceNumber($transactionReferenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionReferenceNumber) && !(is_int($transactionReferenceNumber) || ctype_digit($transactionReferenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionReferenceNumber, true), gettype($transactionReferenceNumber)), __LINE__);
        }
        if (is_null($transactionReferenceNumber) || (is_array($transactionReferenceNumber) && empty($transactionReferenceNumber))) {
            unset($this->TransactionReferenceNumber);
        } else {
            $this->TransactionReferenceNumber = $transactionReferenceNumber;
        }
        return $this;
    }
    /**
     * Get UnpaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getUnpaidAmount()
    {
        return isset($this->UnpaidAmount) ? $this->UnpaidAmount : null;
    }
    /**
     * Set UnpaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $unpaidAmount
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setUnpaidAmount(\patest\StructType\Money $unpaidAmount = null)
    {
        if (is_null($unpaidAmount) || (is_array($unpaidAmount) && empty($unpaidAmount))) {
            unset($this->UnpaidAmount);
        } else {
            $this->UnpaidAmount = $unpaidAmount;
        }
        return $this;
    }
    /**
     * Get UnpaidInstallmentsAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getUnpaidInstallmentsAmount()
    {
        return isset($this->UnpaidInstallmentsAmount) ? $this->UnpaidInstallmentsAmount : null;
    }
    /**
     * Set UnpaidInstallmentsAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $unpaidInstallmentsAmount
     * @return \patest\StructType\Merchandise_MerchandiseExtended
     */
    public function setUnpaidInstallmentsAmount(\patest\StructType\Money $unpaidInstallmentsAmount = null)
    {
        if (is_null($unpaidInstallmentsAmount) || (is_array($unpaidInstallmentsAmount) && empty($unpaidInstallmentsAmount))) {
            unset($this->UnpaidInstallmentsAmount);
        } else {
            $this->UnpaidInstallmentsAmount = $unpaidInstallmentsAmount;
        }
        return $this;
    }
}
