<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.Merchandise StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Merchandise.Merchandise
 * @subpackage Structs
 */
class Merchandise_Merchandise extends Merchandise_MerchandiseBase
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The AdditionalBarcodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMerchandise_MerchandiseItemAdditionalBarcode
     */
    public $AdditionalBarcodes;
    /**
     * The AlertInventoryAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AlertInventoryAmount;
    /**
     * The Attribute1ValueId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Attribute1ValueId;
    /**
     * The Attribute2ValueId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Attribute2ValueId;
    /**
     * The Attribute3ValueId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Attribute3ValueId;
    /**
     * The Attribute4ValueId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Attribute4ValueId;
    /**
     * The AvailableForDisplayFrom
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForDisplayFrom;
    /**
     * The AvailableForDisplayUntil
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForDisplayUntil;
    /**
     * The AvailableForSaleFrom
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForSaleFrom;
    /**
     * The AvailableForSaleUntil
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForSaleUntil;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The CopyFrom
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CopyFrom;
    /**
     * The CrossOrgUnitsAclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CrossOrgUnitsAclSchemeId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The HasNoAttributes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasNoAttributes;
    /**
     * The Ingredients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMerchandise_MerchandiseIngredient
     */
    public $Ingredients;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsAvailableForDisplay
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForDisplay;
    /**
     * The IsAvailableForSale
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForSale;
    /**
     * The ItemCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ItemCost;
    /**
     * The ItemEsv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ItemEsv;
    /**
     * The ItemSku
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemSku;
    /**
     * The ItemTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemTypeId;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The LocationQuantityInInventory
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LocationQuantityInInventory;
    /**
     * The Manufacturer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Manufacturer;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Merchandise_Media
     */
    public $Media;
    /**
     * The MinimumActualStock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MinimumActualStock;
    /**
     * The MinItemsInStock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MinItemsInStock;
    /**
     * The Model
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Model;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NotificationToUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NotificationToUserId;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Price;
    /**
     * The PricePerUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PricePerUnit;
    /**
     * The ProductEsv
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ProductEsv;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The QuantityInInventory
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantityInInventory;
    /**
     * The QuantityInOrder
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantityInOrder;
    /**
     * The SellOnlyAsPartOfPrompt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SellOnlyAsPartOfPrompt;
    /**
     * The StockType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StockType;
    /**
     * The Suppliers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMerchandise_MerchandiseSupplier
     */
    public $Suppliers;
    /**
     * The UPC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UPC;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Merchandise.Merchandise
     * @uses Merchandise_Merchandise::setAclSchemeId()
     * @uses Merchandise_Merchandise::setAdditionalBarcodes()
     * @uses Merchandise_Merchandise::setAlertInventoryAmount()
     * @uses Merchandise_Merchandise::setAttribute1ValueId()
     * @uses Merchandise_Merchandise::setAttribute2ValueId()
     * @uses Merchandise_Merchandise::setAttribute3ValueId()
     * @uses Merchandise_Merchandise::setAttribute4ValueId()
     * @uses Merchandise_Merchandise::setAvailableForDisplayFrom()
     * @uses Merchandise_Merchandise::setAvailableForDisplayUntil()
     * @uses Merchandise_Merchandise::setAvailableForSaleFrom()
     * @uses Merchandise_Merchandise::setAvailableForSaleUntil()
     * @uses Merchandise_Merchandise::setBarcode()
     * @uses Merchandise_Merchandise::setCategoryId()
     * @uses Merchandise_Merchandise::setCopyFrom()
     * @uses Merchandise_Merchandise::setCrossOrgUnitsAclSchemeId()
     * @uses Merchandise_Merchandise::setDescription()
     * @uses Merchandise_Merchandise::setExternalId()
     * @uses Merchandise_Merchandise::setHasNoAttributes()
     * @uses Merchandise_Merchandise::setIngredients()
     * @uses Merchandise_Merchandise::setIsActive()
     * @uses Merchandise_Merchandise::setIsAvailableForDisplay()
     * @uses Merchandise_Merchandise::setIsAvailableForSale()
     * @uses Merchandise_Merchandise::setItemCost()
     * @uses Merchandise_Merchandise::setItemEsv()
     * @uses Merchandise_Merchandise::setItemSku()
     * @uses Merchandise_Merchandise::setItemTypeId()
     * @uses Merchandise_Merchandise::setLedgerId()
     * @uses Merchandise_Merchandise::setLocationQuantityInInventory()
     * @uses Merchandise_Merchandise::setManufacturer()
     * @uses Merchandise_Merchandise::setMedia()
     * @uses Merchandise_Merchandise::setMinimumActualStock()
     * @uses Merchandise_Merchandise::setMinItemsInStock()
     * @uses Merchandise_Merchandise::setModel()
     * @uses Merchandise_Merchandise::setName()
     * @uses Merchandise_Merchandise::setNotificationToUserId()
     * @uses Merchandise_Merchandise::setOrdinal()
     * @uses Merchandise_Merchandise::setOrganizationUnitId()
     * @uses Merchandise_Merchandise::setPrice()
     * @uses Merchandise_Merchandise::setPricePerUnit()
     * @uses Merchandise_Merchandise::setProductEsv()
     * @uses Merchandise_Merchandise::setProductId()
     * @uses Merchandise_Merchandise::setProjectIdentifierId()
     * @uses Merchandise_Merchandise::setQuantityInInventory()
     * @uses Merchandise_Merchandise::setQuantityInOrder()
     * @uses Merchandise_Merchandise::setSellOnlyAsPartOfPrompt()
     * @uses Merchandise_Merchandise::setStockType()
     * @uses Merchandise_Merchandise::setSuppliers()
     * @uses Merchandise_Merchandise::setUPC()
     * @uses Merchandise_Merchandise::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param \patest\StructType\RecordSetOfMerchandise_MerchandiseItemAdditionalBarcode $additionalBarcodes
     * @param int $alertInventoryAmount
     * @param string $attribute1ValueId
     * @param string $attribute2ValueId
     * @param string $attribute3ValueId
     * @param string $attribute4ValueId
     * @param string $availableForDisplayFrom
     * @param string $availableForDisplayUntil
     * @param string $availableForSaleFrom
     * @param string $availableForSaleUntil
     * @param string $barcode
     * @param string $categoryId
     * @param string $copyFrom
     * @param int $crossOrgUnitsAclSchemeId
     * @param \patest\StructType\GlobalString $description
     * @param string $externalId
     * @param bool $hasNoAttributes
     * @param \patest\StructType\RecordSetOfMerchandise_MerchandiseIngredient $ingredients
     * @param bool $isActive
     * @param bool $isAvailableForDisplay
     * @param bool $isAvailableForSale
     * @param \patest\StructType\Money $itemCost
     * @param \patest\StructType\Money $itemEsv
     * @param string $itemSku
     * @param string $itemTypeId
     * @param string $ledgerId
     * @param float $locationQuantityInInventory
     * @param \patest\StructType\GlobalString $manufacturer
     * @param \patest\StructType\Merchandise_Media $media
     * @param float $minimumActualStock
     * @param float $minItemsInStock
     * @param string $model
     * @param \patest\StructType\GlobalString $name
     * @param string $notificationToUserId
     * @param int $ordinal
     * @param string $organizationUnitId
     * @param float $price
     * @param float $pricePerUnit
     * @param \patest\StructType\Money $productEsv
     * @param string $productId
     * @param string $projectIdentifierId
     * @param float $quantityInInventory
     * @param float $quantityInOrder
     * @param bool $sellOnlyAsPartOfPrompt
     * @param string $stockType
     * @param \patest\StructType\RecordSetOfMerchandise_MerchandiseSupplier $suppliers
     * @param string $uPC
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, \patest\StructType\RecordSetOfMerchandise_MerchandiseItemAdditionalBarcode $additionalBarcodes = null, $alertInventoryAmount = null, $attribute1ValueId = null, $attribute2ValueId = null, $attribute3ValueId = null, $attribute4ValueId = null, $availableForDisplayFrom = null, $availableForDisplayUntil = null, $availableForSaleFrom = null, $availableForSaleUntil = null, $barcode = null, $categoryId = null, $copyFrom = null, $crossOrgUnitsAclSchemeId = null, \patest\StructType\GlobalString $description = null, $externalId = null, $hasNoAttributes = null, \patest\StructType\RecordSetOfMerchandise_MerchandiseIngredient $ingredients = null, $isActive = null, $isAvailableForDisplay = null, $isAvailableForSale = null, \patest\StructType\Money $itemCost = null, \patest\StructType\Money $itemEsv = null, $itemSku = null, $itemTypeId = null, $ledgerId = null, $locationQuantityInInventory = null, \patest\StructType\GlobalString $manufacturer = null, \patest\StructType\Merchandise_Media $media = null, $minimumActualStock = null, $minItemsInStock = null, $model = null, \patest\StructType\GlobalString $name = null, $notificationToUserId = null, $ordinal = null, $organizationUnitId = null, $price = null, $pricePerUnit = null, \patest\StructType\Money $productEsv = null, $productId = null, $projectIdentifierId = null, $quantityInInventory = null, $quantityInOrder = null, $sellOnlyAsPartOfPrompt = null, $stockType = null, \patest\StructType\RecordSetOfMerchandise_MerchandiseSupplier $suppliers = null, $uPC = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setAdditionalBarcodes($additionalBarcodes)
            ->setAlertInventoryAmount($alertInventoryAmount)
            ->setAttribute1ValueId($attribute1ValueId)
            ->setAttribute2ValueId($attribute2ValueId)
            ->setAttribute3ValueId($attribute3ValueId)
            ->setAttribute4ValueId($attribute4ValueId)
            ->setAvailableForDisplayFrom($availableForDisplayFrom)
            ->setAvailableForDisplayUntil($availableForDisplayUntil)
            ->setAvailableForSaleFrom($availableForSaleFrom)
            ->setAvailableForSaleUntil($availableForSaleUntil)
            ->setBarcode($barcode)
            ->setCategoryId($categoryId)
            ->setCopyFrom($copyFrom)
            ->setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId)
            ->setDescription($description)
            ->setExternalId($externalId)
            ->setHasNoAttributes($hasNoAttributes)
            ->setIngredients($ingredients)
            ->setIsActive($isActive)
            ->setIsAvailableForDisplay($isAvailableForDisplay)
            ->setIsAvailableForSale($isAvailableForSale)
            ->setItemCost($itemCost)
            ->setItemEsv($itemEsv)
            ->setItemSku($itemSku)
            ->setItemTypeId($itemTypeId)
            ->setLedgerId($ledgerId)
            ->setLocationQuantityInInventory($locationQuantityInInventory)
            ->setManufacturer($manufacturer)
            ->setMedia($media)
            ->setMinimumActualStock($minimumActualStock)
            ->setMinItemsInStock($minItemsInStock)
            ->setModel($model)
            ->setName($name)
            ->setNotificationToUserId($notificationToUserId)
            ->setOrdinal($ordinal)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPrice($price)
            ->setPricePerUnit($pricePerUnit)
            ->setProductEsv($productEsv)
            ->setProductId($productId)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setQuantityInInventory($quantityInInventory)
            ->setQuantityInOrder($quantityInOrder)
            ->setSellOnlyAsPartOfPrompt($sellOnlyAsPartOfPrompt)
            ->setStockType($stockType)
            ->setSuppliers($suppliers)
            ->setUPC($uPC)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get AdditionalBarcodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMerchandise_MerchandiseItemAdditionalBarcode|null
     */
    public function getAdditionalBarcodes()
    {
        return isset($this->AdditionalBarcodes) ? $this->AdditionalBarcodes : null;
    }
    /**
     * Set AdditionalBarcodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMerchandise_MerchandiseItemAdditionalBarcode $additionalBarcodes
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setAdditionalBarcodes(\patest\StructType\RecordSetOfMerchandise_MerchandiseItemAdditionalBarcode $additionalBarcodes = null)
    {
        if (is_null($additionalBarcodes) || (is_array($additionalBarcodes) && empty($additionalBarcodes))) {
            unset($this->AdditionalBarcodes);
        } else {
            $this->AdditionalBarcodes = $additionalBarcodes;
        }
        return $this;
    }
    /**
     * Get AlertInventoryAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAlertInventoryAmount()
    {
        return isset($this->AlertInventoryAmount) ? $this->AlertInventoryAmount : null;
    }
    /**
     * Set AlertInventoryAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $alertInventoryAmount
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setAlertInventoryAmount($alertInventoryAmount = null)
    {
        // validation for constraint: int
        if (!is_null($alertInventoryAmount) && !(is_int($alertInventoryAmount) || ctype_digit($alertInventoryAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alertInventoryAmount, true), gettype($alertInventoryAmount)), __LINE__);
        }
        if (is_null($alertInventoryAmount) || (is_array($alertInventoryAmount) && empty($alertInventoryAmount))) {
            unset($this->AlertInventoryAmount);
        } else {
            $this->AlertInventoryAmount = $alertInventoryAmount;
        }
        return $this;
    }
    /**
     * Get Attribute1ValueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttribute1ValueId()
    {
        return isset($this->Attribute1ValueId) ? $this->Attribute1ValueId : null;
    }
    /**
     * Set Attribute1ValueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attribute1ValueId
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setAttribute1ValueId($attribute1ValueId = null)
    {
        // validation for constraint: string
        if (!is_null($attribute1ValueId) && !is_string($attribute1ValueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attribute1ValueId, true), gettype($attribute1ValueId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attribute1ValueId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attribute1ValueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attribute1ValueId, true)), __LINE__);
        }
        if (is_null($attribute1ValueId) || (is_array($attribute1ValueId) && empty($attribute1ValueId))) {
            unset($this->Attribute1ValueId);
        } else {
            $this->Attribute1ValueId = $attribute1ValueId;
        }
        return $this;
    }
    /**
     * Get Attribute2ValueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttribute2ValueId()
    {
        return isset($this->Attribute2ValueId) ? $this->Attribute2ValueId : null;
    }
    /**
     * Set Attribute2ValueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attribute2ValueId
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setAttribute2ValueId($attribute2ValueId = null)
    {
        // validation for constraint: string
        if (!is_null($attribute2ValueId) && !is_string($attribute2ValueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attribute2ValueId, true), gettype($attribute2ValueId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attribute2ValueId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attribute2ValueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attribute2ValueId, true)), __LINE__);
        }
        if (is_null($attribute2ValueId) || (is_array($attribute2ValueId) && empty($attribute2ValueId))) {
            unset($this->Attribute2ValueId);
        } else {
            $this->Attribute2ValueId = $attribute2ValueId;
        }
        return $this;
    }
    /**
     * Get Attribute3ValueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttribute3ValueId()
    {
        return isset($this->Attribute3ValueId) ? $this->Attribute3ValueId : null;
    }
    /**
     * Set Attribute3ValueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attribute3ValueId
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setAttribute3ValueId($attribute3ValueId = null)
    {
        // validation for constraint: string
        if (!is_null($attribute3ValueId) && !is_string($attribute3ValueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attribute3ValueId, true), gettype($attribute3ValueId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attribute3ValueId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attribute3ValueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attribute3ValueId, true)), __LINE__);
        }
        if (is_null($attribute3ValueId) || (is_array($attribute3ValueId) && empty($attribute3ValueId))) {
            unset($this->Attribute3ValueId);
        } else {
            $this->Attribute3ValueId = $attribute3ValueId;
        }
        return $this;
    }
    /**
     * Get Attribute4ValueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttribute4ValueId()
    {
        return isset($this->Attribute4ValueId) ? $this->Attribute4ValueId : null;
    }
    /**
     * Set Attribute4ValueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attribute4ValueId
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setAttribute4ValueId($attribute4ValueId = null)
    {
        // validation for constraint: string
        if (!is_null($attribute4ValueId) && !is_string($attribute4ValueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attribute4ValueId, true), gettype($attribute4ValueId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attribute4ValueId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attribute4ValueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attribute4ValueId, true)), __LINE__);
        }
        if (is_null($attribute4ValueId) || (is_array($attribute4ValueId) && empty($attribute4ValueId))) {
            unset($this->Attribute4ValueId);
        } else {
            $this->Attribute4ValueId = $attribute4ValueId;
        }
        return $this;
    }
    /**
     * Get AvailableForDisplayFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForDisplayFrom()
    {
        return isset($this->AvailableForDisplayFrom) ? $this->AvailableForDisplayFrom : null;
    }
    /**
     * Set AvailableForDisplayFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForDisplayFrom
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setAvailableForDisplayFrom($availableForDisplayFrom = null)
    {
        // validation for constraint: string
        if (!is_null($availableForDisplayFrom) && !is_string($availableForDisplayFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForDisplayFrom, true), gettype($availableForDisplayFrom)), __LINE__);
        }
        if (is_null($availableForDisplayFrom) || (is_array($availableForDisplayFrom) && empty($availableForDisplayFrom))) {
            unset($this->AvailableForDisplayFrom);
        } else {
            $this->AvailableForDisplayFrom = $availableForDisplayFrom;
        }
        return $this;
    }
    /**
     * Get AvailableForDisplayUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForDisplayUntil()
    {
        return isset($this->AvailableForDisplayUntil) ? $this->AvailableForDisplayUntil : null;
    }
    /**
     * Set AvailableForDisplayUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForDisplayUntil
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setAvailableForDisplayUntil($availableForDisplayUntil = null)
    {
        // validation for constraint: string
        if (!is_null($availableForDisplayUntil) && !is_string($availableForDisplayUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForDisplayUntil, true), gettype($availableForDisplayUntil)), __LINE__);
        }
        if (is_null($availableForDisplayUntil) || (is_array($availableForDisplayUntil) && empty($availableForDisplayUntil))) {
            unset($this->AvailableForDisplayUntil);
        } else {
            $this->AvailableForDisplayUntil = $availableForDisplayUntil;
        }
        return $this;
    }
    /**
     * Get AvailableForSaleFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForSaleFrom()
    {
        return isset($this->AvailableForSaleFrom) ? $this->AvailableForSaleFrom : null;
    }
    /**
     * Set AvailableForSaleFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForSaleFrom
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setAvailableForSaleFrom($availableForSaleFrom = null)
    {
        // validation for constraint: string
        if (!is_null($availableForSaleFrom) && !is_string($availableForSaleFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForSaleFrom, true), gettype($availableForSaleFrom)), __LINE__);
        }
        if (is_null($availableForSaleFrom) || (is_array($availableForSaleFrom) && empty($availableForSaleFrom))) {
            unset($this->AvailableForSaleFrom);
        } else {
            $this->AvailableForSaleFrom = $availableForSaleFrom;
        }
        return $this;
    }
    /**
     * Get AvailableForSaleUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForSaleUntil()
    {
        return isset($this->AvailableForSaleUntil) ? $this->AvailableForSaleUntil : null;
    }
    /**
     * Set AvailableForSaleUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForSaleUntil
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setAvailableForSaleUntil($availableForSaleUntil = null)
    {
        // validation for constraint: string
        if (!is_null($availableForSaleUntil) && !is_string($availableForSaleUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForSaleUntil, true), gettype($availableForSaleUntil)), __LINE__);
        }
        if (is_null($availableForSaleUntil) || (is_array($availableForSaleUntil) && empty($availableForSaleUntil))) {
            unset($this->AvailableForSaleUntil);
        } else {
            $this->AvailableForSaleUntil = $availableForSaleUntil;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get CopyFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCopyFrom()
    {
        return isset($this->CopyFrom) ? $this->CopyFrom : null;
    }
    /**
     * Set CopyFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $copyFrom
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setCopyFrom($copyFrom = null)
    {
        // validation for constraint: string
        if (!is_null($copyFrom) && !is_string($copyFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyFrom, true), gettype($copyFrom)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($copyFrom) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $copyFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($copyFrom, true)), __LINE__);
        }
        if (is_null($copyFrom) || (is_array($copyFrom) && empty($copyFrom))) {
            unset($this->CopyFrom);
        } else {
            $this->CopyFrom = $copyFrom;
        }
        return $this;
    }
    /**
     * Get CrossOrgUnitsAclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCrossOrgUnitsAclSchemeId()
    {
        return isset($this->CrossOrgUnitsAclSchemeId) ? $this->CrossOrgUnitsAclSchemeId : null;
    }
    /**
     * Set CrossOrgUnitsAclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $crossOrgUnitsAclSchemeId
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($crossOrgUnitsAclSchemeId) && !(is_int($crossOrgUnitsAclSchemeId) || ctype_digit($crossOrgUnitsAclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($crossOrgUnitsAclSchemeId, true), gettype($crossOrgUnitsAclSchemeId)), __LINE__);
        }
        if (is_null($crossOrgUnitsAclSchemeId) || (is_array($crossOrgUnitsAclSchemeId) && empty($crossOrgUnitsAclSchemeId))) {
            unset($this->CrossOrgUnitsAclSchemeId);
        } else {
            $this->CrossOrgUnitsAclSchemeId = $crossOrgUnitsAclSchemeId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get HasNoAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasNoAttributes()
    {
        return isset($this->HasNoAttributes) ? $this->HasNoAttributes : null;
    }
    /**
     * Set HasNoAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasNoAttributes
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setHasNoAttributes($hasNoAttributes = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasNoAttributes) && !is_bool($hasNoAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasNoAttributes, true), gettype($hasNoAttributes)), __LINE__);
        }
        if (is_null($hasNoAttributes) || (is_array($hasNoAttributes) && empty($hasNoAttributes))) {
            unset($this->HasNoAttributes);
        } else {
            $this->HasNoAttributes = $hasNoAttributes;
        }
        return $this;
    }
    /**
     * Get Ingredients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMerchandise_MerchandiseIngredient|null
     */
    public function getIngredients()
    {
        return isset($this->Ingredients) ? $this->Ingredients : null;
    }
    /**
     * Set Ingredients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMerchandise_MerchandiseIngredient $ingredients
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setIngredients(\patest\StructType\RecordSetOfMerchandise_MerchandiseIngredient $ingredients = null)
    {
        if (is_null($ingredients) || (is_array($ingredients) && empty($ingredients))) {
            unset($this->Ingredients);
        } else {
            $this->Ingredients = $ingredients;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsAvailableForDisplay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForDisplay()
    {
        return isset($this->IsAvailableForDisplay) ? $this->IsAvailableForDisplay : null;
    }
    /**
     * Set IsAvailableForDisplay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForDisplay
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setIsAvailableForDisplay($isAvailableForDisplay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForDisplay) && !is_bool($isAvailableForDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForDisplay, true), gettype($isAvailableForDisplay)), __LINE__);
        }
        if (is_null($isAvailableForDisplay) || (is_array($isAvailableForDisplay) && empty($isAvailableForDisplay))) {
            unset($this->IsAvailableForDisplay);
        } else {
            $this->IsAvailableForDisplay = $isAvailableForDisplay;
        }
        return $this;
    }
    /**
     * Get IsAvailableForSale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForSale()
    {
        return isset($this->IsAvailableForSale) ? $this->IsAvailableForSale : null;
    }
    /**
     * Set IsAvailableForSale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForSale
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setIsAvailableForSale($isAvailableForSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForSale) && !is_bool($isAvailableForSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForSale, true), gettype($isAvailableForSale)), __LINE__);
        }
        if (is_null($isAvailableForSale) || (is_array($isAvailableForSale) && empty($isAvailableForSale))) {
            unset($this->IsAvailableForSale);
        } else {
            $this->IsAvailableForSale = $isAvailableForSale;
        }
        return $this;
    }
    /**
     * Get ItemCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getItemCost()
    {
        return isset($this->ItemCost) ? $this->ItemCost : null;
    }
    /**
     * Set ItemCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $itemCost
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setItemCost(\patest\StructType\Money $itemCost = null)
    {
        if (is_null($itemCost) || (is_array($itemCost) && empty($itemCost))) {
            unset($this->ItemCost);
        } else {
            $this->ItemCost = $itemCost;
        }
        return $this;
    }
    /**
     * Get ItemEsv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getItemEsv()
    {
        return isset($this->ItemEsv) ? $this->ItemEsv : null;
    }
    /**
     * Set ItemEsv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $itemEsv
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setItemEsv(\patest\StructType\Money $itemEsv = null)
    {
        if (is_null($itemEsv) || (is_array($itemEsv) && empty($itemEsv))) {
            unset($this->ItemEsv);
        } else {
            $this->ItemEsv = $itemEsv;
        }
        return $this;
    }
    /**
     * Get ItemSku value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemSku()
    {
        return isset($this->ItemSku) ? $this->ItemSku : null;
    }
    /**
     * Set ItemSku value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemSku
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setItemSku($itemSku = null)
    {
        // validation for constraint: string
        if (!is_null($itemSku) && !is_string($itemSku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSku, true), gettype($itemSku)), __LINE__);
        }
        if (is_null($itemSku) || (is_array($itemSku) && empty($itemSku))) {
            unset($this->ItemSku);
        } else {
            $this->ItemSku = $itemSku;
        }
        return $this;
    }
    /**
     * Get ItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemTypeId()
    {
        return isset($this->ItemTypeId) ? $this->ItemTypeId : null;
    }
    /**
     * Set ItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemTypeId
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setItemTypeId($itemTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($itemTypeId) && !is_string($itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemTypeId, true), gettype($itemTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemTypeId, true)), __LINE__);
        }
        if (is_null($itemTypeId) || (is_array($itemTypeId) && empty($itemTypeId))) {
            unset($this->ItemTypeId);
        } else {
            $this->ItemTypeId = $itemTypeId;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get LocationQuantityInInventory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLocationQuantityInInventory()
    {
        return isset($this->LocationQuantityInInventory) ? $this->LocationQuantityInInventory : null;
    }
    /**
     * Set LocationQuantityInInventory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $locationQuantityInInventory
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setLocationQuantityInInventory($locationQuantityInInventory = null)
    {
        // validation for constraint: float
        if (!is_null($locationQuantityInInventory) && !(is_float($locationQuantityInInventory) || is_numeric($locationQuantityInInventory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($locationQuantityInInventory, true), gettype($locationQuantityInInventory)), __LINE__);
        }
        if (is_null($locationQuantityInInventory) || (is_array($locationQuantityInInventory) && empty($locationQuantityInInventory))) {
            unset($this->LocationQuantityInInventory);
        } else {
            $this->LocationQuantityInInventory = $locationQuantityInInventory;
        }
        return $this;
    }
    /**
     * Get Manufacturer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getManufacturer()
    {
        return isset($this->Manufacturer) ? $this->Manufacturer : null;
    }
    /**
     * Set Manufacturer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $manufacturer
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setManufacturer(\patest\StructType\GlobalString $manufacturer = null)
    {
        if (is_null($manufacturer) || (is_array($manufacturer) && empty($manufacturer))) {
            unset($this->Manufacturer);
        } else {
            $this->Manufacturer = $manufacturer;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Merchandise_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Merchandise_Media $media
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setMedia(\patest\StructType\Merchandise_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get MinimumActualStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMinimumActualStock()
    {
        return isset($this->MinimumActualStock) ? $this->MinimumActualStock : null;
    }
    /**
     * Set MinimumActualStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $minimumActualStock
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setMinimumActualStock($minimumActualStock = null)
    {
        // validation for constraint: float
        if (!is_null($minimumActualStock) && !(is_float($minimumActualStock) || is_numeric($minimumActualStock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumActualStock, true), gettype($minimumActualStock)), __LINE__);
        }
        if (is_null($minimumActualStock) || (is_array($minimumActualStock) && empty($minimumActualStock))) {
            unset($this->MinimumActualStock);
        } else {
            $this->MinimumActualStock = $minimumActualStock;
        }
        return $this;
    }
    /**
     * Get MinItemsInStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMinItemsInStock()
    {
        return isset($this->MinItemsInStock) ? $this->MinItemsInStock : null;
    }
    /**
     * Set MinItemsInStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $minItemsInStock
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setMinItemsInStock($minItemsInStock = null)
    {
        // validation for constraint: float
        if (!is_null($minItemsInStock) && !(is_float($minItemsInStock) || is_numeric($minItemsInStock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minItemsInStock, true), gettype($minItemsInStock)), __LINE__);
        }
        if (is_null($minItemsInStock) || (is_array($minItemsInStock) && empty($minItemsInStock))) {
            unset($this->MinItemsInStock);
        } else {
            $this->MinItemsInStock = $minItemsInStock;
        }
        return $this;
    }
    /**
     * Get Model value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModel()
    {
        return isset($this->Model) ? $this->Model : null;
    }
    /**
     * Set Model value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $model
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setModel($model = null)
    {
        // validation for constraint: string
        if (!is_null($model) && !is_string($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($model, true), gettype($model)), __LINE__);
        }
        if (is_null($model) || (is_array($model) && empty($model))) {
            unset($this->Model);
        } else {
            $this->Model = $model;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NotificationToUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotificationToUserId()
    {
        return isset($this->NotificationToUserId) ? $this->NotificationToUserId : null;
    }
    /**
     * Set NotificationToUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notificationToUserId
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setNotificationToUserId($notificationToUserId = null)
    {
        // validation for constraint: string
        if (!is_null($notificationToUserId) && !is_string($notificationToUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationToUserId, true), gettype($notificationToUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($notificationToUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $notificationToUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($notificationToUserId, true)), __LINE__);
        }
        if (is_null($notificationToUserId) || (is_array($notificationToUserId) && empty($notificationToUserId))) {
            unset($this->NotificationToUserId);
        } else {
            $this->NotificationToUserId = $notificationToUserId;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * Get PricePerUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPricePerUnit()
    {
        return isset($this->PricePerUnit) ? $this->PricePerUnit : null;
    }
    /**
     * Set PricePerUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pricePerUnit
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setPricePerUnit($pricePerUnit = null)
    {
        // validation for constraint: float
        if (!is_null($pricePerUnit) && !(is_float($pricePerUnit) || is_numeric($pricePerUnit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pricePerUnit, true), gettype($pricePerUnit)), __LINE__);
        }
        if (is_null($pricePerUnit) || (is_array($pricePerUnit) && empty($pricePerUnit))) {
            unset($this->PricePerUnit);
        } else {
            $this->PricePerUnit = $pricePerUnit;
        }
        return $this;
    }
    /**
     * Get ProductEsv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getProductEsv()
    {
        return isset($this->ProductEsv) ? $this->ProductEsv : null;
    }
    /**
     * Set ProductEsv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $productEsv
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setProductEsv(\patest\StructType\Money $productEsv = null)
    {
        if (is_null($productEsv) || (is_array($productEsv) && empty($productEsv))) {
            unset($this->ProductEsv);
        } else {
            $this->ProductEsv = $productEsv;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductId()
    {
        return isset($this->ProductId) ? $this->ProductId : null;
    }
    /**
     * Set ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productId
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        if (is_null($productId) || (is_array($productId) && empty($productId))) {
            unset($this->ProductId);
        } else {
            $this->ProductId = $productId;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get QuantityInInventory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantityInInventory()
    {
        return isset($this->QuantityInInventory) ? $this->QuantityInInventory : null;
    }
    /**
     * Set QuantityInInventory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantityInInventory
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setQuantityInInventory($quantityInInventory = null)
    {
        // validation for constraint: float
        if (!is_null($quantityInInventory) && !(is_float($quantityInInventory) || is_numeric($quantityInInventory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityInInventory, true), gettype($quantityInInventory)), __LINE__);
        }
        if (is_null($quantityInInventory) || (is_array($quantityInInventory) && empty($quantityInInventory))) {
            unset($this->QuantityInInventory);
        } else {
            $this->QuantityInInventory = $quantityInInventory;
        }
        return $this;
    }
    /**
     * Get QuantityInOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantityInOrder()
    {
        return isset($this->QuantityInOrder) ? $this->QuantityInOrder : null;
    }
    /**
     * Set QuantityInOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantityInOrder
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setQuantityInOrder($quantityInOrder = null)
    {
        // validation for constraint: float
        if (!is_null($quantityInOrder) && !(is_float($quantityInOrder) || is_numeric($quantityInOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityInOrder, true), gettype($quantityInOrder)), __LINE__);
        }
        if (is_null($quantityInOrder) || (is_array($quantityInOrder) && empty($quantityInOrder))) {
            unset($this->QuantityInOrder);
        } else {
            $this->QuantityInOrder = $quantityInOrder;
        }
        return $this;
    }
    /**
     * Get SellOnlyAsPartOfPrompt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSellOnlyAsPartOfPrompt()
    {
        return isset($this->SellOnlyAsPartOfPrompt) ? $this->SellOnlyAsPartOfPrompt : null;
    }
    /**
     * Set SellOnlyAsPartOfPrompt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sellOnlyAsPartOfPrompt
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setSellOnlyAsPartOfPrompt($sellOnlyAsPartOfPrompt = null)
    {
        // validation for constraint: boolean
        if (!is_null($sellOnlyAsPartOfPrompt) && !is_bool($sellOnlyAsPartOfPrompt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sellOnlyAsPartOfPrompt, true), gettype($sellOnlyAsPartOfPrompt)), __LINE__);
        }
        if (is_null($sellOnlyAsPartOfPrompt) || (is_array($sellOnlyAsPartOfPrompt) && empty($sellOnlyAsPartOfPrompt))) {
            unset($this->SellOnlyAsPartOfPrompt);
        } else {
            $this->SellOnlyAsPartOfPrompt = $sellOnlyAsPartOfPrompt;
        }
        return $this;
    }
    /**
     * Get StockType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStockType()
    {
        return isset($this->StockType) ? $this->StockType : null;
    }
    /**
     * Set StockType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\StockType::valueIsValid()
     * @uses \patest\EnumType\StockType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stockType
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setStockType($stockType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\StockType::valueIsValid($stockType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\StockType', is_array($stockType) ? implode(', ', $stockType) : var_export($stockType, true), implode(', ', \patest\EnumType\StockType::getValidValues())), __LINE__);
        }
        if (is_null($stockType) || (is_array($stockType) && empty($stockType))) {
            unset($this->StockType);
        } else {
            $this->StockType = $stockType;
        }
        return $this;
    }
    /**
     * Get Suppliers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMerchandise_MerchandiseSupplier|null
     */
    public function getSuppliers()
    {
        return isset($this->Suppliers) ? $this->Suppliers : null;
    }
    /**
     * Set Suppliers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMerchandise_MerchandiseSupplier $suppliers
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setSuppliers(\patest\StructType\RecordSetOfMerchandise_MerchandiseSupplier $suppliers = null)
    {
        if (is_null($suppliers) || (is_array($suppliers) && empty($suppliers))) {
            unset($this->Suppliers);
        } else {
            $this->Suppliers = $suppliers;
        }
        return $this;
    }
    /**
     * Get UPC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUPC()
    {
        return isset($this->UPC) ? $this->UPC : null;
    }
    /**
     * Set UPC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uPC
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setUPC($uPC = null)
    {
        // validation for constraint: string
        if (!is_null($uPC) && !is_string($uPC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uPC, true), gettype($uPC)), __LINE__);
        }
        if (is_null($uPC) || (is_array($uPC) && empty($uPC))) {
            unset($this->UPC);
        } else {
            $this->UPC = $uPC;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Merchandise_Merchandise
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
