<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.Media StructType
 * @subpackage Structs
 */
class Merchandise_Media extends PersistableEntity
{
    /**
     * The BriefOverview
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $BriefOverview;
    /**
     * The DetailOverview
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DetailOverview;
    /**
     * The EffectiveOnlineHeroImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveOnlineHeroImageUrl;
    /**
     * The EffectiveOnlineThumbnailImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveOnlineThumbnailImageUrl;
    /**
     * The ImageMedia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMerchandise_ImageMedia
     */
    public $ImageMedia;
    /**
     * The Incentive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Incentive;
    /**
     * The OnlineHeroImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OnlineHeroImageId;
    /**
     * The OnlineThumbnailImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OnlineThumbnailImageId;
    /**
     * The PassbookDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PassbookDescription;
    /**
     * The ReviewUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ReviewUrl;
    /**
     * The TrailerUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TrailerUrl;
    /**
     * Constructor method for Merchandise.Media
     * @uses Merchandise_Media::setBriefOverview()
     * @uses Merchandise_Media::setDetailOverview()
     * @uses Merchandise_Media::setEffectiveOnlineHeroImageUrl()
     * @uses Merchandise_Media::setEffectiveOnlineThumbnailImageUrl()
     * @uses Merchandise_Media::setImageMedia()
     * @uses Merchandise_Media::setIncentive()
     * @uses Merchandise_Media::setOnlineHeroImageId()
     * @uses Merchandise_Media::setOnlineThumbnailImageId()
     * @uses Merchandise_Media::setPassbookDescription()
     * @uses Merchandise_Media::setReviewUrl()
     * @uses Merchandise_Media::setTrailerUrl()
     * @param \patest\StructType\GlobalString $briefOverview
     * @param \patest\StructType\GlobalString $detailOverview
     * @param string $effectiveOnlineHeroImageUrl
     * @param string $effectiveOnlineThumbnailImageUrl
     * @param \patest\StructType\RecordSetOfMerchandise_ImageMedia $imageMedia
     * @param \patest\StructType\GlobalString $incentive
     * @param int $onlineHeroImageId
     * @param int $onlineThumbnailImageId
     * @param \patest\StructType\GlobalString $passbookDescription
     * @param \patest\StructType\GlobalString $reviewUrl
     * @param \patest\StructType\GlobalString $trailerUrl
     */
    public function __construct(\patest\StructType\GlobalString $briefOverview = null, \patest\StructType\GlobalString $detailOverview = null, $effectiveOnlineHeroImageUrl = null, $effectiveOnlineThumbnailImageUrl = null, \patest\StructType\RecordSetOfMerchandise_ImageMedia $imageMedia = null, \patest\StructType\GlobalString $incentive = null, $onlineHeroImageId = null, $onlineThumbnailImageId = null, \patest\StructType\GlobalString $passbookDescription = null, \patest\StructType\GlobalString $reviewUrl = null, \patest\StructType\GlobalString $trailerUrl = null)
    {
        $this
            ->setBriefOverview($briefOverview)
            ->setDetailOverview($detailOverview)
            ->setEffectiveOnlineHeroImageUrl($effectiveOnlineHeroImageUrl)
            ->setEffectiveOnlineThumbnailImageUrl($effectiveOnlineThumbnailImageUrl)
            ->setImageMedia($imageMedia)
            ->setIncentive($incentive)
            ->setOnlineHeroImageId($onlineHeroImageId)
            ->setOnlineThumbnailImageId($onlineThumbnailImageId)
            ->setPassbookDescription($passbookDescription)
            ->setReviewUrl($reviewUrl)
            ->setTrailerUrl($trailerUrl);
    }
    /**
     * Get BriefOverview value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getBriefOverview()
    {
        return isset($this->BriefOverview) ? $this->BriefOverview : null;
    }
    /**
     * Set BriefOverview value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $briefOverview
     * @return \patest\StructType\Merchandise_Media
     */
    public function setBriefOverview(\patest\StructType\GlobalString $briefOverview = null)
    {
        if (is_null($briefOverview) || (is_array($briefOverview) && empty($briefOverview))) {
            unset($this->BriefOverview);
        } else {
            $this->BriefOverview = $briefOverview;
        }
        return $this;
    }
    /**
     * Get DetailOverview value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDetailOverview()
    {
        return isset($this->DetailOverview) ? $this->DetailOverview : null;
    }
    /**
     * Set DetailOverview value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $detailOverview
     * @return \patest\StructType\Merchandise_Media
     */
    public function setDetailOverview(\patest\StructType\GlobalString $detailOverview = null)
    {
        if (is_null($detailOverview) || (is_array($detailOverview) && empty($detailOverview))) {
            unset($this->DetailOverview);
        } else {
            $this->DetailOverview = $detailOverview;
        }
        return $this;
    }
    /**
     * Get EffectiveOnlineHeroImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveOnlineHeroImageUrl()
    {
        return isset($this->EffectiveOnlineHeroImageUrl) ? $this->EffectiveOnlineHeroImageUrl : null;
    }
    /**
     * Set EffectiveOnlineHeroImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveOnlineHeroImageUrl
     * @return \patest\StructType\Merchandise_Media
     */
    public function setEffectiveOnlineHeroImageUrl($effectiveOnlineHeroImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveOnlineHeroImageUrl) && !is_string($effectiveOnlineHeroImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveOnlineHeroImageUrl, true), gettype($effectiveOnlineHeroImageUrl)), __LINE__);
        }
        if (is_null($effectiveOnlineHeroImageUrl) || (is_array($effectiveOnlineHeroImageUrl) && empty($effectiveOnlineHeroImageUrl))) {
            unset($this->EffectiveOnlineHeroImageUrl);
        } else {
            $this->EffectiveOnlineHeroImageUrl = $effectiveOnlineHeroImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectiveOnlineThumbnailImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveOnlineThumbnailImageUrl()
    {
        return isset($this->EffectiveOnlineThumbnailImageUrl) ? $this->EffectiveOnlineThumbnailImageUrl : null;
    }
    /**
     * Set EffectiveOnlineThumbnailImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveOnlineThumbnailImageUrl
     * @return \patest\StructType\Merchandise_Media
     */
    public function setEffectiveOnlineThumbnailImageUrl($effectiveOnlineThumbnailImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveOnlineThumbnailImageUrl) && !is_string($effectiveOnlineThumbnailImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveOnlineThumbnailImageUrl, true), gettype($effectiveOnlineThumbnailImageUrl)), __LINE__);
        }
        if (is_null($effectiveOnlineThumbnailImageUrl) || (is_array($effectiveOnlineThumbnailImageUrl) && empty($effectiveOnlineThumbnailImageUrl))) {
            unset($this->EffectiveOnlineThumbnailImageUrl);
        } else {
            $this->EffectiveOnlineThumbnailImageUrl = $effectiveOnlineThumbnailImageUrl;
        }
        return $this;
    }
    /**
     * Get ImageMedia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMerchandise_ImageMedia|null
     */
    public function getImageMedia()
    {
        return isset($this->ImageMedia) ? $this->ImageMedia : null;
    }
    /**
     * Set ImageMedia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMerchandise_ImageMedia $imageMedia
     * @return \patest\StructType\Merchandise_Media
     */
    public function setImageMedia(\patest\StructType\RecordSetOfMerchandise_ImageMedia $imageMedia = null)
    {
        if (is_null($imageMedia) || (is_array($imageMedia) && empty($imageMedia))) {
            unset($this->ImageMedia);
        } else {
            $this->ImageMedia = $imageMedia;
        }
        return $this;
    }
    /**
     * Get Incentive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getIncentive()
    {
        return isset($this->Incentive) ? $this->Incentive : null;
    }
    /**
     * Set Incentive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $incentive
     * @return \patest\StructType\Merchandise_Media
     */
    public function setIncentive(\patest\StructType\GlobalString $incentive = null)
    {
        if (is_null($incentive) || (is_array($incentive) && empty($incentive))) {
            unset($this->Incentive);
        } else {
            $this->Incentive = $incentive;
        }
        return $this;
    }
    /**
     * Get OnlineHeroImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOnlineHeroImageId()
    {
        return isset($this->OnlineHeroImageId) ? $this->OnlineHeroImageId : null;
    }
    /**
     * Set OnlineHeroImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $onlineHeroImageId
     * @return \patest\StructType\Merchandise_Media
     */
    public function setOnlineHeroImageId($onlineHeroImageId = null)
    {
        // validation for constraint: int
        if (!is_null($onlineHeroImageId) && !(is_int($onlineHeroImageId) || ctype_digit($onlineHeroImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($onlineHeroImageId, true), gettype($onlineHeroImageId)), __LINE__);
        }
        if (is_null($onlineHeroImageId) || (is_array($onlineHeroImageId) && empty($onlineHeroImageId))) {
            unset($this->OnlineHeroImageId);
        } else {
            $this->OnlineHeroImageId = $onlineHeroImageId;
        }
        return $this;
    }
    /**
     * Get OnlineThumbnailImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOnlineThumbnailImageId()
    {
        return isset($this->OnlineThumbnailImageId) ? $this->OnlineThumbnailImageId : null;
    }
    /**
     * Set OnlineThumbnailImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $onlineThumbnailImageId
     * @return \patest\StructType\Merchandise_Media
     */
    public function setOnlineThumbnailImageId($onlineThumbnailImageId = null)
    {
        // validation for constraint: int
        if (!is_null($onlineThumbnailImageId) && !(is_int($onlineThumbnailImageId) || ctype_digit($onlineThumbnailImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($onlineThumbnailImageId, true), gettype($onlineThumbnailImageId)), __LINE__);
        }
        if (is_null($onlineThumbnailImageId) || (is_array($onlineThumbnailImageId) && empty($onlineThumbnailImageId))) {
            unset($this->OnlineThumbnailImageId);
        } else {
            $this->OnlineThumbnailImageId = $onlineThumbnailImageId;
        }
        return $this;
    }
    /**
     * Get PassbookDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPassbookDescription()
    {
        return isset($this->PassbookDescription) ? $this->PassbookDescription : null;
    }
    /**
     * Set PassbookDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $passbookDescription
     * @return \patest\StructType\Merchandise_Media
     */
    public function setPassbookDescription(\patest\StructType\GlobalString $passbookDescription = null)
    {
        if (is_null($passbookDescription) || (is_array($passbookDescription) && empty($passbookDescription))) {
            unset($this->PassbookDescription);
        } else {
            $this->PassbookDescription = $passbookDescription;
        }
        return $this;
    }
    /**
     * Get ReviewUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getReviewUrl()
    {
        return isset($this->ReviewUrl) ? $this->ReviewUrl : null;
    }
    /**
     * Set ReviewUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $reviewUrl
     * @return \patest\StructType\Merchandise_Media
     */
    public function setReviewUrl(\patest\StructType\GlobalString $reviewUrl = null)
    {
        if (is_null($reviewUrl) || (is_array($reviewUrl) && empty($reviewUrl))) {
            unset($this->ReviewUrl);
        } else {
            $this->ReviewUrl = $reviewUrl;
        }
        return $this;
    }
    /**
     * Get TrailerUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTrailerUrl()
    {
        return isset($this->TrailerUrl) ? $this->TrailerUrl : null;
    }
    /**
     * Set TrailerUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $trailerUrl
     * @return \patest\StructType\Merchandise_Media
     */
    public function setTrailerUrl(\patest\StructType\GlobalString $trailerUrl = null)
    {
        if (is_null($trailerUrl) || (is_array($trailerUrl) && empty($trailerUrl))) {
            unset($this->TrailerUrl);
        } else {
            $this->TrailerUrl = $trailerUrl;
        }
        return $this;
    }
}
