<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MerchandiseSaleItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MerchandiseSaleItem
 * @subpackage Structs
 */
class MerchandiseSaleItem extends AbstractStructBase
{
    /**
     * The InsertionMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InsertionMode;
    /**
     * The MerchandiseItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseItemId;
    /**
     * Constructor method for MerchandiseSaleItem
     * @uses MerchandiseSaleItem::setInsertionMode()
     * @uses MerchandiseSaleItem::setMerchandiseItemId()
     * @param string $insertionMode
     * @param string $merchandiseItemId
     */
    public function __construct($insertionMode = null, $merchandiseItemId = null)
    {
        $this
            ->setInsertionMode($insertionMode)
            ->setMerchandiseItemId($merchandiseItemId);
    }
    /**
     * Get InsertionMode value
     * @return string|null
     */
    public function getInsertionMode()
    {
        return $this->InsertionMode;
    }
    /**
     * Set InsertionMode value
     * @uses \patest\EnumType\ItemInsertionMode::valueIsValid()
     * @uses \patest\EnumType\ItemInsertionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insertionMode
     * @return \patest\StructType\MerchandiseSaleItem
     */
    public function setInsertionMode($insertionMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemInsertionMode::valueIsValid($insertionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemInsertionMode', is_array($insertionMode) ? implode(', ', $insertionMode) : var_export($insertionMode, true), implode(', ', \patest\EnumType\ItemInsertionMode::getValidValues())), __LINE__);
        }
        $this->InsertionMode = $insertionMode;
        return $this;
    }
    /**
     * Get MerchandiseItemId value
     * @return string|null
     */
    public function getMerchandiseItemId()
    {
        return $this->MerchandiseItemId;
    }
    /**
     * Set MerchandiseItemId value
     * @param string $merchandiseItemId
     * @return \patest\StructType\MerchandiseSaleItem
     */
    public function setMerchandiseItemId($merchandiseItemId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseItemId) && !is_string($merchandiseItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseItemId, true), gettype($merchandiseItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseItemId, true)), __LINE__);
        }
        $this->MerchandiseItemId = $merchandiseItemId;
        return $this;
    }
}
