<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MerchandiseProductItemAttribute StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MerchandiseProductItemAttribute
 * @subpackage Structs
 */
class MerchandiseProductItemAttribute extends AbstractStructBase
{
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TypeId;
    /**
     * The TypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeName;
    /**
     * The ValueId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ValueId;
    /**
     * The ValueName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValueName;
    /**
     * Constructor method for MerchandiseProductItemAttribute
     * @uses MerchandiseProductItemAttribute::setTypeId()
     * @uses MerchandiseProductItemAttribute::setTypeName()
     * @uses MerchandiseProductItemAttribute::setValueId()
     * @uses MerchandiseProductItemAttribute::setValueName()
     * @param string $typeId
     * @param string $typeName
     * @param string $valueId
     * @param string $valueName
     */
    public function __construct($typeId = null, $typeName = null, $valueId = null, $valueName = null)
    {
        $this
            ->setTypeId($typeId)
            ->setTypeName($typeName)
            ->setValueId($valueId)
            ->setValueName($valueName);
    }
    /**
     * Get TypeId value
     * @return string|null
     */
    public function getTypeId()
    {
        return $this->TypeId;
    }
    /**
     * Set TypeId value
     * @param string $typeId
     * @return \patest\StructType\MerchandiseProductItemAttribute
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($typeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($typeId, true)), __LINE__);
        }
        $this->TypeId = $typeId;
        return $this;
    }
    /**
     * Get TypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeName()
    {
        return isset($this->TypeName) ? $this->TypeName : null;
    }
    /**
     * Set TypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeName
     * @return \patest\StructType\MerchandiseProductItemAttribute
     */
    public function setTypeName($typeName = null)
    {
        // validation for constraint: string
        if (!is_null($typeName) && !is_string($typeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeName, true), gettype($typeName)), __LINE__);
        }
        if (is_null($typeName) || (is_array($typeName) && empty($typeName))) {
            unset($this->TypeName);
        } else {
            $this->TypeName = $typeName;
        }
        return $this;
    }
    /**
     * Get ValueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValueId()
    {
        return isset($this->ValueId) ? $this->ValueId : null;
    }
    /**
     * Set ValueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valueId
     * @return \patest\StructType\MerchandiseProductItemAttribute
     */
    public function setValueId($valueId = null)
    {
        // validation for constraint: string
        if (!is_null($valueId) && !is_string($valueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueId, true), gettype($valueId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($valueId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $valueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($valueId, true)), __LINE__);
        }
        if (is_null($valueId) || (is_array($valueId) && empty($valueId))) {
            unset($this->ValueId);
        } else {
            $this->ValueId = $valueId;
        }
        return $this;
    }
    /**
     * Get ValueName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValueName()
    {
        return isset($this->ValueName) ? $this->ValueName : null;
    }
    /**
     * Set ValueName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valueName
     * @return \patest\StructType\MerchandiseProductItemAttribute
     */
    public function setValueName($valueName = null)
    {
        // validation for constraint: string
        if (!is_null($valueName) && !is_string($valueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueName, true), gettype($valueName)), __LINE__);
        }
        if (is_null($valueName) || (is_array($valueName) && empty($valueName))) {
            unset($this->ValueName);
        } else {
            $this->ValueName = $valueName;
        }
        return $this;
    }
}
