<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MerchandiseProductItemAddOn StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MerchandiseProductItemAddOn
 * @subpackage Structs
 */
class MerchandiseProductItemAddOn extends AbstractStructBase
{
    /**
     * The Components
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfMerchandiseProductItemAddOnComponent
     */
    public $Components;
    /**
     * The TypeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeDescription;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TypeId;
    /**
     * Constructor method for MerchandiseProductItemAddOn
     * @uses MerchandiseProductItemAddOn::setComponents()
     * @uses MerchandiseProductItemAddOn::setTypeDescription()
     * @uses MerchandiseProductItemAddOn::setTypeId()
     * @param \patest\ArrayType\ArrayOfMerchandiseProductItemAddOnComponent $components
     * @param string $typeDescription
     * @param string $typeId
     */
    public function __construct(\patest\ArrayType\ArrayOfMerchandiseProductItemAddOnComponent $components = null, $typeDescription = null, $typeId = null)
    {
        $this
            ->setComponents($components)
            ->setTypeDescription($typeDescription)
            ->setTypeId($typeId);
    }
    /**
     * Get Components value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfMerchandiseProductItemAddOnComponent|null
     */
    public function getComponents()
    {
        return isset($this->Components) ? $this->Components : null;
    }
    /**
     * Set Components value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfMerchandiseProductItemAddOnComponent $components
     * @return \patest\StructType\MerchandiseProductItemAddOn
     */
    public function setComponents(\patest\ArrayType\ArrayOfMerchandiseProductItemAddOnComponent $components = null)
    {
        if (is_null($components) || (is_array($components) && empty($components))) {
            unset($this->Components);
        } else {
            $this->Components = $components;
        }
        return $this;
    }
    /**
     * Get TypeDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeDescription()
    {
        return isset($this->TypeDescription) ? $this->TypeDescription : null;
    }
    /**
     * Set TypeDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeDescription
     * @return \patest\StructType\MerchandiseProductItemAddOn
     */
    public function setTypeDescription($typeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($typeDescription) && !is_string($typeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDescription, true), gettype($typeDescription)), __LINE__);
        }
        if (is_null($typeDescription) || (is_array($typeDescription) && empty($typeDescription))) {
            unset($this->TypeDescription);
        } else {
            $this->TypeDescription = $typeDescription;
        }
        return $this;
    }
    /**
     * Get TypeId value
     * @return string|null
     */
    public function getTypeId()
    {
        return $this->TypeId;
    }
    /**
     * Set TypeId value
     * @param string $typeId
     * @return \patest\StructType\MerchandiseProductItemAddOn
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($typeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($typeId, true)), __LINE__);
        }
        $this->TypeId = $typeId;
        return $this;
    }
}
