<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MerchandiseDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MerchandiseDescription
 * @subpackage Structs
 */
class MerchandiseDescription extends AbstractStructBase
{
    /**
     * The LocationQuantityInInventory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $LocationQuantityInInventory;
    /**
     * The Merchandise
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Merchandise_Merchandise
     */
    public $Merchandise;
    /**
     * The Pricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\MerchandisePricingDescription
     */
    public $Pricing;
    /**
     * The QuantityInInventory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $QuantityInInventory;
    /**
     * Constructor method for MerchandiseDescription
     * @uses MerchandiseDescription::setLocationQuantityInInventory()
     * @uses MerchandiseDescription::setMerchandise()
     * @uses MerchandiseDescription::setPricing()
     * @uses MerchandiseDescription::setQuantityInInventory()
     * @param float $locationQuantityInInventory
     * @param \patest\StructType\Merchandise_Merchandise $merchandise
     * @param \patest\StructType\MerchandisePricingDescription $pricing
     * @param float $quantityInInventory
     */
    public function __construct($locationQuantityInInventory = null, \patest\StructType\Merchandise_Merchandise $merchandise = null, \patest\StructType\MerchandisePricingDescription $pricing = null, $quantityInInventory = null)
    {
        $this
            ->setLocationQuantityInInventory($locationQuantityInInventory)
            ->setMerchandise($merchandise)
            ->setPricing($pricing)
            ->setQuantityInInventory($quantityInInventory);
    }
    /**
     * Get LocationQuantityInInventory value
     * @return float|null
     */
    public function getLocationQuantityInInventory()
    {
        return $this->LocationQuantityInInventory;
    }
    /**
     * Set LocationQuantityInInventory value
     * @param float $locationQuantityInInventory
     * @return \patest\StructType\MerchandiseDescription
     */
    public function setLocationQuantityInInventory($locationQuantityInInventory = null)
    {
        // validation for constraint: float
        if (!is_null($locationQuantityInInventory) && !(is_float($locationQuantityInInventory) || is_numeric($locationQuantityInInventory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($locationQuantityInInventory, true), gettype($locationQuantityInInventory)), __LINE__);
        }
        $this->LocationQuantityInInventory = $locationQuantityInInventory;
        return $this;
    }
    /**
     * Get Merchandise value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Merchandise_Merchandise|null
     */
    public function getMerchandise()
    {
        return isset($this->Merchandise) ? $this->Merchandise : null;
    }
    /**
     * Set Merchandise value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Merchandise_Merchandise $merchandise
     * @return \patest\StructType\MerchandiseDescription
     */
    public function setMerchandise(\patest\StructType\Merchandise_Merchandise $merchandise = null)
    {
        if (is_null($merchandise) || (is_array($merchandise) && empty($merchandise))) {
            unset($this->Merchandise);
        } else {
            $this->Merchandise = $merchandise;
        }
        return $this;
    }
    /**
     * Get Pricing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\MerchandisePricingDescription|null
     */
    public function getPricing()
    {
        return isset($this->Pricing) ? $this->Pricing : null;
    }
    /**
     * Set Pricing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\MerchandisePricingDescription $pricing
     * @return \patest\StructType\MerchandiseDescription
     */
    public function setPricing(\patest\StructType\MerchandisePricingDescription $pricing = null)
    {
        if (is_null($pricing) || (is_array($pricing) && empty($pricing))) {
            unset($this->Pricing);
        } else {
            $this->Pricing = $pricing;
        }
        return $this;
    }
    /**
     * Get QuantityInInventory value
     * @return float|null
     */
    public function getQuantityInInventory()
    {
        return $this->QuantityInInventory;
    }
    /**
     * Set QuantityInInventory value
     * @param float $quantityInInventory
     * @return \patest\StructType\MerchandiseDescription
     */
    public function setQuantityInInventory($quantityInInventory = null)
    {
        // validation for constraint: float
        if (!is_null($quantityInInventory) && !(is_float($quantityInInventory) || is_numeric($quantityInInventory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityInInventory, true), gettype($quantityInInventory)), __LINE__);
        }
        $this->QuantityInInventory = $quantityInInventory;
        return $this;
    }
}
