<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MerchandiseData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MerchandiseData
 * @subpackage Structs
 */
class MerchandiseData extends SearchResultDataChunk
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemName;
    /**
     * The MerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseId;
    /**
     * The MerchandiseProductItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseProductItemId;
    /**
     * The Printed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Printed;
    /**
     * The TransactionGuids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $TransactionGuids;
    /**
     * Constructor method for MerchandiseData
     * @uses MerchandiseData::setActive()
     * @uses MerchandiseData::setItemName()
     * @uses MerchandiseData::setMerchandiseId()
     * @uses MerchandiseData::setMerchandiseProductItemId()
     * @uses MerchandiseData::setPrinted()
     * @uses MerchandiseData::setTransactionGuids()
     * @param bool $active
     * @param string $itemName
     * @param string $merchandiseId
     * @param string $merchandiseProductItemId
     * @param bool $printed
     * @param \patest\ArrayType\ArrayOfguid $transactionGuids
     */
    public function __construct($active = null, $itemName = null, $merchandiseId = null, $merchandiseProductItemId = null, $printed = null, \patest\ArrayType\ArrayOfguid $transactionGuids = null)
    {
        $this
            ->setActive($active)
            ->setItemName($itemName)
            ->setMerchandiseId($merchandiseId)
            ->setMerchandiseProductItemId($merchandiseProductItemId)
            ->setPrinted($printed)
            ->setTransactionGuids($transactionGuids);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \patest\StructType\MerchandiseData
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get ItemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemName()
    {
        return isset($this->ItemName) ? $this->ItemName : null;
    }
    /**
     * Set ItemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemName
     * @return \patest\StructType\MerchandiseData
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        if (is_null($itemName) || (is_array($itemName) && empty($itemName))) {
            unset($this->ItemName);
        } else {
            $this->ItemName = $itemName;
        }
        return $this;
    }
    /**
     * Get MerchandiseId value
     * @return string|null
     */
    public function getMerchandiseId()
    {
        return $this->MerchandiseId;
    }
    /**
     * Set MerchandiseId value
     * @param string $merchandiseId
     * @return \patest\StructType\MerchandiseData
     */
    public function setMerchandiseId($merchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseId) && !is_string($merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseId, true), gettype($merchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseId, true)), __LINE__);
        }
        $this->MerchandiseId = $merchandiseId;
        return $this;
    }
    /**
     * Get MerchandiseProductItemId value
     * @return string|null
     */
    public function getMerchandiseProductItemId()
    {
        return $this->MerchandiseProductItemId;
    }
    /**
     * Set MerchandiseProductItemId value
     * @param string $merchandiseProductItemId
     * @return \patest\StructType\MerchandiseData
     */
    public function setMerchandiseProductItemId($merchandiseProductItemId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseProductItemId) && !is_string($merchandiseProductItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseProductItemId, true), gettype($merchandiseProductItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseProductItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseProductItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseProductItemId, true)), __LINE__);
        }
        $this->MerchandiseProductItemId = $merchandiseProductItemId;
        return $this;
    }
    /**
     * Get Printed value
     * @return bool|null
     */
    public function getPrinted()
    {
        return $this->Printed;
    }
    /**
     * Set Printed value
     * @param bool $printed
     * @return \patest\StructType\MerchandiseData
     */
    public function setPrinted($printed = null)
    {
        // validation for constraint: boolean
        if (!is_null($printed) && !is_bool($printed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printed, true), gettype($printed)), __LINE__);
        }
        $this->Printed = $printed;
        return $this;
    }
    /**
     * Get TransactionGuids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getTransactionGuids()
    {
        return isset($this->TransactionGuids) ? $this->TransactionGuids : null;
    }
    /**
     * Set TransactionGuids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $transactionGuids
     * @return \patest\StructType\MerchandiseData
     */
    public function setTransactionGuids(\patest\ArrayType\ArrayOfguid $transactionGuids = null)
    {
        if (is_null($transactionGuids) || (is_array($transactionGuids) && empty($transactionGuids))) {
            unset($this->TransactionGuids);
        } else {
            $this->TransactionGuids = $transactionGuids;
        }
        return $this;
    }
}
