<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership.UIMembershipInstanceExtended StructType
 * @subpackage Structs
 */
class Membership_UIMembershipInstanceExtended extends Membership_MembershipInstance
{
    /**
     * The BenefitPackageGrantData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_BenefitPackageElementInstance
     */
    public $BenefitPackageGrantData;
    /**
     * The BenefitPackageGrantDataExists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BenefitPackageGrantDataExists;
    /**
     * The IsGift
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGift;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The JointMembershipOwnersNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JointMembershipOwnersNumber;
    /**
     * The MemberOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMembership_JointOwnerRow
     */
    public $MemberOwners;
    /**
     * The OldMembershipName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldMembershipName;
    /**
     * The RenewedExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RenewedExpiryDate;
    /**
     * The RequestedOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestedOperation;
    /**
     * The SchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemeId;
    /**
     * Constructor method for Membership.UIMembershipInstanceExtended
     * @uses Membership_UIMembershipInstanceExtended::setBenefitPackageGrantData()
     * @uses Membership_UIMembershipInstanceExtended::setBenefitPackageGrantDataExists()
     * @uses Membership_UIMembershipInstanceExtended::setIsGift()
     * @uses Membership_UIMembershipInstanceExtended::setItemId()
     * @uses Membership_UIMembershipInstanceExtended::setJointMembershipOwnersNumber()
     * @uses Membership_UIMembershipInstanceExtended::setMemberOwners()
     * @uses Membership_UIMembershipInstanceExtended::setOldMembershipName()
     * @uses Membership_UIMembershipInstanceExtended::setRenewedExpiryDate()
     * @uses Membership_UIMembershipInstanceExtended::setRequestedOperation()
     * @uses Membership_UIMembershipInstanceExtended::setSchemeId()
     * @param \patest\StructType\RecordSetOfSales_BenefitPackageElementInstance $benefitPackageGrantData
     * @param bool $benefitPackageGrantDataExists
     * @param bool $isGift
     * @param int $itemId
     * @param string $jointMembershipOwnersNumber
     * @param \patest\StructType\RecordSetOfMembership_JointOwnerRow $memberOwners
     * @param string $oldMembershipName
     * @param string $renewedExpiryDate
     * @param string $requestedOperation
     * @param string $schemeId
     */
    public function __construct(\patest\StructType\RecordSetOfSales_BenefitPackageElementInstance $benefitPackageGrantData = null, $benefitPackageGrantDataExists = null, $isGift = null, $itemId = null, $jointMembershipOwnersNumber = null, \patest\StructType\RecordSetOfMembership_JointOwnerRow $memberOwners = null, $oldMembershipName = null, $renewedExpiryDate = null, $requestedOperation = null, $schemeId = null)
    {
        $this
            ->setBenefitPackageGrantData($benefitPackageGrantData)
            ->setBenefitPackageGrantDataExists($benefitPackageGrantDataExists)
            ->setIsGift($isGift)
            ->setItemId($itemId)
            ->setJointMembershipOwnersNumber($jointMembershipOwnersNumber)
            ->setMemberOwners($memberOwners)
            ->setOldMembershipName($oldMembershipName)
            ->setRenewedExpiryDate($renewedExpiryDate)
            ->setRequestedOperation($requestedOperation)
            ->setSchemeId($schemeId);
    }
    /**
     * Get BenefitPackageGrantData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_BenefitPackageElementInstance|null
     */
    public function getBenefitPackageGrantData()
    {
        return isset($this->BenefitPackageGrantData) ? $this->BenefitPackageGrantData : null;
    }
    /**
     * Set BenefitPackageGrantData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_BenefitPackageElementInstance $benefitPackageGrantData
     * @return \patest\StructType\Membership_UIMembershipInstanceExtended
     */
    public function setBenefitPackageGrantData(\patest\StructType\RecordSetOfSales_BenefitPackageElementInstance $benefitPackageGrantData = null)
    {
        if (is_null($benefitPackageGrantData) || (is_array($benefitPackageGrantData) && empty($benefitPackageGrantData))) {
            unset($this->BenefitPackageGrantData);
        } else {
            $this->BenefitPackageGrantData = $benefitPackageGrantData;
        }
        return $this;
    }
    /**
     * Get BenefitPackageGrantDataExists value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBenefitPackageGrantDataExists()
    {
        return isset($this->BenefitPackageGrantDataExists) ? $this->BenefitPackageGrantDataExists : null;
    }
    /**
     * Set BenefitPackageGrantDataExists value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $benefitPackageGrantDataExists
     * @return \patest\StructType\Membership_UIMembershipInstanceExtended
     */
    public function setBenefitPackageGrantDataExists($benefitPackageGrantDataExists = null)
    {
        // validation for constraint: boolean
        if (!is_null($benefitPackageGrantDataExists) && !is_bool($benefitPackageGrantDataExists)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($benefitPackageGrantDataExists, true), gettype($benefitPackageGrantDataExists)), __LINE__);
        }
        if (is_null($benefitPackageGrantDataExists) || (is_array($benefitPackageGrantDataExists) && empty($benefitPackageGrantDataExists))) {
            unset($this->BenefitPackageGrantDataExists);
        } else {
            $this->BenefitPackageGrantDataExists = $benefitPackageGrantDataExists;
        }
        return $this;
    }
    /**
     * Get IsGift value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGift()
    {
        return isset($this->IsGift) ? $this->IsGift : null;
    }
    /**
     * Set IsGift value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGift
     * @return \patest\StructType\Membership_UIMembershipInstanceExtended
     */
    public function setIsGift($isGift = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGift) && !is_bool($isGift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGift, true), gettype($isGift)), __LINE__);
        }
        if (is_null($isGift) || (is_array($isGift) && empty($isGift))) {
            unset($this->IsGift);
        } else {
            $this->IsGift = $isGift;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \patest\StructType\Membership_UIMembershipInstanceExtended
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get JointMembershipOwnersNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJointMembershipOwnersNumber()
    {
        return isset($this->JointMembershipOwnersNumber) ? $this->JointMembershipOwnersNumber : null;
    }
    /**
     * Set JointMembershipOwnersNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jointMembershipOwnersNumber
     * @return \patest\StructType\Membership_UIMembershipInstanceExtended
     */
    public function setJointMembershipOwnersNumber($jointMembershipOwnersNumber = null)
    {
        // validation for constraint: string
        if (!is_null($jointMembershipOwnersNumber) && !is_string($jointMembershipOwnersNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jointMembershipOwnersNumber, true), gettype($jointMembershipOwnersNumber)), __LINE__);
        }
        if (is_null($jointMembershipOwnersNumber) || (is_array($jointMembershipOwnersNumber) && empty($jointMembershipOwnersNumber))) {
            unset($this->JointMembershipOwnersNumber);
        } else {
            $this->JointMembershipOwnersNumber = $jointMembershipOwnersNumber;
        }
        return $this;
    }
    /**
     * Get MemberOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMembership_JointOwnerRow|null
     */
    public function getMemberOwners()
    {
        return isset($this->MemberOwners) ? $this->MemberOwners : null;
    }
    /**
     * Set MemberOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMembership_JointOwnerRow $memberOwners
     * @return \patest\StructType\Membership_UIMembershipInstanceExtended
     */
    public function setMemberOwners(\patest\StructType\RecordSetOfMembership_JointOwnerRow $memberOwners = null)
    {
        if (is_null($memberOwners) || (is_array($memberOwners) && empty($memberOwners))) {
            unset($this->MemberOwners);
        } else {
            $this->MemberOwners = $memberOwners;
        }
        return $this;
    }
    /**
     * Get OldMembershipName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldMembershipName()
    {
        return isset($this->OldMembershipName) ? $this->OldMembershipName : null;
    }
    /**
     * Set OldMembershipName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldMembershipName
     * @return \patest\StructType\Membership_UIMembershipInstanceExtended
     */
    public function setOldMembershipName($oldMembershipName = null)
    {
        // validation for constraint: string
        if (!is_null($oldMembershipName) && !is_string($oldMembershipName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldMembershipName, true), gettype($oldMembershipName)), __LINE__);
        }
        if (is_null($oldMembershipName) || (is_array($oldMembershipName) && empty($oldMembershipName))) {
            unset($this->OldMembershipName);
        } else {
            $this->OldMembershipName = $oldMembershipName;
        }
        return $this;
    }
    /**
     * Get RenewedExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewedExpiryDate()
    {
        return isset($this->RenewedExpiryDate) ? $this->RenewedExpiryDate : null;
    }
    /**
     * Set RenewedExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewedExpiryDate
     * @return \patest\StructType\Membership_UIMembershipInstanceExtended
     */
    public function setRenewedExpiryDate($renewedExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($renewedExpiryDate) && !is_string($renewedExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewedExpiryDate, true), gettype($renewedExpiryDate)), __LINE__);
        }
        if (is_null($renewedExpiryDate) || (is_array($renewedExpiryDate) && empty($renewedExpiryDate))) {
            unset($this->RenewedExpiryDate);
        } else {
            $this->RenewedExpiryDate = $renewedExpiryDate;
        }
        return $this;
    }
    /**
     * Get RequestedOperation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestedOperation()
    {
        return isset($this->RequestedOperation) ? $this->RequestedOperation : null;
    }
    /**
     * Set RequestedOperation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MembershipRequestedOperation::valueIsValid()
     * @uses \patest\EnumType\MembershipRequestedOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestedOperation
     * @return \patest\StructType\Membership_UIMembershipInstanceExtended
     */
    public function setRequestedOperation($requestedOperation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipRequestedOperation::valueIsValid($requestedOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipRequestedOperation', is_array($requestedOperation) ? implode(', ', $requestedOperation) : var_export($requestedOperation, true), implode(', ', \patest\EnumType\MembershipRequestedOperation::getValidValues())), __LINE__);
        }
        if (is_null($requestedOperation) || (is_array($requestedOperation) && empty($requestedOperation))) {
            unset($this->RequestedOperation);
        } else {
            $this->RequestedOperation = $requestedOperation;
        }
        return $this;
    }
    /**
     * Get SchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeId()
    {
        return isset($this->SchemeId) ? $this->SchemeId : null;
    }
    /**
     * Set SchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeId
     * @return \patest\StructType\Membership_UIMembershipInstanceExtended
     */
    public function setSchemeId($schemeId = null)
    {
        // validation for constraint: string
        if (!is_null($schemeId) && !is_string($schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeId, true), gettype($schemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemeId, true)), __LINE__);
        }
        if (is_null($schemeId) || (is_array($schemeId) && empty($schemeId))) {
            unset($this->SchemeId);
        } else {
            $this->SchemeId = $schemeId;
        }
        return $this;
    }
}
