<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership.MembershipAssignPaymentFulfillment StructType
 * @subpackage Structs
 */
class Membership_MembershipAssignPaymentFulfillment extends PersistableEntity
{
    /**
     * The ClientEnrollmentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientEnrollmentId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The EnrolledInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EnrolledInstanceId;
    /**
     * The MembershipAssignPaymentLogId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipAssignPaymentLogId;
    /**
     * The MembershipExpiry
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipExpiry;
    /**
     * The MembershipNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipNumber;
    /**
     * The PayerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PayerId;
    /**
     * The PayerName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayerName;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentMethodName;
    /**
     * The PaymentToken
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentToken;
    /**
     * The PaymentTokenExpiryDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentTokenExpiryDate;
    /**
     * The PaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTokenId;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * Constructor method for Membership.MembershipAssignPaymentFulfillment
     * @uses Membership_MembershipAssignPaymentFulfillment::setClientEnrollmentId()
     * @uses Membership_MembershipAssignPaymentFulfillment::setClientId()
     * @uses Membership_MembershipAssignPaymentFulfillment::setClientName()
     * @uses Membership_MembershipAssignPaymentFulfillment::setCrmId()
     * @uses Membership_MembershipAssignPaymentFulfillment::setDate()
     * @uses Membership_MembershipAssignPaymentFulfillment::setEnrolledInstanceId()
     * @uses Membership_MembershipAssignPaymentFulfillment::setMembershipAssignPaymentLogId()
     * @uses Membership_MembershipAssignPaymentFulfillment::setMembershipExpiry()
     * @uses Membership_MembershipAssignPaymentFulfillment::setMembershipNumber()
     * @uses Membership_MembershipAssignPaymentFulfillment::setPayerId()
     * @uses Membership_MembershipAssignPaymentFulfillment::setPayerName()
     * @uses Membership_MembershipAssignPaymentFulfillment::setPaymentMethodId()
     * @uses Membership_MembershipAssignPaymentFulfillment::setPaymentMethodName()
     * @uses Membership_MembershipAssignPaymentFulfillment::setPaymentToken()
     * @uses Membership_MembershipAssignPaymentFulfillment::setPaymentTokenExpiryDate()
     * @uses Membership_MembershipAssignPaymentFulfillment::setPaymentTokenId()
     * @uses Membership_MembershipAssignPaymentFulfillment::setState()
     * @param string $clientEnrollmentId
     * @param string $clientId
     * @param string $clientName
     * @param string $crmId
     * @param string $date
     * @param string $enrolledInstanceId
     * @param string $membershipAssignPaymentLogId
     * @param string $membershipExpiry
     * @param string $membershipNumber
     * @param string $payerId
     * @param string $payerName
     * @param string $paymentMethodId
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @param string $paymentToken
     * @param string $paymentTokenExpiryDate
     * @param string $paymentTokenId
     * @param string $state
     */
    public function __construct($clientEnrollmentId = null, $clientId = null, $clientName = null, $crmId = null, $date = null, $enrolledInstanceId = null, $membershipAssignPaymentLogId = null, $membershipExpiry = null, $membershipNumber = null, $payerId = null, $payerName = null, $paymentMethodId = null, \patest\StructType\GlobalString $paymentMethodName = null, $paymentToken = null, $paymentTokenExpiryDate = null, $paymentTokenId = null, $state = null)
    {
        $this
            ->setClientEnrollmentId($clientEnrollmentId)
            ->setClientId($clientId)
            ->setClientName($clientName)
            ->setCrmId($crmId)
            ->setDate($date)
            ->setEnrolledInstanceId($enrolledInstanceId)
            ->setMembershipAssignPaymentLogId($membershipAssignPaymentLogId)
            ->setMembershipExpiry($membershipExpiry)
            ->setMembershipNumber($membershipNumber)
            ->setPayerId($payerId)
            ->setPayerName($payerName)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodName($paymentMethodName)
            ->setPaymentToken($paymentToken)
            ->setPaymentTokenExpiryDate($paymentTokenExpiryDate)
            ->setPaymentTokenId($paymentTokenId)
            ->setState($state);
    }
    /**
     * Get ClientEnrollmentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientEnrollmentId()
    {
        return isset($this->ClientEnrollmentId) ? $this->ClientEnrollmentId : null;
    }
    /**
     * Set ClientEnrollmentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientEnrollmentId
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setClientEnrollmentId($clientEnrollmentId = null)
    {
        // validation for constraint: string
        if (!is_null($clientEnrollmentId) && !is_string($clientEnrollmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientEnrollmentId, true), gettype($clientEnrollmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientEnrollmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientEnrollmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientEnrollmentId, true)), __LINE__);
        }
        if (is_null($clientEnrollmentId) || (is_array($clientEnrollmentId) && empty($clientEnrollmentId))) {
            unset($this->ClientEnrollmentId);
        } else {
            $this->ClientEnrollmentId = $clientEnrollmentId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $date
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get EnrolledInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnrolledInstanceId()
    {
        return isset($this->EnrolledInstanceId) ? $this->EnrolledInstanceId : null;
    }
    /**
     * Set EnrolledInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enrolledInstanceId
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setEnrolledInstanceId($enrolledInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($enrolledInstanceId) && !is_string($enrolledInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enrolledInstanceId, true), gettype($enrolledInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($enrolledInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $enrolledInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($enrolledInstanceId, true)), __LINE__);
        }
        if (is_null($enrolledInstanceId) || (is_array($enrolledInstanceId) && empty($enrolledInstanceId))) {
            unset($this->EnrolledInstanceId);
        } else {
            $this->EnrolledInstanceId = $enrolledInstanceId;
        }
        return $this;
    }
    /**
     * Get MembershipAssignPaymentLogId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipAssignPaymentLogId()
    {
        return isset($this->MembershipAssignPaymentLogId) ? $this->MembershipAssignPaymentLogId : null;
    }
    /**
     * Set MembershipAssignPaymentLogId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipAssignPaymentLogId
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setMembershipAssignPaymentLogId($membershipAssignPaymentLogId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipAssignPaymentLogId) && !is_string($membershipAssignPaymentLogId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipAssignPaymentLogId, true), gettype($membershipAssignPaymentLogId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipAssignPaymentLogId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipAssignPaymentLogId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipAssignPaymentLogId, true)), __LINE__);
        }
        if (is_null($membershipAssignPaymentLogId) || (is_array($membershipAssignPaymentLogId) && empty($membershipAssignPaymentLogId))) {
            unset($this->MembershipAssignPaymentLogId);
        } else {
            $this->MembershipAssignPaymentLogId = $membershipAssignPaymentLogId;
        }
        return $this;
    }
    /**
     * Get MembershipExpiry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipExpiry()
    {
        return isset($this->MembershipExpiry) ? $this->MembershipExpiry : null;
    }
    /**
     * Set MembershipExpiry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipExpiry
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setMembershipExpiry($membershipExpiry = null)
    {
        // validation for constraint: string
        if (!is_null($membershipExpiry) && !is_string($membershipExpiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipExpiry, true), gettype($membershipExpiry)), __LINE__);
        }
        if (is_null($membershipExpiry) || (is_array($membershipExpiry) && empty($membershipExpiry))) {
            unset($this->MembershipExpiry);
        } else {
            $this->MembershipExpiry = $membershipExpiry;
        }
        return $this;
    }
    /**
     * Get MembershipNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipNumber()
    {
        return isset($this->MembershipNumber) ? $this->MembershipNumber : null;
    }
    /**
     * Set MembershipNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipNumber
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setMembershipNumber($membershipNumber = null)
    {
        // validation for constraint: string
        if (!is_null($membershipNumber) && !is_string($membershipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipNumber, true), gettype($membershipNumber)), __LINE__);
        }
        if (is_null($membershipNumber) || (is_array($membershipNumber) && empty($membershipNumber))) {
            unset($this->MembershipNumber);
        } else {
            $this->MembershipNumber = $membershipNumber;
        }
        return $this;
    }
    /**
     * Get PayerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerId()
    {
        return isset($this->PayerId) ? $this->PayerId : null;
    }
    /**
     * Set PayerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerId
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setPayerId($payerId = null)
    {
        // validation for constraint: string
        if (!is_null($payerId) && !is_string($payerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerId, true), gettype($payerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($payerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $payerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($payerId, true)), __LINE__);
        }
        if (is_null($payerId) || (is_array($payerId) && empty($payerId))) {
            unset($this->PayerId);
        } else {
            $this->PayerId = $payerId;
        }
        return $this;
    }
    /**
     * Get PayerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerName()
    {
        return isset($this->PayerName) ? $this->PayerName : null;
    }
    /**
     * Set PayerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerName
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        if (is_null($payerName) || (is_array($payerName) && empty($payerName))) {
            unset($this->PayerName);
        } else {
            $this->PayerName = $payerName;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentMethodName()
    {
        return isset($this->PaymentMethodName) ? $this->PaymentMethodName : null;
    }
    /**
     * Set PaymentMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setPaymentMethodName(\patest\StructType\GlobalString $paymentMethodName = null)
    {
        if (is_null($paymentMethodName) || (is_array($paymentMethodName) && empty($paymentMethodName))) {
            unset($this->PaymentMethodName);
        } else {
            $this->PaymentMethodName = $paymentMethodName;
        }
        return $this;
    }
    /**
     * Get PaymentToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentToken()
    {
        return isset($this->PaymentToken) ? $this->PaymentToken : null;
    }
    /**
     * Set PaymentToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentToken
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setPaymentToken($paymentToken = null)
    {
        // validation for constraint: string
        if (!is_null($paymentToken) && !is_string($paymentToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentToken, true), gettype($paymentToken)), __LINE__);
        }
        if (is_null($paymentToken) || (is_array($paymentToken) && empty($paymentToken))) {
            unset($this->PaymentToken);
        } else {
            $this->PaymentToken = $paymentToken;
        }
        return $this;
    }
    /**
     * Get PaymentTokenExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenExpiryDate()
    {
        return isset($this->PaymentTokenExpiryDate) ? $this->PaymentTokenExpiryDate : null;
    }
    /**
     * Set PaymentTokenExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenExpiryDate
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setPaymentTokenExpiryDate($paymentTokenExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenExpiryDate) && !is_string($paymentTokenExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenExpiryDate, true), gettype($paymentTokenExpiryDate)), __LINE__);
        }
        if (is_null($paymentTokenExpiryDate) || (is_array($paymentTokenExpiryDate) && empty($paymentTokenExpiryDate))) {
            unset($this->PaymentTokenExpiryDate);
        } else {
            $this->PaymentTokenExpiryDate = $paymentTokenExpiryDate;
        }
        return $this;
    }
    /**
     * Get PaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenId()
    {
        return isset($this->PaymentTokenId) ? $this->PaymentTokenId : null;
    }
    /**
     * Set PaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenId
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setPaymentTokenId($paymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenId) && !is_string($paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenId, true), gettype($paymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTokenId, true)), __LINE__);
        }
        if (is_null($paymentTokenId) || (is_array($paymentTokenId) && empty($paymentTokenId))) {
            unset($this->PaymentTokenId);
        } else {
            $this->PaymentTokenId = $paymentTokenId;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EnrollmentLinkPaymentStatus::valueIsValid()
     * @uses \patest\EnumType\EnrollmentLinkPaymentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\Membership_MembershipAssignPaymentFulfillment
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EnrollmentLinkPaymentStatus::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EnrollmentLinkPaymentStatus', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\EnrollmentLinkPaymentStatus::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
}
