<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership.Membership StructType
 * @subpackage Structs
 */
class Membership_Membership extends Membership_Base
{
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CardStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardStatus;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CurrentEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentEndDate;
    /**
     * The CurrentInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CurrentInstanceId;
    /**
     * The CurrentStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentStartDate;
    /**
     * The CurrentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentStatus;
    /**
     * The CurrentTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CurrentTransactionGuid;
    /**
     * The IsGift
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGift;
    /**
     * The IsJoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsJoint;
    /**
     * The JointCardsInfo
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMembership_JointMembershipCardInfo
     */
    public $JointCardsInfo;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The MembershipInstances
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMembership_MembershipInstance
     */
    public $MembershipInstances;
    /**
     * The MembershipNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipNumber;
    /**
     * The MemberSince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MemberSince;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Membership.Membership
     * @uses Membership_Membership::setCardNumber()
     * @uses Membership_Membership::setCardStatus()
     * @uses Membership_Membership::setClientId()
     * @uses Membership_Membership::setCurrentEndDate()
     * @uses Membership_Membership::setCurrentInstanceId()
     * @uses Membership_Membership::setCurrentStartDate()
     * @uses Membership_Membership::setCurrentStatus()
     * @uses Membership_Membership::setCurrentTransactionGuid()
     * @uses Membership_Membership::setIsGift()
     * @uses Membership_Membership::setIsJoint()
     * @uses Membership_Membership::setJointCardsInfo()
     * @uses Membership_Membership::setLastUpdateDateTime()
     * @uses Membership_Membership::setMembershipDefinitionId()
     * @uses Membership_Membership::setMembershipInstances()
     * @uses Membership_Membership::setMembershipNumber()
     * @uses Membership_Membership::setMemberSince()
     * @uses Membership_Membership::setOrganizationUnitId()
     * @uses Membership_Membership::setVisibleBySubordinates()
     * @param string $cardNumber
     * @param string $cardStatus
     * @param string $clientId
     * @param string $currentEndDate
     * @param string $currentInstanceId
     * @param string $currentStartDate
     * @param string $currentStatus
     * @param string $currentTransactionGuid
     * @param bool $isGift
     * @param bool $isJoint
     * @param \patest\StructType\RecordSetOfMembership_JointMembershipCardInfo $jointCardsInfo
     * @param string $lastUpdateDateTime
     * @param string $membershipDefinitionId
     * @param \patest\StructType\RecordSetOfMembership_MembershipInstance $membershipInstances
     * @param string $membershipNumber
     * @param string $memberSince
     * @param string $organizationUnitId
     * @param bool $visibleBySubordinates
     */
    public function __construct($cardNumber = null, $cardStatus = null, $clientId = null, $currentEndDate = null, $currentInstanceId = null, $currentStartDate = null, $currentStatus = null, $currentTransactionGuid = null, $isGift = null, $isJoint = null, \patest\StructType\RecordSetOfMembership_JointMembershipCardInfo $jointCardsInfo = null, $lastUpdateDateTime = null, $membershipDefinitionId = null, \patest\StructType\RecordSetOfMembership_MembershipInstance $membershipInstances = null, $membershipNumber = null, $memberSince = null, $organizationUnitId = null, $visibleBySubordinates = null)
    {
        $this
            ->setCardNumber($cardNumber)
            ->setCardStatus($cardStatus)
            ->setClientId($clientId)
            ->setCurrentEndDate($currentEndDate)
            ->setCurrentInstanceId($currentInstanceId)
            ->setCurrentStartDate($currentStartDate)
            ->setCurrentStatus($currentStatus)
            ->setCurrentTransactionGuid($currentTransactionGuid)
            ->setIsGift($isGift)
            ->setIsJoint($isJoint)
            ->setJointCardsInfo($jointCardsInfo)
            ->setLastUpdateDateTime($lastUpdateDateTime)
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setMembershipInstances($membershipInstances)
            ->setMembershipNumber($membershipNumber)
            ->setMemberSince($memberSince)
            ->setOrganizationUnitId($organizationUnitId)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\Membership_Membership
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CardStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardStatus()
    {
        return isset($this->CardStatus) ? $this->CardStatus : null;
    }
    /**
     * Set CardStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccessCardStatus::valueIsValid()
     * @uses \patest\EnumType\AccessCardStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardStatus
     * @return \patest\StructType\Membership_Membership
     */
    public function setCardStatus($cardStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccessCardStatus::valueIsValid($cardStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessCardStatus', is_array($cardStatus) ? implode(', ', $cardStatus) : var_export($cardStatus, true), implode(', ', \patest\EnumType\AccessCardStatus::getValidValues())), __LINE__);
        }
        if (is_null($cardStatus) || (is_array($cardStatus) && empty($cardStatus))) {
            unset($this->CardStatus);
        } else {
            $this->CardStatus = $cardStatus;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Membership_Membership
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CurrentEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentEndDate()
    {
        return isset($this->CurrentEndDate) ? $this->CurrentEndDate : null;
    }
    /**
     * Set CurrentEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentEndDate
     * @return \patest\StructType\Membership_Membership
     */
    public function setCurrentEndDate($currentEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($currentEndDate) && !is_string($currentEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentEndDate, true), gettype($currentEndDate)), __LINE__);
        }
        if (is_null($currentEndDate) || (is_array($currentEndDate) && empty($currentEndDate))) {
            unset($this->CurrentEndDate);
        } else {
            $this->CurrentEndDate = $currentEndDate;
        }
        return $this;
    }
    /**
     * Get CurrentInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentInstanceId()
    {
        return isset($this->CurrentInstanceId) ? $this->CurrentInstanceId : null;
    }
    /**
     * Set CurrentInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentInstanceId
     * @return \patest\StructType\Membership_Membership
     */
    public function setCurrentInstanceId($currentInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($currentInstanceId) && !is_string($currentInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentInstanceId, true), gettype($currentInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($currentInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $currentInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($currentInstanceId, true)), __LINE__);
        }
        if (is_null($currentInstanceId) || (is_array($currentInstanceId) && empty($currentInstanceId))) {
            unset($this->CurrentInstanceId);
        } else {
            $this->CurrentInstanceId = $currentInstanceId;
        }
        return $this;
    }
    /**
     * Get CurrentStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentStartDate()
    {
        return isset($this->CurrentStartDate) ? $this->CurrentStartDate : null;
    }
    /**
     * Set CurrentStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentStartDate
     * @return \patest\StructType\Membership_Membership
     */
    public function setCurrentStartDate($currentStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($currentStartDate) && !is_string($currentStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentStartDate, true), gettype($currentStartDate)), __LINE__);
        }
        if (is_null($currentStartDate) || (is_array($currentStartDate) && empty($currentStartDate))) {
            unset($this->CurrentStartDate);
        } else {
            $this->CurrentStartDate = $currentStartDate;
        }
        return $this;
    }
    /**
     * Get CurrentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentStatus()
    {
        return isset($this->CurrentStatus) ? $this->CurrentStatus : null;
    }
    /**
     * Set CurrentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MembershipStatus::valueIsValid()
     * @uses \patest\EnumType\MembershipStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currentStatus
     * @return \patest\StructType\Membership_Membership
     */
    public function setCurrentStatus($currentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipStatus::valueIsValid($currentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipStatus', is_array($currentStatus) ? implode(', ', $currentStatus) : var_export($currentStatus, true), implode(', ', \patest\EnumType\MembershipStatus::getValidValues())), __LINE__);
        }
        if (is_null($currentStatus) || (is_array($currentStatus) && empty($currentStatus))) {
            unset($this->CurrentStatus);
        } else {
            $this->CurrentStatus = $currentStatus;
        }
        return $this;
    }
    /**
     * Get CurrentTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentTransactionGuid()
    {
        return isset($this->CurrentTransactionGuid) ? $this->CurrentTransactionGuid : null;
    }
    /**
     * Set CurrentTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentTransactionGuid
     * @return \patest\StructType\Membership_Membership
     */
    public function setCurrentTransactionGuid($currentTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($currentTransactionGuid) && !is_string($currentTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentTransactionGuid, true), gettype($currentTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($currentTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $currentTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($currentTransactionGuid, true)), __LINE__);
        }
        if (is_null($currentTransactionGuid) || (is_array($currentTransactionGuid) && empty($currentTransactionGuid))) {
            unset($this->CurrentTransactionGuid);
        } else {
            $this->CurrentTransactionGuid = $currentTransactionGuid;
        }
        return $this;
    }
    /**
     * Get IsGift value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGift()
    {
        return isset($this->IsGift) ? $this->IsGift : null;
    }
    /**
     * Set IsGift value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGift
     * @return \patest\StructType\Membership_Membership
     */
    public function setIsGift($isGift = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGift) && !is_bool($isGift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGift, true), gettype($isGift)), __LINE__);
        }
        if (is_null($isGift) || (is_array($isGift) && empty($isGift))) {
            unset($this->IsGift);
        } else {
            $this->IsGift = $isGift;
        }
        return $this;
    }
    /**
     * Get IsJoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsJoint()
    {
        return isset($this->IsJoint) ? $this->IsJoint : null;
    }
    /**
     * Set IsJoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isJoint
     * @return \patest\StructType\Membership_Membership
     */
    public function setIsJoint($isJoint = null)
    {
        // validation for constraint: boolean
        if (!is_null($isJoint) && !is_bool($isJoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isJoint, true), gettype($isJoint)), __LINE__);
        }
        if (is_null($isJoint) || (is_array($isJoint) && empty($isJoint))) {
            unset($this->IsJoint);
        } else {
            $this->IsJoint = $isJoint;
        }
        return $this;
    }
    /**
     * Get JointCardsInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMembership_JointMembershipCardInfo|null
     */
    public function getJointCardsInfo()
    {
        return isset($this->JointCardsInfo) ? $this->JointCardsInfo : null;
    }
    /**
     * Set JointCardsInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMembership_JointMembershipCardInfo $jointCardsInfo
     * @return \patest\StructType\Membership_Membership
     */
    public function setJointCardsInfo(\patest\StructType\RecordSetOfMembership_JointMembershipCardInfo $jointCardsInfo = null)
    {
        if (is_null($jointCardsInfo) || (is_array($jointCardsInfo) && empty($jointCardsInfo))) {
            unset($this->JointCardsInfo);
        } else {
            $this->JointCardsInfo = $jointCardsInfo;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\Membership_Membership
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return isset($this->MembershipDefinitionId) ? $this->MembershipDefinitionId : null;
    }
    /**
     * Set MembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionId
     * @return \patest\StructType\Membership_Membership
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        if (is_null($membershipDefinitionId) || (is_array($membershipDefinitionId) && empty($membershipDefinitionId))) {
            unset($this->MembershipDefinitionId);
        } else {
            $this->MembershipDefinitionId = $membershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get MembershipInstances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMembership_MembershipInstance|null
     */
    public function getMembershipInstances()
    {
        return isset($this->MembershipInstances) ? $this->MembershipInstances : null;
    }
    /**
     * Set MembershipInstances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMembership_MembershipInstance $membershipInstances
     * @return \patest\StructType\Membership_Membership
     */
    public function setMembershipInstances(\patest\StructType\RecordSetOfMembership_MembershipInstance $membershipInstances = null)
    {
        if (is_null($membershipInstances) || (is_array($membershipInstances) && empty($membershipInstances))) {
            unset($this->MembershipInstances);
        } else {
            $this->MembershipInstances = $membershipInstances;
        }
        return $this;
    }
    /**
     * Get MembershipNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipNumber()
    {
        return isset($this->MembershipNumber) ? $this->MembershipNumber : null;
    }
    /**
     * Set MembershipNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipNumber
     * @return \patest\StructType\Membership_Membership
     */
    public function setMembershipNumber($membershipNumber = null)
    {
        // validation for constraint: string
        if (!is_null($membershipNumber) && !is_string($membershipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipNumber, true), gettype($membershipNumber)), __LINE__);
        }
        if (is_null($membershipNumber) || (is_array($membershipNumber) && empty($membershipNumber))) {
            unset($this->MembershipNumber);
        } else {
            $this->MembershipNumber = $membershipNumber;
        }
        return $this;
    }
    /**
     * Get MemberSince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMemberSince()
    {
        return isset($this->MemberSince) ? $this->MemberSince : null;
    }
    /**
     * Set MemberSince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $memberSince
     * @return \patest\StructType\Membership_Membership
     */
    public function setMemberSince($memberSince = null)
    {
        // validation for constraint: string
        if (!is_null($memberSince) && !is_string($memberSince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberSince, true), gettype($memberSince)), __LINE__);
        }
        if (is_null($memberSince) || (is_array($memberSince) && empty($memberSince))) {
            unset($this->MemberSince);
        } else {
            $this->MemberSince = $memberSince;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Membership_Membership
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Membership_Membership
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
