<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership.JointMembershipCardInfo StructType
 * @subpackage Structs
 */
class Membership_JointMembershipCardInfo extends AnyEntity
{
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CardStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardStatus;
    /**
     * Constructor method for Membership.JointMembershipCardInfo
     * @uses Membership_JointMembershipCardInfo::setCardNumber()
     * @uses Membership_JointMembershipCardInfo::setCardStatus()
     * @param string $cardNumber
     * @param string $cardStatus
     */
    public function __construct($cardNumber = null, $cardStatus = null)
    {
        $this
            ->setCardNumber($cardNumber)
            ->setCardStatus($cardStatus);
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\Membership_JointMembershipCardInfo
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CardStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardStatus()
    {
        return isset($this->CardStatus) ? $this->CardStatus : null;
    }
    /**
     * Set CardStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccessCardStatus::valueIsValid()
     * @uses \patest\EnumType\AccessCardStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardStatus
     * @return \patest\StructType\Membership_JointMembershipCardInfo
     */
    public function setCardStatus($cardStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccessCardStatus::valueIsValid($cardStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessCardStatus', is_array($cardStatus) ? implode(', ', $cardStatus) : var_export($cardStatus, true), implode(', ', \patest\EnumType\AccessCardStatus::getValidValues())), __LINE__);
        }
        if (is_null($cardStatus) || (is_array($cardStatus) && empty($cardStatus))) {
            unset($this->CardStatus);
        } else {
            $this->CardStatus = $cardStatus;
        }
        return $this;
    }
}
