<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership.Base StructType
 * @subpackage Structs
 */
class Membership_Base extends DistributableEntity
{
    /**
     * The ExternalReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalReference;
    /**
     * Constructor method for Membership.Base
     * @uses Membership_Base::setExternalReference()
     * @param string $externalReference
     */
    public function __construct($externalReference = null)
    {
        $this
            ->setExternalReference($externalReference);
    }
    /**
     * Get ExternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalReference()
    {
        return isset($this->ExternalReference) ? $this->ExternalReference : null;
    }
    /**
     * Set ExternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalReference
     * @return \patest\StructType\Membership_Base
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        if (is_null($externalReference) || (is_array($externalReference) && empty($externalReference))) {
            unset($this->ExternalReference);
        } else {
            $this->ExternalReference = $externalReference;
        }
        return $this;
    }
}
