<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MembershipItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MembershipItem
 * @subpackage Structs
 */
class MembershipItem extends AbstractProductItem
{
    /**
     * The AllianceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AllianceId;
    /**
     * The AllianceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllianceName;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The ExtrasPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExtrasPriceTypeId;
    /**
     * The GuestsPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuestsPriceTypeId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsBenefitsShared
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsBenefitsShared;
    /**
     * The IsGift
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsGift;
    /**
     * The IsJoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsJoint;
    /**
     * The IsJointOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IsJointOwners;
    /**
     * The IsRenewed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRenewed;
    /**
     * The IsUpdated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsUpdated;
    /**
     * The JointMembers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfJointMembershipMember
     */
    public $JointMembers;
    /**
     * The JointMembershipPrintingOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JointMembershipPrintingOption;
    /**
     * The JointOwnersDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JointOwnersDetails;
    /**
     * The ManuallySetDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ManuallySetDates;
    /**
     * The MemberSince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MemberSince;
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The MembershipDefinitionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipDefinitionName;
    /**
     * The MembershipId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipId;
    /**
     * The MembershipNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipNumber;
    /**
     * The NameOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameOnCard;
    /**
     * The NumberOfExtras
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfExtras;
    /**
     * The NumberOfGuests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfGuests;
    /**
     * The NumberOfJointOwnersAllowedByPlan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfJointOwnersAllowedByPlan;
    /**
     * The OldMembershipClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OldMembershipClientId;
    /**
     * The OldMembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OldMembershipDefinitionId;
    /**
     * The OldMembershipName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldMembershipName;
    /**
     * The OldMembershipNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldMembershipNumber;
    /**
     * The OldMembershipPriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldMembershipPriceTypeName;
    /**
     * The OwnersMustBeRelatives
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OwnersMustBeRelatives;
    /**
     * The OwnersPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnersPriceTypeId;
    /**
     * The OwnersUpdatedFromPreviousMembership
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OwnersUpdatedFromPreviousMembership;
    /**
     * The RenewedExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RenewedExpiryDate;
    /**
     * The RenewedId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RenewedId;
    /**
     * The RenewedInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RenewedInstanceId;
    /**
     * The RequestedOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RequestedOperation;
    /**
     * The SchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemeId;
    /**
     * The SchemeLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemeLevelId;
    /**
     * The SchemeLevelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchemeLevelName;
    /**
     * The SchemeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchemeName;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The StatusOfReturned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusOfReturned;
    /**
     * The UpdateOfInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UpdateOfInstanceId;
    /**
     * The UpgradeOnlyMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UpgradeOnlyMode;
    /**
     * The IsAutoRenewRequested
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutoRenewRequested;
    /**
     * The SkipAutoRenewValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SkipAutoRenewValidation;
    /**
     * The PreferredExchange
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PreferredExchange;
    /**
     * Constructor method for MembershipItem
     * @uses MembershipItem::setAllianceId()
     * @uses MembershipItem::setAllianceName()
     * @uses MembershipItem::setEndDate()
     * @uses MembershipItem::setExtrasPriceTypeId()
     * @uses MembershipItem::setGuestsPriceTypeId()
     * @uses MembershipItem::setId()
     * @uses MembershipItem::setIsBenefitsShared()
     * @uses MembershipItem::setIsGift()
     * @uses MembershipItem::setIsJoint()
     * @uses MembershipItem::setIsJointOwners()
     * @uses MembershipItem::setIsRenewed()
     * @uses MembershipItem::setIsUpdated()
     * @uses MembershipItem::setJointMembers()
     * @uses MembershipItem::setJointMembershipPrintingOption()
     * @uses MembershipItem::setJointOwnersDetails()
     * @uses MembershipItem::setManuallySetDates()
     * @uses MembershipItem::setMemberSince()
     * @uses MembershipItem::setMembershipDefinitionId()
     * @uses MembershipItem::setMembershipDefinitionName()
     * @uses MembershipItem::setMembershipId()
     * @uses MembershipItem::setMembershipNumber()
     * @uses MembershipItem::setNameOnCard()
     * @uses MembershipItem::setNumberOfExtras()
     * @uses MembershipItem::setNumberOfGuests()
     * @uses MembershipItem::setNumberOfJointOwnersAllowedByPlan()
     * @uses MembershipItem::setOldMembershipClientId()
     * @uses MembershipItem::setOldMembershipDefinitionId()
     * @uses MembershipItem::setOldMembershipName()
     * @uses MembershipItem::setOldMembershipNumber()
     * @uses MembershipItem::setOldMembershipPriceTypeName()
     * @uses MembershipItem::setOwnersMustBeRelatives()
     * @uses MembershipItem::setOwnersPriceTypeId()
     * @uses MembershipItem::setOwnersUpdatedFromPreviousMembership()
     * @uses MembershipItem::setRenewedExpiryDate()
     * @uses MembershipItem::setRenewedId()
     * @uses MembershipItem::setRenewedInstanceId()
     * @uses MembershipItem::setRequestedOperation()
     * @uses MembershipItem::setSchemeId()
     * @uses MembershipItem::setSchemeLevelId()
     * @uses MembershipItem::setSchemeLevelName()
     * @uses MembershipItem::setSchemeName()
     * @uses MembershipItem::setStartDate()
     * @uses MembershipItem::setStatus()
     * @uses MembershipItem::setStatusOfReturned()
     * @uses MembershipItem::setUpdateOfInstanceId()
     * @uses MembershipItem::setUpgradeOnlyMode()
     * @uses MembershipItem::setIsAutoRenewRequested()
     * @uses MembershipItem::setSkipAutoRenewValidation()
     * @uses MembershipItem::setPreferredExchange()
     * @param string $allianceId
     * @param string $allianceName
     * @param string $endDate
     * @param string $extrasPriceTypeId
     * @param string $guestsPriceTypeId
     * @param string $id
     * @param bool $isBenefitsShared
     * @param bool $isGift
     * @param bool $isJoint
     * @param string $isJointOwners
     * @param bool $isRenewed
     * @param bool $isUpdated
     * @param \patest\ArrayType\ArrayOfJointMembershipMember $jointMembers
     * @param string $jointMembershipPrintingOption
     * @param string $jointOwnersDetails
     * @param bool $manuallySetDates
     * @param string $memberSince
     * @param string $membershipDefinitionId
     * @param string $membershipDefinitionName
     * @param string $membershipId
     * @param string $membershipNumber
     * @param string $nameOnCard
     * @param int $numberOfExtras
     * @param int $numberOfGuests
     * @param int $numberOfJointOwnersAllowedByPlan
     * @param string $oldMembershipClientId
     * @param string $oldMembershipDefinitionId
     * @param string $oldMembershipName
     * @param string $oldMembershipNumber
     * @param string $oldMembershipPriceTypeName
     * @param bool $ownersMustBeRelatives
     * @param string $ownersPriceTypeId
     * @param bool $ownersUpdatedFromPreviousMembership
     * @param string $renewedExpiryDate
     * @param string $renewedId
     * @param string $renewedInstanceId
     * @param string $requestedOperation
     * @param string $schemeId
     * @param string $schemeLevelId
     * @param string $schemeLevelName
     * @param string $schemeName
     * @param string $startDate
     * @param string $status
     * @param string $statusOfReturned
     * @param string $updateOfInstanceId
     * @param bool $upgradeOnlyMode
     * @param bool $isAutoRenewRequested
     * @param bool $skipAutoRenewValidation
     * @param string $preferredExchange
     */
    public function __construct($allianceId = null, $allianceName = null, $endDate = null, $extrasPriceTypeId = null, $guestsPriceTypeId = null, $id = null, $isBenefitsShared = null, $isGift = null, $isJoint = null, $isJointOwners = null, $isRenewed = null, $isUpdated = null, \patest\ArrayType\ArrayOfJointMembershipMember $jointMembers = null, $jointMembershipPrintingOption = null, $jointOwnersDetails = null, $manuallySetDates = null, $memberSince = null, $membershipDefinitionId = null, $membershipDefinitionName = null, $membershipId = null, $membershipNumber = null, $nameOnCard = null, $numberOfExtras = null, $numberOfGuests = null, $numberOfJointOwnersAllowedByPlan = null, $oldMembershipClientId = null, $oldMembershipDefinitionId = null, $oldMembershipName = null, $oldMembershipNumber = null, $oldMembershipPriceTypeName = null, $ownersMustBeRelatives = null, $ownersPriceTypeId = null, $ownersUpdatedFromPreviousMembership = null, $renewedExpiryDate = null, $renewedId = null, $renewedInstanceId = null, $requestedOperation = null, $schemeId = null, $schemeLevelId = null, $schemeLevelName = null, $schemeName = null, $startDate = null, $status = null, $statusOfReturned = null, $updateOfInstanceId = null, $upgradeOnlyMode = null, $isAutoRenewRequested = null, $skipAutoRenewValidation = null, $preferredExchange = null)
    {
        $this
            ->setAllianceId($allianceId)
            ->setAllianceName($allianceName)
            ->setEndDate($endDate)
            ->setExtrasPriceTypeId($extrasPriceTypeId)
            ->setGuestsPriceTypeId($guestsPriceTypeId)
            ->setId($id)
            ->setIsBenefitsShared($isBenefitsShared)
            ->setIsGift($isGift)
            ->setIsJoint($isJoint)
            ->setIsJointOwners($isJointOwners)
            ->setIsRenewed($isRenewed)
            ->setIsUpdated($isUpdated)
            ->setJointMembers($jointMembers)
            ->setJointMembershipPrintingOption($jointMembershipPrintingOption)
            ->setJointOwnersDetails($jointOwnersDetails)
            ->setManuallySetDates($manuallySetDates)
            ->setMemberSince($memberSince)
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setMembershipDefinitionName($membershipDefinitionName)
            ->setMembershipId($membershipId)
            ->setMembershipNumber($membershipNumber)
            ->setNameOnCard($nameOnCard)
            ->setNumberOfExtras($numberOfExtras)
            ->setNumberOfGuests($numberOfGuests)
            ->setNumberOfJointOwnersAllowedByPlan($numberOfJointOwnersAllowedByPlan)
            ->setOldMembershipClientId($oldMembershipClientId)
            ->setOldMembershipDefinitionId($oldMembershipDefinitionId)
            ->setOldMembershipName($oldMembershipName)
            ->setOldMembershipNumber($oldMembershipNumber)
            ->setOldMembershipPriceTypeName($oldMembershipPriceTypeName)
            ->setOwnersMustBeRelatives($ownersMustBeRelatives)
            ->setOwnersPriceTypeId($ownersPriceTypeId)
            ->setOwnersUpdatedFromPreviousMembership($ownersUpdatedFromPreviousMembership)
            ->setRenewedExpiryDate($renewedExpiryDate)
            ->setRenewedId($renewedId)
            ->setRenewedInstanceId($renewedInstanceId)
            ->setRequestedOperation($requestedOperation)
            ->setSchemeId($schemeId)
            ->setSchemeLevelId($schemeLevelId)
            ->setSchemeLevelName($schemeLevelName)
            ->setSchemeName($schemeName)
            ->setStartDate($startDate)
            ->setStatus($status)
            ->setStatusOfReturned($statusOfReturned)
            ->setUpdateOfInstanceId($updateOfInstanceId)
            ->setUpgradeOnlyMode($upgradeOnlyMode)
            ->setIsAutoRenewRequested($isAutoRenewRequested)
            ->setSkipAutoRenewValidation($skipAutoRenewValidation)
            ->setPreferredExchange($preferredExchange);
    }
    /**
     * Get AllianceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllianceId()
    {
        return isset($this->AllianceId) ? $this->AllianceId : null;
    }
    /**
     * Set AllianceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allianceId
     * @return \patest\StructType\MembershipItem
     */
    public function setAllianceId($allianceId = null)
    {
        // validation for constraint: string
        if (!is_null($allianceId) && !is_string($allianceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allianceId, true), gettype($allianceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($allianceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $allianceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($allianceId, true)), __LINE__);
        }
        if (is_null($allianceId) || (is_array($allianceId) && empty($allianceId))) {
            unset($this->AllianceId);
        } else {
            $this->AllianceId = $allianceId;
        }
        return $this;
    }
    /**
     * Get AllianceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllianceName()
    {
        return isset($this->AllianceName) ? $this->AllianceName : null;
    }
    /**
     * Set AllianceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allianceName
     * @return \patest\StructType\MembershipItem
     */
    public function setAllianceName($allianceName = null)
    {
        // validation for constraint: string
        if (!is_null($allianceName) && !is_string($allianceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allianceName, true), gettype($allianceName)), __LINE__);
        }
        if (is_null($allianceName) || (is_array($allianceName) && empty($allianceName))) {
            unset($this->AllianceName);
        } else {
            $this->AllianceName = $allianceName;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \patest\StructType\MembershipItem
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ExtrasPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtrasPriceTypeId()
    {
        return isset($this->ExtrasPriceTypeId) ? $this->ExtrasPriceTypeId : null;
    }
    /**
     * Set ExtrasPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extrasPriceTypeId
     * @return \patest\StructType\MembershipItem
     */
    public function setExtrasPriceTypeId($extrasPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($extrasPriceTypeId) && !is_string($extrasPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extrasPriceTypeId, true), gettype($extrasPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($extrasPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $extrasPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($extrasPriceTypeId, true)), __LINE__);
        }
        if (is_null($extrasPriceTypeId) || (is_array($extrasPriceTypeId) && empty($extrasPriceTypeId))) {
            unset($this->ExtrasPriceTypeId);
        } else {
            $this->ExtrasPriceTypeId = $extrasPriceTypeId;
        }
        return $this;
    }
    /**
     * Get GuestsPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuestsPriceTypeId()
    {
        return isset($this->GuestsPriceTypeId) ? $this->GuestsPriceTypeId : null;
    }
    /**
     * Set GuestsPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guestsPriceTypeId
     * @return \patest\StructType\MembershipItem
     */
    public function setGuestsPriceTypeId($guestsPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($guestsPriceTypeId) && !is_string($guestsPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestsPriceTypeId, true), gettype($guestsPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guestsPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guestsPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guestsPriceTypeId, true)), __LINE__);
        }
        if (is_null($guestsPriceTypeId) || (is_array($guestsPriceTypeId) && empty($guestsPriceTypeId))) {
            unset($this->GuestsPriceTypeId);
        } else {
            $this->GuestsPriceTypeId = $guestsPriceTypeId;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\MembershipItem
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IsBenefitsShared value
     * @return bool|null
     */
    public function getIsBenefitsShared()
    {
        return $this->IsBenefitsShared;
    }
    /**
     * Set IsBenefitsShared value
     * @param bool $isBenefitsShared
     * @return \patest\StructType\MembershipItem
     */
    public function setIsBenefitsShared($isBenefitsShared = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBenefitsShared) && !is_bool($isBenefitsShared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBenefitsShared, true), gettype($isBenefitsShared)), __LINE__);
        }
        $this->IsBenefitsShared = $isBenefitsShared;
        return $this;
    }
    /**
     * Get IsGift value
     * @return bool|null
     */
    public function getIsGift()
    {
        return $this->IsGift;
    }
    /**
     * Set IsGift value
     * @param bool $isGift
     * @return \patest\StructType\MembershipItem
     */
    public function setIsGift($isGift = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGift) && !is_bool($isGift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGift, true), gettype($isGift)), __LINE__);
        }
        $this->IsGift = $isGift;
        return $this;
    }
    /**
     * Get IsJoint value
     * @return bool|null
     */
    public function getIsJoint()
    {
        return $this->IsJoint;
    }
    /**
     * Set IsJoint value
     * @param bool $isJoint
     * @return \patest\StructType\MembershipItem
     */
    public function setIsJoint($isJoint = null)
    {
        // validation for constraint: boolean
        if (!is_null($isJoint) && !is_bool($isJoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isJoint, true), gettype($isJoint)), __LINE__);
        }
        $this->IsJoint = $isJoint;
        return $this;
    }
    /**
     * Get IsJointOwners value
     * @return string|null
     */
    public function getIsJointOwners()
    {
        return $this->IsJointOwners;
    }
    /**
     * Set IsJointOwners value
     * @uses \patest\EnumType\JointOnwersStatus::valueIsValid()
     * @uses \patest\EnumType\JointOnwersStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $isJointOwners
     * @return \patest\StructType\MembershipItem
     */
    public function setIsJointOwners($isJointOwners = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JointOnwersStatus::valueIsValid($isJointOwners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JointOnwersStatus', is_array($isJointOwners) ? implode(', ', $isJointOwners) : var_export($isJointOwners, true), implode(', ', \patest\EnumType\JointOnwersStatus::getValidValues())), __LINE__);
        }
        $this->IsJointOwners = $isJointOwners;
        return $this;
    }
    /**
     * Get IsRenewed value
     * @return bool|null
     */
    public function getIsRenewed()
    {
        return $this->IsRenewed;
    }
    /**
     * Set IsRenewed value
     * @param bool $isRenewed
     * @return \patest\StructType\MembershipItem
     */
    public function setIsRenewed($isRenewed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRenewed) && !is_bool($isRenewed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRenewed, true), gettype($isRenewed)), __LINE__);
        }
        $this->IsRenewed = $isRenewed;
        return $this;
    }
    /**
     * Get IsUpdated value
     * @return bool|null
     */
    public function getIsUpdated()
    {
        return $this->IsUpdated;
    }
    /**
     * Set IsUpdated value
     * @param bool $isUpdated
     * @return \patest\StructType\MembershipItem
     */
    public function setIsUpdated($isUpdated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdated) && !is_bool($isUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdated, true), gettype($isUpdated)), __LINE__);
        }
        $this->IsUpdated = $isUpdated;
        return $this;
    }
    /**
     * Get JointMembers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfJointMembershipMember|null
     */
    public function getJointMembers()
    {
        return isset($this->JointMembers) ? $this->JointMembers : null;
    }
    /**
     * Set JointMembers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfJointMembershipMember $jointMembers
     * @return \patest\StructType\MembershipItem
     */
    public function setJointMembers(\patest\ArrayType\ArrayOfJointMembershipMember $jointMembers = null)
    {
        if (is_null($jointMembers) || (is_array($jointMembers) && empty($jointMembers))) {
            unset($this->JointMembers);
        } else {
            $this->JointMembers = $jointMembers;
        }
        return $this;
    }
    /**
     * Get JointMembershipPrintingOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJointMembershipPrintingOption()
    {
        return isset($this->JointMembershipPrintingOption) ? $this->JointMembershipPrintingOption : null;
    }
    /**
     * Set JointMembershipPrintingOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\JointMembershipPrintingOption::valueIsValid()
     * @uses \patest\EnumType\JointMembershipPrintingOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $jointMembershipPrintingOption
     * @return \patest\StructType\MembershipItem
     */
    public function setJointMembershipPrintingOption($jointMembershipPrintingOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JointMembershipPrintingOption::valueIsValid($jointMembershipPrintingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JointMembershipPrintingOption', is_array($jointMembershipPrintingOption) ? implode(', ', $jointMembershipPrintingOption) : var_export($jointMembershipPrintingOption, true), implode(', ', \patest\EnumType\JointMembershipPrintingOption::getValidValues())), __LINE__);
        }
        if (is_null($jointMembershipPrintingOption) || (is_array($jointMembershipPrintingOption) && empty($jointMembershipPrintingOption))) {
            unset($this->JointMembershipPrintingOption);
        } else {
            $this->JointMembershipPrintingOption = $jointMembershipPrintingOption;
        }
        return $this;
    }
    /**
     * Get JointOwnersDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJointOwnersDetails()
    {
        return isset($this->JointOwnersDetails) ? $this->JointOwnersDetails : null;
    }
    /**
     * Set JointOwnersDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jointOwnersDetails
     * @return \patest\StructType\MembershipItem
     */
    public function setJointOwnersDetails($jointOwnersDetails = null)
    {
        // validation for constraint: string
        if (!is_null($jointOwnersDetails) && !is_string($jointOwnersDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jointOwnersDetails, true), gettype($jointOwnersDetails)), __LINE__);
        }
        if (is_null($jointOwnersDetails) || (is_array($jointOwnersDetails) && empty($jointOwnersDetails))) {
            unset($this->JointOwnersDetails);
        } else {
            $this->JointOwnersDetails = $jointOwnersDetails;
        }
        return $this;
    }
    /**
     * Get ManuallySetDates value
     * @return bool|null
     */
    public function getManuallySetDates()
    {
        return $this->ManuallySetDates;
    }
    /**
     * Set ManuallySetDates value
     * @param bool $manuallySetDates
     * @return \patest\StructType\MembershipItem
     */
    public function setManuallySetDates($manuallySetDates = null)
    {
        // validation for constraint: boolean
        if (!is_null($manuallySetDates) && !is_bool($manuallySetDates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($manuallySetDates, true), gettype($manuallySetDates)), __LINE__);
        }
        $this->ManuallySetDates = $manuallySetDates;
        return $this;
    }
    /**
     * Get MemberSince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMemberSince()
    {
        return isset($this->MemberSince) ? $this->MemberSince : null;
    }
    /**
     * Set MemberSince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $memberSince
     * @return \patest\StructType\MembershipItem
     */
    public function setMemberSince($memberSince = null)
    {
        // validation for constraint: string
        if (!is_null($memberSince) && !is_string($memberSince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberSince, true), gettype($memberSince)), __LINE__);
        }
        if (is_null($memberSince) || (is_array($memberSince) && empty($memberSince))) {
            unset($this->MemberSince);
        } else {
            $this->MemberSince = $memberSince;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionId value
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return $this->MembershipDefinitionId;
    }
    /**
     * Set MembershipDefinitionId value
     * @param string $membershipDefinitionId
     * @return \patest\StructType\MembershipItem
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        $this->MembershipDefinitionId = $membershipDefinitionId;
        return $this;
    }
    /**
     * Get MembershipDefinitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionName()
    {
        return isset($this->MembershipDefinitionName) ? $this->MembershipDefinitionName : null;
    }
    /**
     * Set MembershipDefinitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionName
     * @return \patest\StructType\MembershipItem
     */
    public function setMembershipDefinitionName($membershipDefinitionName = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionName) && !is_string($membershipDefinitionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionName, true), gettype($membershipDefinitionName)), __LINE__);
        }
        if (is_null($membershipDefinitionName) || (is_array($membershipDefinitionName) && empty($membershipDefinitionName))) {
            unset($this->MembershipDefinitionName);
        } else {
            $this->MembershipDefinitionName = $membershipDefinitionName;
        }
        return $this;
    }
    /**
     * Get MembershipId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipId()
    {
        return isset($this->MembershipId) ? $this->MembershipId : null;
    }
    /**
     * Set MembershipId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipId
     * @return \patest\StructType\MembershipItem
     */
    public function setMembershipId($membershipId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipId) && !is_string($membershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipId, true), gettype($membershipId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipId, true)), __LINE__);
        }
        if (is_null($membershipId) || (is_array($membershipId) && empty($membershipId))) {
            unset($this->MembershipId);
        } else {
            $this->MembershipId = $membershipId;
        }
        return $this;
    }
    /**
     * Get MembershipNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipNumber()
    {
        return isset($this->MembershipNumber) ? $this->MembershipNumber : null;
    }
    /**
     * Set MembershipNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipNumber
     * @return \patest\StructType\MembershipItem
     */
    public function setMembershipNumber($membershipNumber = null)
    {
        // validation for constraint: string
        if (!is_null($membershipNumber) && !is_string($membershipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipNumber, true), gettype($membershipNumber)), __LINE__);
        }
        if (is_null($membershipNumber) || (is_array($membershipNumber) && empty($membershipNumber))) {
            unset($this->MembershipNumber);
        } else {
            $this->MembershipNumber = $membershipNumber;
        }
        return $this;
    }
    /**
     * Get NameOnCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameOnCard()
    {
        return isset($this->NameOnCard) ? $this->NameOnCard : null;
    }
    /**
     * Set NameOnCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameOnCard
     * @return \patest\StructType\MembershipItem
     */
    public function setNameOnCard($nameOnCard = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnCard) && !is_string($nameOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameOnCard, true), gettype($nameOnCard)), __LINE__);
        }
        if (is_null($nameOnCard) || (is_array($nameOnCard) && empty($nameOnCard))) {
            unset($this->NameOnCard);
        } else {
            $this->NameOnCard = $nameOnCard;
        }
        return $this;
    }
    /**
     * Get NumberOfExtras value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfExtras()
    {
        return isset($this->NumberOfExtras) ? $this->NumberOfExtras : null;
    }
    /**
     * Set NumberOfExtras value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfExtras
     * @return \patest\StructType\MembershipItem
     */
    public function setNumberOfExtras($numberOfExtras = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfExtras) && !(is_int($numberOfExtras) || ctype_digit($numberOfExtras))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfExtras, true), gettype($numberOfExtras)), __LINE__);
        }
        if (is_null($numberOfExtras) || (is_array($numberOfExtras) && empty($numberOfExtras))) {
            unset($this->NumberOfExtras);
        } else {
            $this->NumberOfExtras = $numberOfExtras;
        }
        return $this;
    }
    /**
     * Get NumberOfGuests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfGuests()
    {
        return isset($this->NumberOfGuests) ? $this->NumberOfGuests : null;
    }
    /**
     * Set NumberOfGuests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfGuests
     * @return \patest\StructType\MembershipItem
     */
    public function setNumberOfGuests($numberOfGuests = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfGuests) && !(is_int($numberOfGuests) || ctype_digit($numberOfGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfGuests, true), gettype($numberOfGuests)), __LINE__);
        }
        if (is_null($numberOfGuests) || (is_array($numberOfGuests) && empty($numberOfGuests))) {
            unset($this->NumberOfGuests);
        } else {
            $this->NumberOfGuests = $numberOfGuests;
        }
        return $this;
    }
    /**
     * Get NumberOfJointOwnersAllowedByPlan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfJointOwnersAllowedByPlan()
    {
        return isset($this->NumberOfJointOwnersAllowedByPlan) ? $this->NumberOfJointOwnersAllowedByPlan : null;
    }
    /**
     * Set NumberOfJointOwnersAllowedByPlan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfJointOwnersAllowedByPlan
     * @return \patest\StructType\MembershipItem
     */
    public function setNumberOfJointOwnersAllowedByPlan($numberOfJointOwnersAllowedByPlan = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfJointOwnersAllowedByPlan) && !(is_int($numberOfJointOwnersAllowedByPlan) || ctype_digit($numberOfJointOwnersAllowedByPlan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfJointOwnersAllowedByPlan, true), gettype($numberOfJointOwnersAllowedByPlan)), __LINE__);
        }
        if (is_null($numberOfJointOwnersAllowedByPlan) || (is_array($numberOfJointOwnersAllowedByPlan) && empty($numberOfJointOwnersAllowedByPlan))) {
            unset($this->NumberOfJointOwnersAllowedByPlan);
        } else {
            $this->NumberOfJointOwnersAllowedByPlan = $numberOfJointOwnersAllowedByPlan;
        }
        return $this;
    }
    /**
     * Get OldMembershipClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldMembershipClientId()
    {
        return isset($this->OldMembershipClientId) ? $this->OldMembershipClientId : null;
    }
    /**
     * Set OldMembershipClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldMembershipClientId
     * @return \patest\StructType\MembershipItem
     */
    public function setOldMembershipClientId($oldMembershipClientId = null)
    {
        // validation for constraint: string
        if (!is_null($oldMembershipClientId) && !is_string($oldMembershipClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldMembershipClientId, true), gettype($oldMembershipClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($oldMembershipClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $oldMembershipClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($oldMembershipClientId, true)), __LINE__);
        }
        if (is_null($oldMembershipClientId) || (is_array($oldMembershipClientId) && empty($oldMembershipClientId))) {
            unset($this->OldMembershipClientId);
        } else {
            $this->OldMembershipClientId = $oldMembershipClientId;
        }
        return $this;
    }
    /**
     * Get OldMembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldMembershipDefinitionId()
    {
        return isset($this->OldMembershipDefinitionId) ? $this->OldMembershipDefinitionId : null;
    }
    /**
     * Set OldMembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldMembershipDefinitionId
     * @return \patest\StructType\MembershipItem
     */
    public function setOldMembershipDefinitionId($oldMembershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($oldMembershipDefinitionId) && !is_string($oldMembershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldMembershipDefinitionId, true), gettype($oldMembershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($oldMembershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $oldMembershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($oldMembershipDefinitionId, true)), __LINE__);
        }
        if (is_null($oldMembershipDefinitionId) || (is_array($oldMembershipDefinitionId) && empty($oldMembershipDefinitionId))) {
            unset($this->OldMembershipDefinitionId);
        } else {
            $this->OldMembershipDefinitionId = $oldMembershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get OldMembershipName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldMembershipName()
    {
        return isset($this->OldMembershipName) ? $this->OldMembershipName : null;
    }
    /**
     * Set OldMembershipName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldMembershipName
     * @return \patest\StructType\MembershipItem
     */
    public function setOldMembershipName($oldMembershipName = null)
    {
        // validation for constraint: string
        if (!is_null($oldMembershipName) && !is_string($oldMembershipName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldMembershipName, true), gettype($oldMembershipName)), __LINE__);
        }
        if (is_null($oldMembershipName) || (is_array($oldMembershipName) && empty($oldMembershipName))) {
            unset($this->OldMembershipName);
        } else {
            $this->OldMembershipName = $oldMembershipName;
        }
        return $this;
    }
    /**
     * Get OldMembershipNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldMembershipNumber()
    {
        return isset($this->OldMembershipNumber) ? $this->OldMembershipNumber : null;
    }
    /**
     * Set OldMembershipNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldMembershipNumber
     * @return \patest\StructType\MembershipItem
     */
    public function setOldMembershipNumber($oldMembershipNumber = null)
    {
        // validation for constraint: string
        if (!is_null($oldMembershipNumber) && !is_string($oldMembershipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldMembershipNumber, true), gettype($oldMembershipNumber)), __LINE__);
        }
        if (is_null($oldMembershipNumber) || (is_array($oldMembershipNumber) && empty($oldMembershipNumber))) {
            unset($this->OldMembershipNumber);
        } else {
            $this->OldMembershipNumber = $oldMembershipNumber;
        }
        return $this;
    }
    /**
     * Get OldMembershipPriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldMembershipPriceTypeName()
    {
        return isset($this->OldMembershipPriceTypeName) ? $this->OldMembershipPriceTypeName : null;
    }
    /**
     * Set OldMembershipPriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldMembershipPriceTypeName
     * @return \patest\StructType\MembershipItem
     */
    public function setOldMembershipPriceTypeName($oldMembershipPriceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($oldMembershipPriceTypeName) && !is_string($oldMembershipPriceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldMembershipPriceTypeName, true), gettype($oldMembershipPriceTypeName)), __LINE__);
        }
        if (is_null($oldMembershipPriceTypeName) || (is_array($oldMembershipPriceTypeName) && empty($oldMembershipPriceTypeName))) {
            unset($this->OldMembershipPriceTypeName);
        } else {
            $this->OldMembershipPriceTypeName = $oldMembershipPriceTypeName;
        }
        return $this;
    }
    /**
     * Get OwnersMustBeRelatives value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOwnersMustBeRelatives()
    {
        return isset($this->OwnersMustBeRelatives) ? $this->OwnersMustBeRelatives : null;
    }
    /**
     * Set OwnersMustBeRelatives value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $ownersMustBeRelatives
     * @return \patest\StructType\MembershipItem
     */
    public function setOwnersMustBeRelatives($ownersMustBeRelatives = null)
    {
        // validation for constraint: boolean
        if (!is_null($ownersMustBeRelatives) && !is_bool($ownersMustBeRelatives)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ownersMustBeRelatives, true), gettype($ownersMustBeRelatives)), __LINE__);
        }
        if (is_null($ownersMustBeRelatives) || (is_array($ownersMustBeRelatives) && empty($ownersMustBeRelatives))) {
            unset($this->OwnersMustBeRelatives);
        } else {
            $this->OwnersMustBeRelatives = $ownersMustBeRelatives;
        }
        return $this;
    }
    /**
     * Get OwnersPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnersPriceTypeId()
    {
        return isset($this->OwnersPriceTypeId) ? $this->OwnersPriceTypeId : null;
    }
    /**
     * Set OwnersPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownersPriceTypeId
     * @return \patest\StructType\MembershipItem
     */
    public function setOwnersPriceTypeId($ownersPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($ownersPriceTypeId) && !is_string($ownersPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownersPriceTypeId, true), gettype($ownersPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownersPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownersPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownersPriceTypeId, true)), __LINE__);
        }
        if (is_null($ownersPriceTypeId) || (is_array($ownersPriceTypeId) && empty($ownersPriceTypeId))) {
            unset($this->OwnersPriceTypeId);
        } else {
            $this->OwnersPriceTypeId = $ownersPriceTypeId;
        }
        return $this;
    }
    /**
     * Get OwnersUpdatedFromPreviousMembership value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOwnersUpdatedFromPreviousMembership()
    {
        return isset($this->OwnersUpdatedFromPreviousMembership) ? $this->OwnersUpdatedFromPreviousMembership : null;
    }
    /**
     * Set OwnersUpdatedFromPreviousMembership value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $ownersUpdatedFromPreviousMembership
     * @return \patest\StructType\MembershipItem
     */
    public function setOwnersUpdatedFromPreviousMembership($ownersUpdatedFromPreviousMembership = null)
    {
        // validation for constraint: boolean
        if (!is_null($ownersUpdatedFromPreviousMembership) && !is_bool($ownersUpdatedFromPreviousMembership)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ownersUpdatedFromPreviousMembership, true), gettype($ownersUpdatedFromPreviousMembership)), __LINE__);
        }
        if (is_null($ownersUpdatedFromPreviousMembership) || (is_array($ownersUpdatedFromPreviousMembership) && empty($ownersUpdatedFromPreviousMembership))) {
            unset($this->OwnersUpdatedFromPreviousMembership);
        } else {
            $this->OwnersUpdatedFromPreviousMembership = $ownersUpdatedFromPreviousMembership;
        }
        return $this;
    }
    /**
     * Get RenewedExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewedExpiryDate()
    {
        return isset($this->RenewedExpiryDate) ? $this->RenewedExpiryDate : null;
    }
    /**
     * Set RenewedExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewedExpiryDate
     * @return \patest\StructType\MembershipItem
     */
    public function setRenewedExpiryDate($renewedExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($renewedExpiryDate) && !is_string($renewedExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewedExpiryDate, true), gettype($renewedExpiryDate)), __LINE__);
        }
        if (is_null($renewedExpiryDate) || (is_array($renewedExpiryDate) && empty($renewedExpiryDate))) {
            unset($this->RenewedExpiryDate);
        } else {
            $this->RenewedExpiryDate = $renewedExpiryDate;
        }
        return $this;
    }
    /**
     * Get RenewedId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewedId()
    {
        return isset($this->RenewedId) ? $this->RenewedId : null;
    }
    /**
     * Set RenewedId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewedId
     * @return \patest\StructType\MembershipItem
     */
    public function setRenewedId($renewedId = null)
    {
        // validation for constraint: string
        if (!is_null($renewedId) && !is_string($renewedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewedId, true), gettype($renewedId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($renewedId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $renewedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($renewedId, true)), __LINE__);
        }
        if (is_null($renewedId) || (is_array($renewedId) && empty($renewedId))) {
            unset($this->RenewedId);
        } else {
            $this->RenewedId = $renewedId;
        }
        return $this;
    }
    /**
     * Get RenewedInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewedInstanceId()
    {
        return isset($this->RenewedInstanceId) ? $this->RenewedInstanceId : null;
    }
    /**
     * Set RenewedInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewedInstanceId
     * @return \patest\StructType\MembershipItem
     */
    public function setRenewedInstanceId($renewedInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($renewedInstanceId) && !is_string($renewedInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewedInstanceId, true), gettype($renewedInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($renewedInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $renewedInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($renewedInstanceId, true)), __LINE__);
        }
        if (is_null($renewedInstanceId) || (is_array($renewedInstanceId) && empty($renewedInstanceId))) {
            unset($this->RenewedInstanceId);
        } else {
            $this->RenewedInstanceId = $renewedInstanceId;
        }
        return $this;
    }
    /**
     * Get RequestedOperation value
     * @return string|null
     */
    public function getRequestedOperation()
    {
        return $this->RequestedOperation;
    }
    /**
     * Set RequestedOperation value
     * @uses \patest\EnumType\MembershipRequestedOperation::valueIsValid()
     * @uses \patest\EnumType\MembershipRequestedOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestedOperation
     * @return \patest\StructType\MembershipItem
     */
    public function setRequestedOperation($requestedOperation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipRequestedOperation::valueIsValid($requestedOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipRequestedOperation', is_array($requestedOperation) ? implode(', ', $requestedOperation) : var_export($requestedOperation, true), implode(', ', \patest\EnumType\MembershipRequestedOperation::getValidValues())), __LINE__);
        }
        $this->RequestedOperation = $requestedOperation;
        return $this;
    }
    /**
     * Get SchemeId value
     * @return string|null
     */
    public function getSchemeId()
    {
        return $this->SchemeId;
    }
    /**
     * Set SchemeId value
     * @param string $schemeId
     * @return \patest\StructType\MembershipItem
     */
    public function setSchemeId($schemeId = null)
    {
        // validation for constraint: string
        if (!is_null($schemeId) && !is_string($schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeId, true), gettype($schemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemeId, true)), __LINE__);
        }
        $this->SchemeId = $schemeId;
        return $this;
    }
    /**
     * Get SchemeLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeLevelId()
    {
        return isset($this->SchemeLevelId) ? $this->SchemeLevelId : null;
    }
    /**
     * Set SchemeLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeLevelId
     * @return \patest\StructType\MembershipItem
     */
    public function setSchemeLevelId($schemeLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($schemeLevelId) && !is_string($schemeLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeLevelId, true), gettype($schemeLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemeLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemeLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemeLevelId, true)), __LINE__);
        }
        if (is_null($schemeLevelId) || (is_array($schemeLevelId) && empty($schemeLevelId))) {
            unset($this->SchemeLevelId);
        } else {
            $this->SchemeLevelId = $schemeLevelId;
        }
        return $this;
    }
    /**
     * Get SchemeLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeLevelName()
    {
        return isset($this->SchemeLevelName) ? $this->SchemeLevelName : null;
    }
    /**
     * Set SchemeLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeLevelName
     * @return \patest\StructType\MembershipItem
     */
    public function setSchemeLevelName($schemeLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($schemeLevelName) && !is_string($schemeLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeLevelName, true), gettype($schemeLevelName)), __LINE__);
        }
        if (is_null($schemeLevelName) || (is_array($schemeLevelName) && empty($schemeLevelName))) {
            unset($this->SchemeLevelName);
        } else {
            $this->SchemeLevelName = $schemeLevelName;
        }
        return $this;
    }
    /**
     * Get SchemeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeName()
    {
        return isset($this->SchemeName) ? $this->SchemeName : null;
    }
    /**
     * Set SchemeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeName
     * @return \patest\StructType\MembershipItem
     */
    public function setSchemeName($schemeName = null)
    {
        // validation for constraint: string
        if (!is_null($schemeName) && !is_string($schemeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeName, true), gettype($schemeName)), __LINE__);
        }
        if (is_null($schemeName) || (is_array($schemeName) && empty($schemeName))) {
            unset($this->SchemeName);
        } else {
            $this->SchemeName = $schemeName;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \patest\StructType\MembershipItem
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \patest\EnumType\MembershipStatus::valueIsValid()
     * @uses \patest\EnumType\MembershipStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\MembershipItem
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\MembershipStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusOfReturned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusOfReturned()
    {
        return isset($this->StatusOfReturned) ? $this->StatusOfReturned : null;
    }
    /**
     * Set StatusOfReturned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MembershipStatus::valueIsValid()
     * @uses \patest\EnumType\MembershipStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusOfReturned
     * @return \patest\StructType\MembershipItem
     */
    public function setStatusOfReturned($statusOfReturned = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipStatus::valueIsValid($statusOfReturned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipStatus', is_array($statusOfReturned) ? implode(', ', $statusOfReturned) : var_export($statusOfReturned, true), implode(', ', \patest\EnumType\MembershipStatus::getValidValues())), __LINE__);
        }
        if (is_null($statusOfReturned) || (is_array($statusOfReturned) && empty($statusOfReturned))) {
            unset($this->StatusOfReturned);
        } else {
            $this->StatusOfReturned = $statusOfReturned;
        }
        return $this;
    }
    /**
     * Get UpdateOfInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateOfInstanceId()
    {
        return isset($this->UpdateOfInstanceId) ? $this->UpdateOfInstanceId : null;
    }
    /**
     * Set UpdateOfInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updateOfInstanceId
     * @return \patest\StructType\MembershipItem
     */
    public function setUpdateOfInstanceId($updateOfInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($updateOfInstanceId) && !is_string($updateOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateOfInstanceId, true), gettype($updateOfInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($updateOfInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $updateOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($updateOfInstanceId, true)), __LINE__);
        }
        if (is_null($updateOfInstanceId) || (is_array($updateOfInstanceId) && empty($updateOfInstanceId))) {
            unset($this->UpdateOfInstanceId);
        } else {
            $this->UpdateOfInstanceId = $updateOfInstanceId;
        }
        return $this;
    }
    /**
     * Get UpgradeOnlyMode value
     * @return bool|null
     */
    public function getUpgradeOnlyMode()
    {
        return $this->UpgradeOnlyMode;
    }
    /**
     * Set UpgradeOnlyMode value
     * @param bool $upgradeOnlyMode
     * @return \patest\StructType\MembershipItem
     */
    public function setUpgradeOnlyMode($upgradeOnlyMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($upgradeOnlyMode) && !is_bool($upgradeOnlyMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($upgradeOnlyMode, true), gettype($upgradeOnlyMode)), __LINE__);
        }
        $this->UpgradeOnlyMode = $upgradeOnlyMode;
        return $this;
    }
    /**
     * Get IsAutoRenewRequested value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutoRenewRequested()
    {
        return isset($this->IsAutoRenewRequested) ? $this->IsAutoRenewRequested : null;
    }
    /**
     * Set IsAutoRenewRequested value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutoRenewRequested
     * @return \patest\StructType\MembershipItem
     */
    public function setIsAutoRenewRequested($isAutoRenewRequested = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoRenewRequested) && !is_bool($isAutoRenewRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoRenewRequested, true), gettype($isAutoRenewRequested)), __LINE__);
        }
        if (is_null($isAutoRenewRequested) || (is_array($isAutoRenewRequested) && empty($isAutoRenewRequested))) {
            unset($this->IsAutoRenewRequested);
        } else {
            $this->IsAutoRenewRequested = $isAutoRenewRequested;
        }
        return $this;
    }
    /**
     * Get SkipAutoRenewValidation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSkipAutoRenewValidation()
    {
        return isset($this->SkipAutoRenewValidation) ? $this->SkipAutoRenewValidation : null;
    }
    /**
     * Set SkipAutoRenewValidation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $skipAutoRenewValidation
     * @return \patest\StructType\MembershipItem
     */
    public function setSkipAutoRenewValidation($skipAutoRenewValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipAutoRenewValidation) && !is_bool($skipAutoRenewValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipAutoRenewValidation, true), gettype($skipAutoRenewValidation)), __LINE__);
        }
        if (is_null($skipAutoRenewValidation) || (is_array($skipAutoRenewValidation) && empty($skipAutoRenewValidation))) {
            unset($this->SkipAutoRenewValidation);
        } else {
            $this->SkipAutoRenewValidation = $skipAutoRenewValidation;
        }
        return $this;
    }
    /**
     * Get PreferredExchange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredExchange()
    {
        return isset($this->PreferredExchange) ? $this->PreferredExchange : null;
    }
    /**
     * Set PreferredExchange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredExchange
     * @return \patest\StructType\MembershipItem
     */
    public function setPreferredExchange($preferredExchange = null)
    {
        // validation for constraint: string
        if (!is_null($preferredExchange) && !is_string($preferredExchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredExchange, true), gettype($preferredExchange)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($preferredExchange) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $preferredExchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($preferredExchange, true)), __LINE__);
        }
        if (is_null($preferredExchange) || (is_array($preferredExchange) && empty($preferredExchange))) {
            unset($this->PreferredExchange);
        } else {
            $this->PreferredExchange = $preferredExchange;
        }
        return $this;
    }
}
