<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MembershipDefinitionDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MembershipDefinitionDescription
 * @subpackage Structs
 */
class MembershipDefinitionDescription extends AbstractStructBase
{
    /**
     * The MaxEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MaxEndDate;
    /**
     * The MembershipDefinition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Membership_MembershipDefinition
     */
    public $MembershipDefinition;
    /**
     * The MinStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MinStartDate;
    /**
     * The Pricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\MembershipDefinitionPricingDescription
     */
    public $Pricing;
    /**
     * The SchemeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SchemeDescription
     */
    public $SchemeDescription;
    /**
     * Constructor method for MembershipDefinitionDescription
     * @uses MembershipDefinitionDescription::setMaxEndDate()
     * @uses MembershipDefinitionDescription::setMembershipDefinition()
     * @uses MembershipDefinitionDescription::setMinStartDate()
     * @uses MembershipDefinitionDescription::setPricing()
     * @uses MembershipDefinitionDescription::setSchemeDescription()
     * @param string $maxEndDate
     * @param \patest\StructType\Membership_MembershipDefinition $membershipDefinition
     * @param string $minStartDate
     * @param \patest\StructType\MembershipDefinitionPricingDescription $pricing
     * @param \patest\StructType\SchemeDescription $schemeDescription
     */
    public function __construct($maxEndDate = null, \patest\StructType\Membership_MembershipDefinition $membershipDefinition = null, $minStartDate = null, \patest\StructType\MembershipDefinitionPricingDescription $pricing = null, \patest\StructType\SchemeDescription $schemeDescription = null)
    {
        $this
            ->setMaxEndDate($maxEndDate)
            ->setMembershipDefinition($membershipDefinition)
            ->setMinStartDate($minStartDate)
            ->setPricing($pricing)
            ->setSchemeDescription($schemeDescription);
    }
    /**
     * Get MaxEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaxEndDate()
    {
        return isset($this->MaxEndDate) ? $this->MaxEndDate : null;
    }
    /**
     * Set MaxEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $maxEndDate
     * @return \patest\StructType\MembershipDefinitionDescription
     */
    public function setMaxEndDate($maxEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($maxEndDate) && !is_string($maxEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxEndDate, true), gettype($maxEndDate)), __LINE__);
        }
        if (is_null($maxEndDate) || (is_array($maxEndDate) && empty($maxEndDate))) {
            unset($this->MaxEndDate);
        } else {
            $this->MaxEndDate = $maxEndDate;
        }
        return $this;
    }
    /**
     * Get MembershipDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Membership_MembershipDefinition|null
     */
    public function getMembershipDefinition()
    {
        return isset($this->MembershipDefinition) ? $this->MembershipDefinition : null;
    }
    /**
     * Set MembershipDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Membership_MembershipDefinition $membershipDefinition
     * @return \patest\StructType\MembershipDefinitionDescription
     */
    public function setMembershipDefinition(\patest\StructType\Membership_MembershipDefinition $membershipDefinition = null)
    {
        if (is_null($membershipDefinition) || (is_array($membershipDefinition) && empty($membershipDefinition))) {
            unset($this->MembershipDefinition);
        } else {
            $this->MembershipDefinition = $membershipDefinition;
        }
        return $this;
    }
    /**
     * Get MinStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMinStartDate()
    {
        return isset($this->MinStartDate) ? $this->MinStartDate : null;
    }
    /**
     * Set MinStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $minStartDate
     * @return \patest\StructType\MembershipDefinitionDescription
     */
    public function setMinStartDate($minStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($minStartDate) && !is_string($minStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minStartDate, true), gettype($minStartDate)), __LINE__);
        }
        if (is_null($minStartDate) || (is_array($minStartDate) && empty($minStartDate))) {
            unset($this->MinStartDate);
        } else {
            $this->MinStartDate = $minStartDate;
        }
        return $this;
    }
    /**
     * Get Pricing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\MembershipDefinitionPricingDescription|null
     */
    public function getPricing()
    {
        return isset($this->Pricing) ? $this->Pricing : null;
    }
    /**
     * Set Pricing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\MembershipDefinitionPricingDescription $pricing
     * @return \patest\StructType\MembershipDefinitionDescription
     */
    public function setPricing(\patest\StructType\MembershipDefinitionPricingDescription $pricing = null)
    {
        if (is_null($pricing) || (is_array($pricing) && empty($pricing))) {
            unset($this->Pricing);
        } else {
            $this->Pricing = $pricing;
        }
        return $this;
    }
    /**
     * Get SchemeDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SchemeDescription|null
     */
    public function getSchemeDescription()
    {
        return isset($this->SchemeDescription) ? $this->SchemeDescription : null;
    }
    /**
     * Set SchemeDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SchemeDescription $schemeDescription
     * @return \patest\StructType\MembershipDefinitionDescription
     */
    public function setSchemeDescription(\patest\StructType\SchemeDescription $schemeDescription = null)
    {
        if (is_null($schemeDescription) || (is_array($schemeDescription) && empty($schemeDescription))) {
            unset($this->SchemeDescription);
        } else {
            $this->SchemeDescription = $schemeDescription;
        }
        return $this;
    }
}
