<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Marketing.ScheduledQueryExecutionFilter StructType
 * @subpackage Structs
 */
class Marketing_ScheduledQueryExecutionFilter extends FilterEntity
{
    /**
     * The EmailSentTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailSentTo;
    /**
     * The EmailWasSent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailWasSent;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The GeneratedRequests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeneratedRequests;
    /**
     * The GeneratedResults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeneratedResults;
    /**
     * The ProcessDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProcessDefinitionId;
    /**
     * The QueryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * Constructor method for Marketing.ScheduledQueryExecutionFilter
     * @uses Marketing_ScheduledQueryExecutionFilter::setEmailSentTo()
     * @uses Marketing_ScheduledQueryExecutionFilter::setEmailWasSent()
     * @uses Marketing_ScheduledQueryExecutionFilter::setFromDate()
     * @uses Marketing_ScheduledQueryExecutionFilter::setGeneratedRequests()
     * @uses Marketing_ScheduledQueryExecutionFilter::setGeneratedResults()
     * @uses Marketing_ScheduledQueryExecutionFilter::setProcessDefinitionId()
     * @uses Marketing_ScheduledQueryExecutionFilter::setQueryId()
     * @uses Marketing_ScheduledQueryExecutionFilter::setStatus()
     * @uses Marketing_ScheduledQueryExecutionFilter::setToDate()
     * @param string $emailSentTo
     * @param string $emailWasSent
     * @param string $fromDate
     * @param string $generatedRequests
     * @param string $generatedResults
     * @param string $processDefinitionId
     * @param string $queryId
     * @param string $status
     * @param string $toDate
     */
    public function __construct($emailSentTo = null, $emailWasSent = null, $fromDate = null, $generatedRequests = null, $generatedResults = null, $processDefinitionId = null, $queryId = null, $status = null, $toDate = null)
    {
        $this
            ->setEmailSentTo($emailSentTo)
            ->setEmailWasSent($emailWasSent)
            ->setFromDate($fromDate)
            ->setGeneratedRequests($generatedRequests)
            ->setGeneratedResults($generatedResults)
            ->setProcessDefinitionId($processDefinitionId)
            ->setQueryId($queryId)
            ->setStatus($status)
            ->setToDate($toDate);
    }
    /**
     * Get EmailSentTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailSentTo()
    {
        return isset($this->EmailSentTo) ? $this->EmailSentTo : null;
    }
    /**
     * Set EmailSentTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailSentTo
     * @return \patest\StructType\Marketing_ScheduledQueryExecutionFilter
     */
    public function setEmailSentTo($emailSentTo = null)
    {
        // validation for constraint: string
        if (!is_null($emailSentTo) && !is_string($emailSentTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailSentTo, true), gettype($emailSentTo)), __LINE__);
        }
        if (is_null($emailSentTo) || (is_array($emailSentTo) && empty($emailSentTo))) {
            unset($this->EmailSentTo);
        } else {
            $this->EmailSentTo = $emailSentTo;
        }
        return $this;
    }
    /**
     * Get EmailWasSent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailWasSent()
    {
        return isset($this->EmailWasSent) ? $this->EmailWasSent : null;
    }
    /**
     * Set EmailWasSent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\YesNo::valueIsValid()
     * @uses \patest\EnumType\YesNo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $emailWasSent
     * @return \patest\StructType\Marketing_ScheduledQueryExecutionFilter
     */
    public function setEmailWasSent($emailWasSent = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\YesNo::valueIsValid($emailWasSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\YesNo', is_array($emailWasSent) ? implode(', ', $emailWasSent) : var_export($emailWasSent, true), implode(', ', \patest\EnumType\YesNo::getValidValues())), __LINE__);
        }
        if (is_null($emailWasSent) || (is_array($emailWasSent) && empty($emailWasSent))) {
            unset($this->EmailWasSent);
        } else {
            $this->EmailWasSent = $emailWasSent;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Marketing_ScheduledQueryExecutionFilter
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get GeneratedRequests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneratedRequests()
    {
        return isset($this->GeneratedRequests) ? $this->GeneratedRequests : null;
    }
    /**
     * Set GeneratedRequests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\YesNo::valueIsValid()
     * @uses \patest\EnumType\YesNo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $generatedRequests
     * @return \patest\StructType\Marketing_ScheduledQueryExecutionFilter
     */
    public function setGeneratedRequests($generatedRequests = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\YesNo::valueIsValid($generatedRequests)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\YesNo', is_array($generatedRequests) ? implode(', ', $generatedRequests) : var_export($generatedRequests, true), implode(', ', \patest\EnumType\YesNo::getValidValues())), __LINE__);
        }
        if (is_null($generatedRequests) || (is_array($generatedRequests) && empty($generatedRequests))) {
            unset($this->GeneratedRequests);
        } else {
            $this->GeneratedRequests = $generatedRequests;
        }
        return $this;
    }
    /**
     * Get GeneratedResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneratedResults()
    {
        return isset($this->GeneratedResults) ? $this->GeneratedResults : null;
    }
    /**
     * Set GeneratedResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\YesNo::valueIsValid()
     * @uses \patest\EnumType\YesNo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $generatedResults
     * @return \patest\StructType\Marketing_ScheduledQueryExecutionFilter
     */
    public function setGeneratedResults($generatedResults = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\YesNo::valueIsValid($generatedResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\YesNo', is_array($generatedResults) ? implode(', ', $generatedResults) : var_export($generatedResults, true), implode(', ', \patest\EnumType\YesNo::getValidValues())), __LINE__);
        }
        if (is_null($generatedResults) || (is_array($generatedResults) && empty($generatedResults))) {
            unset($this->GeneratedResults);
        } else {
            $this->GeneratedResults = $generatedResults;
        }
        return $this;
    }
    /**
     * Get ProcessDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessDefinitionId()
    {
        return isset($this->ProcessDefinitionId) ? $this->ProcessDefinitionId : null;
    }
    /**
     * Set ProcessDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processDefinitionId
     * @return \patest\StructType\Marketing_ScheduledQueryExecutionFilter
     */
    public function setProcessDefinitionId($processDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($processDefinitionId) && !is_string($processDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processDefinitionId, true), gettype($processDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($processDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $processDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($processDefinitionId, true)), __LINE__);
        }
        if (is_null($processDefinitionId) || (is_array($processDefinitionId) && empty($processDefinitionId))) {
            unset($this->ProcessDefinitionId);
        } else {
            $this->ProcessDefinitionId = $processDefinitionId;
        }
        return $this;
    }
    /**
     * Get QueryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryId()
    {
        return isset($this->QueryId) ? $this->QueryId : null;
    }
    /**
     * Set QueryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryId
     * @return \patest\StructType\Marketing_ScheduledQueryExecutionFilter
     */
    public function setQueryId($queryId = null)
    {
        // validation for constraint: string
        if (!is_null($queryId) && !is_string($queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryId, true), gettype($queryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryId, true)), __LINE__);
        }
        if (is_null($queryId) || (is_array($queryId) && empty($queryId))) {
            unset($this->QueryId);
        } else {
            $this->QueryId = $queryId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ScheduledQueryExecutionFilterStatus::valueIsValid()
     * @uses \patest\EnumType\ScheduledQueryExecutionFilterStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Marketing_ScheduledQueryExecutionFilter
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ScheduledQueryExecutionFilterStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ScheduledQueryExecutionFilterStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\ScheduledQueryExecutionFilterStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\Marketing_ScheduledQueryExecutionFilter
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
}
