<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Marketing.ExecutedAppealRecipient StructType
 * @subpackage Structs
 */
class Marketing_ExecutedAppealRecipient extends DistributableEntity
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The BusinessPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessPhone;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $City;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Comment;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Country;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The ExecutedAppealId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExecutedAppealId;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The HomePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomePhone;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsBounced
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBounced;
    /**
     * The IsClicked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsClicked;
    /**
     * The IsManuallyExecuted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsManuallyExecuted;
    /**
     * The IsOpened
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOpened;
    /**
     * The IsProcessed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsProcessed;
    /**
     * The IsUnsubscribed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUnsubscribed;
    /**
     * The JobTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $JobTitle;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mobile;
    /**
     * The Region
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Region;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $State;
    /**
     * Constructor method for Marketing.ExecutedAppealRecipient
     * @uses Marketing_ExecutedAppealRecipient::setAddress()
     * @uses Marketing_ExecutedAppealRecipient::setBusinessPhone()
     * @uses Marketing_ExecutedAppealRecipient::setCity()
     * @uses Marketing_ExecutedAppealRecipient::setClientId()
     * @uses Marketing_ExecutedAppealRecipient::setComment()
     * @uses Marketing_ExecutedAppealRecipient::setCountry()
     * @uses Marketing_ExecutedAppealRecipient::setCrmId()
     * @uses Marketing_ExecutedAppealRecipient::setEmail()
     * @uses Marketing_ExecutedAppealRecipient::setExecutedAppealId()
     * @uses Marketing_ExecutedAppealRecipient::setFirstName()
     * @uses Marketing_ExecutedAppealRecipient::setHomePhone()
     * @uses Marketing_ExecutedAppealRecipient::setIsActive()
     * @uses Marketing_ExecutedAppealRecipient::setIsBounced()
     * @uses Marketing_ExecutedAppealRecipient::setIsClicked()
     * @uses Marketing_ExecutedAppealRecipient::setIsManuallyExecuted()
     * @uses Marketing_ExecutedAppealRecipient::setIsOpened()
     * @uses Marketing_ExecutedAppealRecipient::setIsProcessed()
     * @uses Marketing_ExecutedAppealRecipient::setIsUnsubscribed()
     * @uses Marketing_ExecutedAppealRecipient::setJobTitle()
     * @uses Marketing_ExecutedAppealRecipient::setLastName()
     * @uses Marketing_ExecutedAppealRecipient::setMobile()
     * @uses Marketing_ExecutedAppealRecipient::setRegion()
     * @uses Marketing_ExecutedAppealRecipient::setState()
     * @param string $address
     * @param string $businessPhone
     * @param \patest\StructType\GlobalString $city
     * @param string $clientId
     * @param \patest\StructType\GlobalString $comment
     * @param \patest\StructType\GlobalString $country
     * @param string $crmId
     * @param string $email
     * @param string $executedAppealId
     * @param string $firstName
     * @param string $homePhone
     * @param bool $isActive
     * @param bool $isBounced
     * @param bool $isClicked
     * @param bool $isManuallyExecuted
     * @param bool $isOpened
     * @param bool $isProcessed
     * @param bool $isUnsubscribed
     * @param \patest\StructType\GlobalString $jobTitle
     * @param string $lastName
     * @param string $mobile
     * @param \patest\StructType\GlobalString $region
     * @param \patest\StructType\GlobalString $state
     */
    public function __construct($address = null, $businessPhone = null, \patest\StructType\GlobalString $city = null, $clientId = null, \patest\StructType\GlobalString $comment = null, \patest\StructType\GlobalString $country = null, $crmId = null, $email = null, $executedAppealId = null, $firstName = null, $homePhone = null, $isActive = null, $isBounced = null, $isClicked = null, $isManuallyExecuted = null, $isOpened = null, $isProcessed = null, $isUnsubscribed = null, \patest\StructType\GlobalString $jobTitle = null, $lastName = null, $mobile = null, \patest\StructType\GlobalString $region = null, \patest\StructType\GlobalString $state = null)
    {
        $this
            ->setAddress($address)
            ->setBusinessPhone($businessPhone)
            ->setCity($city)
            ->setClientId($clientId)
            ->setComment($comment)
            ->setCountry($country)
            ->setCrmId($crmId)
            ->setEmail($email)
            ->setExecutedAppealId($executedAppealId)
            ->setFirstName($firstName)
            ->setHomePhone($homePhone)
            ->setIsActive($isActive)
            ->setIsBounced($isBounced)
            ->setIsClicked($isClicked)
            ->setIsManuallyExecuted($isManuallyExecuted)
            ->setIsOpened($isOpened)
            ->setIsProcessed($isProcessed)
            ->setIsUnsubscribed($isUnsubscribed)
            ->setJobTitle($jobTitle)
            ->setLastName($lastName)
            ->setMobile($mobile)
            ->setRegion($region)
            ->setState($state);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get BusinessPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessPhone()
    {
        return isset($this->BusinessPhone) ? $this->BusinessPhone : null;
    }
    /**
     * Set BusinessPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessPhone
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setBusinessPhone($businessPhone = null)
    {
        // validation for constraint: string
        if (!is_null($businessPhone) && !is_string($businessPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessPhone, true), gettype($businessPhone)), __LINE__);
        }
        if (is_null($businessPhone) || (is_array($businessPhone) && empty($businessPhone))) {
            unset($this->BusinessPhone);
        } else {
            $this->BusinessPhone = $businessPhone;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $city
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setCity(\patest\StructType\GlobalString $city = null)
    {
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $comment
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setComment(\patest\StructType\GlobalString $comment = null)
    {
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $country
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setCountry(\patest\StructType\GlobalString $country = null)
    {
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get ExecutedAppealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutedAppealId()
    {
        return isset($this->ExecutedAppealId) ? $this->ExecutedAppealId : null;
    }
    /**
     * Set ExecutedAppealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executedAppealId
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setExecutedAppealId($executedAppealId = null)
    {
        // validation for constraint: string
        if (!is_null($executedAppealId) && !is_string($executedAppealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executedAppealId, true), gettype($executedAppealId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($executedAppealId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $executedAppealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($executedAppealId, true)), __LINE__);
        }
        if (is_null($executedAppealId) || (is_array($executedAppealId) && empty($executedAppealId))) {
            unset($this->ExecutedAppealId);
        } else {
            $this->ExecutedAppealId = $executedAppealId;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get HomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomePhone()
    {
        return isset($this->HomePhone) ? $this->HomePhone : null;
    }
    /**
     * Set HomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homePhone
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        if (is_null($homePhone) || (is_array($homePhone) && empty($homePhone))) {
            unset($this->HomePhone);
        } else {
            $this->HomePhone = $homePhone;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsBounced value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBounced()
    {
        return isset($this->IsBounced) ? $this->IsBounced : null;
    }
    /**
     * Set IsBounced value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBounced
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setIsBounced($isBounced = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBounced) && !is_bool($isBounced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBounced, true), gettype($isBounced)), __LINE__);
        }
        if (is_null($isBounced) || (is_array($isBounced) && empty($isBounced))) {
            unset($this->IsBounced);
        } else {
            $this->IsBounced = $isBounced;
        }
        return $this;
    }
    /**
     * Get IsClicked value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsClicked()
    {
        return isset($this->IsClicked) ? $this->IsClicked : null;
    }
    /**
     * Set IsClicked value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isClicked
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setIsClicked($isClicked = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClicked) && !is_bool($isClicked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClicked, true), gettype($isClicked)), __LINE__);
        }
        if (is_null($isClicked) || (is_array($isClicked) && empty($isClicked))) {
            unset($this->IsClicked);
        } else {
            $this->IsClicked = $isClicked;
        }
        return $this;
    }
    /**
     * Get IsManuallyExecuted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsManuallyExecuted()
    {
        return isset($this->IsManuallyExecuted) ? $this->IsManuallyExecuted : null;
    }
    /**
     * Set IsManuallyExecuted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isManuallyExecuted
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setIsManuallyExecuted($isManuallyExecuted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isManuallyExecuted) && !is_bool($isManuallyExecuted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isManuallyExecuted, true), gettype($isManuallyExecuted)), __LINE__);
        }
        if (is_null($isManuallyExecuted) || (is_array($isManuallyExecuted) && empty($isManuallyExecuted))) {
            unset($this->IsManuallyExecuted);
        } else {
            $this->IsManuallyExecuted = $isManuallyExecuted;
        }
        return $this;
    }
    /**
     * Get IsOpened value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOpened()
    {
        return isset($this->IsOpened) ? $this->IsOpened : null;
    }
    /**
     * Set IsOpened value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOpened
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setIsOpened($isOpened = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOpened) && !is_bool($isOpened)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOpened, true), gettype($isOpened)), __LINE__);
        }
        if (is_null($isOpened) || (is_array($isOpened) && empty($isOpened))) {
            unset($this->IsOpened);
        } else {
            $this->IsOpened = $isOpened;
        }
        return $this;
    }
    /**
     * Get IsProcessed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsProcessed()
    {
        return isset($this->IsProcessed) ? $this->IsProcessed : null;
    }
    /**
     * Set IsProcessed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isProcessed
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setIsProcessed($isProcessed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isProcessed) && !is_bool($isProcessed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isProcessed, true), gettype($isProcessed)), __LINE__);
        }
        if (is_null($isProcessed) || (is_array($isProcessed) && empty($isProcessed))) {
            unset($this->IsProcessed);
        } else {
            $this->IsProcessed = $isProcessed;
        }
        return $this;
    }
    /**
     * Get IsUnsubscribed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUnsubscribed()
    {
        return isset($this->IsUnsubscribed) ? $this->IsUnsubscribed : null;
    }
    /**
     * Set IsUnsubscribed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUnsubscribed
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setIsUnsubscribed($isUnsubscribed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUnsubscribed) && !is_bool($isUnsubscribed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUnsubscribed, true), gettype($isUnsubscribed)), __LINE__);
        }
        if (is_null($isUnsubscribed) || (is_array($isUnsubscribed) && empty($isUnsubscribed))) {
            unset($this->IsUnsubscribed);
        } else {
            $this->IsUnsubscribed = $isUnsubscribed;
        }
        return $this;
    }
    /**
     * Get JobTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getJobTitle()
    {
        return isset($this->JobTitle) ? $this->JobTitle : null;
    }
    /**
     * Set JobTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $jobTitle
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setJobTitle(\patest\StructType\GlobalString $jobTitle = null)
    {
        if (is_null($jobTitle) || (is_array($jobTitle) && empty($jobTitle))) {
            unset($this->JobTitle);
        } else {
            $this->JobTitle = $jobTitle;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get Mobile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobile()
    {
        return isset($this->Mobile) ? $this->Mobile : null;
    }
    /**
     * Set Mobile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobile
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        if (is_null($mobile) || (is_array($mobile) && empty($mobile))) {
            unset($this->Mobile);
        } else {
            $this->Mobile = $mobile;
        }
        return $this;
    }
    /**
     * Get Region value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getRegion()
    {
        return isset($this->Region) ? $this->Region : null;
    }
    /**
     * Set Region value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $region
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setRegion(\patest\StructType\GlobalString $region = null)
    {
        if (is_null($region) || (is_array($region) && empty($region))) {
            unset($this->Region);
        } else {
            $this->Region = $region;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $state
     * @return \patest\StructType\Marketing_ExecutedAppealRecipient
     */
    public function setState(\patest\StructType\GlobalString $state = null)
    {
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
}
