<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Marketing.ExecutableAppealConfig.Internal StructType
 * @subpackage Structs
 */
class Marketing_ExecutableAppealConfig_Internal extends Marketing_ExecutableAppealConfigBase
{
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DocumentId;
    /**
     * The EmailSubject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $EmailSubject;
    /**
     * Constructor method for Marketing.ExecutableAppealConfig.Internal
     * @uses Marketing_ExecutableAppealConfig_Internal::setDocumentId()
     * @uses Marketing_ExecutableAppealConfig_Internal::setEmailSubject()
     * @param string $documentId
     * @param \patest\StructType\GlobalString $emailSubject
     */
    public function __construct($documentId = null, \patest\StructType\GlobalString $emailSubject = null)
    {
        $this
            ->setDocumentId($documentId)
            ->setEmailSubject($emailSubject);
    }
    /**
     * Get DocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentId()
    {
        return isset($this->DocumentId) ? $this->DocumentId : null;
    }
    /**
     * Set DocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentId
     * @return \patest\StructType\Marketing_ExecutableAppealConfig_Internal
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($documentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($documentId, true)), __LINE__);
        }
        if (is_null($documentId) || (is_array($documentId) && empty($documentId))) {
            unset($this->DocumentId);
        } else {
            $this->DocumentId = $documentId;
        }
        return $this;
    }
    /**
     * Get EmailSubject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getEmailSubject()
    {
        return isset($this->EmailSubject) ? $this->EmailSubject : null;
    }
    /**
     * Set EmailSubject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $emailSubject
     * @return \patest\StructType\Marketing_ExecutableAppealConfig_Internal
     */
    public function setEmailSubject(\patest\StructType\GlobalString $emailSubject = null)
    {
        if (is_null($emailSubject) || (is_array($emailSubject) && empty($emailSubject))) {
            unset($this->EmailSubject);
        } else {
            $this->EmailSubject = $emailSubject;
        }
        return $this;
    }
}
