<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaintainableGlobalizedEntity StructType
 * @subpackage Structs
 */
class MaintainableGlobalizedEntity extends DistributableEntity
{
    /**
     * The CreationAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreationAuditId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The LastModifiedAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LastModifiedAuditId;
    /**
     * The LastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * Constructor method for MaintainableGlobalizedEntity
     * @uses MaintainableGlobalizedEntity::setCreationAuditId()
     * @uses MaintainableGlobalizedEntity::setCreationDate()
     * @uses MaintainableGlobalizedEntity::setDescription()
     * @uses MaintainableGlobalizedEntity::setLastModifiedAuditId()
     * @uses MaintainableGlobalizedEntity::setLastModifiedDate()
     * @uses MaintainableGlobalizedEntity::setName()
     * @param int $creationAuditId
     * @param string $creationDate
     * @param \patest\StructType\GlobalString $description
     * @param int $lastModifiedAuditId
     * @param string $lastModifiedDate
     * @param \patest\StructType\GlobalString $name
     */
    public function __construct($creationAuditId = null, $creationDate = null, \patest\StructType\GlobalString $description = null, $lastModifiedAuditId = null, $lastModifiedDate = null, \patest\StructType\GlobalString $name = null)
    {
        $this
            ->setCreationAuditId($creationAuditId)
            ->setCreationDate($creationDate)
            ->setDescription($description)
            ->setLastModifiedAuditId($lastModifiedAuditId)
            ->setLastModifiedDate($lastModifiedDate)
            ->setName($name);
    }
    /**
     * Get CreationAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreationAuditId()
    {
        return isset($this->CreationAuditId) ? $this->CreationAuditId : null;
    }
    /**
     * Set CreationAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creationAuditId
     * @return \patest\StructType\MaintainableGlobalizedEntity
     */
    public function setCreationAuditId($creationAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($creationAuditId) && !(is_int($creationAuditId) || ctype_digit($creationAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creationAuditId, true), gettype($creationAuditId)), __LINE__);
        }
        if (is_null($creationAuditId) || (is_array($creationAuditId) && empty($creationAuditId))) {
            unset($this->CreationAuditId);
        } else {
            $this->CreationAuditId = $creationAuditId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\MaintainableGlobalizedEntity
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\MaintainableGlobalizedEntity
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get LastModifiedAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLastModifiedAuditId()
    {
        return isset($this->LastModifiedAuditId) ? $this->LastModifiedAuditId : null;
    }
    /**
     * Set LastModifiedAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lastModifiedAuditId
     * @return \patest\StructType\MaintainableGlobalizedEntity
     */
    public function setLastModifiedAuditId($lastModifiedAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($lastModifiedAuditId) && !(is_int($lastModifiedAuditId) || ctype_digit($lastModifiedAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastModifiedAuditId, true), gettype($lastModifiedAuditId)), __LINE__);
        }
        if (is_null($lastModifiedAuditId) || (is_array($lastModifiedAuditId) && empty($lastModifiedAuditId))) {
            unset($this->LastModifiedAuditId);
        } else {
            $this->LastModifiedAuditId = $lastModifiedAuditId;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \patest\StructType\MaintainableGlobalizedEntity
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\MaintainableGlobalizedEntity
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
