<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginClient-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoginClient-Response
 * @subpackage Structs
 */
class LoginClient_Response extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfCrm_ClientType
     */
    public $ClientTypes;
    /**
     * The IsAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAccount;
    /**
     * Constructor method for LoginClient-Response
     * @uses LoginClient_Response::setClientId()
     * @uses LoginClient_Response::setClientTypes()
     * @uses LoginClient_Response::setIsAccount()
     * @param string $clientId
     * @param \patest\ArrayType\ArrayOfCrm_ClientType $clientTypes
     * @param bool $isAccount
     */
    public function __construct($clientId = null, \patest\ArrayType\ArrayOfCrm_ClientType $clientTypes = null, $isAccount = null)
    {
        $this
            ->setClientId($clientId)
            ->setClientTypes($clientTypes)
            ->setIsAccount($isAccount);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\LoginClient_Response
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfCrm_ClientType|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfCrm_ClientType $clientTypes
     * @return \patest\StructType\LoginClient_Response
     */
    public function setClientTypes(\patest\ArrayType\ArrayOfCrm_ClientType $clientTypes = null)
    {
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get IsAccount value
     * @return bool|null
     */
    public function getIsAccount()
    {
        return $this->IsAccount;
    }
    /**
     * Set IsAccount value
     * @param bool $isAccount
     * @return \patest\StructType\LoginClient_Response
     */
    public function setIsAccount($isAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccount) && !is_bool($isAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAccount, true), gettype($isAccount)), __LINE__);
        }
        $this->IsAccount = $isAccount;
        return $this;
    }
}
