<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginClient-Request-V2 StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoginClient-Request-V2
 * @subpackage Structs
 */
class LoginClient_Request_V2 extends LoginClient_Request
{
    /**
     * The ClientKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ClientKind;
    /**
     * Constructor method for LoginClient-Request-V2
     * @uses LoginClient_Request_V2::setClientKind()
     * @param string[] $clientKind
     */
    public function __construct(array $clientKind = array())
    {
        $this
            ->setClientKind($clientKind);
    }
    /**
     * Get ClientKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getClientKind()
    {
        return isset($this->ClientKind) ? $this->ClientKind : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClientKind method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClientKind method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClientKindForArrayConstraintsFromSetClientKind(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $loginClient_Request_V2ClientKindItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($loginClient_Request_V2ClientKindItem)) {
                $invalidValues[] = is_object($loginClient_Request_V2ClientKindItem) ? get_class($loginClient_Request_V2ClientKindItem) : sprintf('%s(%s)', gettype($loginClient_Request_V2ClientKindItem), var_export($loginClient_Request_V2ClientKindItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ClientKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $clientKind
     * @return \patest\StructType\LoginClient_Request_V2
     */
    public function setClientKind(array $clientKind = array())
    {
        // validation for constraint: list
        if ('' !== ($clientKindArrayErrorMessage = self::validateClientKindForArrayConstraintsFromSetClientKind($clientKind))) {
            throw new \InvalidArgumentException($clientKindArrayErrorMessage, __LINE__);
        }
        if (is_null($clientKind) || (is_array($clientKind) && empty($clientKind))) {
            unset($this->ClientKind);
        } else {
            $this->ClientKind = is_array($clientKind) ? implode(' ', $clientKind) : null;
        }
        return $this;
    }
}
