<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LogBannerRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LogBannerRequest
 * @subpackage Structs
 */
class LogBannerRequest extends AbstractStructBase
{
    /**
     * The BannerText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BannerText;
    /**
     * The BannerWidth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BannerWidth;
    /**
     * Constructor method for LogBannerRequest
     * @uses LogBannerRequest::setBannerText()
     * @uses LogBannerRequest::setBannerWidth()
     * @param string $bannerText
     * @param int $bannerWidth
     */
    public function __construct($bannerText = null, $bannerWidth = null)
    {
        $this
            ->setBannerText($bannerText)
            ->setBannerWidth($bannerWidth);
    }
    /**
     * Get BannerText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBannerText()
    {
        return isset($this->BannerText) ? $this->BannerText : null;
    }
    /**
     * Set BannerText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bannerText
     * @return \patest\StructType\LogBannerRequest
     */
    public function setBannerText($bannerText = null)
    {
        // validation for constraint: string
        if (!is_null($bannerText) && !is_string($bannerText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bannerText, true), gettype($bannerText)), __LINE__);
        }
        if (is_null($bannerText) || (is_array($bannerText) && empty($bannerText))) {
            unset($this->BannerText);
        } else {
            $this->BannerText = $bannerText;
        }
        return $this;
    }
    /**
     * Get BannerWidth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBannerWidth()
    {
        return isset($this->BannerWidth) ? $this->BannerWidth : null;
    }
    /**
     * Set BannerWidth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bannerWidth
     * @return \patest\StructType\LogBannerRequest
     */
    public function setBannerWidth($bannerWidth = null)
    {
        // validation for constraint: int
        if (!is_null($bannerWidth) && !(is_int($bannerWidth) || ctype_digit($bannerWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bannerWidth, true), gettype($bannerWidth)), __LINE__);
        }
        if (is_null($bannerWidth) || (is_array($bannerWidth) && empty($bannerWidth))) {
            unset($this->BannerWidth);
        } else {
            $this->BannerWidth = $bannerWidth;
        }
        return $this;
    }
}
