<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocaleInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LocaleInfo
 * @subpackage Structs
 */
class LocaleInfo extends AbstractStructBase
{
    /**
     * The AbbreviatedDayNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $AbbreviatedDayNames;
    /**
     * The AbbreviatedMonthNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $AbbreviatedMonthNames;
    /**
     * The CurrencyDecimalDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CurrencyDecimalDigits;
    /**
     * The CurrencyDecimalSeparator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyDecimalSeparator;
    /**
     * The CurrencyNegativePattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyNegativePattern;
    /**
     * The CurrencyPositivePattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyPositivePattern;
    /**
     * The CurrencySymbol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencySymbol;
    /**
     * The DateSeperator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateSeperator;
    /**
     * The DayNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $DayNames;
    /**
     * The FirstDayOfWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FirstDayOfWeek;
    /**
     * The FullDateTimePattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullDateTimePattern;
    /**
     * The IsMetric
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsMetric;
    /**
     * The IsRightToLeft
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRightToLeft;
    /**
     * The LongDatePattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LongDatePattern;
    /**
     * The LongTimePattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LongTimePattern;
    /**
     * The MonthNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $MonthNames;
    /**
     * The NegativeSign
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NegativeSign;
    /**
     * The NumberDecimalDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberDecimalDigits;
    /**
     * The NumberDecimalSeparator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberDecimalSeparator;
    /**
     * The PercentSymbol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PercentSymbol;
    /**
     * The PositiveSign
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PositiveSign;
    /**
     * The ShortDatePattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShortDatePattern;
    /**
     * The ShortTimePattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShortTimePattern;
    /**
     * The TimeSeperator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeSeperator;
    /**
     * The NumberGroupingSeparator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberGroupingSeparator;
    /**
     * Constructor method for LocaleInfo
     * @uses LocaleInfo::setAbbreviatedDayNames()
     * @uses LocaleInfo::setAbbreviatedMonthNames()
     * @uses LocaleInfo::setCurrencyDecimalDigits()
     * @uses LocaleInfo::setCurrencyDecimalSeparator()
     * @uses LocaleInfo::setCurrencyNegativePattern()
     * @uses LocaleInfo::setCurrencyPositivePattern()
     * @uses LocaleInfo::setCurrencySymbol()
     * @uses LocaleInfo::setDateSeperator()
     * @uses LocaleInfo::setDayNames()
     * @uses LocaleInfo::setFirstDayOfWeek()
     * @uses LocaleInfo::setFullDateTimePattern()
     * @uses LocaleInfo::setIsMetric()
     * @uses LocaleInfo::setIsRightToLeft()
     * @uses LocaleInfo::setLongDatePattern()
     * @uses LocaleInfo::setLongTimePattern()
     * @uses LocaleInfo::setMonthNames()
     * @uses LocaleInfo::setNegativeSign()
     * @uses LocaleInfo::setNumberDecimalDigits()
     * @uses LocaleInfo::setNumberDecimalSeparator()
     * @uses LocaleInfo::setPercentSymbol()
     * @uses LocaleInfo::setPositiveSign()
     * @uses LocaleInfo::setShortDatePattern()
     * @uses LocaleInfo::setShortTimePattern()
     * @uses LocaleInfo::setTimeSeperator()
     * @uses LocaleInfo::setNumberGroupingSeparator()
     * @param \patest\ArrayType\ArrayOfstring $abbreviatedDayNames
     * @param \patest\ArrayType\ArrayOfstring $abbreviatedMonthNames
     * @param int $currencyDecimalDigits
     * @param string $currencyDecimalSeparator
     * @param string $currencyNegativePattern
     * @param string $currencyPositivePattern
     * @param string $currencySymbol
     * @param string $dateSeperator
     * @param \patest\ArrayType\ArrayOfstring $dayNames
     * @param int $firstDayOfWeek
     * @param string $fullDateTimePattern
     * @param bool $isMetric
     * @param bool $isRightToLeft
     * @param string $longDatePattern
     * @param string $longTimePattern
     * @param \patest\ArrayType\ArrayOfstring $monthNames
     * @param string $negativeSign
     * @param int $numberDecimalDigits
     * @param string $numberDecimalSeparator
     * @param string $percentSymbol
     * @param string $positiveSign
     * @param string $shortDatePattern
     * @param string $shortTimePattern
     * @param string $timeSeperator
     * @param string $numberGroupingSeparator
     */
    public function __construct(\patest\ArrayType\ArrayOfstring $abbreviatedDayNames = null, \patest\ArrayType\ArrayOfstring $abbreviatedMonthNames = null, $currencyDecimalDigits = null, $currencyDecimalSeparator = null, $currencyNegativePattern = null, $currencyPositivePattern = null, $currencySymbol = null, $dateSeperator = null, \patest\ArrayType\ArrayOfstring $dayNames = null, $firstDayOfWeek = null, $fullDateTimePattern = null, $isMetric = null, $isRightToLeft = null, $longDatePattern = null, $longTimePattern = null, \patest\ArrayType\ArrayOfstring $monthNames = null, $negativeSign = null, $numberDecimalDigits = null, $numberDecimalSeparator = null, $percentSymbol = null, $positiveSign = null, $shortDatePattern = null, $shortTimePattern = null, $timeSeperator = null, $numberGroupingSeparator = null)
    {
        $this
            ->setAbbreviatedDayNames($abbreviatedDayNames)
            ->setAbbreviatedMonthNames($abbreviatedMonthNames)
            ->setCurrencyDecimalDigits($currencyDecimalDigits)
            ->setCurrencyDecimalSeparator($currencyDecimalSeparator)
            ->setCurrencyNegativePattern($currencyNegativePattern)
            ->setCurrencyPositivePattern($currencyPositivePattern)
            ->setCurrencySymbol($currencySymbol)
            ->setDateSeperator($dateSeperator)
            ->setDayNames($dayNames)
            ->setFirstDayOfWeek($firstDayOfWeek)
            ->setFullDateTimePattern($fullDateTimePattern)
            ->setIsMetric($isMetric)
            ->setIsRightToLeft($isRightToLeft)
            ->setLongDatePattern($longDatePattern)
            ->setLongTimePattern($longTimePattern)
            ->setMonthNames($monthNames)
            ->setNegativeSign($negativeSign)
            ->setNumberDecimalDigits($numberDecimalDigits)
            ->setNumberDecimalSeparator($numberDecimalSeparator)
            ->setPercentSymbol($percentSymbol)
            ->setPositiveSign($positiveSign)
            ->setShortDatePattern($shortDatePattern)
            ->setShortTimePattern($shortTimePattern)
            ->setTimeSeperator($timeSeperator)
            ->setNumberGroupingSeparator($numberGroupingSeparator);
    }
    /**
     * Get AbbreviatedDayNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getAbbreviatedDayNames()
    {
        return isset($this->AbbreviatedDayNames) ? $this->AbbreviatedDayNames : null;
    }
    /**
     * Set AbbreviatedDayNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $abbreviatedDayNames
     * @return \patest\StructType\LocaleInfo
     */
    public function setAbbreviatedDayNames(\patest\ArrayType\ArrayOfstring $abbreviatedDayNames = null)
    {
        if (is_null($abbreviatedDayNames) || (is_array($abbreviatedDayNames) && empty($abbreviatedDayNames))) {
            unset($this->AbbreviatedDayNames);
        } else {
            $this->AbbreviatedDayNames = $abbreviatedDayNames;
        }
        return $this;
    }
    /**
     * Get AbbreviatedMonthNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getAbbreviatedMonthNames()
    {
        return isset($this->AbbreviatedMonthNames) ? $this->AbbreviatedMonthNames : null;
    }
    /**
     * Set AbbreviatedMonthNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $abbreviatedMonthNames
     * @return \patest\StructType\LocaleInfo
     */
    public function setAbbreviatedMonthNames(\patest\ArrayType\ArrayOfstring $abbreviatedMonthNames = null)
    {
        if (is_null($abbreviatedMonthNames) || (is_array($abbreviatedMonthNames) && empty($abbreviatedMonthNames))) {
            unset($this->AbbreviatedMonthNames);
        } else {
            $this->AbbreviatedMonthNames = $abbreviatedMonthNames;
        }
        return $this;
    }
    /**
     * Get CurrencyDecimalDigits value
     * @return int|null
     */
    public function getCurrencyDecimalDigits()
    {
        return $this->CurrencyDecimalDigits;
    }
    /**
     * Set CurrencyDecimalDigits value
     * @param int $currencyDecimalDigits
     * @return \patest\StructType\LocaleInfo
     */
    public function setCurrencyDecimalDigits($currencyDecimalDigits = null)
    {
        // validation for constraint: int
        if (!is_null($currencyDecimalDigits) && !(is_int($currencyDecimalDigits) || ctype_digit($currencyDecimalDigits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currencyDecimalDigits, true), gettype($currencyDecimalDigits)), __LINE__);
        }
        $this->CurrencyDecimalDigits = $currencyDecimalDigits;
        return $this;
    }
    /**
     * Get CurrencyDecimalSeparator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyDecimalSeparator()
    {
        return isset($this->CurrencyDecimalSeparator) ? $this->CurrencyDecimalSeparator : null;
    }
    /**
     * Set CurrencyDecimalSeparator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyDecimalSeparator
     * @return \patest\StructType\LocaleInfo
     */
    public function setCurrencyDecimalSeparator($currencyDecimalSeparator = null)
    {
        // validation for constraint: string
        if (!is_null($currencyDecimalSeparator) && !is_string($currencyDecimalSeparator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyDecimalSeparator, true), gettype($currencyDecimalSeparator)), __LINE__);
        }
        if (is_null($currencyDecimalSeparator) || (is_array($currencyDecimalSeparator) && empty($currencyDecimalSeparator))) {
            unset($this->CurrencyDecimalSeparator);
        } else {
            $this->CurrencyDecimalSeparator = $currencyDecimalSeparator;
        }
        return $this;
    }
    /**
     * Get CurrencyNegativePattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyNegativePattern()
    {
        return isset($this->CurrencyNegativePattern) ? $this->CurrencyNegativePattern : null;
    }
    /**
     * Set CurrencyNegativePattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyNegativePattern
     * @return \patest\StructType\LocaleInfo
     */
    public function setCurrencyNegativePattern($currencyNegativePattern = null)
    {
        // validation for constraint: string
        if (!is_null($currencyNegativePattern) && !is_string($currencyNegativePattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyNegativePattern, true), gettype($currencyNegativePattern)), __LINE__);
        }
        if (is_null($currencyNegativePattern) || (is_array($currencyNegativePattern) && empty($currencyNegativePattern))) {
            unset($this->CurrencyNegativePattern);
        } else {
            $this->CurrencyNegativePattern = $currencyNegativePattern;
        }
        return $this;
    }
    /**
     * Get CurrencyPositivePattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyPositivePattern()
    {
        return isset($this->CurrencyPositivePattern) ? $this->CurrencyPositivePattern : null;
    }
    /**
     * Set CurrencyPositivePattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyPositivePattern
     * @return \patest\StructType\LocaleInfo
     */
    public function setCurrencyPositivePattern($currencyPositivePattern = null)
    {
        // validation for constraint: string
        if (!is_null($currencyPositivePattern) && !is_string($currencyPositivePattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyPositivePattern, true), gettype($currencyPositivePattern)), __LINE__);
        }
        if (is_null($currencyPositivePattern) || (is_array($currencyPositivePattern) && empty($currencyPositivePattern))) {
            unset($this->CurrencyPositivePattern);
        } else {
            $this->CurrencyPositivePattern = $currencyPositivePattern;
        }
        return $this;
    }
    /**
     * Get CurrencySymbol value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencySymbol()
    {
        return isset($this->CurrencySymbol) ? $this->CurrencySymbol : null;
    }
    /**
     * Set CurrencySymbol value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencySymbol
     * @return \patest\StructType\LocaleInfo
     */
    public function setCurrencySymbol($currencySymbol = null)
    {
        // validation for constraint: string
        if (!is_null($currencySymbol) && !is_string($currencySymbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencySymbol, true), gettype($currencySymbol)), __LINE__);
        }
        if (is_null($currencySymbol) || (is_array($currencySymbol) && empty($currencySymbol))) {
            unset($this->CurrencySymbol);
        } else {
            $this->CurrencySymbol = $currencySymbol;
        }
        return $this;
    }
    /**
     * Get DateSeperator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateSeperator()
    {
        return isset($this->DateSeperator) ? $this->DateSeperator : null;
    }
    /**
     * Set DateSeperator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateSeperator
     * @return \patest\StructType\LocaleInfo
     */
    public function setDateSeperator($dateSeperator = null)
    {
        // validation for constraint: string
        if (!is_null($dateSeperator) && !is_string($dateSeperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateSeperator, true), gettype($dateSeperator)), __LINE__);
        }
        if (is_null($dateSeperator) || (is_array($dateSeperator) && empty($dateSeperator))) {
            unset($this->DateSeperator);
        } else {
            $this->DateSeperator = $dateSeperator;
        }
        return $this;
    }
    /**
     * Get DayNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getDayNames()
    {
        return isset($this->DayNames) ? $this->DayNames : null;
    }
    /**
     * Set DayNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $dayNames
     * @return \patest\StructType\LocaleInfo
     */
    public function setDayNames(\patest\ArrayType\ArrayOfstring $dayNames = null)
    {
        if (is_null($dayNames) || (is_array($dayNames) && empty($dayNames))) {
            unset($this->DayNames);
        } else {
            $this->DayNames = $dayNames;
        }
        return $this;
    }
    /**
     * Get FirstDayOfWeek value
     * @return int|null
     */
    public function getFirstDayOfWeek()
    {
        return $this->FirstDayOfWeek;
    }
    /**
     * Set FirstDayOfWeek value
     * @param int $firstDayOfWeek
     * @return \patest\StructType\LocaleInfo
     */
    public function setFirstDayOfWeek($firstDayOfWeek = null)
    {
        // validation for constraint: int
        if (!is_null($firstDayOfWeek) && !(is_int($firstDayOfWeek) || ctype_digit($firstDayOfWeek))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firstDayOfWeek, true), gettype($firstDayOfWeek)), __LINE__);
        }
        $this->FirstDayOfWeek = $firstDayOfWeek;
        return $this;
    }
    /**
     * Get FullDateTimePattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullDateTimePattern()
    {
        return isset($this->FullDateTimePattern) ? $this->FullDateTimePattern : null;
    }
    /**
     * Set FullDateTimePattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullDateTimePattern
     * @return \patest\StructType\LocaleInfo
     */
    public function setFullDateTimePattern($fullDateTimePattern = null)
    {
        // validation for constraint: string
        if (!is_null($fullDateTimePattern) && !is_string($fullDateTimePattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullDateTimePattern, true), gettype($fullDateTimePattern)), __LINE__);
        }
        if (is_null($fullDateTimePattern) || (is_array($fullDateTimePattern) && empty($fullDateTimePattern))) {
            unset($this->FullDateTimePattern);
        } else {
            $this->FullDateTimePattern = $fullDateTimePattern;
        }
        return $this;
    }
    /**
     * Get IsMetric value
     * @return bool|null
     */
    public function getIsMetric()
    {
        return $this->IsMetric;
    }
    /**
     * Set IsMetric value
     * @param bool $isMetric
     * @return \patest\StructType\LocaleInfo
     */
    public function setIsMetric($isMetric = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMetric) && !is_bool($isMetric)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMetric, true), gettype($isMetric)), __LINE__);
        }
        $this->IsMetric = $isMetric;
        return $this;
    }
    /**
     * Get IsRightToLeft value
     * @return bool|null
     */
    public function getIsRightToLeft()
    {
        return $this->IsRightToLeft;
    }
    /**
     * Set IsRightToLeft value
     * @param bool $isRightToLeft
     * @return \patest\StructType\LocaleInfo
     */
    public function setIsRightToLeft($isRightToLeft = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRightToLeft) && !is_bool($isRightToLeft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRightToLeft, true), gettype($isRightToLeft)), __LINE__);
        }
        $this->IsRightToLeft = $isRightToLeft;
        return $this;
    }
    /**
     * Get LongDatePattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLongDatePattern()
    {
        return isset($this->LongDatePattern) ? $this->LongDatePattern : null;
    }
    /**
     * Set LongDatePattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $longDatePattern
     * @return \patest\StructType\LocaleInfo
     */
    public function setLongDatePattern($longDatePattern = null)
    {
        // validation for constraint: string
        if (!is_null($longDatePattern) && !is_string($longDatePattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longDatePattern, true), gettype($longDatePattern)), __LINE__);
        }
        if (is_null($longDatePattern) || (is_array($longDatePattern) && empty($longDatePattern))) {
            unset($this->LongDatePattern);
        } else {
            $this->LongDatePattern = $longDatePattern;
        }
        return $this;
    }
    /**
     * Get LongTimePattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLongTimePattern()
    {
        return isset($this->LongTimePattern) ? $this->LongTimePattern : null;
    }
    /**
     * Set LongTimePattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $longTimePattern
     * @return \patest\StructType\LocaleInfo
     */
    public function setLongTimePattern($longTimePattern = null)
    {
        // validation for constraint: string
        if (!is_null($longTimePattern) && !is_string($longTimePattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longTimePattern, true), gettype($longTimePattern)), __LINE__);
        }
        if (is_null($longTimePattern) || (is_array($longTimePattern) && empty($longTimePattern))) {
            unset($this->LongTimePattern);
        } else {
            $this->LongTimePattern = $longTimePattern;
        }
        return $this;
    }
    /**
     * Get MonthNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getMonthNames()
    {
        return isset($this->MonthNames) ? $this->MonthNames : null;
    }
    /**
     * Set MonthNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $monthNames
     * @return \patest\StructType\LocaleInfo
     */
    public function setMonthNames(\patest\ArrayType\ArrayOfstring $monthNames = null)
    {
        if (is_null($monthNames) || (is_array($monthNames) && empty($monthNames))) {
            unset($this->MonthNames);
        } else {
            $this->MonthNames = $monthNames;
        }
        return $this;
    }
    /**
     * Get NegativeSign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNegativeSign()
    {
        return isset($this->NegativeSign) ? $this->NegativeSign : null;
    }
    /**
     * Set NegativeSign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $negativeSign
     * @return \patest\StructType\LocaleInfo
     */
    public function setNegativeSign($negativeSign = null)
    {
        // validation for constraint: string
        if (!is_null($negativeSign) && !is_string($negativeSign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($negativeSign, true), gettype($negativeSign)), __LINE__);
        }
        if (is_null($negativeSign) || (is_array($negativeSign) && empty($negativeSign))) {
            unset($this->NegativeSign);
        } else {
            $this->NegativeSign = $negativeSign;
        }
        return $this;
    }
    /**
     * Get NumberDecimalDigits value
     * @return int|null
     */
    public function getNumberDecimalDigits()
    {
        return $this->NumberDecimalDigits;
    }
    /**
     * Set NumberDecimalDigits value
     * @param int $numberDecimalDigits
     * @return \patest\StructType\LocaleInfo
     */
    public function setNumberDecimalDigits($numberDecimalDigits = null)
    {
        // validation for constraint: int
        if (!is_null($numberDecimalDigits) && !(is_int($numberDecimalDigits) || ctype_digit($numberDecimalDigits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberDecimalDigits, true), gettype($numberDecimalDigits)), __LINE__);
        }
        $this->NumberDecimalDigits = $numberDecimalDigits;
        return $this;
    }
    /**
     * Get NumberDecimalSeparator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberDecimalSeparator()
    {
        return isset($this->NumberDecimalSeparator) ? $this->NumberDecimalSeparator : null;
    }
    /**
     * Set NumberDecimalSeparator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberDecimalSeparator
     * @return \patest\StructType\LocaleInfo
     */
    public function setNumberDecimalSeparator($numberDecimalSeparator = null)
    {
        // validation for constraint: string
        if (!is_null($numberDecimalSeparator) && !is_string($numberDecimalSeparator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberDecimalSeparator, true), gettype($numberDecimalSeparator)), __LINE__);
        }
        if (is_null($numberDecimalSeparator) || (is_array($numberDecimalSeparator) && empty($numberDecimalSeparator))) {
            unset($this->NumberDecimalSeparator);
        } else {
            $this->NumberDecimalSeparator = $numberDecimalSeparator;
        }
        return $this;
    }
    /**
     * Get PercentSymbol value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPercentSymbol()
    {
        return isset($this->PercentSymbol) ? $this->PercentSymbol : null;
    }
    /**
     * Set PercentSymbol value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $percentSymbol
     * @return \patest\StructType\LocaleInfo
     */
    public function setPercentSymbol($percentSymbol = null)
    {
        // validation for constraint: string
        if (!is_null($percentSymbol) && !is_string($percentSymbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($percentSymbol, true), gettype($percentSymbol)), __LINE__);
        }
        if (is_null($percentSymbol) || (is_array($percentSymbol) && empty($percentSymbol))) {
            unset($this->PercentSymbol);
        } else {
            $this->PercentSymbol = $percentSymbol;
        }
        return $this;
    }
    /**
     * Get PositiveSign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPositiveSign()
    {
        return isset($this->PositiveSign) ? $this->PositiveSign : null;
    }
    /**
     * Set PositiveSign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $positiveSign
     * @return \patest\StructType\LocaleInfo
     */
    public function setPositiveSign($positiveSign = null)
    {
        // validation for constraint: string
        if (!is_null($positiveSign) && !is_string($positiveSign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($positiveSign, true), gettype($positiveSign)), __LINE__);
        }
        if (is_null($positiveSign) || (is_array($positiveSign) && empty($positiveSign))) {
            unset($this->PositiveSign);
        } else {
            $this->PositiveSign = $positiveSign;
        }
        return $this;
    }
    /**
     * Get ShortDatePattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShortDatePattern()
    {
        return isset($this->ShortDatePattern) ? $this->ShortDatePattern : null;
    }
    /**
     * Set ShortDatePattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shortDatePattern
     * @return \patest\StructType\LocaleInfo
     */
    public function setShortDatePattern($shortDatePattern = null)
    {
        // validation for constraint: string
        if (!is_null($shortDatePattern) && !is_string($shortDatePattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortDatePattern, true), gettype($shortDatePattern)), __LINE__);
        }
        if (is_null($shortDatePattern) || (is_array($shortDatePattern) && empty($shortDatePattern))) {
            unset($this->ShortDatePattern);
        } else {
            $this->ShortDatePattern = $shortDatePattern;
        }
        return $this;
    }
    /**
     * Get ShortTimePattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShortTimePattern()
    {
        return isset($this->ShortTimePattern) ? $this->ShortTimePattern : null;
    }
    /**
     * Set ShortTimePattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shortTimePattern
     * @return \patest\StructType\LocaleInfo
     */
    public function setShortTimePattern($shortTimePattern = null)
    {
        // validation for constraint: string
        if (!is_null($shortTimePattern) && !is_string($shortTimePattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortTimePattern, true), gettype($shortTimePattern)), __LINE__);
        }
        if (is_null($shortTimePattern) || (is_array($shortTimePattern) && empty($shortTimePattern))) {
            unset($this->ShortTimePattern);
        } else {
            $this->ShortTimePattern = $shortTimePattern;
        }
        return $this;
    }
    /**
     * Get TimeSeperator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeSeperator()
    {
        return isset($this->TimeSeperator) ? $this->TimeSeperator : null;
    }
    /**
     * Set TimeSeperator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeSeperator
     * @return \patest\StructType\LocaleInfo
     */
    public function setTimeSeperator($timeSeperator = null)
    {
        // validation for constraint: string
        if (!is_null($timeSeperator) && !is_string($timeSeperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeSeperator, true), gettype($timeSeperator)), __LINE__);
        }
        if (is_null($timeSeperator) || (is_array($timeSeperator) && empty($timeSeperator))) {
            unset($this->TimeSeperator);
        } else {
            $this->TimeSeperator = $timeSeperator;
        }
        return $this;
    }
    /**
     * Get NumberGroupingSeparator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberGroupingSeparator()
    {
        return isset($this->NumberGroupingSeparator) ? $this->NumberGroupingSeparator : null;
    }
    /**
     * Set NumberGroupingSeparator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberGroupingSeparator
     * @return \patest\StructType\LocaleInfo
     */
    public function setNumberGroupingSeparator($numberGroupingSeparator = null)
    {
        // validation for constraint: string
        if (!is_null($numberGroupingSeparator) && !is_string($numberGroupingSeparator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberGroupingSeparator, true), gettype($numberGroupingSeparator)), __LINE__);
        }
        if (is_null($numberGroupingSeparator) || (is_array($numberGroupingSeparator) && empty($numberGroupingSeparator))) {
            unset($this->NumberGroupingSeparator);
        } else {
            $this->NumberGroupingSeparator = $numberGroupingSeparator;
        }
        return $this;
    }
}
