<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinkingProductDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LinkingProductDetails
 * @subpackage Structs
 */
class LinkingProductDetails extends AbstractStructBase
{
    /**
     * The NumberOfOriginativeItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfOriginativeItems;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductName;
    /**
     * The ProductTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProductTypeId;
    /**
     * Constructor method for LinkingProductDetails
     * @uses LinkingProductDetails::setNumberOfOriginativeItems()
     * @uses LinkingProductDetails::setProductId()
     * @uses LinkingProductDetails::setProductName()
     * @uses LinkingProductDetails::setProductTypeId()
     * @param int $numberOfOriginativeItems
     * @param string $productId
     * @param string $productName
     * @param int $productTypeId
     */
    public function __construct($numberOfOriginativeItems = null, $productId = null, $productName = null, $productTypeId = null)
    {
        $this
            ->setNumberOfOriginativeItems($numberOfOriginativeItems)
            ->setProductId($productId)
            ->setProductName($productName)
            ->setProductTypeId($productTypeId);
    }
    /**
     * Get NumberOfOriginativeItems value
     * @return int|null
     */
    public function getNumberOfOriginativeItems()
    {
        return $this->NumberOfOriginativeItems;
    }
    /**
     * Set NumberOfOriginativeItems value
     * @param int $numberOfOriginativeItems
     * @return \patest\StructType\LinkingProductDetails
     */
    public function setNumberOfOriginativeItems($numberOfOriginativeItems = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfOriginativeItems) && !(is_int($numberOfOriginativeItems) || ctype_digit($numberOfOriginativeItems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfOriginativeItems, true), gettype($numberOfOriginativeItems)), __LINE__);
        }
        $this->NumberOfOriginativeItems = $numberOfOriginativeItems;
        return $this;
    }
    /**
     * Get ProductId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param string $productId
     * @return \patest\StructType\LinkingProductDetails
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get ProductName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductName()
    {
        return isset($this->ProductName) ? $this->ProductName : null;
    }
    /**
     * Set ProductName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productName
     * @return \patest\StructType\LinkingProductDetails
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        if (is_null($productName) || (is_array($productName) && empty($productName))) {
            unset($this->ProductName);
        } else {
            $this->ProductName = $productName;
        }
        return $this;
    }
    /**
     * Get ProductTypeId value
     * @return int|null
     */
    public function getProductTypeId()
    {
        return $this->ProductTypeId;
    }
    /**
     * Set ProductTypeId value
     * @param int $productTypeId
     * @return \patest\StructType\LinkingProductDetails
     */
    public function setProductTypeId($productTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($productTypeId) && !(is_int($productTypeId) || ctype_digit($productTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productTypeId, true), gettype($productTypeId)), __LINE__);
        }
        $this->ProductTypeId = $productTypeId;
        return $this;
    }
}
