<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LimitationCounterData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LimitationCounterData
 * @subpackage Structs
 */
class LimitationCounterData extends AbstractStructBase
{
    /**
     * The AppliesTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AppliesTo;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The Consumed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Consumed;
    /**
     * The Limit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Limit;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $PriceTypes;
    /**
     * Constructor method for LimitationCounterData
     * @uses LimitationCounterData::setAppliesTo()
     * @uses LimitationCounterData::setAreaId()
     * @uses LimitationCounterData::setConsumed()
     * @uses LimitationCounterData::setLimit()
     * @uses LimitationCounterData::setPriceLevelId()
     * @uses LimitationCounterData::setPriceTypes()
     * @param string $appliesTo
     * @param string $areaId
     * @param int $consumed
     * @param int $limit
     * @param string $priceLevelId
     * @param \patest\ArrayType\ArrayOfguid $priceTypes
     */
    public function __construct($appliesTo = null, $areaId = null, $consumed = null, $limit = null, $priceLevelId = null, \patest\ArrayType\ArrayOfguid $priceTypes = null)
    {
        $this
            ->setAppliesTo($appliesTo)
            ->setAreaId($areaId)
            ->setConsumed($consumed)
            ->setLimit($limit)
            ->setPriceLevelId($priceLevelId)
            ->setPriceTypes($priceTypes);
    }
    /**
     * Get AppliesTo value
     * @return string|null
     */
    public function getAppliesTo()
    {
        return $this->AppliesTo;
    }
    /**
     * Set AppliesTo value
     * @uses \patest\EnumType\LimitationAppliesToType::valueIsValid()
     * @uses \patest\EnumType\LimitationAppliesToType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appliesTo
     * @return \patest\StructType\LimitationCounterData
     */
    public function setAppliesTo($appliesTo = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LimitationAppliesToType::valueIsValid($appliesTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LimitationAppliesToType', is_array($appliesTo) ? implode(', ', $appliesTo) : var_export($appliesTo, true), implode(', ', \patest\EnumType\LimitationAppliesToType::getValidValues())), __LINE__);
        }
        $this->AppliesTo = $appliesTo;
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\LimitationCounterData
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get Consumed value
     * @return int|null
     */
    public function getConsumed()
    {
        return $this->Consumed;
    }
    /**
     * Set Consumed value
     * @param int $consumed
     * @return \patest\StructType\LimitationCounterData
     */
    public function setConsumed($consumed = null)
    {
        // validation for constraint: int
        if (!is_null($consumed) && !(is_int($consumed) || ctype_digit($consumed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consumed, true), gettype($consumed)), __LINE__);
        }
        $this->Consumed = $consumed;
        return $this;
    }
    /**
     * Get Limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param int $limit
     * @return \patest\StructType\LimitationCounterData
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !(is_int($limit) || ctype_digit($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\LimitationCounterData
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getPriceTypes()
    {
        return isset($this->PriceTypes) ? $this->PriceTypes : null;
    }
    /**
     * Set PriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $priceTypes
     * @return \patest\StructType\LimitationCounterData
     */
    public function setPriceTypes(\patest\ArrayType\ArrayOfguid $priceTypes = null)
    {
        if (is_null($priceTypes) || (is_array($priceTypes) && empty($priceTypes))) {
            unset($this->PriceTypes);
        } else {
            $this->PriceTypes = $priceTypes;
        }
        return $this;
    }
}
