<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiateSearchPaymentServerSession-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InitiateSearchPaymentServerSession-Response
 * @subpackage Structs
 */
class InitiateSearchPaymentServerSession_Response extends ExtensibleDataContract
{
    /**
     * The PaymentServerSessionCookie
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentServerSessionCookie;
    /**
     * The RegisterNewPaymentUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegisterNewPaymentUrl;
    /**
     * Constructor method for InitiateSearchPaymentServerSession-Response
     * @uses InitiateSearchPaymentServerSession_Response::setPaymentServerSessionCookie()
     * @uses InitiateSearchPaymentServerSession_Response::setRegisterNewPaymentUrl()
     * @param string $paymentServerSessionCookie
     * @param string $registerNewPaymentUrl
     */
    public function __construct($paymentServerSessionCookie = null, $registerNewPaymentUrl = null)
    {
        $this
            ->setPaymentServerSessionCookie($paymentServerSessionCookie)
            ->setRegisterNewPaymentUrl($registerNewPaymentUrl);
    }
    /**
     * Get PaymentServerSessionCookie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentServerSessionCookie()
    {
        return isset($this->PaymentServerSessionCookie) ? $this->PaymentServerSessionCookie : null;
    }
    /**
     * Set PaymentServerSessionCookie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentServerSessionCookie
     * @return \patest\StructType\InitiateSearchPaymentServerSession_Response
     */
    public function setPaymentServerSessionCookie($paymentServerSessionCookie = null)
    {
        // validation for constraint: string
        if (!is_null($paymentServerSessionCookie) && !is_string($paymentServerSessionCookie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentServerSessionCookie, true), gettype($paymentServerSessionCookie)), __LINE__);
        }
        if (is_null($paymentServerSessionCookie) || (is_array($paymentServerSessionCookie) && empty($paymentServerSessionCookie))) {
            unset($this->PaymentServerSessionCookie);
        } else {
            $this->PaymentServerSessionCookie = $paymentServerSessionCookie;
        }
        return $this;
    }
    /**
     * Get RegisterNewPaymentUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegisterNewPaymentUrl()
    {
        return isset($this->RegisterNewPaymentUrl) ? $this->RegisterNewPaymentUrl : null;
    }
    /**
     * Set RegisterNewPaymentUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $registerNewPaymentUrl
     * @return \patest\StructType\InitiateSearchPaymentServerSession_Response
     */
    public function setRegisterNewPaymentUrl($registerNewPaymentUrl = null)
    {
        // validation for constraint: string
        if (!is_null($registerNewPaymentUrl) && !is_string($registerNewPaymentUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registerNewPaymentUrl, true), gettype($registerNewPaymentUrl)), __LINE__);
        }
        if (is_null($registerNewPaymentUrl) || (is_array($registerNewPaymentUrl) && empty($registerNewPaymentUrl))) {
            unset($this->RegisterNewPaymentUrl);
        } else {
            $this->RegisterNewPaymentUrl = $registerNewPaymentUrl;
        }
        return $this;
    }
}
