<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiateSearchPaymentServerSession-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InitiateSearchPaymentServerSession-Request
 * @subpackage Structs
 */
class InitiateSearchPaymentServerSession_Request extends ExtensibleDataContract
{
    /**
     * The ClientParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $ClientParameters;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * Constructor method for InitiateSearchPaymentServerSession-Request
     * @uses InitiateSearchPaymentServerSession_Request::setClientParameters()
     * @uses InitiateSearchPaymentServerSession_Request::setPaymentMethodId()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $clientParameters
     * @param string $paymentMethodId
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfstringstring $clientParameters = null, $paymentMethodId = null)
    {
        $this
            ->setClientParameters($clientParameters)
            ->setPaymentMethodId($paymentMethodId);
    }
    /**
     * Get ClientParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getClientParameters()
    {
        return isset($this->ClientParameters) ? $this->ClientParameters : null;
    }
    /**
     * Set ClientParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $clientParameters
     * @return \patest\StructType\InitiateSearchPaymentServerSession_Request
     */
    public function setClientParameters(\patest\ArrayType\ArrayOfKeyValueOfstringstring $clientParameters = null)
    {
        if (is_null($clientParameters) || (is_array($clientParameters) && empty($clientParameters))) {
            unset($this->ClientParameters);
        } else {
            $this->ClientParameters = $clientParameters;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->PaymentMethodId;
    }
    /**
     * Set PaymentMethodId value
     * @param string $paymentMethodId
     * @return \patest\StructType\InitiateSearchPaymentServerSession_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        $this->PaymentMethodId = $paymentMethodId;
        return $this;
    }
}
