<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiatePaymentSessionRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InitiatePaymentSessionRequest
 * @subpackage Structs
 */
class InitiatePaymentSessionRequest extends ExtensibleDataContract
{
    /**
     * The IsMarkPaymentSessionInProcess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsMarkPaymentSessionInProcess;
    /**
     * The PaymentItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentItemId;
    /**
     * The PaymentSessionExecutionStep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentSessionExecutionStep;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for InitiatePaymentSessionRequest
     * @uses InitiatePaymentSessionRequest::setIsMarkPaymentSessionInProcess()
     * @uses InitiatePaymentSessionRequest::setPaymentItemId()
     * @uses InitiatePaymentSessionRequest::setPaymentSessionExecutionStep()
     * @uses InitiatePaymentSessionRequest::setTransactionGuid()
     * @uses InitiatePaymentSessionRequest::setTransactionSnapshotType()
     * @param bool $isMarkPaymentSessionInProcess
     * @param int $paymentItemId
     * @param string $paymentSessionExecutionStep
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     */
    public function __construct($isMarkPaymentSessionInProcess = null, $paymentItemId = null, $paymentSessionExecutionStep = null, $transactionGuid = null, $transactionSnapshotType = null)
    {
        $this
            ->setIsMarkPaymentSessionInProcess($isMarkPaymentSessionInProcess)
            ->setPaymentItemId($paymentItemId)
            ->setPaymentSessionExecutionStep($paymentSessionExecutionStep)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get IsMarkPaymentSessionInProcess value
     * @return bool|null
     */
    public function getIsMarkPaymentSessionInProcess()
    {
        return $this->IsMarkPaymentSessionInProcess;
    }
    /**
     * Set IsMarkPaymentSessionInProcess value
     * @param bool $isMarkPaymentSessionInProcess
     * @return \patest\StructType\InitiatePaymentSessionRequest
     */
    public function setIsMarkPaymentSessionInProcess($isMarkPaymentSessionInProcess = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMarkPaymentSessionInProcess) && !is_bool($isMarkPaymentSessionInProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMarkPaymentSessionInProcess, true), gettype($isMarkPaymentSessionInProcess)), __LINE__);
        }
        $this->IsMarkPaymentSessionInProcess = $isMarkPaymentSessionInProcess;
        return $this;
    }
    /**
     * Get PaymentItemId value
     * @return int|null
     */
    public function getPaymentItemId()
    {
        return $this->PaymentItemId;
    }
    /**
     * Set PaymentItemId value
     * @param int $paymentItemId
     * @return \patest\StructType\InitiatePaymentSessionRequest
     */
    public function setPaymentItemId($paymentItemId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentItemId) && !(is_int($paymentItemId) || ctype_digit($paymentItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentItemId, true), gettype($paymentItemId)), __LINE__);
        }
        $this->PaymentItemId = $paymentItemId;
        return $this;
    }
    /**
     * Get PaymentSessionExecutionStep value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentSessionExecutionStep()
    {
        return isset($this->PaymentSessionExecutionStep) ? $this->PaymentSessionExecutionStep : null;
    }
    /**
     * Set PaymentSessionExecutionStep value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentSessionExecutionStep
     * @return \patest\StructType\InitiatePaymentSessionRequest
     */
    public function setPaymentSessionExecutionStep($paymentSessionExecutionStep = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSessionExecutionStep) && !is_string($paymentSessionExecutionStep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentSessionExecutionStep, true), gettype($paymentSessionExecutionStep)), __LINE__);
        }
        if (is_null($paymentSessionExecutionStep) || (is_array($paymentSessionExecutionStep) && empty($paymentSessionExecutionStep))) {
            unset($this->PaymentSessionExecutionStep);
        } else {
            $this->PaymentSessionExecutionStep = $paymentSessionExecutionStep;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\InitiatePaymentSessionRequest
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\InitiatePaymentSessionRequest
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
