<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Infra.InstallationLog StructType
 * @subpackage Structs
 */
class Infra_InstallationLog extends AnyEntity
{
    /**
     * The Buid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Buid;
    /**
     * The InstallationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallationDate;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalId;
    /**
     * The MajorVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MajorVersion;
    /**
     * The MinorVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MinorVersion;
    /**
     * The Patch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Patch;
    /**
     * The SourceDB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceDB;
    /**
     * Constructor method for Infra.InstallationLog
     * @uses Infra_InstallationLog::setBuid()
     * @uses Infra_InstallationLog::setInstallationDate()
     * @uses Infra_InstallationLog::setLocalId()
     * @uses Infra_InstallationLog::setMajorVersion()
     * @uses Infra_InstallationLog::setMinorVersion()
     * @uses Infra_InstallationLog::setPatch()
     * @uses Infra_InstallationLog::setSourceDB()
     * @param string $buid
     * @param string $installationDate
     * @param int $localId
     * @param int $majorVersion
     * @param string $minorVersion
     * @param int $patch
     * @param string $sourceDB
     */
    public function __construct($buid = null, $installationDate = null, $localId = null, $majorVersion = null, $minorVersion = null, $patch = null, $sourceDB = null)
    {
        $this
            ->setBuid($buid)
            ->setInstallationDate($installationDate)
            ->setLocalId($localId)
            ->setMajorVersion($majorVersion)
            ->setMinorVersion($minorVersion)
            ->setPatch($patch)
            ->setSourceDB($sourceDB);
    }
    /**
     * Get Buid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuid()
    {
        return isset($this->Buid) ? $this->Buid : null;
    }
    /**
     * Set Buid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buid
     * @return \patest\StructType\Infra_InstallationLog
     */
    public function setBuid($buid = null)
    {
        // validation for constraint: string
        if (!is_null($buid) && !is_string($buid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buid, true), gettype($buid)), __LINE__);
        }
        if (is_null($buid) || (is_array($buid) && empty($buid))) {
            unset($this->Buid);
        } else {
            $this->Buid = $buid;
        }
        return $this;
    }
    /**
     * Get InstallationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallationDate()
    {
        return isset($this->InstallationDate) ? $this->InstallationDate : null;
    }
    /**
     * Set InstallationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installationDate
     * @return \patest\StructType\Infra_InstallationLog
     */
    public function setInstallationDate($installationDate = null)
    {
        // validation for constraint: string
        if (!is_null($installationDate) && !is_string($installationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installationDate, true), gettype($installationDate)), __LINE__);
        }
        if (is_null($installationDate) || (is_array($installationDate) && empty($installationDate))) {
            unset($this->InstallationDate);
        } else {
            $this->InstallationDate = $installationDate;
        }
        return $this;
    }
    /**
     * Get LocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalId()
    {
        return isset($this->LocalId) ? $this->LocalId : null;
    }
    /**
     * Set LocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localId
     * @return \patest\StructType\Infra_InstallationLog
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        if (is_null($localId) || (is_array($localId) && empty($localId))) {
            unset($this->LocalId);
        } else {
            $this->LocalId = $localId;
        }
        return $this;
    }
    /**
     * Get MajorVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMajorVersion()
    {
        return isset($this->MajorVersion) ? $this->MajorVersion : null;
    }
    /**
     * Set MajorVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $majorVersion
     * @return \patest\StructType\Infra_InstallationLog
     */
    public function setMajorVersion($majorVersion = null)
    {
        // validation for constraint: int
        if (!is_null($majorVersion) && !(is_int($majorVersion) || ctype_digit($majorVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($majorVersion, true), gettype($majorVersion)), __LINE__);
        }
        if (is_null($majorVersion) || (is_array($majorVersion) && empty($majorVersion))) {
            unset($this->MajorVersion);
        } else {
            $this->MajorVersion = $majorVersion;
        }
        return $this;
    }
    /**
     * Get MinorVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMinorVersion()
    {
        return isset($this->MinorVersion) ? $this->MinorVersion : null;
    }
    /**
     * Set MinorVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $minorVersion
     * @return \patest\StructType\Infra_InstallationLog
     */
    public function setMinorVersion($minorVersion = null)
    {
        // validation for constraint: string
        if (!is_null($minorVersion) && !is_string($minorVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minorVersion, true), gettype($minorVersion)), __LINE__);
        }
        if (is_null($minorVersion) || (is_array($minorVersion) && empty($minorVersion))) {
            unset($this->MinorVersion);
        } else {
            $this->MinorVersion = $minorVersion;
        }
        return $this;
    }
    /**
     * Get Patch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPatch()
    {
        return isset($this->Patch) ? $this->Patch : null;
    }
    /**
     * Set Patch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $patch
     * @return \patest\StructType\Infra_InstallationLog
     */
    public function setPatch($patch = null)
    {
        // validation for constraint: int
        if (!is_null($patch) && !(is_int($patch) || ctype_digit($patch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($patch, true), gettype($patch)), __LINE__);
        }
        if (is_null($patch) || (is_array($patch) && empty($patch))) {
            unset($this->Patch);
        } else {
            $this->Patch = $patch;
        }
        return $this;
    }
    /**
     * Get SourceDB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceDB()
    {
        return isset($this->SourceDB) ? $this->SourceDB : null;
    }
    /**
     * Set SourceDB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceDB
     * @return \patest\StructType\Infra_InstallationLog
     */
    public function setSourceDB($sourceDB = null)
    {
        // validation for constraint: string
        if (!is_null($sourceDB) && !is_string($sourceDB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceDB, true), gettype($sourceDB)), __LINE__);
        }
        if (is_null($sourceDB) || (is_array($sourceDB) && empty($sourceDB))) {
            unset($this->SourceDB);
        } else {
            $this->SourceDB = $sourceDB;
        }
        return $this;
    }
}
