<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Infra.ForeignDataInfo StructType
 * @subpackage Structs
 */
class Infra_ForeignDataInfo extends PersistableEntity
{
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EntityId;
    /**
     * The EntityIssuerCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EntityIssuerCompanyId;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The ForeignRowVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForeignRowVersion;
    /**
     * Constructor method for Infra.ForeignDataInfo
     * @uses Infra_ForeignDataInfo::setEntityId()
     * @uses Infra_ForeignDataInfo::setEntityIssuerCompanyId()
     * @uses Infra_ForeignDataInfo::setEntityName()
     * @uses Infra_ForeignDataInfo::setForeignRowVersion()
     * @param string $entityId
     * @param int $entityIssuerCompanyId
     * @param string $entityName
     * @param string $foreignRowVersion
     */
    public function __construct($entityId = null, $entityIssuerCompanyId = null, $entityName = null, $foreignRowVersion = null)
    {
        $this
            ->setEntityId($entityId)
            ->setEntityIssuerCompanyId($entityIssuerCompanyId)
            ->setEntityName($entityName)
            ->setForeignRowVersion($foreignRowVersion);
    }
    /**
     * Get EntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityId()
    {
        return isset($this->EntityId) ? $this->EntityId : null;
    }
    /**
     * Set EntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityId
     * @return \patest\StructType\Infra_ForeignDataInfo
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($entityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($entityId, true)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->EntityId);
        } else {
            $this->EntityId = $entityId;
        }
        return $this;
    }
    /**
     * Get EntityIssuerCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEntityIssuerCompanyId()
    {
        return isset($this->EntityIssuerCompanyId) ? $this->EntityIssuerCompanyId : null;
    }
    /**
     * Set EntityIssuerCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $entityIssuerCompanyId
     * @return \patest\StructType\Infra_ForeignDataInfo
     */
    public function setEntityIssuerCompanyId($entityIssuerCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($entityIssuerCompanyId) && !(is_int($entityIssuerCompanyId) || ctype_digit($entityIssuerCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityIssuerCompanyId, true), gettype($entityIssuerCompanyId)), __LINE__);
        }
        if (is_null($entityIssuerCompanyId) || (is_array($entityIssuerCompanyId) && empty($entityIssuerCompanyId))) {
            unset($this->EntityIssuerCompanyId);
        } else {
            $this->EntityIssuerCompanyId = $entityIssuerCompanyId;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\Infra_ForeignDataInfo
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get ForeignRowVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForeignRowVersion()
    {
        return isset($this->ForeignRowVersion) ? $this->ForeignRowVersion : null;
    }
    /**
     * Set ForeignRowVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $foreignRowVersion
     * @return \patest\StructType\Infra_ForeignDataInfo
     */
    public function setForeignRowVersion($foreignRowVersion = null)
    {
        // validation for constraint: string
        if (!is_null($foreignRowVersion) && !is_string($foreignRowVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foreignRowVersion, true), gettype($foreignRowVersion)), __LINE__);
        }
        if (is_null($foreignRowVersion) || (is_array($foreignRowVersion) && empty($foreignRowVersion))) {
            unset($this->ForeignRowVersion);
        } else {
            $this->ForeignRowVersion = $foreignRowVersion;
        }
        return $this;
    }
}
