<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageMedia StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ImageMedia
 * @subpackage Structs
 */
class ImageMedia extends AbstractStructBase
{
    /**
     * The EffectiveImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveImageUrl;
    /**
     * The ImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ImageId;
    /**
     * The ImagePurpose
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImagePurpose;
    /**
     * The MediaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MediaId;
    /**
     * Constructor method for ImageMedia
     * @uses ImageMedia::setEffectiveImageUrl()
     * @uses ImageMedia::setImageId()
     * @uses ImageMedia::setImagePurpose()
     * @uses ImageMedia::setMediaId()
     * @param string $effectiveImageUrl
     * @param int $imageId
     * @param string $imagePurpose
     * @param string $mediaId
     */
    public function __construct($effectiveImageUrl = null, $imageId = null, $imagePurpose = null, $mediaId = null)
    {
        $this
            ->setEffectiveImageUrl($effectiveImageUrl)
            ->setImageId($imageId)
            ->setImagePurpose($imagePurpose)
            ->setMediaId($mediaId);
    }
    /**
     * Get EffectiveImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveImageUrl()
    {
        return isset($this->EffectiveImageUrl) ? $this->EffectiveImageUrl : null;
    }
    /**
     * Set EffectiveImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveImageUrl
     * @return \patest\StructType\ImageMedia
     */
    public function setEffectiveImageUrl($effectiveImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveImageUrl) && !is_string($effectiveImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveImageUrl, true), gettype($effectiveImageUrl)), __LINE__);
        }
        if (is_null($effectiveImageUrl) || (is_array($effectiveImageUrl) && empty($effectiveImageUrl))) {
            unset($this->EffectiveImageUrl);
        } else {
            $this->EffectiveImageUrl = $effectiveImageUrl;
        }
        return $this;
    }
    /**
     * Get ImageId value
     * @return int|null
     */
    public function getImageId()
    {
        return $this->ImageId;
    }
    /**
     * Set ImageId value
     * @param int $imageId
     * @return \patest\StructType\ImageMedia
     */
    public function setImageId($imageId = null)
    {
        // validation for constraint: int
        if (!is_null($imageId) && !(is_int($imageId) || ctype_digit($imageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($imageId, true), gettype($imageId)), __LINE__);
        }
        $this->ImageId = $imageId;
        return $this;
    }
    /**
     * Get ImagePurpose value
     * @return string|null
     */
    public function getImagePurpose()
    {
        return $this->ImagePurpose;
    }
    /**
     * Set ImagePurpose value
     * @uses \patest\EnumType\ImagePurpose::valueIsValid()
     * @uses \patest\EnumType\ImagePurpose::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $imagePurpose
     * @return \patest\StructType\ImageMedia
     */
    public function setImagePurpose($imagePurpose = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ImagePurpose::valueIsValid($imagePurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ImagePurpose', is_array($imagePurpose) ? implode(', ', $imagePurpose) : var_export($imagePurpose, true), implode(', ', \patest\EnumType\ImagePurpose::getValidValues())), __LINE__);
        }
        $this->ImagePurpose = $imagePurpose;
        return $this;
    }
    /**
     * Get MediaId value
     * @return string|null
     */
    public function getMediaId()
    {
        return $this->MediaId;
    }
    /**
     * Set MediaId value
     * @param string $mediaId
     * @return \patest\StructType\ImageMedia
     */
    public function setMediaId($mediaId = null)
    {
        // validation for constraint: string
        if (!is_null($mediaId) && !is_string($mediaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mediaId, true), gettype($mediaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mediaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mediaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mediaId, true)), __LINE__);
        }
        $this->MediaId = $mediaId;
        return $this;
    }
}
