<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.ServiceRequestMyLink StructType
 * @subpackage Structs
 */
class HelpDesk_ServiceRequestMyLink extends HelpDesk_ServiceRequestLink
{
    /**
     * The CanBeAccessedByCurrentUser
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanBeAccessedByCurrentUser;
    /**
     * The CounterPartId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CounterPartId;
    /**
     * The CounterPartLocalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CounterPartLocalId;
    /**
     * Constructor method for HelpDesk.ServiceRequestMyLink
     * @uses HelpDesk_ServiceRequestMyLink::setCanBeAccessedByCurrentUser()
     * @uses HelpDesk_ServiceRequestMyLink::setCounterPartId()
     * @uses HelpDesk_ServiceRequestMyLink::setCounterPartLocalId()
     * @param bool $canBeAccessedByCurrentUser
     * @param string $counterPartId
     * @param int $counterPartLocalId
     */
    public function __construct($canBeAccessedByCurrentUser = null, $counterPartId = null, $counterPartLocalId = null)
    {
        $this
            ->setCanBeAccessedByCurrentUser($canBeAccessedByCurrentUser)
            ->setCounterPartId($counterPartId)
            ->setCounterPartLocalId($counterPartLocalId);
    }
    /**
     * Get CanBeAccessedByCurrentUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanBeAccessedByCurrentUser()
    {
        return isset($this->CanBeAccessedByCurrentUser) ? $this->CanBeAccessedByCurrentUser : null;
    }
    /**
     * Set CanBeAccessedByCurrentUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canBeAccessedByCurrentUser
     * @return \patest\StructType\HelpDesk_ServiceRequestMyLink
     */
    public function setCanBeAccessedByCurrentUser($canBeAccessedByCurrentUser = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBeAccessedByCurrentUser) && !is_bool($canBeAccessedByCurrentUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canBeAccessedByCurrentUser, true), gettype($canBeAccessedByCurrentUser)), __LINE__);
        }
        if (is_null($canBeAccessedByCurrentUser) || (is_array($canBeAccessedByCurrentUser) && empty($canBeAccessedByCurrentUser))) {
            unset($this->CanBeAccessedByCurrentUser);
        } else {
            $this->CanBeAccessedByCurrentUser = $canBeAccessedByCurrentUser;
        }
        return $this;
    }
    /**
     * Get CounterPartId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCounterPartId()
    {
        return isset($this->CounterPartId) ? $this->CounterPartId : null;
    }
    /**
     * Set CounterPartId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $counterPartId
     * @return \patest\StructType\HelpDesk_ServiceRequestMyLink
     */
    public function setCounterPartId($counterPartId = null)
    {
        // validation for constraint: string
        if (!is_null($counterPartId) && !is_string($counterPartId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($counterPartId, true), gettype($counterPartId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($counterPartId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $counterPartId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($counterPartId, true)), __LINE__);
        }
        if (is_null($counterPartId) || (is_array($counterPartId) && empty($counterPartId))) {
            unset($this->CounterPartId);
        } else {
            $this->CounterPartId = $counterPartId;
        }
        return $this;
    }
    /**
     * Get CounterPartLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCounterPartLocalId()
    {
        return isset($this->CounterPartLocalId) ? $this->CounterPartLocalId : null;
    }
    /**
     * Set CounterPartLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $counterPartLocalId
     * @return \patest\StructType\HelpDesk_ServiceRequestMyLink
     */
    public function setCounterPartLocalId($counterPartLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($counterPartLocalId) && !(is_int($counterPartLocalId) || ctype_digit($counterPartLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($counterPartLocalId, true), gettype($counterPartLocalId)), __LINE__);
        }
        if (is_null($counterPartLocalId) || (is_array($counterPartLocalId) && empty($counterPartLocalId))) {
            unset($this->CounterPartLocalId);
        } else {
            $this->CounterPartLocalId = $counterPartLocalId;
        }
        return $this;
    }
}
