<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.ServiceRequestLink StructType
 * @subpackage Structs
 */
class HelpDesk_ServiceRequestLink extends PersistableEntity
{
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comment;
    /**
     * The Left
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Left;
    /**
     * The LeftLocalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LeftLocalId;
    /**
     * The Right
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Right;
    /**
     * The RightLocalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RightLocalId;
    /**
     * Constructor method for HelpDesk.ServiceRequestLink
     * @uses HelpDesk_ServiceRequestLink::setComment()
     * @uses HelpDesk_ServiceRequestLink::setLeft()
     * @uses HelpDesk_ServiceRequestLink::setLeftLocalId()
     * @uses HelpDesk_ServiceRequestLink::setRight()
     * @uses HelpDesk_ServiceRequestLink::setRightLocalId()
     * @param string $comment
     * @param string $left
     * @param int $leftLocalId
     * @param string $right
     * @param int $rightLocalId
     */
    public function __construct($comment = null, $left = null, $leftLocalId = null, $right = null, $rightLocalId = null)
    {
        $this
            ->setComment($comment)
            ->setLeft($left)
            ->setLeftLocalId($leftLocalId)
            ->setRight($right)
            ->setRightLocalId($rightLocalId);
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comment
     * @return \patest\StructType\HelpDesk_ServiceRequestLink
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get Left value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeft()
    {
        return isset($this->Left) ? $this->Left : null;
    }
    /**
     * Set Left value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $left
     * @return \patest\StructType\HelpDesk_ServiceRequestLink
     */
    public function setLeft($left = null)
    {
        // validation for constraint: string
        if (!is_null($left) && !is_string($left)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($left, true), gettype($left)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($left) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $left)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($left, true)), __LINE__);
        }
        if (is_null($left) || (is_array($left) && empty($left))) {
            unset($this->Left);
        } else {
            $this->Left = $left;
        }
        return $this;
    }
    /**
     * Get LeftLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLeftLocalId()
    {
        return isset($this->LeftLocalId) ? $this->LeftLocalId : null;
    }
    /**
     * Set LeftLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $leftLocalId
     * @return \patest\StructType\HelpDesk_ServiceRequestLink
     */
    public function setLeftLocalId($leftLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($leftLocalId) && !(is_int($leftLocalId) || ctype_digit($leftLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leftLocalId, true), gettype($leftLocalId)), __LINE__);
        }
        if (is_null($leftLocalId) || (is_array($leftLocalId) && empty($leftLocalId))) {
            unset($this->LeftLocalId);
        } else {
            $this->LeftLocalId = $leftLocalId;
        }
        return $this;
    }
    /**
     * Get Right value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRight()
    {
        return isset($this->Right) ? $this->Right : null;
    }
    /**
     * Set Right value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $right
     * @return \patest\StructType\HelpDesk_ServiceRequestLink
     */
    public function setRight($right = null)
    {
        // validation for constraint: string
        if (!is_null($right) && !is_string($right)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($right, true), gettype($right)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($right) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $right)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($right, true)), __LINE__);
        }
        if (is_null($right) || (is_array($right) && empty($right))) {
            unset($this->Right);
        } else {
            $this->Right = $right;
        }
        return $this;
    }
    /**
     * Get RightLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRightLocalId()
    {
        return isset($this->RightLocalId) ? $this->RightLocalId : null;
    }
    /**
     * Set RightLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rightLocalId
     * @return \patest\StructType\HelpDesk_ServiceRequestLink
     */
    public function setRightLocalId($rightLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($rightLocalId) && !(is_int($rightLocalId) || ctype_digit($rightLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rightLocalId, true), gettype($rightLocalId)), __LINE__);
        }
        if (is_null($rightLocalId) || (is_array($rightLocalId) && empty($rightLocalId))) {
            unset($this->RightLocalId);
        } else {
            $this->RightLocalId = $rightLocalId;
        }
        return $this;
    }
}
