<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.ServiceRequestForLauncher StructType
 * @subpackage Structs
 */
class HelpDesk_ServiceRequestForLauncher extends AnyEntity
{
    /**
     * The CrmMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CrmMode;
    /**
     * The RequestType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestType;
    /**
     * The TypeEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeEntityName;
    /**
     * The UIScreen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UIScreen;
    /**
     * Constructor method for HelpDesk.ServiceRequestForLauncher
     * @uses HelpDesk_ServiceRequestForLauncher::setCrmMode()
     * @uses HelpDesk_ServiceRequestForLauncher::setRequestType()
     * @uses HelpDesk_ServiceRequestForLauncher::setTypeEntityName()
     * @uses HelpDesk_ServiceRequestForLauncher::setUIScreen()
     * @param bool $crmMode
     * @param string $requestType
     * @param string $typeEntityName
     * @param string $uIScreen
     */
    public function __construct($crmMode = null, $requestType = null, $typeEntityName = null, $uIScreen = null)
    {
        $this
            ->setCrmMode($crmMode)
            ->setRequestType($requestType)
            ->setTypeEntityName($typeEntityName)
            ->setUIScreen($uIScreen);
    }
    /**
     * Get CrmMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCrmMode()
    {
        return isset($this->CrmMode) ? $this->CrmMode : null;
    }
    /**
     * Set CrmMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $crmMode
     * @return \patest\StructType\HelpDesk_ServiceRequestForLauncher
     */
    public function setCrmMode($crmMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($crmMode) && !is_bool($crmMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($crmMode, true), gettype($crmMode)), __LINE__);
        }
        if (is_null($crmMode) || (is_array($crmMode) && empty($crmMode))) {
            unset($this->CrmMode);
        } else {
            $this->CrmMode = $crmMode;
        }
        return $this;
    }
    /**
     * Get RequestType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestType()
    {
        return isset($this->RequestType) ? $this->RequestType : null;
    }
    /**
     * Set RequestType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestType
     * @return \patest\StructType\HelpDesk_ServiceRequestForLauncher
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: string
        if (!is_null($requestType) && !is_string($requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestType, true), gettype($requestType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestType, true)), __LINE__);
        }
        if (is_null($requestType) || (is_array($requestType) && empty($requestType))) {
            unset($this->RequestType);
        } else {
            $this->RequestType = $requestType;
        }
        return $this;
    }
    /**
     * Get TypeEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeEntityName()
    {
        return isset($this->TypeEntityName) ? $this->TypeEntityName : null;
    }
    /**
     * Set TypeEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeEntityName
     * @return \patest\StructType\HelpDesk_ServiceRequestForLauncher
     */
    public function setTypeEntityName($typeEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($typeEntityName) && !is_string($typeEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeEntityName, true), gettype($typeEntityName)), __LINE__);
        }
        if (is_null($typeEntityName) || (is_array($typeEntityName) && empty($typeEntityName))) {
            unset($this->TypeEntityName);
        } else {
            $this->TypeEntityName = $typeEntityName;
        }
        return $this;
    }
    /**
     * Get UIScreen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUIScreen()
    {
        return isset($this->UIScreen) ? $this->UIScreen : null;
    }
    /**
     * Set UIScreen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uIScreen
     * @return \patest\StructType\HelpDesk_ServiceRequestForLauncher
     */
    public function setUIScreen($uIScreen = null)
    {
        // validation for constraint: string
        if (!is_null($uIScreen) && !is_string($uIScreen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uIScreen, true), gettype($uIScreen)), __LINE__);
        }
        if (is_null($uIScreen) || (is_array($uIScreen) && empty($uIScreen))) {
            unset($this->UIScreen);
        } else {
            $this->UIScreen = $uIScreen;
        }
        return $this;
    }
}
