<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.ServiceRequest StructType
 * @subpackage Structs
 */
class HelpDesk_ServiceRequest extends PersistableEntity
{
    /**
     * The AssignedTo
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AssignedTo;
    /**
     * The AuxilaryData1
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AuxilaryData1;
    /**
     * The AuxilaryData2
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AuxilaryData2;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfHelpDesk_ServiceRequestComment
     */
    public $Comments;
    /**
     * The CompletionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompletionDate;
    /**
     * The CreatedBy
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreatedBy;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDate;
    /**
     * The Explanation
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Explanation;
    /**
     * The ExplanationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExplanationId;
    /**
     * The ExtendedData1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData1;
    /**
     * The ExtendedData10
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData10;
    /**
     * The ExtendedData11
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData11;
    /**
     * The ExtendedData12
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData12;
    /**
     * The ExtendedData13
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData13;
    /**
     * The ExtendedData14
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData14;
    /**
     * The ExtendedData15
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData15;
    /**
     * The ExtendedData16
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData16;
    /**
     * The ExtendedData17
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData17;
    /**
     * The ExtendedData18
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData18;
    /**
     * The ExtendedData19
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData19;
    /**
     * The ExtendedData2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData2;
    /**
     * The ExtendedData20
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData20;
    /**
     * The ExtendedData21
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData21;
    /**
     * The ExtendedData22
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData22;
    /**
     * The ExtendedData23
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData23;
    /**
     * The ExtendedData24
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData24;
    /**
     * The ExtendedData25
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData25;
    /**
     * The ExtendedData26
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData26;
    /**
     * The ExtendedData27
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData27;
    /**
     * The ExtendedData28
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData28;
    /**
     * The ExtendedData29
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData29;
    /**
     * The ExtendedData3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData3;
    /**
     * The ExtendedData30
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData30;
    /**
     * The ExtendedData31
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData31;
    /**
     * The ExtendedData32
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData32;
    /**
     * The ExtendedData33
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData33;
    /**
     * The ExtendedData34
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData34;
    /**
     * The ExtendedData4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData4;
    /**
     * The ExtendedData5
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData5;
    /**
     * The ExtendedData6
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData6;
    /**
     * The ExtendedData7
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData7;
    /**
     * The ExtendedData8
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData8;
    /**
     * The ExtendedData9
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData9;
    /**
     * The GeneralRequestInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeneralRequestInfo;
    /**
     * The HandledByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HandledByUserId;
    /**
     * The HandledOnDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandledOnDate;
    /**
     * The HandleRequestNotLaterThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandleRequestNotLaterThan;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The Links
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfHelpDesk_ServiceRequestMyLink
     */
    public $Links;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OtherExplanation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OtherExplanation;
    /**
     * The Phase
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phase;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Priority;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The RelatedEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedEntityId;
    /**
     * The RelatedEntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedEntityType;
    /**
     * The RequestDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestDetails;
    /**
     * The RequestTopic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestTopic;
    /**
     * The RequestType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestType;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The Show
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Show
     */
    public $Show;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Status;
    /**
     * The StatusName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $StatusName;
    /**
     * The SubsidizingAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubsidizingAccountId;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TypeEntityName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeEntityName;
    /**
     * The UIScreen
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UIScreen;
    /**
     * The UserComments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserComments;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for HelpDesk.ServiceRequest
     * @uses HelpDesk_ServiceRequest::setAssignedTo()
     * @uses HelpDesk_ServiceRequest::setAuxilaryData1()
     * @uses HelpDesk_ServiceRequest::setAuxilaryData2()
     * @uses HelpDesk_ServiceRequest::setCategoryId()
     * @uses HelpDesk_ServiceRequest::setClientId()
     * @uses HelpDesk_ServiceRequest::setComments()
     * @uses HelpDesk_ServiceRequest::setCompletionDate()
     * @uses HelpDesk_ServiceRequest::setCreatedBy()
     * @uses HelpDesk_ServiceRequest::setCreationDate()
     * @uses HelpDesk_ServiceRequest::setExpiryDate()
     * @uses HelpDesk_ServiceRequest::setExplanation()
     * @uses HelpDesk_ServiceRequest::setExplanationId()
     * @uses HelpDesk_ServiceRequest::setExtendedData1()
     * @uses HelpDesk_ServiceRequest::setExtendedData10()
     * @uses HelpDesk_ServiceRequest::setExtendedData11()
     * @uses HelpDesk_ServiceRequest::setExtendedData12()
     * @uses HelpDesk_ServiceRequest::setExtendedData13()
     * @uses HelpDesk_ServiceRequest::setExtendedData14()
     * @uses HelpDesk_ServiceRequest::setExtendedData15()
     * @uses HelpDesk_ServiceRequest::setExtendedData16()
     * @uses HelpDesk_ServiceRequest::setExtendedData17()
     * @uses HelpDesk_ServiceRequest::setExtendedData18()
     * @uses HelpDesk_ServiceRequest::setExtendedData19()
     * @uses HelpDesk_ServiceRequest::setExtendedData2()
     * @uses HelpDesk_ServiceRequest::setExtendedData20()
     * @uses HelpDesk_ServiceRequest::setExtendedData21()
     * @uses HelpDesk_ServiceRequest::setExtendedData22()
     * @uses HelpDesk_ServiceRequest::setExtendedData23()
     * @uses HelpDesk_ServiceRequest::setExtendedData24()
     * @uses HelpDesk_ServiceRequest::setExtendedData25()
     * @uses HelpDesk_ServiceRequest::setExtendedData26()
     * @uses HelpDesk_ServiceRequest::setExtendedData27()
     * @uses HelpDesk_ServiceRequest::setExtendedData28()
     * @uses HelpDesk_ServiceRequest::setExtendedData29()
     * @uses HelpDesk_ServiceRequest::setExtendedData3()
     * @uses HelpDesk_ServiceRequest::setExtendedData30()
     * @uses HelpDesk_ServiceRequest::setExtendedData31()
     * @uses HelpDesk_ServiceRequest::setExtendedData32()
     * @uses HelpDesk_ServiceRequest::setExtendedData33()
     * @uses HelpDesk_ServiceRequest::setExtendedData34()
     * @uses HelpDesk_ServiceRequest::setExtendedData4()
     * @uses HelpDesk_ServiceRequest::setExtendedData5()
     * @uses HelpDesk_ServiceRequest::setExtendedData6()
     * @uses HelpDesk_ServiceRequest::setExtendedData7()
     * @uses HelpDesk_ServiceRequest::setExtendedData8()
     * @uses HelpDesk_ServiceRequest::setExtendedData9()
     * @uses HelpDesk_ServiceRequest::setGeneralRequestInfo()
     * @uses HelpDesk_ServiceRequest::setHandledByUserId()
     * @uses HelpDesk_ServiceRequest::setHandledOnDate()
     * @uses HelpDesk_ServiceRequest::setHandleRequestNotLaterThan()
     * @uses HelpDesk_ServiceRequest::setIsActive()
     * @uses HelpDesk_ServiceRequest::setLinks()
     * @uses HelpDesk_ServiceRequest::setOrganizationUnitId()
     * @uses HelpDesk_ServiceRequest::setOtherExplanation()
     * @uses HelpDesk_ServiceRequest::setPhase()
     * @uses HelpDesk_ServiceRequest::setPriority()
     * @uses HelpDesk_ServiceRequest::setQuantity()
     * @uses HelpDesk_ServiceRequest::setRelatedEntityId()
     * @uses HelpDesk_ServiceRequest::setRelatedEntityType()
     * @uses HelpDesk_ServiceRequest::setRequestDetails()
     * @uses HelpDesk_ServiceRequest::setRequestTopic()
     * @uses HelpDesk_ServiceRequest::setRequestType()
     * @uses HelpDesk_ServiceRequest::setSeasonId()
     * @uses HelpDesk_ServiceRequest::setShow()
     * @uses HelpDesk_ServiceRequest::setShowId()
     * @uses HelpDesk_ServiceRequest::setStatus()
     * @uses HelpDesk_ServiceRequest::setStatusName()
     * @uses HelpDesk_ServiceRequest::setSubsidizingAccountId()
     * @uses HelpDesk_ServiceRequest::setTransactionNumber()
     * @uses HelpDesk_ServiceRequest::setTypeEntityName()
     * @uses HelpDesk_ServiceRequest::setUIScreen()
     * @uses HelpDesk_ServiceRequest::setUserComments()
     * @uses HelpDesk_ServiceRequest::setVisibleBySubordinates()
     * @param string $assignedTo
     * @param string $auxilaryData1
     * @param string $auxilaryData2
     * @param string $categoryId
     * @param string $clientId
     * @param \patest\StructType\RecordSetOfHelpDesk_ServiceRequestComment $comments
     * @param string $completionDate
     * @param string $createdBy
     * @param string $creationDate
     * @param string $expiryDate
     * @param \patest\StructType\GlobalString $explanation
     * @param string $explanationId
     * @param string $extendedData1
     * @param string $extendedData10
     * @param string $extendedData11
     * @param string $extendedData12
     * @param string $extendedData13
     * @param string $extendedData14
     * @param string $extendedData15
     * @param string $extendedData16
     * @param string $extendedData17
     * @param string $extendedData18
     * @param string $extendedData19
     * @param string $extendedData2
     * @param string $extendedData20
     * @param string $extendedData21
     * @param string $extendedData22
     * @param string $extendedData23
     * @param string $extendedData24
     * @param string $extendedData25
     * @param string $extendedData26
     * @param string $extendedData27
     * @param string $extendedData28
     * @param string $extendedData29
     * @param string $extendedData3
     * @param string $extendedData30
     * @param string $extendedData31
     * @param string $extendedData32
     * @param string $extendedData33
     * @param string $extendedData34
     * @param string $extendedData4
     * @param string $extendedData5
     * @param string $extendedData6
     * @param string $extendedData7
     * @param string $extendedData8
     * @param string $extendedData9
     * @param string $generalRequestInfo
     * @param string $handledByUserId
     * @param string $handledOnDate
     * @param string $handleRequestNotLaterThan
     * @param bool $isActive
     * @param \patest\StructType\RecordSetOfHelpDesk_ServiceRequestMyLink $links
     * @param string $organizationUnitId
     * @param string $otherExplanation
     * @param string $phase
     * @param string $priority
     * @param int $quantity
     * @param string $relatedEntityId
     * @param string $relatedEntityType
     * @param string $requestDetails
     * @param string $requestTopic
     * @param string $requestType
     * @param string $seasonId
     * @param \patest\StructType\Ticketing_Show $show
     * @param string $showId
     * @param string $status
     * @param \patest\StructType\GlobalString $statusName
     * @param string $subsidizingAccountId
     * @param int $transactionNumber
     * @param string $typeEntityName
     * @param string $uIScreen
     * @param string $userComments
     * @param bool $visibleBySubordinates
     */
    public function __construct($assignedTo = null, $auxilaryData1 = null, $auxilaryData2 = null, $categoryId = null, $clientId = null, \patest\StructType\RecordSetOfHelpDesk_ServiceRequestComment $comments = null, $completionDate = null, $createdBy = null, $creationDate = null, $expiryDate = null, \patest\StructType\GlobalString $explanation = null, $explanationId = null, $extendedData1 = null, $extendedData10 = null, $extendedData11 = null, $extendedData12 = null, $extendedData13 = null, $extendedData14 = null, $extendedData15 = null, $extendedData16 = null, $extendedData17 = null, $extendedData18 = null, $extendedData19 = null, $extendedData2 = null, $extendedData20 = null, $extendedData21 = null, $extendedData22 = null, $extendedData23 = null, $extendedData24 = null, $extendedData25 = null, $extendedData26 = null, $extendedData27 = null, $extendedData28 = null, $extendedData29 = null, $extendedData3 = null, $extendedData30 = null, $extendedData31 = null, $extendedData32 = null, $extendedData33 = null, $extendedData34 = null, $extendedData4 = null, $extendedData5 = null, $extendedData6 = null, $extendedData7 = null, $extendedData8 = null, $extendedData9 = null, $generalRequestInfo = null, $handledByUserId = null, $handledOnDate = null, $handleRequestNotLaterThan = null, $isActive = null, \patest\StructType\RecordSetOfHelpDesk_ServiceRequestMyLink $links = null, $organizationUnitId = null, $otherExplanation = null, $phase = null, $priority = null, $quantity = null, $relatedEntityId = null, $relatedEntityType = null, $requestDetails = null, $requestTopic = null, $requestType = null, $seasonId = null, \patest\StructType\Ticketing_Show $show = null, $showId = null, $status = null, \patest\StructType\GlobalString $statusName = null, $subsidizingAccountId = null, $transactionNumber = null, $typeEntityName = null, $uIScreen = null, $userComments = null, $visibleBySubordinates = null)
    {
        $this
            ->setAssignedTo($assignedTo)
            ->setAuxilaryData1($auxilaryData1)
            ->setAuxilaryData2($auxilaryData2)
            ->setCategoryId($categoryId)
            ->setClientId($clientId)
            ->setComments($comments)
            ->setCompletionDate($completionDate)
            ->setCreatedBy($createdBy)
            ->setCreationDate($creationDate)
            ->setExpiryDate($expiryDate)
            ->setExplanation($explanation)
            ->setExplanationId($explanationId)
            ->setExtendedData1($extendedData1)
            ->setExtendedData10($extendedData10)
            ->setExtendedData11($extendedData11)
            ->setExtendedData12($extendedData12)
            ->setExtendedData13($extendedData13)
            ->setExtendedData14($extendedData14)
            ->setExtendedData15($extendedData15)
            ->setExtendedData16($extendedData16)
            ->setExtendedData17($extendedData17)
            ->setExtendedData18($extendedData18)
            ->setExtendedData19($extendedData19)
            ->setExtendedData2($extendedData2)
            ->setExtendedData20($extendedData20)
            ->setExtendedData21($extendedData21)
            ->setExtendedData22($extendedData22)
            ->setExtendedData23($extendedData23)
            ->setExtendedData24($extendedData24)
            ->setExtendedData25($extendedData25)
            ->setExtendedData26($extendedData26)
            ->setExtendedData27($extendedData27)
            ->setExtendedData28($extendedData28)
            ->setExtendedData29($extendedData29)
            ->setExtendedData3($extendedData3)
            ->setExtendedData30($extendedData30)
            ->setExtendedData31($extendedData31)
            ->setExtendedData32($extendedData32)
            ->setExtendedData33($extendedData33)
            ->setExtendedData34($extendedData34)
            ->setExtendedData4($extendedData4)
            ->setExtendedData5($extendedData5)
            ->setExtendedData6($extendedData6)
            ->setExtendedData7($extendedData7)
            ->setExtendedData8($extendedData8)
            ->setExtendedData9($extendedData9)
            ->setGeneralRequestInfo($generalRequestInfo)
            ->setHandledByUserId($handledByUserId)
            ->setHandledOnDate($handledOnDate)
            ->setHandleRequestNotLaterThan($handleRequestNotLaterThan)
            ->setIsActive($isActive)
            ->setLinks($links)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOtherExplanation($otherExplanation)
            ->setPhase($phase)
            ->setPriority($priority)
            ->setQuantity($quantity)
            ->setRelatedEntityId($relatedEntityId)
            ->setRelatedEntityType($relatedEntityType)
            ->setRequestDetails($requestDetails)
            ->setRequestTopic($requestTopic)
            ->setRequestType($requestType)
            ->setSeasonId($seasonId)
            ->setShow($show)
            ->setShowId($showId)
            ->setStatus($status)
            ->setStatusName($statusName)
            ->setSubsidizingAccountId($subsidizingAccountId)
            ->setTransactionNumber($transactionNumber)
            ->setTypeEntityName($typeEntityName)
            ->setUIScreen($uIScreen)
            ->setUserComments($userComments)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AssignedTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignedTo()
    {
        return isset($this->AssignedTo) ? $this->AssignedTo : null;
    }
    /**
     * Set AssignedTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignedTo
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setAssignedTo($assignedTo = null)
    {
        // validation for constraint: string
        if (!is_null($assignedTo) && !is_string($assignedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignedTo, true), gettype($assignedTo)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($assignedTo) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $assignedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($assignedTo, true)), __LINE__);
        }
        if (is_null($assignedTo) || (is_array($assignedTo) && empty($assignedTo))) {
            unset($this->AssignedTo);
        } else {
            $this->AssignedTo = $assignedTo;
        }
        return $this;
    }
    /**
     * Get AuxilaryData1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuxilaryData1()
    {
        return isset($this->AuxilaryData1) ? $this->AuxilaryData1 : null;
    }
    /**
     * Set AuxilaryData1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auxilaryData1
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setAuxilaryData1($auxilaryData1 = null)
    {
        // validation for constraint: string
        if (!is_null($auxilaryData1) && !is_string($auxilaryData1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auxilaryData1, true), gettype($auxilaryData1)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($auxilaryData1) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $auxilaryData1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($auxilaryData1, true)), __LINE__);
        }
        if (is_null($auxilaryData1) || (is_array($auxilaryData1) && empty($auxilaryData1))) {
            unset($this->AuxilaryData1);
        } else {
            $this->AuxilaryData1 = $auxilaryData1;
        }
        return $this;
    }
    /**
     * Get AuxilaryData2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuxilaryData2()
    {
        return isset($this->AuxilaryData2) ? $this->AuxilaryData2 : null;
    }
    /**
     * Set AuxilaryData2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auxilaryData2
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setAuxilaryData2($auxilaryData2 = null)
    {
        // validation for constraint: string
        if (!is_null($auxilaryData2) && !is_string($auxilaryData2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auxilaryData2, true), gettype($auxilaryData2)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($auxilaryData2) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $auxilaryData2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($auxilaryData2, true)), __LINE__);
        }
        if (is_null($auxilaryData2) || (is_array($auxilaryData2) && empty($auxilaryData2))) {
            unset($this->AuxilaryData2);
        } else {
            $this->AuxilaryData2 = $auxilaryData2;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfHelpDesk_ServiceRequestComment|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfHelpDesk_ServiceRequestComment $comments
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setComments(\patest\StructType\RecordSetOfHelpDesk_ServiceRequestComment $comments = null)
    {
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Get CompletionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompletionDate()
    {
        return isset($this->CompletionDate) ? $this->CompletionDate : null;
    }
    /**
     * Set CompletionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $completionDate
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setCompletionDate($completionDate = null)
    {
        // validation for constraint: string
        if (!is_null($completionDate) && !is_string($completionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($completionDate, true), gettype($completionDate)), __LINE__);
        }
        if (is_null($completionDate) || (is_array($completionDate) && empty($completionDate))) {
            unset($this->CompletionDate);
        } else {
            $this->CompletionDate = $completionDate;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdBy
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($createdBy) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($createdBy, true)), __LINE__);
        }
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get ExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDate()
    {
        return isset($this->ExpiryDate) ? $this->ExpiryDate : null;
    }
    /**
     * Set ExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDate
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        if (is_null($expiryDate) || (is_array($expiryDate) && empty($expiryDate))) {
            unset($this->ExpiryDate);
        } else {
            $this->ExpiryDate = $expiryDate;
        }
        return $this;
    }
    /**
     * Get Explanation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getExplanation()
    {
        return isset($this->Explanation) ? $this->Explanation : null;
    }
    /**
     * Set Explanation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $explanation
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExplanation(\patest\StructType\GlobalString $explanation = null)
    {
        if (is_null($explanation) || (is_array($explanation) && empty($explanation))) {
            unset($this->Explanation);
        } else {
            $this->Explanation = $explanation;
        }
        return $this;
    }
    /**
     * Get ExplanationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExplanationId()
    {
        return isset($this->ExplanationId) ? $this->ExplanationId : null;
    }
    /**
     * Set ExplanationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $explanationId
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExplanationId($explanationId = null)
    {
        // validation for constraint: string
        if (!is_null($explanationId) && !is_string($explanationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($explanationId, true), gettype($explanationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($explanationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $explanationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($explanationId, true)), __LINE__);
        }
        if (is_null($explanationId) || (is_array($explanationId) && empty($explanationId))) {
            unset($this->ExplanationId);
        } else {
            $this->ExplanationId = $explanationId;
        }
        return $this;
    }
    /**
     * Get ExtendedData1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData1()
    {
        return isset($this->ExtendedData1) ? $this->ExtendedData1 : null;
    }
    /**
     * Set ExtendedData1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData1
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData1($extendedData1 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData1) && !is_string($extendedData1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData1, true), gettype($extendedData1)), __LINE__);
        }
        if (is_null($extendedData1) || (is_array($extendedData1) && empty($extendedData1))) {
            unset($this->ExtendedData1);
        } else {
            $this->ExtendedData1 = $extendedData1;
        }
        return $this;
    }
    /**
     * Get ExtendedData10 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData10()
    {
        return isset($this->ExtendedData10) ? $this->ExtendedData10 : null;
    }
    /**
     * Set ExtendedData10 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData10
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData10($extendedData10 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData10) && !is_string($extendedData10)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData10, true), gettype($extendedData10)), __LINE__);
        }
        if (is_null($extendedData10) || (is_array($extendedData10) && empty($extendedData10))) {
            unset($this->ExtendedData10);
        } else {
            $this->ExtendedData10 = $extendedData10;
        }
        return $this;
    }
    /**
     * Get ExtendedData11 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData11()
    {
        return isset($this->ExtendedData11) ? $this->ExtendedData11 : null;
    }
    /**
     * Set ExtendedData11 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData11
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData11($extendedData11 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData11) && !is_string($extendedData11)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData11, true), gettype($extendedData11)), __LINE__);
        }
        if (is_null($extendedData11) || (is_array($extendedData11) && empty($extendedData11))) {
            unset($this->ExtendedData11);
        } else {
            $this->ExtendedData11 = $extendedData11;
        }
        return $this;
    }
    /**
     * Get ExtendedData12 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData12()
    {
        return isset($this->ExtendedData12) ? $this->ExtendedData12 : null;
    }
    /**
     * Set ExtendedData12 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData12
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData12($extendedData12 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData12) && !is_string($extendedData12)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData12, true), gettype($extendedData12)), __LINE__);
        }
        if (is_null($extendedData12) || (is_array($extendedData12) && empty($extendedData12))) {
            unset($this->ExtendedData12);
        } else {
            $this->ExtendedData12 = $extendedData12;
        }
        return $this;
    }
    /**
     * Get ExtendedData13 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData13()
    {
        return isset($this->ExtendedData13) ? $this->ExtendedData13 : null;
    }
    /**
     * Set ExtendedData13 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData13
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData13($extendedData13 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData13) && !is_string($extendedData13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData13, true), gettype($extendedData13)), __LINE__);
        }
        if (is_null($extendedData13) || (is_array($extendedData13) && empty($extendedData13))) {
            unset($this->ExtendedData13);
        } else {
            $this->ExtendedData13 = $extendedData13;
        }
        return $this;
    }
    /**
     * Get ExtendedData14 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData14()
    {
        return isset($this->ExtendedData14) ? $this->ExtendedData14 : null;
    }
    /**
     * Set ExtendedData14 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData14
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData14($extendedData14 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData14) && !is_string($extendedData14)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData14, true), gettype($extendedData14)), __LINE__);
        }
        if (is_null($extendedData14) || (is_array($extendedData14) && empty($extendedData14))) {
            unset($this->ExtendedData14);
        } else {
            $this->ExtendedData14 = $extendedData14;
        }
        return $this;
    }
    /**
     * Get ExtendedData15 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData15()
    {
        return isset($this->ExtendedData15) ? $this->ExtendedData15 : null;
    }
    /**
     * Set ExtendedData15 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData15
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData15($extendedData15 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData15) && !is_string($extendedData15)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData15, true), gettype($extendedData15)), __LINE__);
        }
        if (is_null($extendedData15) || (is_array($extendedData15) && empty($extendedData15))) {
            unset($this->ExtendedData15);
        } else {
            $this->ExtendedData15 = $extendedData15;
        }
        return $this;
    }
    /**
     * Get ExtendedData16 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData16()
    {
        return isset($this->ExtendedData16) ? $this->ExtendedData16 : null;
    }
    /**
     * Set ExtendedData16 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData16
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData16($extendedData16 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData16) && !is_string($extendedData16)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData16, true), gettype($extendedData16)), __LINE__);
        }
        if (is_null($extendedData16) || (is_array($extendedData16) && empty($extendedData16))) {
            unset($this->ExtendedData16);
        } else {
            $this->ExtendedData16 = $extendedData16;
        }
        return $this;
    }
    /**
     * Get ExtendedData17 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData17()
    {
        return isset($this->ExtendedData17) ? $this->ExtendedData17 : null;
    }
    /**
     * Set ExtendedData17 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData17
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData17($extendedData17 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData17) && !is_string($extendedData17)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData17, true), gettype($extendedData17)), __LINE__);
        }
        if (is_null($extendedData17) || (is_array($extendedData17) && empty($extendedData17))) {
            unset($this->ExtendedData17);
        } else {
            $this->ExtendedData17 = $extendedData17;
        }
        return $this;
    }
    /**
     * Get ExtendedData18 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData18()
    {
        return isset($this->ExtendedData18) ? $this->ExtendedData18 : null;
    }
    /**
     * Set ExtendedData18 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData18
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData18($extendedData18 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData18) && !is_string($extendedData18)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData18, true), gettype($extendedData18)), __LINE__);
        }
        if (is_null($extendedData18) || (is_array($extendedData18) && empty($extendedData18))) {
            unset($this->ExtendedData18);
        } else {
            $this->ExtendedData18 = $extendedData18;
        }
        return $this;
    }
    /**
     * Get ExtendedData19 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData19()
    {
        return isset($this->ExtendedData19) ? $this->ExtendedData19 : null;
    }
    /**
     * Set ExtendedData19 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData19
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData19($extendedData19 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData19) && !is_string($extendedData19)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData19, true), gettype($extendedData19)), __LINE__);
        }
        if (is_null($extendedData19) || (is_array($extendedData19) && empty($extendedData19))) {
            unset($this->ExtendedData19);
        } else {
            $this->ExtendedData19 = $extendedData19;
        }
        return $this;
    }
    /**
     * Get ExtendedData2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData2()
    {
        return isset($this->ExtendedData2) ? $this->ExtendedData2 : null;
    }
    /**
     * Set ExtendedData2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData2
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData2($extendedData2 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData2) && !is_string($extendedData2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData2, true), gettype($extendedData2)), __LINE__);
        }
        if (is_null($extendedData2) || (is_array($extendedData2) && empty($extendedData2))) {
            unset($this->ExtendedData2);
        } else {
            $this->ExtendedData2 = $extendedData2;
        }
        return $this;
    }
    /**
     * Get ExtendedData20 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData20()
    {
        return isset($this->ExtendedData20) ? $this->ExtendedData20 : null;
    }
    /**
     * Set ExtendedData20 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData20
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData20($extendedData20 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData20) && !is_string($extendedData20)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData20, true), gettype($extendedData20)), __LINE__);
        }
        if (is_null($extendedData20) || (is_array($extendedData20) && empty($extendedData20))) {
            unset($this->ExtendedData20);
        } else {
            $this->ExtendedData20 = $extendedData20;
        }
        return $this;
    }
    /**
     * Get ExtendedData21 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData21()
    {
        return isset($this->ExtendedData21) ? $this->ExtendedData21 : null;
    }
    /**
     * Set ExtendedData21 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData21
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData21($extendedData21 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData21) && !is_string($extendedData21)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData21, true), gettype($extendedData21)), __LINE__);
        }
        if (is_null($extendedData21) || (is_array($extendedData21) && empty($extendedData21))) {
            unset($this->ExtendedData21);
        } else {
            $this->ExtendedData21 = $extendedData21;
        }
        return $this;
    }
    /**
     * Get ExtendedData22 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData22()
    {
        return isset($this->ExtendedData22) ? $this->ExtendedData22 : null;
    }
    /**
     * Set ExtendedData22 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData22
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData22($extendedData22 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData22) && !is_string($extendedData22)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData22, true), gettype($extendedData22)), __LINE__);
        }
        if (is_null($extendedData22) || (is_array($extendedData22) && empty($extendedData22))) {
            unset($this->ExtendedData22);
        } else {
            $this->ExtendedData22 = $extendedData22;
        }
        return $this;
    }
    /**
     * Get ExtendedData23 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData23()
    {
        return isset($this->ExtendedData23) ? $this->ExtendedData23 : null;
    }
    /**
     * Set ExtendedData23 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData23
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData23($extendedData23 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData23) && !is_string($extendedData23)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData23, true), gettype($extendedData23)), __LINE__);
        }
        if (is_null($extendedData23) || (is_array($extendedData23) && empty($extendedData23))) {
            unset($this->ExtendedData23);
        } else {
            $this->ExtendedData23 = $extendedData23;
        }
        return $this;
    }
    /**
     * Get ExtendedData24 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData24()
    {
        return isset($this->ExtendedData24) ? $this->ExtendedData24 : null;
    }
    /**
     * Set ExtendedData24 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData24
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData24($extendedData24 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData24) && !is_string($extendedData24)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData24, true), gettype($extendedData24)), __LINE__);
        }
        if (is_null($extendedData24) || (is_array($extendedData24) && empty($extendedData24))) {
            unset($this->ExtendedData24);
        } else {
            $this->ExtendedData24 = $extendedData24;
        }
        return $this;
    }
    /**
     * Get ExtendedData25 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData25()
    {
        return isset($this->ExtendedData25) ? $this->ExtendedData25 : null;
    }
    /**
     * Set ExtendedData25 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData25
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData25($extendedData25 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData25) && !is_string($extendedData25)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData25, true), gettype($extendedData25)), __LINE__);
        }
        if (is_null($extendedData25) || (is_array($extendedData25) && empty($extendedData25))) {
            unset($this->ExtendedData25);
        } else {
            $this->ExtendedData25 = $extendedData25;
        }
        return $this;
    }
    /**
     * Get ExtendedData26 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData26()
    {
        return isset($this->ExtendedData26) ? $this->ExtendedData26 : null;
    }
    /**
     * Set ExtendedData26 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData26
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData26($extendedData26 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData26) && !is_string($extendedData26)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData26, true), gettype($extendedData26)), __LINE__);
        }
        if (is_null($extendedData26) || (is_array($extendedData26) && empty($extendedData26))) {
            unset($this->ExtendedData26);
        } else {
            $this->ExtendedData26 = $extendedData26;
        }
        return $this;
    }
    /**
     * Get ExtendedData27 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData27()
    {
        return isset($this->ExtendedData27) ? $this->ExtendedData27 : null;
    }
    /**
     * Set ExtendedData27 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData27
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData27($extendedData27 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData27) && !is_string($extendedData27)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData27, true), gettype($extendedData27)), __LINE__);
        }
        if (is_null($extendedData27) || (is_array($extendedData27) && empty($extendedData27))) {
            unset($this->ExtendedData27);
        } else {
            $this->ExtendedData27 = $extendedData27;
        }
        return $this;
    }
    /**
     * Get ExtendedData28 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData28()
    {
        return isset($this->ExtendedData28) ? $this->ExtendedData28 : null;
    }
    /**
     * Set ExtendedData28 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData28
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData28($extendedData28 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData28) && !is_string($extendedData28)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData28, true), gettype($extendedData28)), __LINE__);
        }
        if (is_null($extendedData28) || (is_array($extendedData28) && empty($extendedData28))) {
            unset($this->ExtendedData28);
        } else {
            $this->ExtendedData28 = $extendedData28;
        }
        return $this;
    }
    /**
     * Get ExtendedData29 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData29()
    {
        return isset($this->ExtendedData29) ? $this->ExtendedData29 : null;
    }
    /**
     * Set ExtendedData29 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData29
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData29($extendedData29 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData29) && !is_string($extendedData29)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData29, true), gettype($extendedData29)), __LINE__);
        }
        if (is_null($extendedData29) || (is_array($extendedData29) && empty($extendedData29))) {
            unset($this->ExtendedData29);
        } else {
            $this->ExtendedData29 = $extendedData29;
        }
        return $this;
    }
    /**
     * Get ExtendedData3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData3()
    {
        return isset($this->ExtendedData3) ? $this->ExtendedData3 : null;
    }
    /**
     * Set ExtendedData3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData3
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData3($extendedData3 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData3) && !is_string($extendedData3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData3, true), gettype($extendedData3)), __LINE__);
        }
        if (is_null($extendedData3) || (is_array($extendedData3) && empty($extendedData3))) {
            unset($this->ExtendedData3);
        } else {
            $this->ExtendedData3 = $extendedData3;
        }
        return $this;
    }
    /**
     * Get ExtendedData30 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData30()
    {
        return isset($this->ExtendedData30) ? $this->ExtendedData30 : null;
    }
    /**
     * Set ExtendedData30 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData30
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData30($extendedData30 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData30) && !is_string($extendedData30)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData30, true), gettype($extendedData30)), __LINE__);
        }
        if (is_null($extendedData30) || (is_array($extendedData30) && empty($extendedData30))) {
            unset($this->ExtendedData30);
        } else {
            $this->ExtendedData30 = $extendedData30;
        }
        return $this;
    }
    /**
     * Get ExtendedData31 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData31()
    {
        return isset($this->ExtendedData31) ? $this->ExtendedData31 : null;
    }
    /**
     * Set ExtendedData31 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData31
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData31($extendedData31 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData31) && !is_string($extendedData31)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData31, true), gettype($extendedData31)), __LINE__);
        }
        if (is_null($extendedData31) || (is_array($extendedData31) && empty($extendedData31))) {
            unset($this->ExtendedData31);
        } else {
            $this->ExtendedData31 = $extendedData31;
        }
        return $this;
    }
    /**
     * Get ExtendedData32 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData32()
    {
        return isset($this->ExtendedData32) ? $this->ExtendedData32 : null;
    }
    /**
     * Set ExtendedData32 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData32
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData32($extendedData32 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData32) && !is_string($extendedData32)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData32, true), gettype($extendedData32)), __LINE__);
        }
        if (is_null($extendedData32) || (is_array($extendedData32) && empty($extendedData32))) {
            unset($this->ExtendedData32);
        } else {
            $this->ExtendedData32 = $extendedData32;
        }
        return $this;
    }
    /**
     * Get ExtendedData33 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData33()
    {
        return isset($this->ExtendedData33) ? $this->ExtendedData33 : null;
    }
    /**
     * Set ExtendedData33 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData33
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData33($extendedData33 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData33) && !is_string($extendedData33)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData33, true), gettype($extendedData33)), __LINE__);
        }
        if (is_null($extendedData33) || (is_array($extendedData33) && empty($extendedData33))) {
            unset($this->ExtendedData33);
        } else {
            $this->ExtendedData33 = $extendedData33;
        }
        return $this;
    }
    /**
     * Get ExtendedData34 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData34()
    {
        return isset($this->ExtendedData34) ? $this->ExtendedData34 : null;
    }
    /**
     * Set ExtendedData34 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData34
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData34($extendedData34 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData34) && !is_string($extendedData34)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData34, true), gettype($extendedData34)), __LINE__);
        }
        if (is_null($extendedData34) || (is_array($extendedData34) && empty($extendedData34))) {
            unset($this->ExtendedData34);
        } else {
            $this->ExtendedData34 = $extendedData34;
        }
        return $this;
    }
    /**
     * Get ExtendedData4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData4()
    {
        return isset($this->ExtendedData4) ? $this->ExtendedData4 : null;
    }
    /**
     * Set ExtendedData4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData4
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData4($extendedData4 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData4) && !is_string($extendedData4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData4, true), gettype($extendedData4)), __LINE__);
        }
        if (is_null($extendedData4) || (is_array($extendedData4) && empty($extendedData4))) {
            unset($this->ExtendedData4);
        } else {
            $this->ExtendedData4 = $extendedData4;
        }
        return $this;
    }
    /**
     * Get ExtendedData5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData5()
    {
        return isset($this->ExtendedData5) ? $this->ExtendedData5 : null;
    }
    /**
     * Set ExtendedData5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData5
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData5($extendedData5 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData5) && !is_string($extendedData5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData5, true), gettype($extendedData5)), __LINE__);
        }
        if (is_null($extendedData5) || (is_array($extendedData5) && empty($extendedData5))) {
            unset($this->ExtendedData5);
        } else {
            $this->ExtendedData5 = $extendedData5;
        }
        return $this;
    }
    /**
     * Get ExtendedData6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData6()
    {
        return isset($this->ExtendedData6) ? $this->ExtendedData6 : null;
    }
    /**
     * Set ExtendedData6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData6
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData6($extendedData6 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData6) && !is_string($extendedData6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData6, true), gettype($extendedData6)), __LINE__);
        }
        if (is_null($extendedData6) || (is_array($extendedData6) && empty($extendedData6))) {
            unset($this->ExtendedData6);
        } else {
            $this->ExtendedData6 = $extendedData6;
        }
        return $this;
    }
    /**
     * Get ExtendedData7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData7()
    {
        return isset($this->ExtendedData7) ? $this->ExtendedData7 : null;
    }
    /**
     * Set ExtendedData7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData7
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData7($extendedData7 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData7) && !is_string($extendedData7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData7, true), gettype($extendedData7)), __LINE__);
        }
        if (is_null($extendedData7) || (is_array($extendedData7) && empty($extendedData7))) {
            unset($this->ExtendedData7);
        } else {
            $this->ExtendedData7 = $extendedData7;
        }
        return $this;
    }
    /**
     * Get ExtendedData8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData8()
    {
        return isset($this->ExtendedData8) ? $this->ExtendedData8 : null;
    }
    /**
     * Set ExtendedData8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData8
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData8($extendedData8 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData8) && !is_string($extendedData8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData8, true), gettype($extendedData8)), __LINE__);
        }
        if (is_null($extendedData8) || (is_array($extendedData8) && empty($extendedData8))) {
            unset($this->ExtendedData8);
        } else {
            $this->ExtendedData8 = $extendedData8;
        }
        return $this;
    }
    /**
     * Get ExtendedData9 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData9()
    {
        return isset($this->ExtendedData9) ? $this->ExtendedData9 : null;
    }
    /**
     * Set ExtendedData9 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData9
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setExtendedData9($extendedData9 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData9) && !is_string($extendedData9)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData9, true), gettype($extendedData9)), __LINE__);
        }
        if (is_null($extendedData9) || (is_array($extendedData9) && empty($extendedData9))) {
            unset($this->ExtendedData9);
        } else {
            $this->ExtendedData9 = $extendedData9;
        }
        return $this;
    }
    /**
     * Get GeneralRequestInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneralRequestInfo()
    {
        return isset($this->GeneralRequestInfo) ? $this->GeneralRequestInfo : null;
    }
    /**
     * Set GeneralRequestInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generalRequestInfo
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setGeneralRequestInfo($generalRequestInfo = null)
    {
        // validation for constraint: string
        if (!is_null($generalRequestInfo) && !is_string($generalRequestInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generalRequestInfo, true), gettype($generalRequestInfo)), __LINE__);
        }
        if (is_null($generalRequestInfo) || (is_array($generalRequestInfo) && empty($generalRequestInfo))) {
            unset($this->GeneralRequestInfo);
        } else {
            $this->GeneralRequestInfo = $generalRequestInfo;
        }
        return $this;
    }
    /**
     * Get HandledByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandledByUserId()
    {
        return isset($this->HandledByUserId) ? $this->HandledByUserId : null;
    }
    /**
     * Set HandledByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handledByUserId
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setHandledByUserId($handledByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($handledByUserId) && !is_string($handledByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handledByUserId, true), gettype($handledByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($handledByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $handledByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($handledByUserId, true)), __LINE__);
        }
        if (is_null($handledByUserId) || (is_array($handledByUserId) && empty($handledByUserId))) {
            unset($this->HandledByUserId);
        } else {
            $this->HandledByUserId = $handledByUserId;
        }
        return $this;
    }
    /**
     * Get HandledOnDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandledOnDate()
    {
        return isset($this->HandledOnDate) ? $this->HandledOnDate : null;
    }
    /**
     * Set HandledOnDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handledOnDate
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setHandledOnDate($handledOnDate = null)
    {
        // validation for constraint: string
        if (!is_null($handledOnDate) && !is_string($handledOnDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handledOnDate, true), gettype($handledOnDate)), __LINE__);
        }
        if (is_null($handledOnDate) || (is_array($handledOnDate) && empty($handledOnDate))) {
            unset($this->HandledOnDate);
        } else {
            $this->HandledOnDate = $handledOnDate;
        }
        return $this;
    }
    /**
     * Get HandleRequestNotLaterThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandleRequestNotLaterThan()
    {
        return isset($this->HandleRequestNotLaterThan) ? $this->HandleRequestNotLaterThan : null;
    }
    /**
     * Set HandleRequestNotLaterThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handleRequestNotLaterThan
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setHandleRequestNotLaterThan($handleRequestNotLaterThan = null)
    {
        // validation for constraint: string
        if (!is_null($handleRequestNotLaterThan) && !is_string($handleRequestNotLaterThan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handleRequestNotLaterThan, true), gettype($handleRequestNotLaterThan)), __LINE__);
        }
        if (is_null($handleRequestNotLaterThan) || (is_array($handleRequestNotLaterThan) && empty($handleRequestNotLaterThan))) {
            unset($this->HandleRequestNotLaterThan);
        } else {
            $this->HandleRequestNotLaterThan = $handleRequestNotLaterThan;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get Links value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfHelpDesk_ServiceRequestMyLink|null
     */
    public function getLinks()
    {
        return isset($this->Links) ? $this->Links : null;
    }
    /**
     * Set Links value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfHelpDesk_ServiceRequestMyLink $links
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setLinks(\patest\StructType\RecordSetOfHelpDesk_ServiceRequestMyLink $links = null)
    {
        if (is_null($links) || (is_array($links) && empty($links))) {
            unset($this->Links);
        } else {
            $this->Links = $links;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OtherExplanation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOtherExplanation()
    {
        return isset($this->OtherExplanation) ? $this->OtherExplanation : null;
    }
    /**
     * Set OtherExplanation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $otherExplanation
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setOtherExplanation($otherExplanation = null)
    {
        // validation for constraint: string
        if (!is_null($otherExplanation) && !is_string($otherExplanation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherExplanation, true), gettype($otherExplanation)), __LINE__);
        }
        if (is_null($otherExplanation) || (is_array($otherExplanation) && empty($otherExplanation))) {
            unset($this->OtherExplanation);
        } else {
            $this->OtherExplanation = $otherExplanation;
        }
        return $this;
    }
    /**
     * Get Phase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhase()
    {
        return isset($this->Phase) ? $this->Phase : null;
    }
    /**
     * Set Phase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ServiceRequestPhase::valueIsValid()
     * @uses \patest\EnumType\ServiceRequestPhase::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phase
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setPhase($phase = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ServiceRequestPhase::valueIsValid($phase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ServiceRequestPhase', is_array($phase) ? implode(', ', $phase) : var_export($phase, true), implode(', ', \patest\EnumType\ServiceRequestPhase::getValidValues())), __LINE__);
        }
        if (is_null($phase) || (is_array($phase) && empty($phase))) {
            unset($this->Phase);
        } else {
            $this->Phase = $phase;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestPriority::valueIsValid()
     * @uses \patest\EnumType\RequestPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestPriority::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestPriority', is_array($priority) ? implode(', ', $priority) : var_export($priority, true), implode(', ', \patest\EnumType\RequestPriority::getValidValues())), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get RelatedEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedEntityId()
    {
        return isset($this->RelatedEntityId) ? $this->RelatedEntityId : null;
    }
    /**
     * Set RelatedEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedEntityId
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setRelatedEntityId($relatedEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedEntityId) && !is_string($relatedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedEntityId, true), gettype($relatedEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedEntityId, true)), __LINE__);
        }
        if (is_null($relatedEntityId) || (is_array($relatedEntityId) && empty($relatedEntityId))) {
            unset($this->RelatedEntityId);
        } else {
            $this->RelatedEntityId = $relatedEntityId;
        }
        return $this;
    }
    /**
     * Get RelatedEntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedEntityType()
    {
        return isset($this->RelatedEntityType) ? $this->RelatedEntityType : null;
    }
    /**
     * Set RelatedEntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedEntityType
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setRelatedEntityType($relatedEntityType = null)
    {
        // validation for constraint: string
        if (!is_null($relatedEntityType) && !is_string($relatedEntityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedEntityType, true), gettype($relatedEntityType)), __LINE__);
        }
        if (is_null($relatedEntityType) || (is_array($relatedEntityType) && empty($relatedEntityType))) {
            unset($this->RelatedEntityType);
        } else {
            $this->RelatedEntityType = $relatedEntityType;
        }
        return $this;
    }
    /**
     * Get RequestDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestDetails()
    {
        return isset($this->RequestDetails) ? $this->RequestDetails : null;
    }
    /**
     * Set RequestDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestDetails
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setRequestDetails($requestDetails = null)
    {
        // validation for constraint: string
        if (!is_null($requestDetails) && !is_string($requestDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestDetails, true), gettype($requestDetails)), __LINE__);
        }
        if (is_null($requestDetails) || (is_array($requestDetails) && empty($requestDetails))) {
            unset($this->RequestDetails);
        } else {
            $this->RequestDetails = $requestDetails;
        }
        return $this;
    }
    /**
     * Get RequestTopic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTopic()
    {
        return isset($this->RequestTopic) ? $this->RequestTopic : null;
    }
    /**
     * Set RequestTopic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTopic
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setRequestTopic($requestTopic = null)
    {
        // validation for constraint: string
        if (!is_null($requestTopic) && !is_string($requestTopic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTopic, true), gettype($requestTopic)), __LINE__);
        }
        if (is_null($requestTopic) || (is_array($requestTopic) && empty($requestTopic))) {
            unset($this->RequestTopic);
        } else {
            $this->RequestTopic = $requestTopic;
        }
        return $this;
    }
    /**
     * Get RequestType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestType()
    {
        return isset($this->RequestType) ? $this->RequestType : null;
    }
    /**
     * Set RequestType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestType
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: string
        if (!is_null($requestType) && !is_string($requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestType, true), gettype($requestType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestType, true)), __LINE__);
        }
        if (is_null($requestType) || (is_array($requestType) && empty($requestType))) {
            unset($this->RequestType);
        } else {
            $this->RequestType = $requestType;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get Show value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Show|null
     */
    public function getShow()
    {
        return isset($this->Show) ? $this->Show : null;
    }
    /**
     * Set Show value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Show $show
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setShow(\patest\StructType\Ticketing_Show $show = null)
    {
        if (is_null($show) || (is_array($show) && empty($show))) {
            unset($this->Show);
        } else {
            $this->Show = $show;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($status) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($status, true)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get StatusName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getStatusName()
    {
        return isset($this->StatusName) ? $this->StatusName : null;
    }
    /**
     * Set StatusName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $statusName
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setStatusName(\patest\StructType\GlobalString $statusName = null)
    {
        if (is_null($statusName) || (is_array($statusName) && empty($statusName))) {
            unset($this->StatusName);
        } else {
            $this->StatusName = $statusName;
        }
        return $this;
    }
    /**
     * Get SubsidizingAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubsidizingAccountId()
    {
        return isset($this->SubsidizingAccountId) ? $this->SubsidizingAccountId : null;
    }
    /**
     * Set SubsidizingAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subsidizingAccountId
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setSubsidizingAccountId($subsidizingAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($subsidizingAccountId) && !is_string($subsidizingAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidizingAccountId, true), gettype($subsidizingAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subsidizingAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subsidizingAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subsidizingAccountId, true)), __LINE__);
        }
        if (is_null($subsidizingAccountId) || (is_array($subsidizingAccountId) && empty($subsidizingAccountId))) {
            unset($this->SubsidizingAccountId);
        } else {
            $this->SubsidizingAccountId = $subsidizingAccountId;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TypeEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeEntityName()
    {
        return isset($this->TypeEntityName) ? $this->TypeEntityName : null;
    }
    /**
     * Set TypeEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeEntityName
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setTypeEntityName($typeEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($typeEntityName) && !is_string($typeEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeEntityName, true), gettype($typeEntityName)), __LINE__);
        }
        if (is_null($typeEntityName) || (is_array($typeEntityName) && empty($typeEntityName))) {
            unset($this->TypeEntityName);
        } else {
            $this->TypeEntityName = $typeEntityName;
        }
        return $this;
    }
    /**
     * Get UIScreen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUIScreen()
    {
        return isset($this->UIScreen) ? $this->UIScreen : null;
    }
    /**
     * Set UIScreen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uIScreen
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setUIScreen($uIScreen = null)
    {
        // validation for constraint: string
        if (!is_null($uIScreen) && !is_string($uIScreen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uIScreen, true), gettype($uIScreen)), __LINE__);
        }
        if (is_null($uIScreen) || (is_array($uIScreen) && empty($uIScreen))) {
            unset($this->UIScreen);
        } else {
            $this->UIScreen = $uIScreen;
        }
        return $this;
    }
    /**
     * Get UserComments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserComments()
    {
        return isset($this->UserComments) ? $this->UserComments : null;
    }
    /**
     * Set UserComments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userComments
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setUserComments($userComments = null)
    {
        // validation for constraint: string
        if (!is_null($userComments) && !is_string($userComments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userComments, true), gettype($userComments)), __LINE__);
        }
        if (is_null($userComments) || (is_array($userComments) && empty($userComments))) {
            unset($this->UserComments);
        } else {
            $this->UserComments = $userComments;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\HelpDesk_ServiceRequest
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
