<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.SecurityDefinitionsForRequestType StructType
 * @subpackage Structs
 */
class HelpDesk_SecurityDefinitionsForRequestType extends PersistableEntity
{
    /**
     * The AssignToOthers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssignToOthers;
    /**
     * The AssignToRequests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AssignToRequests;
    /**
     * The CreateRequests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CreateRequests;
    /**
     * The EditOthersRequests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EditOthersRequests;
    /**
     * The IsDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDefault;
    /**
     * The RequestTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestTypeId;
    /**
     * The UserOrDepartmentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserOrDepartmentId;
    /**
     * The ViewOthersRequests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ViewOthersRequests;
    /**
     * Constructor method for HelpDesk.SecurityDefinitionsForRequestType
     * @uses HelpDesk_SecurityDefinitionsForRequestType::setAssignToOthers()
     * @uses HelpDesk_SecurityDefinitionsForRequestType::setAssignToRequests()
     * @uses HelpDesk_SecurityDefinitionsForRequestType::setCreateRequests()
     * @uses HelpDesk_SecurityDefinitionsForRequestType::setEditOthersRequests()
     * @uses HelpDesk_SecurityDefinitionsForRequestType::setIsDefault()
     * @uses HelpDesk_SecurityDefinitionsForRequestType::setRequestTypeId()
     * @uses HelpDesk_SecurityDefinitionsForRequestType::setUserOrDepartmentId()
     * @uses HelpDesk_SecurityDefinitionsForRequestType::setViewOthersRequests()
     * @param string $assignToOthers
     * @param bool $assignToRequests
     * @param bool $createRequests
     * @param string $editOthersRequests
     * @param bool $isDefault
     * @param string $requestTypeId
     * @param string $userOrDepartmentId
     * @param string $viewOthersRequests
     */
    public function __construct($assignToOthers = null, $assignToRequests = null, $createRequests = null, $editOthersRequests = null, $isDefault = null, $requestTypeId = null, $userOrDepartmentId = null, $viewOthersRequests = null)
    {
        $this
            ->setAssignToOthers($assignToOthers)
            ->setAssignToRequests($assignToRequests)
            ->setCreateRequests($createRequests)
            ->setEditOthersRequests($editOthersRequests)
            ->setIsDefault($isDefault)
            ->setRequestTypeId($requestTypeId)
            ->setUserOrDepartmentId($userOrDepartmentId)
            ->setViewOthersRequests($viewOthersRequests);
    }
    /**
     * Get AssignToOthers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignToOthers()
    {
        return isset($this->AssignToOthers) ? $this->AssignToOthers : null;
    }
    /**
     * Set AssignToOthers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccessToOthersRequests::valueIsValid()
     * @uses \patest\EnumType\AccessToOthersRequests::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $assignToOthers
     * @return \patest\StructType\HelpDesk_SecurityDefinitionsForRequestType
     */
    public function setAssignToOthers($assignToOthers = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccessToOthersRequests::valueIsValid($assignToOthers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessToOthersRequests', is_array($assignToOthers) ? implode(', ', $assignToOthers) : var_export($assignToOthers, true), implode(', ', \patest\EnumType\AccessToOthersRequests::getValidValues())), __LINE__);
        }
        if (is_null($assignToOthers) || (is_array($assignToOthers) && empty($assignToOthers))) {
            unset($this->AssignToOthers);
        } else {
            $this->AssignToOthers = $assignToOthers;
        }
        return $this;
    }
    /**
     * Get AssignToRequests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAssignToRequests()
    {
        return isset($this->AssignToRequests) ? $this->AssignToRequests : null;
    }
    /**
     * Set AssignToRequests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $assignToRequests
     * @return \patest\StructType\HelpDesk_SecurityDefinitionsForRequestType
     */
    public function setAssignToRequests($assignToRequests = null)
    {
        // validation for constraint: boolean
        if (!is_null($assignToRequests) && !is_bool($assignToRequests)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($assignToRequests, true), gettype($assignToRequests)), __LINE__);
        }
        if (is_null($assignToRequests) || (is_array($assignToRequests) && empty($assignToRequests))) {
            unset($this->AssignToRequests);
        } else {
            $this->AssignToRequests = $assignToRequests;
        }
        return $this;
    }
    /**
     * Get CreateRequests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCreateRequests()
    {
        return isset($this->CreateRequests) ? $this->CreateRequests : null;
    }
    /**
     * Set CreateRequests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $createRequests
     * @return \patest\StructType\HelpDesk_SecurityDefinitionsForRequestType
     */
    public function setCreateRequests($createRequests = null)
    {
        // validation for constraint: boolean
        if (!is_null($createRequests) && !is_bool($createRequests)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createRequests, true), gettype($createRequests)), __LINE__);
        }
        if (is_null($createRequests) || (is_array($createRequests) && empty($createRequests))) {
            unset($this->CreateRequests);
        } else {
            $this->CreateRequests = $createRequests;
        }
        return $this;
    }
    /**
     * Get EditOthersRequests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEditOthersRequests()
    {
        return isset($this->EditOthersRequests) ? $this->EditOthersRequests : null;
    }
    /**
     * Set EditOthersRequests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccessToOthersRequests::valueIsValid()
     * @uses \patest\EnumType\AccessToOthersRequests::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $editOthersRequests
     * @return \patest\StructType\HelpDesk_SecurityDefinitionsForRequestType
     */
    public function setEditOthersRequests($editOthersRequests = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccessToOthersRequests::valueIsValid($editOthersRequests)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessToOthersRequests', is_array($editOthersRequests) ? implode(', ', $editOthersRequests) : var_export($editOthersRequests, true), implode(', ', \patest\EnumType\AccessToOthersRequests::getValidValues())), __LINE__);
        }
        if (is_null($editOthersRequests) || (is_array($editOthersRequests) && empty($editOthersRequests))) {
            unset($this->EditOthersRequests);
        } else {
            $this->EditOthersRequests = $editOthersRequests;
        }
        return $this;
    }
    /**
     * Get IsDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDefault()
    {
        return isset($this->IsDefault) ? $this->IsDefault : null;
    }
    /**
     * Set IsDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDefault
     * @return \patest\StructType\HelpDesk_SecurityDefinitionsForRequestType
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        if (is_null($isDefault) || (is_array($isDefault) && empty($isDefault))) {
            unset($this->IsDefault);
        } else {
            $this->IsDefault = $isDefault;
        }
        return $this;
    }
    /**
     * Get RequestTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTypeId()
    {
        return isset($this->RequestTypeId) ? $this->RequestTypeId : null;
    }
    /**
     * Set RequestTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTypeId
     * @return \patest\StructType\HelpDesk_SecurityDefinitionsForRequestType
     */
    public function setRequestTypeId($requestTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($requestTypeId) && !is_string($requestTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTypeId, true), gettype($requestTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestTypeId, true)), __LINE__);
        }
        if (is_null($requestTypeId) || (is_array($requestTypeId) && empty($requestTypeId))) {
            unset($this->RequestTypeId);
        } else {
            $this->RequestTypeId = $requestTypeId;
        }
        return $this;
    }
    /**
     * Get UserOrDepartmentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserOrDepartmentId()
    {
        return isset($this->UserOrDepartmentId) ? $this->UserOrDepartmentId : null;
    }
    /**
     * Set UserOrDepartmentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userOrDepartmentId
     * @return \patest\StructType\HelpDesk_SecurityDefinitionsForRequestType
     */
    public function setUserOrDepartmentId($userOrDepartmentId = null)
    {
        // validation for constraint: string
        if (!is_null($userOrDepartmentId) && !is_string($userOrDepartmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userOrDepartmentId, true), gettype($userOrDepartmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userOrDepartmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userOrDepartmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userOrDepartmentId, true)), __LINE__);
        }
        if (is_null($userOrDepartmentId) || (is_array($userOrDepartmentId) && empty($userOrDepartmentId))) {
            unset($this->UserOrDepartmentId);
        } else {
            $this->UserOrDepartmentId = $userOrDepartmentId;
        }
        return $this;
    }
    /**
     * Get ViewOthersRequests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getViewOthersRequests()
    {
        return isset($this->ViewOthersRequests) ? $this->ViewOthersRequests : null;
    }
    /**
     * Set ViewOthersRequests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccessToOthersRequests::valueIsValid()
     * @uses \patest\EnumType\AccessToOthersRequests::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $viewOthersRequests
     * @return \patest\StructType\HelpDesk_SecurityDefinitionsForRequestType
     */
    public function setViewOthersRequests($viewOthersRequests = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccessToOthersRequests::valueIsValid($viewOthersRequests)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessToOthersRequests', is_array($viewOthersRequests) ? implode(', ', $viewOthersRequests) : var_export($viewOthersRequests, true), implode(', ', \patest\EnumType\AccessToOthersRequests::getValidValues())), __LINE__);
        }
        if (is_null($viewOthersRequests) || (is_array($viewOthersRequests) && empty($viewOthersRequests))) {
            unset($this->ViewOthersRequests);
        } else {
            $this->ViewOthersRequests = $viewOthersRequests;
        }
        return $this;
    }
}
