<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.RequestStatusUsage StructType
 * @subpackage Structs
 */
class HelpDesk_RequestStatusUsage extends PersistableEntity
{
    /**
     * The DisplayStyleValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayStyleValue;
    /**
     * The ExplanationRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExplanationRequired;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Phase
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phase;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The StatusId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StatusId;
    /**
     * The UsageId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UsageId;
    /**
     * Constructor method for HelpDesk.RequestStatusUsage
     * @uses HelpDesk_RequestStatusUsage::setDisplayStyleValue()
     * @uses HelpDesk_RequestStatusUsage::setExplanationRequired()
     * @uses HelpDesk_RequestStatusUsage::setIsActive()
     * @uses HelpDesk_RequestStatusUsage::setIsSystem()
     * @uses HelpDesk_RequestStatusUsage::setName()
     * @uses HelpDesk_RequestStatusUsage::setPhase()
     * @uses HelpDesk_RequestStatusUsage::setPriority()
     * @uses HelpDesk_RequestStatusUsage::setStatusId()
     * @uses HelpDesk_RequestStatusUsage::setUsageId()
     * @param string $displayStyleValue
     * @param bool $explanationRequired
     * @param bool $isActive
     * @param bool $isSystem
     * @param \patest\StructType\GlobalString $name
     * @param string $phase
     * @param int $priority
     * @param string $statusId
     * @param string $usageId
     */
    public function __construct($displayStyleValue = null, $explanationRequired = null, $isActive = null, $isSystem = null, \patest\StructType\GlobalString $name = null, $phase = null, $priority = null, $statusId = null, $usageId = null)
    {
        $this
            ->setDisplayStyleValue($displayStyleValue)
            ->setExplanationRequired($explanationRequired)
            ->setIsActive($isActive)
            ->setIsSystem($isSystem)
            ->setName($name)
            ->setPhase($phase)
            ->setPriority($priority)
            ->setStatusId($statusId)
            ->setUsageId($usageId);
    }
    /**
     * Get DisplayStyleValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayStyleValue()
    {
        return isset($this->DisplayStyleValue) ? $this->DisplayStyleValue : null;
    }
    /**
     * Set DisplayStyleValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayStyleValue
     * @return \patest\StructType\HelpDesk_RequestStatusUsage
     */
    public function setDisplayStyleValue($displayStyleValue = null)
    {
        // validation for constraint: string
        if (!is_null($displayStyleValue) && !is_string($displayStyleValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayStyleValue, true), gettype($displayStyleValue)), __LINE__);
        }
        if (is_null($displayStyleValue) || (is_array($displayStyleValue) && empty($displayStyleValue))) {
            unset($this->DisplayStyleValue);
        } else {
            $this->DisplayStyleValue = $displayStyleValue;
        }
        return $this;
    }
    /**
     * Get ExplanationRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExplanationRequired()
    {
        return isset($this->ExplanationRequired) ? $this->ExplanationRequired : null;
    }
    /**
     * Set ExplanationRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $explanationRequired
     * @return \patest\StructType\HelpDesk_RequestStatusUsage
     */
    public function setExplanationRequired($explanationRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($explanationRequired) && !is_bool($explanationRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($explanationRequired, true), gettype($explanationRequired)), __LINE__);
        }
        if (is_null($explanationRequired) || (is_array($explanationRequired) && empty($explanationRequired))) {
            unset($this->ExplanationRequired);
        } else {
            $this->ExplanationRequired = $explanationRequired;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\HelpDesk_RequestStatusUsage
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\HelpDesk_RequestStatusUsage
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\HelpDesk_RequestStatusUsage
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Phase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhase()
    {
        return isset($this->Phase) ? $this->Phase : null;
    }
    /**
     * Set Phase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ServiceRequestPhase::valueIsValid()
     * @uses \patest\EnumType\ServiceRequestPhase::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phase
     * @return \patest\StructType\HelpDesk_RequestStatusUsage
     */
    public function setPhase($phase = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ServiceRequestPhase::valueIsValid($phase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ServiceRequestPhase', is_array($phase) ? implode(', ', $phase) : var_export($phase, true), implode(', ', \patest\EnumType\ServiceRequestPhase::getValidValues())), __LINE__);
        }
        if (is_null($phase) || (is_array($phase) && empty($phase))) {
            unset($this->Phase);
        } else {
            $this->Phase = $phase;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\HelpDesk_RequestStatusUsage
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get StatusId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusId()
    {
        return isset($this->StatusId) ? $this->StatusId : null;
    }
    /**
     * Set StatusId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusId
     * @return \patest\StructType\HelpDesk_RequestStatusUsage
     */
    public function setStatusId($statusId = null)
    {
        // validation for constraint: string
        if (!is_null($statusId) && !is_string($statusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusId, true), gettype($statusId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($statusId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $statusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($statusId, true)), __LINE__);
        }
        if (is_null($statusId) || (is_array($statusId) && empty($statusId))) {
            unset($this->StatusId);
        } else {
            $this->StatusId = $statusId;
        }
        return $this;
    }
    /**
     * Get UsageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsageId()
    {
        return isset($this->UsageId) ? $this->UsageId : null;
    }
    /**
     * Set UsageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $usageId
     * @return \patest\StructType\HelpDesk_RequestStatusUsage
     */
    public function setUsageId($usageId = null)
    {
        // validation for constraint: string
        if (!is_null($usageId) && !is_string($usageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usageId, true), gettype($usageId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($usageId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $usageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($usageId, true)), __LINE__);
        }
        if (is_null($usageId) || (is_array($usageId) && empty($usageId))) {
            unset($this->UsageId);
        } else {
            $this->UsageId = $usageId;
        }
        return $this;
    }
}
