<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.RequestStatus StructType
 * @subpackage Structs
 */
class HelpDesk_RequestStatus extends PersistableEntity
{
    /**
     * The CombinedStatusForOnline
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CombinedStatusForOnline;
    /**
     * The DisplayStyleValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayStyleValue;
    /**
     * The ExplanationRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExplanationRequired;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NameForOnlineClients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $NameForOnlineClients;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Phase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phase;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for HelpDesk.RequestStatus
     * @uses HelpDesk_RequestStatus::setCombinedStatusForOnline()
     * @uses HelpDesk_RequestStatus::setDisplayStyleValue()
     * @uses HelpDesk_RequestStatus::setExplanationRequired()
     * @uses HelpDesk_RequestStatus::setIsActive()
     * @uses HelpDesk_RequestStatus::setIsSystem()
     * @uses HelpDesk_RequestStatus::setName()
     * @uses HelpDesk_RequestStatus::setNameForOnlineClients()
     * @uses HelpDesk_RequestStatus::setOrganizationUnitId()
     * @uses HelpDesk_RequestStatus::setPhase()
     * @uses HelpDesk_RequestStatus::setVisibleBySubordinates()
     * @param \patest\StructType\GlobalString $combinedStatusForOnline
     * @param string $displayStyleValue
     * @param bool $explanationRequired
     * @param bool $isActive
     * @param bool $isSystem
     * @param \patest\StructType\GlobalString $name
     * @param \patest\StructType\GlobalString $nameForOnlineClients
     * @param string $organizationUnitId
     * @param string $phase
     * @param bool $visibleBySubordinates
     */
    public function __construct(\patest\StructType\GlobalString $combinedStatusForOnline = null, $displayStyleValue = null, $explanationRequired = null, $isActive = null, $isSystem = null, \patest\StructType\GlobalString $name = null, \patest\StructType\GlobalString $nameForOnlineClients = null, $organizationUnitId = null, $phase = null, $visibleBySubordinates = null)
    {
        $this
            ->setCombinedStatusForOnline($combinedStatusForOnline)
            ->setDisplayStyleValue($displayStyleValue)
            ->setExplanationRequired($explanationRequired)
            ->setIsActive($isActive)
            ->setIsSystem($isSystem)
            ->setName($name)
            ->setNameForOnlineClients($nameForOnlineClients)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPhase($phase)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get CombinedStatusForOnline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCombinedStatusForOnline()
    {
        return isset($this->CombinedStatusForOnline) ? $this->CombinedStatusForOnline : null;
    }
    /**
     * Set CombinedStatusForOnline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $combinedStatusForOnline
     * @return \patest\StructType\HelpDesk_RequestStatus
     */
    public function setCombinedStatusForOnline(\patest\StructType\GlobalString $combinedStatusForOnline = null)
    {
        if (is_null($combinedStatusForOnline) || (is_array($combinedStatusForOnline) && empty($combinedStatusForOnline))) {
            unset($this->CombinedStatusForOnline);
        } else {
            $this->CombinedStatusForOnline = $combinedStatusForOnline;
        }
        return $this;
    }
    /**
     * Get DisplayStyleValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayStyleValue()
    {
        return isset($this->DisplayStyleValue) ? $this->DisplayStyleValue : null;
    }
    /**
     * Set DisplayStyleValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayStyleValue
     * @return \patest\StructType\HelpDesk_RequestStatus
     */
    public function setDisplayStyleValue($displayStyleValue = null)
    {
        // validation for constraint: string
        if (!is_null($displayStyleValue) && !is_string($displayStyleValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayStyleValue, true), gettype($displayStyleValue)), __LINE__);
        }
        if (is_null($displayStyleValue) || (is_array($displayStyleValue) && empty($displayStyleValue))) {
            unset($this->DisplayStyleValue);
        } else {
            $this->DisplayStyleValue = $displayStyleValue;
        }
        return $this;
    }
    /**
     * Get ExplanationRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExplanationRequired()
    {
        return isset($this->ExplanationRequired) ? $this->ExplanationRequired : null;
    }
    /**
     * Set ExplanationRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $explanationRequired
     * @return \patest\StructType\HelpDesk_RequestStatus
     */
    public function setExplanationRequired($explanationRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($explanationRequired) && !is_bool($explanationRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($explanationRequired, true), gettype($explanationRequired)), __LINE__);
        }
        if (is_null($explanationRequired) || (is_array($explanationRequired) && empty($explanationRequired))) {
            unset($this->ExplanationRequired);
        } else {
            $this->ExplanationRequired = $explanationRequired;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\HelpDesk_RequestStatus
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\HelpDesk_RequestStatus
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\HelpDesk_RequestStatus
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NameForOnlineClients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNameForOnlineClients()
    {
        return isset($this->NameForOnlineClients) ? $this->NameForOnlineClients : null;
    }
    /**
     * Set NameForOnlineClients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $nameForOnlineClients
     * @return \patest\StructType\HelpDesk_RequestStatus
     */
    public function setNameForOnlineClients(\patest\StructType\GlobalString $nameForOnlineClients = null)
    {
        if (is_null($nameForOnlineClients) || (is_array($nameForOnlineClients) && empty($nameForOnlineClients))) {
            unset($this->NameForOnlineClients);
        } else {
            $this->NameForOnlineClients = $nameForOnlineClients;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\HelpDesk_RequestStatus
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Phase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhase()
    {
        return isset($this->Phase) ? $this->Phase : null;
    }
    /**
     * Set Phase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ServiceRequestPhase::valueIsValid()
     * @uses \patest\EnumType\ServiceRequestPhase::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phase
     * @return \patest\StructType\HelpDesk_RequestStatus
     */
    public function setPhase($phase = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ServiceRequestPhase::valueIsValid($phase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ServiceRequestPhase', is_array($phase) ? implode(', ', $phase) : var_export($phase, true), implode(', ', \patest\EnumType\ServiceRequestPhase::getValidValues())), __LINE__);
        }
        if (is_null($phase) || (is_array($phase) && empty($phase))) {
            unset($this->Phase);
        } else {
            $this->Phase = $phase;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\HelpDesk_RequestStatus
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
