<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.RequestCategory StructType
 * @subpackage Structs
 */
class HelpDesk_RequestCategory extends PersistableEntity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsCustomerRelated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCustomerRelated;
    /**
     * The IsProductRelated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsProductRelated;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Statuses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfHelpDesk_RequestStatusUsage
     */
    public $Statuses;
    /**
     * The UsersMayAddRequestsManually
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsersMayAddRequestsManually;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for HelpDesk.RequestCategory
     * @uses HelpDesk_RequestCategory::setDescription()
     * @uses HelpDesk_RequestCategory::setEntityName()
     * @uses HelpDesk_RequestCategory::setIsActive()
     * @uses HelpDesk_RequestCategory::setIsCustomerRelated()
     * @uses HelpDesk_RequestCategory::setIsProductRelated()
     * @uses HelpDesk_RequestCategory::setIsSystem()
     * @uses HelpDesk_RequestCategory::setName()
     * @uses HelpDesk_RequestCategory::setOrganizationUnitId()
     * @uses HelpDesk_RequestCategory::setStatuses()
     * @uses HelpDesk_RequestCategory::setUsersMayAddRequestsManually()
     * @uses HelpDesk_RequestCategory::setVisibleBySubordinates()
     * @param \patest\StructType\GlobalString $description
     * @param string $entityName
     * @param bool $isActive
     * @param bool $isCustomerRelated
     * @param bool $isProductRelated
     * @param bool $isSystem
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param \patest\StructType\RecordSetOfHelpDesk_RequestStatusUsage $statuses
     * @param bool $usersMayAddRequestsManually
     * @param bool $visibleBySubordinates
     */
    public function __construct(\patest\StructType\GlobalString $description = null, $entityName = null, $isActive = null, $isCustomerRelated = null, $isProductRelated = null, $isSystem = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, \patest\StructType\RecordSetOfHelpDesk_RequestStatusUsage $statuses = null, $usersMayAddRequestsManually = null, $visibleBySubordinates = null)
    {
        $this
            ->setDescription($description)
            ->setEntityName($entityName)
            ->setIsActive($isActive)
            ->setIsCustomerRelated($isCustomerRelated)
            ->setIsProductRelated($isProductRelated)
            ->setIsSystem($isSystem)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setStatuses($statuses)
            ->setUsersMayAddRequestsManually($usersMayAddRequestsManually)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\HelpDesk_RequestCategory
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\HelpDesk_RequestCategory
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\HelpDesk_RequestCategory
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsCustomerRelated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCustomerRelated()
    {
        return isset($this->IsCustomerRelated) ? $this->IsCustomerRelated : null;
    }
    /**
     * Set IsCustomerRelated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCustomerRelated
     * @return \patest\StructType\HelpDesk_RequestCategory
     */
    public function setIsCustomerRelated($isCustomerRelated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCustomerRelated) && !is_bool($isCustomerRelated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCustomerRelated, true), gettype($isCustomerRelated)), __LINE__);
        }
        if (is_null($isCustomerRelated) || (is_array($isCustomerRelated) && empty($isCustomerRelated))) {
            unset($this->IsCustomerRelated);
        } else {
            $this->IsCustomerRelated = $isCustomerRelated;
        }
        return $this;
    }
    /**
     * Get IsProductRelated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsProductRelated()
    {
        return isset($this->IsProductRelated) ? $this->IsProductRelated : null;
    }
    /**
     * Set IsProductRelated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isProductRelated
     * @return \patest\StructType\HelpDesk_RequestCategory
     */
    public function setIsProductRelated($isProductRelated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isProductRelated) && !is_bool($isProductRelated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isProductRelated, true), gettype($isProductRelated)), __LINE__);
        }
        if (is_null($isProductRelated) || (is_array($isProductRelated) && empty($isProductRelated))) {
            unset($this->IsProductRelated);
        } else {
            $this->IsProductRelated = $isProductRelated;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\HelpDesk_RequestCategory
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\HelpDesk_RequestCategory
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\HelpDesk_RequestCategory
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Statuses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfHelpDesk_RequestStatusUsage|null
     */
    public function getStatuses()
    {
        return isset($this->Statuses) ? $this->Statuses : null;
    }
    /**
     * Set Statuses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfHelpDesk_RequestStatusUsage $statuses
     * @return \patest\StructType\HelpDesk_RequestCategory
     */
    public function setStatuses(\patest\StructType\RecordSetOfHelpDesk_RequestStatusUsage $statuses = null)
    {
        if (is_null($statuses) || (is_array($statuses) && empty($statuses))) {
            unset($this->Statuses);
        } else {
            $this->Statuses = $statuses;
        }
        return $this;
    }
    /**
     * Get UsersMayAddRequestsManually value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsersMayAddRequestsManually()
    {
        return isset($this->UsersMayAddRequestsManually) ? $this->UsersMayAddRequestsManually : null;
    }
    /**
     * Set UsersMayAddRequestsManually value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usersMayAddRequestsManually
     * @return \patest\StructType\HelpDesk_RequestCategory
     */
    public function setUsersMayAddRequestsManually($usersMayAddRequestsManually = null)
    {
        // validation for constraint: boolean
        if (!is_null($usersMayAddRequestsManually) && !is_bool($usersMayAddRequestsManually)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usersMayAddRequestsManually, true), gettype($usersMayAddRequestsManually)), __LINE__);
        }
        if (is_null($usersMayAddRequestsManually) || (is_array($usersMayAddRequestsManually) && empty($usersMayAddRequestsManually))) {
            unset($this->UsersMayAddRequestsManually);
        } else {
            $this->UsersMayAddRequestsManually = $usersMayAddRequestsManually;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\HelpDesk_RequestCategory
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
