<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.Document.ServiceRequest StructType
 * @subpackage Structs
 */
class HelpDesk_Document_ServiceRequest extends Printing_PrintableItem_Base
{
    /**
     * The AssignedTo
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AssignedTo;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The CompletionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompletionDate;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDate;
    /**
     * The Explanation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Explanation;
    /**
     * The ExplanationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExplanationId;
    /**
     * The GeneralRequestInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeneralRequestInfo;
    /**
     * The HandledByUser
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Security_User
     */
    public $HandledByUser;
    /**
     * The HandledByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HandledByUserId;
    /**
     * The HandledOnDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandledOnDate;
    /**
     * The HandleRequestNotLaterThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandleRequestNotLaterThan;
    /**
     * The IsClosed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsClosed;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalId;
    /**
     * The OtherExplanation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OtherExplanation;
    /**
     * The Phase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phase;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Priority;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The RequestDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestDetails;
    /**
     * The RequestTopic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestTopic;
    /**
     * The RequestType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestType;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Status;
    /**
     * The StatusName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $StatusName;
    /**
     * The SubsidizingAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubsidizingAccountId;
    /**
     * Constructor method for HelpDesk.Document.ServiceRequest
     * @uses HelpDesk_Document_ServiceRequest::setAssignedTo()
     * @uses HelpDesk_Document_ServiceRequest::setCategoryId()
     * @uses HelpDesk_Document_ServiceRequest::setCompletionDate()
     * @uses HelpDesk_Document_ServiceRequest::setCreationDate()
     * @uses HelpDesk_Document_ServiceRequest::setExpiryDate()
     * @uses HelpDesk_Document_ServiceRequest::setExplanation()
     * @uses HelpDesk_Document_ServiceRequest::setExplanationId()
     * @uses HelpDesk_Document_ServiceRequest::setGeneralRequestInfo()
     * @uses HelpDesk_Document_ServiceRequest::setHandledByUser()
     * @uses HelpDesk_Document_ServiceRequest::setHandledByUserId()
     * @uses HelpDesk_Document_ServiceRequest::setHandledOnDate()
     * @uses HelpDesk_Document_ServiceRequest::setHandleRequestNotLaterThan()
     * @uses HelpDesk_Document_ServiceRequest::setIsClosed()
     * @uses HelpDesk_Document_ServiceRequest::setLocalId()
     * @uses HelpDesk_Document_ServiceRequest::setOtherExplanation()
     * @uses HelpDesk_Document_ServiceRequest::setPhase()
     * @uses HelpDesk_Document_ServiceRequest::setPriority()
     * @uses HelpDesk_Document_ServiceRequest::setQuantity()
     * @uses HelpDesk_Document_ServiceRequest::setRequestDetails()
     * @uses HelpDesk_Document_ServiceRequest::setRequestTopic()
     * @uses HelpDesk_Document_ServiceRequest::setRequestType()
     * @uses HelpDesk_Document_ServiceRequest::setSeasonId()
     * @uses HelpDesk_Document_ServiceRequest::setShowId()
     * @uses HelpDesk_Document_ServiceRequest::setStatus()
     * @uses HelpDesk_Document_ServiceRequest::setStatusName()
     * @uses HelpDesk_Document_ServiceRequest::setSubsidizingAccountId()
     * @param string $assignedTo
     * @param string $categoryId
     * @param string $completionDate
     * @param string $creationDate
     * @param string $expiryDate
     * @param \patest\StructType\GlobalString $explanation
     * @param string $explanationId
     * @param string $generalRequestInfo
     * @param \patest\StructType\Security_User $handledByUser
     * @param string $handledByUserId
     * @param string $handledOnDate
     * @param string $handleRequestNotLaterThan
     * @param bool $isClosed
     * @param int $localId
     * @param string $otherExplanation
     * @param string $phase
     * @param string $priority
     * @param int $quantity
     * @param string $requestDetails
     * @param string $requestTopic
     * @param string $requestType
     * @param string $seasonId
     * @param string $showId
     * @param string $status
     * @param \patest\StructType\GlobalString $statusName
     * @param string $subsidizingAccountId
     */
    public function __construct($assignedTo = null, $categoryId = null, $completionDate = null, $creationDate = null, $expiryDate = null, \patest\StructType\GlobalString $explanation = null, $explanationId = null, $generalRequestInfo = null, \patest\StructType\Security_User $handledByUser = null, $handledByUserId = null, $handledOnDate = null, $handleRequestNotLaterThan = null, $isClosed = null, $localId = null, $otherExplanation = null, $phase = null, $priority = null, $quantity = null, $requestDetails = null, $requestTopic = null, $requestType = null, $seasonId = null, $showId = null, $status = null, \patest\StructType\GlobalString $statusName = null, $subsidizingAccountId = null)
    {
        $this
            ->setAssignedTo($assignedTo)
            ->setCategoryId($categoryId)
            ->setCompletionDate($completionDate)
            ->setCreationDate($creationDate)
            ->setExpiryDate($expiryDate)
            ->setExplanation($explanation)
            ->setExplanationId($explanationId)
            ->setGeneralRequestInfo($generalRequestInfo)
            ->setHandledByUser($handledByUser)
            ->setHandledByUserId($handledByUserId)
            ->setHandledOnDate($handledOnDate)
            ->setHandleRequestNotLaterThan($handleRequestNotLaterThan)
            ->setIsClosed($isClosed)
            ->setLocalId($localId)
            ->setOtherExplanation($otherExplanation)
            ->setPhase($phase)
            ->setPriority($priority)
            ->setQuantity($quantity)
            ->setRequestDetails($requestDetails)
            ->setRequestTopic($requestTopic)
            ->setRequestType($requestType)
            ->setSeasonId($seasonId)
            ->setShowId($showId)
            ->setStatus($status)
            ->setStatusName($statusName)
            ->setSubsidizingAccountId($subsidizingAccountId);
    }
    /**
     * Get AssignedTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignedTo()
    {
        return isset($this->AssignedTo) ? $this->AssignedTo : null;
    }
    /**
     * Set AssignedTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignedTo
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setAssignedTo($assignedTo = null)
    {
        // validation for constraint: string
        if (!is_null($assignedTo) && !is_string($assignedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignedTo, true), gettype($assignedTo)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($assignedTo) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $assignedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($assignedTo, true)), __LINE__);
        }
        if (is_null($assignedTo) || (is_array($assignedTo) && empty($assignedTo))) {
            unset($this->AssignedTo);
        } else {
            $this->AssignedTo = $assignedTo;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get CompletionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompletionDate()
    {
        return isset($this->CompletionDate) ? $this->CompletionDate : null;
    }
    /**
     * Set CompletionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $completionDate
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setCompletionDate($completionDate = null)
    {
        // validation for constraint: string
        if (!is_null($completionDate) && !is_string($completionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($completionDate, true), gettype($completionDate)), __LINE__);
        }
        if (is_null($completionDate) || (is_array($completionDate) && empty($completionDate))) {
            unset($this->CompletionDate);
        } else {
            $this->CompletionDate = $completionDate;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get ExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDate()
    {
        return isset($this->ExpiryDate) ? $this->ExpiryDate : null;
    }
    /**
     * Set ExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDate
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        if (is_null($expiryDate) || (is_array($expiryDate) && empty($expiryDate))) {
            unset($this->ExpiryDate);
        } else {
            $this->ExpiryDate = $expiryDate;
        }
        return $this;
    }
    /**
     * Get Explanation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getExplanation()
    {
        return isset($this->Explanation) ? $this->Explanation : null;
    }
    /**
     * Set Explanation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $explanation
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setExplanation(\patest\StructType\GlobalString $explanation = null)
    {
        if (is_null($explanation) || (is_array($explanation) && empty($explanation))) {
            unset($this->Explanation);
        } else {
            $this->Explanation = $explanation;
        }
        return $this;
    }
    /**
     * Get ExplanationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExplanationId()
    {
        return isset($this->ExplanationId) ? $this->ExplanationId : null;
    }
    /**
     * Set ExplanationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $explanationId
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setExplanationId($explanationId = null)
    {
        // validation for constraint: string
        if (!is_null($explanationId) && !is_string($explanationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($explanationId, true), gettype($explanationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($explanationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $explanationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($explanationId, true)), __LINE__);
        }
        if (is_null($explanationId) || (is_array($explanationId) && empty($explanationId))) {
            unset($this->ExplanationId);
        } else {
            $this->ExplanationId = $explanationId;
        }
        return $this;
    }
    /**
     * Get GeneralRequestInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneralRequestInfo()
    {
        return isset($this->GeneralRequestInfo) ? $this->GeneralRequestInfo : null;
    }
    /**
     * Set GeneralRequestInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generalRequestInfo
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setGeneralRequestInfo($generalRequestInfo = null)
    {
        // validation for constraint: string
        if (!is_null($generalRequestInfo) && !is_string($generalRequestInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generalRequestInfo, true), gettype($generalRequestInfo)), __LINE__);
        }
        if (is_null($generalRequestInfo) || (is_array($generalRequestInfo) && empty($generalRequestInfo))) {
            unset($this->GeneralRequestInfo);
        } else {
            $this->GeneralRequestInfo = $generalRequestInfo;
        }
        return $this;
    }
    /**
     * Get HandledByUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Security_User|null
     */
    public function getHandledByUser()
    {
        return isset($this->HandledByUser) ? $this->HandledByUser : null;
    }
    /**
     * Set HandledByUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Security_User $handledByUser
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setHandledByUser(\patest\StructType\Security_User $handledByUser = null)
    {
        if (is_null($handledByUser) || (is_array($handledByUser) && empty($handledByUser))) {
            unset($this->HandledByUser);
        } else {
            $this->HandledByUser = $handledByUser;
        }
        return $this;
    }
    /**
     * Get HandledByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandledByUserId()
    {
        return isset($this->HandledByUserId) ? $this->HandledByUserId : null;
    }
    /**
     * Set HandledByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handledByUserId
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setHandledByUserId($handledByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($handledByUserId) && !is_string($handledByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handledByUserId, true), gettype($handledByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($handledByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $handledByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($handledByUserId, true)), __LINE__);
        }
        if (is_null($handledByUserId) || (is_array($handledByUserId) && empty($handledByUserId))) {
            unset($this->HandledByUserId);
        } else {
            $this->HandledByUserId = $handledByUserId;
        }
        return $this;
    }
    /**
     * Get HandledOnDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandledOnDate()
    {
        return isset($this->HandledOnDate) ? $this->HandledOnDate : null;
    }
    /**
     * Set HandledOnDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handledOnDate
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setHandledOnDate($handledOnDate = null)
    {
        // validation for constraint: string
        if (!is_null($handledOnDate) && !is_string($handledOnDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handledOnDate, true), gettype($handledOnDate)), __LINE__);
        }
        if (is_null($handledOnDate) || (is_array($handledOnDate) && empty($handledOnDate))) {
            unset($this->HandledOnDate);
        } else {
            $this->HandledOnDate = $handledOnDate;
        }
        return $this;
    }
    /**
     * Get HandleRequestNotLaterThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandleRequestNotLaterThan()
    {
        return isset($this->HandleRequestNotLaterThan) ? $this->HandleRequestNotLaterThan : null;
    }
    /**
     * Set HandleRequestNotLaterThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handleRequestNotLaterThan
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setHandleRequestNotLaterThan($handleRequestNotLaterThan = null)
    {
        // validation for constraint: string
        if (!is_null($handleRequestNotLaterThan) && !is_string($handleRequestNotLaterThan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handleRequestNotLaterThan, true), gettype($handleRequestNotLaterThan)), __LINE__);
        }
        if (is_null($handleRequestNotLaterThan) || (is_array($handleRequestNotLaterThan) && empty($handleRequestNotLaterThan))) {
            unset($this->HandleRequestNotLaterThan);
        } else {
            $this->HandleRequestNotLaterThan = $handleRequestNotLaterThan;
        }
        return $this;
    }
    /**
     * Get IsClosed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsClosed()
    {
        return isset($this->IsClosed) ? $this->IsClosed : null;
    }
    /**
     * Set IsClosed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isClosed
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setIsClosed($isClosed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClosed) && !is_bool($isClosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClosed, true), gettype($isClosed)), __LINE__);
        }
        if (is_null($isClosed) || (is_array($isClosed) && empty($isClosed))) {
            unset($this->IsClosed);
        } else {
            $this->IsClosed = $isClosed;
        }
        return $this;
    }
    /**
     * Get LocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalId()
    {
        return isset($this->LocalId) ? $this->LocalId : null;
    }
    /**
     * Set LocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localId
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        if (is_null($localId) || (is_array($localId) && empty($localId))) {
            unset($this->LocalId);
        } else {
            $this->LocalId = $localId;
        }
        return $this;
    }
    /**
     * Get OtherExplanation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOtherExplanation()
    {
        return isset($this->OtherExplanation) ? $this->OtherExplanation : null;
    }
    /**
     * Set OtherExplanation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $otherExplanation
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setOtherExplanation($otherExplanation = null)
    {
        // validation for constraint: string
        if (!is_null($otherExplanation) && !is_string($otherExplanation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherExplanation, true), gettype($otherExplanation)), __LINE__);
        }
        if (is_null($otherExplanation) || (is_array($otherExplanation) && empty($otherExplanation))) {
            unset($this->OtherExplanation);
        } else {
            $this->OtherExplanation = $otherExplanation;
        }
        return $this;
    }
    /**
     * Get Phase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhase()
    {
        return isset($this->Phase) ? $this->Phase : null;
    }
    /**
     * Set Phase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ServiceRequestPhase::valueIsValid()
     * @uses \patest\EnumType\ServiceRequestPhase::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phase
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setPhase($phase = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ServiceRequestPhase::valueIsValid($phase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ServiceRequestPhase', is_array($phase) ? implode(', ', $phase) : var_export($phase, true), implode(', ', \patest\EnumType\ServiceRequestPhase::getValidValues())), __LINE__);
        }
        if (is_null($phase) || (is_array($phase) && empty($phase))) {
            unset($this->Phase);
        } else {
            $this->Phase = $phase;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestPriority::valueIsValid()
     * @uses \patest\EnumType\RequestPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestPriority::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestPriority', is_array($priority) ? implode(', ', $priority) : var_export($priority, true), implode(', ', \patest\EnumType\RequestPriority::getValidValues())), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get RequestDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestDetails()
    {
        return isset($this->RequestDetails) ? $this->RequestDetails : null;
    }
    /**
     * Set RequestDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestDetails
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setRequestDetails($requestDetails = null)
    {
        // validation for constraint: string
        if (!is_null($requestDetails) && !is_string($requestDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestDetails, true), gettype($requestDetails)), __LINE__);
        }
        if (is_null($requestDetails) || (is_array($requestDetails) && empty($requestDetails))) {
            unset($this->RequestDetails);
        } else {
            $this->RequestDetails = $requestDetails;
        }
        return $this;
    }
    /**
     * Get RequestTopic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTopic()
    {
        return isset($this->RequestTopic) ? $this->RequestTopic : null;
    }
    /**
     * Set RequestTopic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTopic
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setRequestTopic($requestTopic = null)
    {
        // validation for constraint: string
        if (!is_null($requestTopic) && !is_string($requestTopic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTopic, true), gettype($requestTopic)), __LINE__);
        }
        if (is_null($requestTopic) || (is_array($requestTopic) && empty($requestTopic))) {
            unset($this->RequestTopic);
        } else {
            $this->RequestTopic = $requestTopic;
        }
        return $this;
    }
    /**
     * Get RequestType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestType()
    {
        return isset($this->RequestType) ? $this->RequestType : null;
    }
    /**
     * Set RequestType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestType
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: string
        if (!is_null($requestType) && !is_string($requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestType, true), gettype($requestType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestType, true)), __LINE__);
        }
        if (is_null($requestType) || (is_array($requestType) && empty($requestType))) {
            unset($this->RequestType);
        } else {
            $this->RequestType = $requestType;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($status) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($status, true)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get StatusName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getStatusName()
    {
        return isset($this->StatusName) ? $this->StatusName : null;
    }
    /**
     * Set StatusName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $statusName
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setStatusName(\patest\StructType\GlobalString $statusName = null)
    {
        if (is_null($statusName) || (is_array($statusName) && empty($statusName))) {
            unset($this->StatusName);
        } else {
            $this->StatusName = $statusName;
        }
        return $this;
    }
    /**
     * Get SubsidizingAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubsidizingAccountId()
    {
        return isset($this->SubsidizingAccountId) ? $this->SubsidizingAccountId : null;
    }
    /**
     * Set SubsidizingAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subsidizingAccountId
     * @return \patest\StructType\HelpDesk_Document_ServiceRequest
     */
    public function setSubsidizingAccountId($subsidizingAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($subsidizingAccountId) && !is_string($subsidizingAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidizingAccountId, true), gettype($subsidizingAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subsidizingAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subsidizingAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subsidizingAccountId, true)), __LINE__);
        }
        if (is_null($subsidizingAccountId) || (is_array($subsidizingAccountId) && empty($subsidizingAccountId))) {
            unset($this->SubsidizingAccountId);
        } else {
            $this->SubsidizingAccountId = $subsidizingAccountId;
        }
        return $this;
    }
}
